CREATE FUNCTION signoffs_with_visibility(
    partial_enriched_artifacts_record partial_enriched_artifacts,
    signoff_status TEXT,
    operator TEXT
)
RETURNS JSONB
LANGUAGE plpgsql AS
$func$
BEGIN

    RETURN (
        SELECT signoffs_with_visibility
        FROM (
            -- build a jsonb array containing list of json objects (stepId, signoffStatus, visible) for each signoff
            SELECT JSONB_AGG(
                JSONB_BUILD_OBJECT(
                    'stepId',
                    signoff #>> '{signoffId,stepId}',
                    'signoffStatus',
                    signoff #>> '{status}',
                    'visible',
                    -- if the signoff has no associated workflow step, keep it in the array but tag it as not visible
                    COALESCE(partial_enriched_artifacts_record.artifact_json_without_relationships #> '{workflow,steps}' -> (signoff #>> '{signoffId,stepId}') #>> '{visible}', 'false') = 'true'
                )
            ) AS signoffs_with_visibility
            -- iterate over the signoffs (or empty array if the value is null)
            FROM JSONB_ARRAY_ELEMENTS(COALESCE(partial_enriched_artifacts_record.signoffs, '[]'::JSONB)) AS signoff
            -- sanity checks: signoff without a valid structure are discarded
            WHERE signoff #>> '{signoffId,stepId}' IS NOT NULL AND signoff #>> '{status}' IS NOT NULL
        ) AS aggregated
        -- the function returns null if there are no steps that matches the condition (operator / signoff status pair), otherwise we return the whole computed signoff data
        WHERE JSONB_PATH_EXISTS(
            aggregated.signoffs_with_visibility,
            FORMAT(
                'strict $[*] ? (@.visible == true && @.signoffStatus %s "%s")',
                operator,
                signoff_status
            )::JSONPATH
        )
    );

END;
$func$;
