#!/bin/bash -e
# Compile and install R 4.5 on an Amazon Linux 2 system

R_VERSION="4.5.0"
R_MD5="2342b31a604631f8b130033d8582d547"

# Check environment
source /etc/os-release
[ "$ID" = "amzn" -a "$VERSION_ID" = 2 ] || {
	echo >&2 "*** ERROR : not an Amazon Linux 2 system"
	exit 1
}
[ $EUID -eq 0 ] || {
	echo >&2 "*** ERROR : should be run as root"
	exit 1
}

echo "+ Installing R build dependencies ..."
yum -y install \
  @development \
  bzip2-devel \
  cairo-devel \
  fontconfig-devel \
  freetype-devel \
  fribidi-devel \
  gcc-gfortran \
  harfbuzz-devel \
  java-17-amazon-corretto-devel \
  libcurl-devel \
  libicu-devel \
  libjpeg-turbo-devel \
  libpng-devel \
  libtiff-devel \
  pango-devel \
  pcre2-devel \
  readline-devel \
  texinfo \
  texlive \
  which \
  xz-devel \
  zlib-devel \

TMP_DIR=$(mktemp -d -p /root)
(
	cd "$TMP_DIR"

	echo "+ Downloading R $R_VERSION source archive into $TMP_DIR ..."
	curl -OsS "https://cloud.r-project.org/src/base/R-4/R-$R_VERSION.tar.gz"
	echo "$R_MD5 R-$R_VERSION.tar.gz" | md5sum -c

	tar xf R-"$R_VERSION".tar.gz

	echo "+ Compiling and installing to /usr/local ..."
	(
		cd R-"$R_VERSION"
		JAVA_HOME=/usr/lib/jvm/java-17-openjdk \
			./configure --without-x --without-libdeflate-compression --enable-R-shlib
		make -j 4
		make install
	) >build-R.log
)

echo "+ Cleaning up ..."
rm -rf "$TMP_DIR"

echo "+ Done"
