/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.GenericJson;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonObjectParser;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Clock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.RequestMetadataCallback;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.ServiceAccountSigner;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.JwtClaims;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.JwtCredentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.JwtProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.OAuth2Utils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Throwables;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Ticker;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.CacheLoader;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.cache.LoadingCache;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServiceAccountJwtAccessCredentials
extends Credentials
implements JwtProvider,
ServiceAccountSigner,
QuotaProjectIdProvider {
    private static final long serialVersionUID = -7274955171379494197L;
    static final String JWT_ACCESS_PREFIX = "Bearer ";
    @VisibleForTesting
    static final long LIFE_SPAN_SECS = TimeUnit.HOURS.toSeconds(1L);
    private static final long CLOCK_SKEW = TimeUnit.MINUTES.toSeconds(5L);
    private final String clientId;
    private final String clientEmail;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final URI defaultAudience;
    private final String quotaProjectId;
    private transient LoadingCache<JwtClaims, JwtCredentials> credentialsCache;
    @VisibleForTesting
    transient Clock clock = Clock.SYSTEM;

    private ServiceAccountJwtAccessCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId) {
        this(clientId, clientEmail, privateKey, privateKeyId, null, null);
    }

    private ServiceAccountJwtAccessCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, URI defaultAudience, String quotaProjectId) {
        this.clientId = clientId;
        this.clientEmail = Preconditions.checkNotNull(clientEmail);
        this.privateKey = Preconditions.checkNotNull(privateKey);
        this.privateKeyId = privateKeyId;
        this.defaultAudience = defaultAudience;
        this.credentialsCache = this.createCache();
        this.quotaProjectId = quotaProjectId;
    }

    static ServiceAccountJwtAccessCredentials fromJson(Map<String, Object> json) throws IOException {
        return ServiceAccountJwtAccessCredentials.fromJson(json, null);
    }

    static ServiceAccountJwtAccessCredentials fromJson(Map<String, Object> json, URI defaultAudience) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientEmail = (String)json.get("client_email");
        String privateKeyPkcs8 = (String)json.get("private_key");
        String privateKeyId = (String)json.get("private_key_id");
        String quoataProjectId = (String)json.get("quota_project_id");
        if (clientId == null || clientEmail == null || privateKeyPkcs8 == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from JSON, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        return ServiceAccountJwtAccessCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, defaultAudience, quoataProjectId);
    }

    public static ServiceAccountJwtAccessCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId) throws IOException {
        return ServiceAccountJwtAccessCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, null);
    }

    public static ServiceAccountJwtAccessCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, URI defaultAudience) throws IOException {
        return ServiceAccountJwtAccessCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, defaultAudience, null);
    }

    static ServiceAccountJwtAccessCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, URI defaultAudience, String quotaProjectId) throws IOException {
        PrivateKey privateKey = OAuth2Utils.privateKeyFromPkcs8(privateKeyPkcs8);
        return new ServiceAccountJwtAccessCredentials(clientId, clientEmail, privateKey, privateKeyId, defaultAudience, quotaProjectId);
    }

    public static ServiceAccountJwtAccessCredentials fromStream(InputStream credentialsStream) throws IOException {
        return ServiceAccountJwtAccessCredentials.fromStream(credentialsStream, null);
    }

    public static ServiceAccountJwtAccessCredentials fromStream(InputStream credentialsStream, URI defaultAudience) throws IOException {
        Preconditions.checkNotNull(credentialsStream);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get("type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if ("service_account".equals(fileType)) {
            return ServiceAccountJwtAccessCredentials.fromJson(fileContents, defaultAudience);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Expecting '%s'.", fileType, "service_account"));
    }

    private LoadingCache<JwtClaims, JwtCredentials> createCache() {
        return CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(LIFE_SPAN_SECS - CLOCK_SKEW, TimeUnit.SECONDS).ticker(new Ticker(){

            @Override
            public long read() {
                return TimeUnit.MILLISECONDS.toNanos(ServiceAccountJwtAccessCredentials.this.clock.currentTimeMillis());
            }
        }).build(new CacheLoader<JwtClaims, JwtCredentials>(){

            @Override
            public JwtCredentials load(JwtClaims claims) throws Exception {
                return JwtCredentials.newBuilder().setPrivateKey(ServiceAccountJwtAccessCredentials.this.privateKey).setPrivateKeyId(ServiceAccountJwtAccessCredentials.this.privateKeyId).setJwtClaims(claims).setLifeSpanSeconds(LIFE_SPAN_SECS).setClock(ServiceAccountJwtAccessCredentials.this.clock).build();
            }
        });
    }

    @Override
    public JwtCredentials jwtWithClaims(JwtClaims newClaims) {
        JwtClaims.Builder claimsBuilder = JwtClaims.newBuilder().setIssuer(this.clientEmail).setSubject(this.clientEmail);
        if (this.defaultAudience != null) {
            claimsBuilder.setAudience(this.defaultAudience.toString());
        }
        return JwtCredentials.newBuilder().setPrivateKey(this.privateKey).setPrivateKeyId(this.privateKeyId).setJwtClaims(claimsBuilder.build().merge(newClaims)).setLifeSpanSeconds(LIFE_SPAN_SECS).setClock(this.clock).build();
    }

    @Override
    public String getAuthenticationType() {
        return "JWTAccess";
    }

    @Override
    public boolean hasRequestMetadata() {
        return true;
    }

    @Override
    public boolean hasRequestMetadataOnly() {
        return true;
    }

    @Override
    public void getRequestMetadata(URI uri, Executor executor, RequestMetadataCallback callback) {
        this.blockingGetToCallback(uri, callback);
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        if (uri == null) {
            if (this.defaultAudience != null) {
                uri = this.defaultAudience;
            } else {
                throw new IOException("JwtAccess requires Audience uri to be passed in or the defaultAudience to be specified");
            }
        }
        try {
            JwtClaims defaultClaims = JwtClaims.newBuilder().setAudience(uri.toString()).setIssuer(this.clientEmail).setSubject(this.clientEmail).build();
            JwtCredentials credentials = this.credentialsCache.get(defaultClaims);
            Map<String, List<String>> requestMetadata = credentials.getRequestMetadata(uri);
            return GoogleCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, requestMetadata);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible(e.getCause(), IOException.class);
            throw new IllegalStateException("generateJwtAccess threw an unexpected checked exception", e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked(e);
            throw new IllegalStateException("generateJwtAccess threw an unchecked exception that couldn't be rethrown", e);
        }
    }

    @Override
    public void refresh() {
        this.credentialsCache.invalidateAll();
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientEmail() {
        return this.clientEmail;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }

    @Override
    public String getAccount() {
        return this.getClientEmail();
    }

    @Override
    public byte[] sign(byte[] toSign) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(this.getPrivateKey());
            signer.update(toSign);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
        }
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, this.defaultAudience, this.quotaProjectId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("clientId", this.clientId).add("clientEmail", this.clientEmail).add("privateKeyId", this.privateKeyId).add("defaultAudience", this.defaultAudience).add("quotaProjectId", this.quotaProjectId).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceAccountJwtAccessCredentials)) {
            return false;
        }
        ServiceAccountJwtAccessCredentials other = (ServiceAccountJwtAccessCredentials)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientEmail, other.clientEmail) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.privateKeyId, other.privateKeyId) && Objects.equals(this.defaultAudience, other.defaultAudience) && Objects.equals(this.quotaProjectId, other.quotaProjectId);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.clock = Clock.SYSTEM;
        this.credentialsCache = this.createCache();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    public static class Builder {
        private String clientId;
        private String clientEmail;
        private PrivateKey privateKey;
        private String privateKeyId;
        private URI defaultAudience;
        private String quotaProjectId;

        protected Builder() {
        }

        protected Builder(ServiceAccountJwtAccessCredentials credentials) {
            this.clientId = credentials.clientId;
            this.clientEmail = credentials.clientEmail;
            this.privateKey = credentials.privateKey;
            this.privateKeyId = credentials.privateKeyId;
            this.defaultAudience = credentials.defaultAudience;
            this.quotaProjectId = credentials.quotaProjectId;
        }

        @CanIgnoreReturnValue
        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setClientEmail(String clientEmail) {
            this.clientEmail = clientEmail;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPrivateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDefaultAudience(URI defaultAudience) {
            this.defaultAudience = defaultAudience;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientEmail() {
            return this.clientEmail;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }

        public URI getDefaultAudience() {
            return this.defaultAudience;
        }

        public String getQuotaProjectId() {
            return this.quotaProjectId;
        }

        public ServiceAccountJwtAccessCredentials build() {
            return new ServiceAccountJwtAccessCredentials(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, this.defaultAudience, this.quotaProjectId);
        }
    }
}

