/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponseException;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.IoExceptionHelper;
import java.io.IOException;

@FunctionalInterface
public interface RetryDeterminer<X extends Exception> {
    public static final RetryDeterminer<Exception> DEFAULT = new RetryDeterminer<Exception>(){

        @Override
        public boolean shouldRetry(Exception e) {
            return e instanceof IOException && (SOCKET_ERRORS.shouldRetry((IOException)e) || SERVER_ERRORS.shouldRetry((IOException)e));
        }
    };
    public static final RetryDeterminer<Exception> ALL_ERRORS = e -> true;
    public static final RetryDeterminer<IOException> SOCKET_ERRORS = IoExceptionHelper::isSocketError;
    public static final RetryDeterminer<IOException> SERVER_ERRORS = e -> e instanceof HttpResponseException && ((HttpResponseException)e).getStatusCode() / 100 == 5;
    public static final RetryDeterminer<IOException> RATE_LIMIT_ERRORS = ApiErrorExtractor.INSTANCE::rateLimited;

    public boolean shouldRetry(X var1);
}

