/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.core.BackgroundResource;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.AbstractPage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.OperationCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.PageContext;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.longrunning.Operation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.longrunning.OperationsClient;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Empty;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.BucketName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.CreateFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.CreateManagedFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.DeleteFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.DeleteManagedFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.Folder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.FolderName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.GetFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.GetManagedFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.ListFoldersRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.ListFoldersResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.ListManagedFoldersRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.ListManagedFoldersResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.ManagedFolder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.ManagedFolderName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.RenameFolderMetadata;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.RenameFolderRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.StorageControlSettings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.StorageLayout;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.StorageLayoutName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.stub.StorageControlStub;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.control.v2.stub.StorageControlStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StorageControlClient
implements BackgroundResource {
    private final StorageControlSettings settings;
    private final StorageControlStub stub;
    private final OperationsClient operationsClient;

    public static final StorageControlClient create() throws IOException {
        return StorageControlClient.create(StorageControlSettings.newBuilder().build());
    }

    public static final StorageControlClient create(StorageControlSettings settings) throws IOException {
        return new StorageControlClient(settings);
    }

    public static final StorageControlClient create(StorageControlStub stub) {
        return new StorageControlClient(stub);
    }

    protected StorageControlClient(StorageControlSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageControlStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create(this.stub.getOperationsStub());
    }

    protected StorageControlClient(StorageControlStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create(this.stub.getOperationsStub());
    }

    public final StorageControlSettings getSettings() {
        return this.settings;
    }

    public StorageControlStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Folder createFolder(BucketName parent, Folder folder, String folderId) {
        CreateFolderRequest request = CreateFolderRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFolder(folder).setFolderId(folderId).build();
        return this.createFolder(request);
    }

    public final Folder createFolder(String parent, Folder folder, String folderId) {
        CreateFolderRequest request = CreateFolderRequest.newBuilder().setParent(parent).setFolder(folder).setFolderId(folderId).build();
        return this.createFolder(request);
    }

    public final Folder createFolder(CreateFolderRequest request) {
        return this.createFolderCallable().call(request);
    }

    public final UnaryCallable<CreateFolderRequest, Folder> createFolderCallable() {
        return this.stub.createFolderCallable();
    }

    public final void deleteFolder(FolderName name) {
        DeleteFolderRequest request = DeleteFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFolder(request);
    }

    public final void deleteFolder(String name) {
        DeleteFolderRequest request = DeleteFolderRequest.newBuilder().setName(name).build();
        this.deleteFolder(request);
    }

    public final void deleteFolder(DeleteFolderRequest request) {
        this.deleteFolderCallable().call(request);
    }

    public final UnaryCallable<DeleteFolderRequest, Empty> deleteFolderCallable() {
        return this.stub.deleteFolderCallable();
    }

    public final Folder getFolder(FolderName name) {
        GetFolderRequest request = GetFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFolder(request);
    }

    public final Folder getFolder(String name) {
        GetFolderRequest request = GetFolderRequest.newBuilder().setName(name).build();
        return this.getFolder(request);
    }

    public final Folder getFolder(GetFolderRequest request) {
        return this.getFolderCallable().call(request);
    }

    public final UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.stub.getFolderCallable();
    }

    public final ListFoldersPagedResponse listFolders(BucketName parent) {
        ListFoldersRequest request = ListFoldersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFolders(request);
    }

    public final ListFoldersPagedResponse listFolders(String parent) {
        ListFoldersRequest request = ListFoldersRequest.newBuilder().setParent(parent).build();
        return this.listFolders(request);
    }

    public final ListFoldersPagedResponse listFolders(ListFoldersRequest request) {
        return this.listFoldersPagedCallable().call(request);
    }

    public final UnaryCallable<ListFoldersRequest, ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.stub.listFoldersPagedCallable();
    }

    public final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.stub.listFoldersCallable();
    }

    public final OperationFuture<Folder, RenameFolderMetadata> renameFolderAsync(FolderName name, String destinationFolderId) {
        RenameFolderRequest request = RenameFolderRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationFolderId(destinationFolderId).build();
        return this.renameFolderAsync(request);
    }

    public final OperationFuture<Folder, RenameFolderMetadata> renameFolderAsync(String name, String destinationFolderId) {
        RenameFolderRequest request = RenameFolderRequest.newBuilder().setName(name).setDestinationFolderId(destinationFolderId).build();
        return this.renameFolderAsync(request);
    }

    public final OperationFuture<Folder, RenameFolderMetadata> renameFolderAsync(RenameFolderRequest request) {
        return this.renameFolderOperationCallable().futureCall(request);
    }

    public final OperationCallable<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationCallable() {
        return this.stub.renameFolderOperationCallable();
    }

    public final UnaryCallable<RenameFolderRequest, Operation> renameFolderCallable() {
        return this.stub.renameFolderCallable();
    }

    public final StorageLayout getStorageLayout(StorageLayoutName name) {
        GetStorageLayoutRequest request = GetStorageLayoutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getStorageLayout(request);
    }

    public final StorageLayout getStorageLayout(String name) {
        GetStorageLayoutRequest request = GetStorageLayoutRequest.newBuilder().setName(name).build();
        return this.getStorageLayout(request);
    }

    public final StorageLayout getStorageLayout(GetStorageLayoutRequest request) {
        return this.getStorageLayoutCallable().call(request);
    }

    public final UnaryCallable<GetStorageLayoutRequest, StorageLayout> getStorageLayoutCallable() {
        return this.stub.getStorageLayoutCallable();
    }

    public final ManagedFolder createManagedFolder(BucketName parent, ManagedFolder managedFolder, String managedFolderId) {
        CreateManagedFolderRequest request = CreateManagedFolderRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setManagedFolder(managedFolder).setManagedFolderId(managedFolderId).build();
        return this.createManagedFolder(request);
    }

    public final ManagedFolder createManagedFolder(String parent, ManagedFolder managedFolder, String managedFolderId) {
        CreateManagedFolderRequest request = CreateManagedFolderRequest.newBuilder().setParent(parent).setManagedFolder(managedFolder).setManagedFolderId(managedFolderId).build();
        return this.createManagedFolder(request);
    }

    public final ManagedFolder createManagedFolder(CreateManagedFolderRequest request) {
        return this.createManagedFolderCallable().call(request);
    }

    public final UnaryCallable<CreateManagedFolderRequest, ManagedFolder> createManagedFolderCallable() {
        return this.stub.createManagedFolderCallable();
    }

    public final void deleteManagedFolder(ManagedFolderName name) {
        DeleteManagedFolderRequest request = DeleteManagedFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteManagedFolder(request);
    }

    public final void deleteManagedFolder(String name) {
        DeleteManagedFolderRequest request = DeleteManagedFolderRequest.newBuilder().setName(name).build();
        this.deleteManagedFolder(request);
    }

    public final void deleteManagedFolder(DeleteManagedFolderRequest request) {
        this.deleteManagedFolderCallable().call(request);
    }

    public final UnaryCallable<DeleteManagedFolderRequest, Empty> deleteManagedFolderCallable() {
        return this.stub.deleteManagedFolderCallable();
    }

    public final ManagedFolder getManagedFolder(ManagedFolderName name) {
        GetManagedFolderRequest request = GetManagedFolderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getManagedFolder(request);
    }

    public final ManagedFolder getManagedFolder(String name) {
        GetManagedFolderRequest request = GetManagedFolderRequest.newBuilder().setName(name).build();
        return this.getManagedFolder(request);
    }

    public final ManagedFolder getManagedFolder(GetManagedFolderRequest request) {
        return this.getManagedFolderCallable().call(request);
    }

    public final UnaryCallable<GetManagedFolderRequest, ManagedFolder> getManagedFolderCallable() {
        return this.stub.getManagedFolderCallable();
    }

    public final ListManagedFoldersPagedResponse listManagedFolders(BucketName parent) {
        ListManagedFoldersRequest request = ListManagedFoldersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listManagedFolders(request);
    }

    public final ListManagedFoldersPagedResponse listManagedFolders(String parent) {
        ListManagedFoldersRequest request = ListManagedFoldersRequest.newBuilder().setParent(parent).build();
        return this.listManagedFolders(request);
    }

    public final ListManagedFoldersPagedResponse listManagedFolders(ListManagedFoldersRequest request) {
        return this.listManagedFoldersPagedCallable().call(request);
    }

    public final UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersPagedResponse> listManagedFoldersPagedCallable() {
        return this.stub.listManagedFoldersPagedCallable();
    }

    public final UnaryCallable<ListManagedFoldersRequest, ListManagedFoldersResponse> listManagedFoldersCallable() {
        return this.stub.listManagedFoldersCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFoldersPagedResponse
    extends AbstractPagedListResponse<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage, ListFoldersFixedSizeCollection> {
        public static ApiFuture<ListFoldersPagedResponse> createAsync(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ApiFuture<ListFoldersResponse> futureResponse) {
            ApiFuture<ListFoldersPage> futurePage = ListFoldersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFoldersPagedResponse((ListFoldersPage)input), MoreExecutors.directExecutor());
        }

        private ListFoldersPagedResponse(ListFoldersPage page) {
            super(page, ListFoldersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagedFoldersPagedResponse
    extends AbstractPagedListResponse<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder, ListManagedFoldersPage, ListManagedFoldersFixedSizeCollection> {
        public static ApiFuture<ListManagedFoldersPagedResponse> createAsync(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ApiFuture<ListManagedFoldersResponse> futureResponse) {
            ApiFuture<ListManagedFoldersPage> futurePage = ListManagedFoldersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagedFoldersPagedResponse((ListManagedFoldersPage)input), MoreExecutors.directExecutor());
        }

        private ListManagedFoldersPagedResponse(ListManagedFoldersPage page) {
            super(page, ListManagedFoldersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagedFoldersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder, ListManagedFoldersPage, ListManagedFoldersFixedSizeCollection> {
        private ListManagedFoldersFixedSizeCollection(List<ListManagedFoldersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagedFoldersFixedSizeCollection createEmptyCollection() {
            return new ListManagedFoldersFixedSizeCollection(null, 0);
        }

        @Override
        protected ListManagedFoldersFixedSizeCollection createCollection(List<ListManagedFoldersPage> pages, int collectionSize) {
            return new ListManagedFoldersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagedFoldersPage
    extends AbstractPage<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder, ListManagedFoldersPage> {
        private ListManagedFoldersPage(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ListManagedFoldersResponse response) {
            super(context, response);
        }

        private static ListManagedFoldersPage createEmptyPage() {
            return new ListManagedFoldersPage(null, null);
        }

        @Override
        protected ListManagedFoldersPage createPage(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ListManagedFoldersResponse response) {
            return new ListManagedFoldersPage(context, response);
        }

        @Override
        public ApiFuture<ListManagedFoldersPage> createPageAsync(PageContext<ListManagedFoldersRequest, ListManagedFoldersResponse, ManagedFolder> context, ApiFuture<ListManagedFoldersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFoldersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage, ListFoldersFixedSizeCollection> {
        private ListFoldersFixedSizeCollection(List<ListFoldersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFoldersFixedSizeCollection createEmptyCollection() {
            return new ListFoldersFixedSizeCollection(null, 0);
        }

        @Override
        protected ListFoldersFixedSizeCollection createCollection(List<ListFoldersPage> pages, int collectionSize) {
            return new ListFoldersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFoldersPage
    extends AbstractPage<ListFoldersRequest, ListFoldersResponse, Folder, ListFoldersPage> {
        private ListFoldersPage(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ListFoldersResponse response) {
            super(context, response);
        }

        private static ListFoldersPage createEmptyPage() {
            return new ListFoldersPage(null, null);
        }

        @Override
        protected ListFoldersPage createPage(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ListFoldersResponse response) {
            return new ListFoldersPage(context, response);
        }

        @Override
        public ApiFuture<ListFoldersPage> createPageAsync(PageContext<ListFoldersRequest, ListFoldersResponse, Folder> context, ApiFuture<ListFoldersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

