/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.io.StringReader;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=t!B\u0013'\u0011\u0003)d!B\u001c'\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001eaB!\u0002!\u0003\r\nC\u0011\u0005\u0006\u0007\u000e1\t\u0001R\u0004\u0006O\u0006A\t\u0001\u001b\u0004\u0006\u0003\u0006A\t!\u001b\u0005\u0006\u007f\u0019!\tA\u001b\u0005\u0006W\u001a!\t\u0001\u001c\u0004\u00053\u0006\u0001!\fC\u0003@\u0013\u0011\u0005Q\fC\u0003D\u0013\u0011\u0005qL\u0002\u0003b\u0003\u0001\u0011\u0007\"B \r\t\u0003\u0019\u0007\"B\"\r\t\u0003)ga\u0002>\u0002!\u0003\r\ta\u001f\u0005\u0006y>!\t! \u0005\n\u0003\u0007y!\u0019!D\u0001\u0003\u000bAq!!\u0004\u0010\t\u000b\ty\u0001C\u0004\u0002$=!I!!\n\t\u000f\u0005%rB\"\u0005\u0002,\u001d9\u00111G\u0001\t\u0002\u0005UbA\u0002>\u0002\u0011\u0003\t9\u0004\u0003\u0004@-\u0011\u0005\u0011\u0011\b\u0005\b\u0003w1B\u0011AA\u001f\r\u0019\t\u0019%\u0001\u0001\u0002F!1q(\u0007C\u0001\u0003\u000fB\u0011\"a\u0001\u001a\u0005\u0004%\t!!\u0002\t\u0011\u0005-\u0013\u0004)A\u0005\u0003\u000fAq!!\u000b\u001a\t\u0003\tiE\u0002\u0004\u0002V\u0005\u0001\u0011q\u000b\u0005\u0007\u007fy!\t!!\u0017\t\u0013\u0005\raD1A\u0005\u0002\u0005\u0015\u0001\u0002CA&=\u0001\u0006I!a\u0002\t\u0013\u0005ucD1A\u0005\u0006\u0005}\u0003\u0002CA3=\u0001\u0006i!!\u0019\t\u000f\u0005%b\u0004\"\u0001\u0002h\u0005a1k\u00195f[\u0006DU\r\u001c9fe*\u0011q\u0005K\u0001\u0006gR\fG/\u001a\u0006\u0003S)\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005-b\u0013!C3yK\u000e,H/[8o\u0015\tic&A\u0002tc2T!a\f\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0012\u0014AB1qC\u000eDWMC\u00014\u0003\ry'oZ\u0002\u0001!\t1\u0014!D\u0001'\u00051\u00196\r[3nC\"+G\u000e]3s'\t\t\u0011\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0012AbU2iK6\f'+Z1eKJ\u001c\"aA\u001d\u0002\tI,\u0017\r\u001a\u000b\u0003\u000b:\u0003BA\u000f$I\u0011&\u0011qi\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%cU\"\u0001&\u000b\u0005-c\u0013!\u0002;za\u0016\u001c\u0018BA'K\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u001f\u0012\u0001\r\u0001U\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002R-6\t!K\u0003\u0002T)\u0006\u0011am\u001d\u0006\u0003+B\na\u0001[1e_>\u0004\u0018BA,S\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\\\u0015\u0004\u0007%a!AD*dQ\u0016l\u0017MV\u0019SK\u0006$WM]\n\u0004\u0013eZ\u0006C\u0001/\u0004\u001b\u0005\tA#\u00010\u0011\u0005qKACA#a\u0011\u0015y5\u00021\u0001Q\u00059\u00196\r[3nCZ\u0013$+Z1eKJ\u001c2\u0001D\u001d\\)\u0005!\u0007C\u0001/\r)\t)e\rC\u0003P\u001d\u0001\u0007\u0001+\u0001\u0007TG\",W.\u0019*fC\u0012,'\u000f\u0005\u0002]\rM\u0011a!\u000f\u000b\u0002Q\u0006\u00112M]3bi\u0016\u001c6\r[3nCJ+\u0017\rZ3s)\tYV\u000eC\u0003o\u0011\u0001\u0007q.\u0001\u0006wKJ\u001c\u0018n\u001c8TiJ\u0004\"\u0001]<\u000f\u0005E,\bC\u0001:<\u001b\u0005\u0019(B\u0001;5\u0003\u0019a$o\\8u}%\u0011aoO\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002ww\ta1k\u00195f[\u0006<&/\u001b;feN\u0011q\"O\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003y\u0004\"AO@\n\u0007\u0005\u00051H\u0001\u0003V]&$\u0018a\u0002<feNLwN\\\u000b\u0003\u0003\u000f\u00012AOA\u0005\u0013\r\tYa\u000f\u0002\u0004\u0013:$\u0018!B<sSR,Gc\u0002@\u0002\u0012\u0005U\u0011\u0011\u0004\u0005\u0007\u0003'\u0011\u0002\u0019\u0001%\u0002\u0013-,\u0017pU2iK6\f\u0007BBA\f%\u0001\u0007\u0001*A\u0006wC2,XmU2iK6\f\u0007bBA\u000e%\u0001\u0007\u0011QD\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\t\u0004#\u0006}\u0011bAA\u0011%\n\u0011bi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u000319(/\u001b;f-\u0016\u00148/[8o)\rq\u0018q\u0005\u0005\b\u00037\u0019\u0002\u0019AA\u000f\u0003-9(/\u001b;f'\u000eDW-\\1\u0015\u000fy\fi#a\f\u00022!1\u00111\u0003\u000bA\u0002!Ca!a\u0006\u0015\u0001\u0004A\u0005bBA\u000e)\u0001\u0007\u0011QD\u0001\r'\u000eDW-\\1Xe&$XM\u001d\t\u00039Z\u0019\"AF\u001d\u0015\u0005\u0005U\u0012AE2sK\u0006$XmU2iK6\fwK]5uKJ$B!a\u0010\u0002BA\u0011Al\u0004\u0005\b\u0003\u0007A\u0002\u0019AA\u0004\u00059\u00196\r[3nCZ\u000btK]5uKJ\u001cB!G\u001d\u0002@Q\u0011\u0011\u0011\n\t\u00039f\t\u0001B^3sg&|g\u000e\t\u000b\b}\u0006=\u0013\u0011KA*\u0011\u0019\t\u0019\"\ba\u0001\u0011\"1\u0011qC\u000fA\u0002!Cq!a\u0007\u001e\u0001\u0004\tiB\u0001\bTG\",W.\u0019,3/JLG/\u001a:\u0014\tyI\u0014q\b\u000b\u0003\u00037\u0002\"\u0001\u0018\u0010\u0002%5\u000b\u0005lX+U\r~\u001b\u0005*\u0016(L?NK%,R\u000b\u0003\u0003Cz!!a\u0019\u001e\u0007\u0001y\u0000@A\nN\u0003b{V\u000b\u0016$`\u0007\"+fjS0T\u0013j+\u0005\u0005F\u0004\u007f\u0003S\nY'!\u001c\t\r\u0005MA\u00051\u0001I\u0011\u0019\t9\u0002\na\u0001\u0011\"9\u00111\u0004\u0013A\u0002\u0005u\u0001")
public final class SchemaHelper {

    public static interface SchemaReader {
        public Tuple2<StructType, StructType> read(FSDataInputStream var1);
    }

    public static class SchemaV1Reader
    implements SchemaReader {
        @Override
        public Tuple2<StructType, StructType> read(FSDataInputStream inputStream) {
            String keySchemaStr = inputStream.readUTF();
            String valueSchemaStr = inputStream.readUTF();
            return new Tuple2((Object)StructType$.MODULE$.fromString(keySchemaStr), (Object)StructType$.MODULE$.fromString(valueSchemaStr));
        }
    }

    public static class SchemaV1Writer
    implements SchemaWriter {
        private final int version;

        @Override
        public final void write(StructType keySchema, StructType valueSchema, FSDataOutputStream outputStream) {
            ((SchemaWriter)this).write(keySchema, valueSchema, outputStream);
        }

        @Override
        public int version() {
            return this.version;
        }

        @Override
        public void writeSchema(StructType keySchema, StructType valueSchema, FSDataOutputStream outputStream) {
            outputStream.writeUTF(keySchema.json());
            outputStream.writeUTF(valueSchema.json());
        }

        public SchemaV1Writer() {
            SchemaWriter.$init$(this);
            this.version = 1;
        }
    }

    public static class SchemaV2Reader
    implements SchemaReader {
        @Override
        public Tuple2<StructType, StructType> read(FSDataInputStream inputStream) {
            scala.collection.mutable.StringBuilder buf = new scala.collection.mutable.StringBuilder();
            int numKeyChunks = inputStream.readInt();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeyChunks).foreach((Function1 & Serializable & scala.Serializable)x$1 -> buf.append(inputStream.readUTF()));
            String keySchemaStr = buf.toString();
            buf.clear();
            int numValueChunks = inputStream.readInt();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numValueChunks).foreach((Function1 & Serializable & scala.Serializable)x$2 -> buf.append(inputStream.readUTF()));
            String valueSchemaStr = buf.toString();
            return new Tuple2((Object)StructType$.MODULE$.fromString(keySchemaStr), (Object)StructType$.MODULE$.fromString(valueSchemaStr));
        }
    }

    public static class SchemaV2Writer
    implements SchemaWriter {
        private final int version;

        @Override
        public final void write(StructType keySchema, StructType valueSchema, FSDataOutputStream outputStream) {
            ((SchemaWriter)this).write(keySchema, valueSchema, outputStream);
        }

        @Override
        public int version() {
            return this.version;
        }

        public final int MAX_UTF_CHUNK_SIZE() {
            return 65535;
        }

        @Override
        public void writeSchema(StructType keySchema, StructType valueSchema, FSDataOutputStream outputStream) {
            char[] buf = new char[65535];
            String keySchemaJson = keySchema.json();
            int numKeyChunks = (keySchemaJson.length() - 1) / 65535 + 1;
            StringReader keyStringReader = new StringReader(keySchemaJson);
            outputStream.writeInt(numKeyChunks);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeyChunks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
                int numRead = keyStringReader.read(buf, 0, 65535);
                outputStream.writeUTF(new String(buf, 0, numRead));
            });
            String valueSchemaJson = valueSchema.json();
            int numValueChunks = (valueSchemaJson.length() - 1) / 65535 + 1;
            StringReader valueStringReader = new StringReader(valueSchemaJson);
            outputStream.writeInt(numValueChunks);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numValueChunks).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> {
                int numRead = valueStringReader.read(buf, 0, 65535);
                outputStream.writeUTF(new String(buf, 0, numRead));
            });
        }

        public SchemaV2Writer() {
            SchemaWriter.$init$(this);
            this.version = 2;
        }
    }

    public static interface SchemaWriter {
        public int version();

        default public void write(StructType keySchema, StructType valueSchema, FSDataOutputStream outputStream) {
            this.writeVersion(outputStream);
            this.writeSchema(keySchema, valueSchema, outputStream);
        }

        private void writeVersion(FSDataOutputStream outputStream) {
            outputStream.writeUTF(new StringBuilder(1).append("v").append(this.version()).toString());
        }

        public void writeSchema(StructType var1, StructType var2, FSDataOutputStream var3);

        public static void $init$(SchemaWriter $this) {
        }
    }
}

