/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.metastore;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.emr.secretagent.client.SecretAgentClient;
import com.amazonaws.emr.secretagent.client.SecretAgentClientFactory;
import com.amazonaws.emr.secretagent.client.model.SecretAgentClientException;
import com.amazonaws.emr.secretagent.client.model.TemporaryCredentials;
import com.amazonaws.glue.catalog.exceptions.LakeFormationException;
import com.google.common.annotations.VisibleForTesting;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.log4j.Logger;

public final class LakeFormationCredentialsProvider
implements AWSCredentialsProvider {
    private static final Logger logger = Logger.getLogger(LakeFormationCredentialsProvider.class);
    static final int SECONDS_BEFORE_EXPIRATION_TO_REFRESH_CREDENTIALS = 300;
    private final SecretAgentClient secretAgentClient;
    private ZonedDateTime expiration;
    private AWSSessionCredentials currentCredentials;

    LakeFormationCredentialsProvider() {
        this.secretAgentClient = SecretAgentClientFactory.getDefaultClient();
    }

    @VisibleForTesting
    LakeFormationCredentialsProvider(SecretAgentClient secretAgentClient) {
        this.secretAgentClient = secretAgentClient;
    }

    public AWSCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.currentCredentials;
    }

    public void refresh() {
        this.startSession();
    }

    private void startSession() {
        TemporaryCredentials response = this.getCredentialsFromSecretAgent();
        this.currentCredentials = new BasicSessionCredentials(response.getAwsAccessKeyId(), response.getAwsSecretKey(), response.getSessionToken());
        this.expiration = response.getExpiration();
    }

    private TemporaryCredentials getCredentialsFromSecretAgent() {
        try {
            Optional response = this.secretAgentClient.getTemporaryCredentialsForMetadata();
            if (!response.isPresent()) {
                throw new LakeFormationException("User login details not available.");
            }
            return (TemporaryCredentials)response.get();
        }
        catch (SecretAgentClientException ex) {
            throw new LakeFormationException("Internal error while talking to Lake Formation.");
        }
    }

    private boolean needsNewSession() {
        return this.currentCredentials == null || !this.isCredentialsValid();
    }

    private boolean isCredentialsValid() {
        long timeRemaining = this.expiration.toInstant().toEpochMilli() - System.currentTimeMillis();
        return timeRemaining > 300000L;
    }
}

