/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit.impl;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.s3a.audit.OperationAuditor;
import org.apache.hadoop.fs.s3a.audit.OperationAuditorOptions;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.service.AbstractService;

public abstract class AbstractOperationAuditor
extends AbstractService
implements OperationAuditor {
    public static final String BASE = UUID.randomUUID().toString();
    private static final AtomicLong SPAN_ID_COUNTER = new AtomicLong(1L);
    private IOStatisticsStore iostatistics;
    private OperationAuditorOptions options;
    private final UUID auditorUUID = UUID.randomUUID();
    private final String auditorID = this.auditorUUID.toString();

    protected AbstractOperationAuditor(String name) {
        super(name);
    }

    @Override
    public void init(OperationAuditorOptions opts) {
        this.options = opts;
        this.iostatistics = Objects.requireNonNull(opts.getIoStatisticsStore());
        this.init(opts.getConfiguration());
    }

    @Override
    public String getAuditorId() {
        return this.auditorID;
    }

    public IOStatisticsStore getIOStatistics() {
        return this.iostatistics;
    }

    protected OperationAuditorOptions getOptions() {
        return this.options;
    }

    protected final String createSpanID() {
        return String.format("%s-%08d", this.auditorID, SPAN_ID_COUNTER.incrementAndGet());
    }
}

