/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.magic;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.WriteOperationHelper;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.statistics.PutTrackerStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.model.CompletedPart;

@InterfaceAudience.Private
public abstract class MagicCommitTracker
extends PutTracker {
    public static final Logger LOG = LoggerFactory.getLogger(MagicCommitTracker.class);
    private final String originalDestKey;
    private final String pendingPartKey;
    private final Path path;
    private final WriteOperationHelper writer;
    private final String bucket;
    protected static final byte[] EMPTY = new byte[0];
    private final PutTrackerStatistics trackerStatistics;

    public MagicCommitTracker(Path path, String bucket, String originalDestKey, String destKey, String pendingsetKey, WriteOperationHelper writer, PutTrackerStatistics trackerStatistics) {
        super(destKey);
        this.bucket = bucket;
        this.path = path;
        this.originalDestKey = originalDestKey;
        this.pendingPartKey = pendingsetKey;
        this.writer = writer;
        this.trackerStatistics = Objects.requireNonNull(trackerStatistics);
        LOG.info("File {} is written as magic file to path {}", (Object)path, (Object)destKey);
    }

    @Override
    public boolean initialize() throws IOException {
        return true;
    }

    @Override
    public boolean outputImmediatelyVisible() {
        return false;
    }

    @Override
    public abstract boolean aboutToComplete(String var1, List<CompletedPart> var2, long var3, IOStatistics var5) throws IOException;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MagicCommitTracker{");
        sb.append(", destKey=").append(this.getDestKey());
        sb.append(", pendingPartKey='").append(this.pendingPartKey).append('\'');
        sb.append(", path=").append(this.path);
        sb.append(", writer=").append(this.writer);
        sb.append('}');
        return sb.toString();
    }

    public String getOriginalDestKey() {
        return this.originalDestKey;
    }

    public String getPendingPartKey() {
        return this.pendingPartKey;
    }

    public Path getPath() {
        return this.path;
    }

    public String getBucket() {
        return this.bucket;
    }

    public WriteOperationHelper getWriter() {
        return this.writer;
    }

    public PutTrackerStatistics getTrackerStatistics() {
        return this.trackerStatistics;
    }
}

