/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.package$;
import spire.math.prime.BitSet;
import spire.math.prime.FactorHeap;
import spire.math.prime.SieveSegment$;
import spire.math.prime.SieveUtil;

@ScalaSignature(bytes="\u0006\u0001\u0005Uw!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%\ta\u0010\u0005\u0007\r\u0006\u0001\u000b\u0011\u0002!\t\u000f\u001d\u000b\u0011\u0011!CA\u0011\"I\u0011qW\u0001\u0002\u0002\u0013\u0005\u0015\u0011\u0018\u0005\n\u0003\u0017\f\u0011\u0011!C\u0005\u0003\u001b4A!\r\u0015A\u0015\"Aa\n\u0003BK\u0002\u0013\u0005q\n\u0003\u0005U\u0011\tE\t\u0015!\u0003Q\u0011!)\u0006B!f\u0001\n\u00031\u0006\u0002\u0003.\t\u0005#\u0005\u000b\u0011B,\t\u0011mC!Q3A\u0005\u0002=C\u0001\u0002\u0018\u0005\u0003\u0012\u0003\u0006I\u0001\u0015\u0005\u0006y!!\t!\u0018\u0005\u0006C\"!\tA\u0019\u0005\u0006Q\"!\t!\u001b\u0005\u0006W\"!\t\u0001\u001c\u0005\u0006c\"!\tA\u001d\u0005\u0006i\"!\t!\u001e\u0005\u0006o\"!\t\u0001\u001f\u0005\b\u0003\u001fAA\u0011AA\t\u0011\u001d\t\u0019\u0002\u0003C\u0005\u0003+Aq!!\u0007\t\t\u0013\tY\u0002C\u0004\u00024!!\t!!\u000e\t\u000f\u0005m\u0002\u0002\"\u0001\u0002>!I\u0011\u0011\t\u0005\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u0017B\u0011\u0013!C\u0001\u0003\u001bB\u0011\"a\u0018\t#\u0003%\t!!\u0019\t\u0013\u0005\u0015\u0004\"%A\u0005\u0002\u00055\u0003\"CA4\u0011\u0005\u0005I\u0011IA5\u0011%\tY\bCA\u0001\n\u0003\ti\bC\u0005\u0002\u0000!\t\t\u0011\"\u0001\u0002\u0002\"I\u0011Q\u0012\u0005\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003;C\u0011\u0011!C\u0001\u0003?C\u0011\"a)\t\u0003\u0003%\t%!*\t\u0013\u0005\u001d\u0006\"!A\u0005B\u0005%\u0006\"CAV\u0011\u0005\u0005I\u0011IAW\u00031\u0019\u0016.\u001a<f'\u0016<W.\u001a8u\u0015\tI#&A\u0003qe&lWM\u0003\u0002,Y\u0005!Q.\u0019;i\u0015\u0005i\u0013!B:qSJ,7\u0001\u0001\t\u0003a\u0005i\u0011\u0001\u000b\u0002\r'&,g/Z*fO6,g\u000e^\n\u0004\u0003MJ\u0004C\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*$AB!osJ+g\r\u0005\u00025u%\u00111(\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\nqa\u001e5fK2\u001c\u0004'F\u0001A!\r!\u0014iQ\u0005\u0003\u0005V\u0012Q!\u0011:sCf\u0004\"\u0001\u000e#\n\u0005\u0015+$aA%oi\u0006Aq\u000f[3fYN\u0002\u0004%A\u0003baBd\u0017\u0010F\u0004J\u0003c\u000b\u0019,!.\u0011\u0005AB1\u0003\u0002\u00054\u0017f\u0002\"\u0001\u000e'\n\u00055+$a\u0002)s_\u0012,8\r^\u0001\u0006gR\f'\u000f^\u000b\u0002!B\u0011\u0011KU\u0007\u0002U%\u00111K\u000b\u0002\t'\u00064W\rT8oO\u000611\u000f^1si\u0002\na\u0001\u001d:j[\u0016\u001cX#A,\u0011\u0005AB\u0016BA-)\u0005\u0019\u0011\u0015\u000e^*fi\u00069\u0001O]5nKN\u0004\u0013AB2vi>4g-A\u0004dkR|gM\u001a\u0011\u0015\t%sv\f\u0019\u0005\u0006\u001d>\u0001\r\u0001\u0015\u0005\u0006+>\u0001\ra\u0016\u0005\u00067>\u0001\r\u0001U\u0001\bSN\u0004&/[7f)\t\u0019g\r\u0005\u00025I&\u0011Q-\u000e\u0002\b\u0005>|G.Z1o\u0011\u00159\u0007\u00031\u0001Q\u0003\u0005q\u0017aC5t\u0007>l\u0007o\\:ji\u0016$\"a\u00196\t\u000b\u001d\f\u0002\u0019\u0001)\u0002\u0007M,G\u000f\u0006\u0002naB\u0011AG\\\u0005\u0003_V\u0012A!\u00168ji\")qM\u0005a\u0001!\u0006)QO\\:fiR\u0011Qn\u001d\u0005\u0006ON\u0001\r\u0001U\u0001\n]\u0016DH/\u00114uKJ$\"\u0001\u0015<\t\u000b\u001d$\u0002\u0019\u0001)\u0002\t%t\u0017\u000e\u001e\u000b\u0005[f\f)\u0001C\u0003{+\u0001\u000710A\u0003gCN$\u0018\u000f\u0005\u0002}\u007f:\u0011\u0001'`\u0005\u0003}\"\n\u0011bU5fm\u0016,F/\u001b7\n\t\u0005\u0005\u00111\u0001\u0002\f\r\u0006\u001cHOR1di>\u00148O\u0003\u0002\u007fQ!9\u0011qA\u000bA\u0002\u0005%\u0011!B:m_^\f\bc\u0001\u0019\u0002\f%\u0019\u0011Q\u0002\u0015\u0003\u0015\u0019\u000b7\r^8s\u0011\u0016\f\u0007/A\u0005j]&$Xj\u001c34aQ\tQ.A\u0007j]&$hI]8n\u0003J\u0014\u0018-\u001f\u000b\u0004[\u0006]\u0001\"\u0002>\u0018\u0001\u0004Y\u0018!D5oSR4%o\\7Rk\u0016,X\rF\u0003n\u0003;\t\t\u0003\u0003\u0004\u0002 a\u0001\r\u0001U\u0001\u0006Y&l\u0017\u000e\u001e\u0005\b\u0003GA\u0002\u0019AA\u0005\u0003\u0005\t\bf\u0001\r\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.U\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\u000b\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006I\u0011N\\5u\r&\u00148\u000f\u001e\u000b\u0006[\u0006]\u0012\u0011\b\u0005\u0006uf\u0001\ra\u001f\u0005\b\u0003\u000fI\u0002\u0019AA\u0005\u0003!Ig.\u001b;SKN$HcA7\u0002@!9\u0011q\u0001\u000eA\u0002\u0005%\u0011\u0001B2paf$r!SA#\u0003\u000f\nI\u0005C\u0004O7A\u0005\t\u0019\u0001)\t\u000fU[\u0002\u0013!a\u0001/\"91l\u0007I\u0001\u0002\u0004\u0001\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fR3\u0001UA)W\t\t\u0019\u0006\u0005\u0003\u0002V\u0005mSBAA,\u0015\u0011\tI&a\u000b\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA/\u0003/\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0019+\u0007]\u000b\t&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\t1\fgn\u001a\u0006\u0003\u0003k\nAA[1wC&!\u0011\u0011PA8\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t1)\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0015\u0011\u0012\t\u0004i\u0005\u0015\u0015bAADk\t\u0019\u0011I\\=\t\u0011\u0005-\u0015%!AA\u0002\r\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAI!\u0019\t\u0019*!'\u0002\u00046\u0011\u0011Q\u0013\u0006\u0004\u0003/+\u0014AC2pY2,7\r^5p]&!\u00111TAK\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\r\f\t\u000bC\u0005\u0002\f\u000e\n\t\u00111\u0001\u0002\u0004\u0006A\u0001.Y:i\u0007>$W\rF\u0001D\u0003!!xn\u0015;sS:<GCAA6\u0003\u0019)\u0017/^1mgR\u00191-a,\t\u0013\u0005-e%!AA\u0002\u0005\r\u0005\"\u0002(\u0006\u0001\u0004\u0001\u0006\"B+\u0006\u0001\u00049\u0006\"B.\u0006\u0001\u0004\u0001\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003w\u000b9\rE\u00035\u0003{\u000b\t-C\u0002\u0002@V\u0012aa\u00149uS>t\u0007C\u0002\u001b\u0002DB;\u0006+C\u0002\u0002FV\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAe\r\u0005\u0005\t\u0019A%\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAh!\u0011\ti'!5\n\t\u0005M\u0017q\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class SieveSegment
implements Product,
Serializable {
    private final SafeLong start;
    private final BitSet primes;
    private final SafeLong cutoff;

    public static Option<Tuple3<SafeLong, BitSet, SafeLong>> unapply(SieveSegment sieveSegment) {
        return SieveSegment$.MODULE$.unapply(sieveSegment);
    }

    public static SieveSegment apply(SafeLong safeLong, BitSet bitSet, SafeLong safeLong2) {
        return SieveSegment$.MODULE$.apply(safeLong, bitSet, safeLong2);
    }

    public static int[] wheel30() {
        return SieveSegment$.MODULE$.wheel30();
    }

    public SafeLong start() {
        return this.start;
    }

    public BitSet primes() {
        return this.primes;
    }

    public SafeLong cutoff() {
        return this.cutoff;
    }

    public boolean isPrime(SafeLong n) {
        return this.primes().apply(n.$minus(this.start()).toInt());
    }

    public boolean isComposite(SafeLong n) {
        return !this.primes().apply(n.$minus(this.start()).toInt());
    }

    public void set(SafeLong n) {
        this.primes().$plus$eq(n.$minus(this.start()).toInt());
    }

    public void unset(SafeLong n) {
        this.primes().$minus$eq(n.$minus(this.start()).toInt());
    }

    public SafeLong nextAfter(SafeLong n) {
        int len = this.primes().length();
        for (int i = n.$minus(this.start()).$plus(2L).toInt(); i < len; i += 2) {
            if (!this.primes().apply(i)) continue;
            return this.start().$plus(i);
        }
        return SafeLong$.MODULE$.apply(-1L);
    }

    public void init(SieveUtil.FastFactors fastq, FactorHeap slowq) {
        this.initMod30();
        if (BoxesRunTime.equalsNumObject((Number)((Object)this.start()), (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.initFirst(fastq, slowq);
        } else {
            SafeLong limit = package$.MODULE$.min(this.cutoff().$times$times(2), this.start().$plus(this.primes().length()), SafeLong$.MODULE$.SafeLongIsReal());
            this.initFromArray(fastq);
            this.initFromQueue(limit, slowq);
            this.initRest(slowq);
        }
    }

    public void initMod30() {
        block1: {
            int[] arr = this.primes().array();
            Predef$.MODULE$.assert(arr.length % 15 == 0);
            int limit = arr.length;
            int[] wheel = SieveSegment$.MODULE$.wheel30();
            for (int index$macro$1 = 0; index$macro$1 < limit; index$macro$1 += 15) {
                System.arraycopy(wheel, 0, arr, index$macro$1, 15);
            }
            if (!BoxesRunTime.equalsNumObject((Number)((Object)this.start()), (Object)BoxesRunTime.boxToLong((long)0L))) break block1;
            this.primes().$minus$eq(1);
            this.primes().$plus$eq(2);
            this.primes().$plus$eq(3);
            this.primes().$plus$eq(5);
        }
    }

    private void initFromArray(SieveUtil.FastFactors fastq) {
        long len;
        SieveUtil.FastFactor[] arr = fastq.arr();
        long l = len = this.start().$plus(this.primes().length()).$less((Object)this.cutoff()) ? this.cutoff().$minus(this.start()).toLong() : (long)this.primes().length();
        for (int i = 0; i < arr.length; ++i) {
            SieveUtil.FastFactor factor = arr[i];
            int j = factor.m().$minus(this.start()).toInt();
            int k = factor.p();
            int kk = k + k;
            long lim = len - (long)kk;
            this.primes().$minus$eq(j);
            while ((long)j < lim) {
                this.primes().$minus$eq(j += kk);
            }
            factor.m_$eq(this.start().$plus(j).$plus(kk));
        }
    }

    private void initFromQueue(SafeLong limit, FactorHeap q) {
        SieveUtil.Factor factor;
        while (true) {
            SafeLong safeLong;
            int i;
            if (q.isEmpty()) {
                return;
            }
            factor = q.dequeue();
            SafeLong m = factor.next();
            if (!m.$less((Object)limit)) break;
            SafeLong p = factor.p();
            int len = this.primes().length();
            if (p.$less((Object)SafeLong$.MODULE$.apply(len))) {
                int k = p.toInt();
                int kk = k + k;
                for (i = m.$minus(this.start()).toInt(); i < len; i += kk) {
                    this.primes().$minus$eq(i);
                }
                safeLong = this.start().$plus(i);
            } else {
                this.primes().$minus$eq(i);
                safeLong = m.$plus(p);
            }
            SafeLong m2 = safeLong;
            factor.next_$eq(m2);
            q.$plus$eq(factor);
        }
        q.$plus$eq(factor);
    }

    public void initFirst(SieveUtil.FastFactors fastq, FactorHeap slowq) {
        int len = this.primes().length();
        ArrayBuffer buf = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        for (int p = 1; p < len; p += 2) {
            BoxedUnit boxedUnit;
            if (this.primes().apply(p)) {
                long m = (long)p * (long)p;
                if (m < (long)len) {
                    int pp = p + p;
                    int k = (int)m;
                    this.primes().$minus$eq(k);
                    int lim = len - pp;
                    while (k < lim) {
                        this.primes().$minus$eq(k += pp);
                    }
                    m = (long)k + (long)pp;
                }
                if (p < 7) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (m - (long)this.primes().length() < (long)this.primes().length()) {
                    boxedUnit = buf.$plus$eq((Object)new SieveUtil.FastFactor(p, SafeLong$.MODULE$.apply(m)));
                    continue;
                }
                if (this.cutoff().$greater((Object)SafeLong$.MODULE$.apply(p))) {
                    slowq.$plus$eq(new SieveUtil.Factor(SafeLong$.MODULE$.apply(p), SafeLong$.MODULE$.apply(m)));
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        fastq.arr_$eq((SieveUtil.FastFactor[])buf.toArray(ClassTag$.MODULE$.apply(SieveUtil.FastFactor.class)));
    }

    public void initRest(FactorHeap slowq) {
        if (this.start().$greater$eq((Object)this.cutoff())) {
            return;
        }
        long len = this.start().$plus(this.primes().length()).$greater$eq((Object)this.cutoff()) ? this.cutoff().$minus(this.start()).toLong() : (long)this.primes().length();
        int i = 1;
        while ((long)i < len) {
            if (this.primes().apply(i)) {
                SafeLong p = this.start().$plus(i);
                slowq.$plus$eq(new SieveUtil.Factor(p, p.$times$times(2)));
            }
            i += 2;
        }
    }

    public SieveSegment copy(SafeLong start, BitSet primes, SafeLong cutoff) {
        return new SieveSegment(start, primes, cutoff);
    }

    public SafeLong copy$default$1() {
        return this.start();
    }

    public BitSet copy$default$2() {
        return this.primes();
    }

    public SafeLong copy$default$3() {
        return this.cutoff();
    }

    public String productPrefix() {
        return "SieveSegment";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.start();
                break;
            }
            case 1: {
                object = this.primes();
                break;
            }
            case 2: {
                object = this.cutoff();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SieveSegment;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SieveSegment)) return false;
        boolean bl = true;
        if (!bl) return false;
        SieveSegment sieveSegment = (SieveSegment)x$1;
        if (!BoxesRunTime.equalsNumNum((Number)((Object)this.start()), (Number)((Object)sieveSegment.start()))) return false;
        BitSet bitSet = this.primes();
        BitSet bitSet2 = sieveSegment.primes();
        if (bitSet == null) {
            if (bitSet2 != null) {
                return false;
            }
        } else if (!((Object)bitSet).equals(bitSet2)) return false;
        if (!BoxesRunTime.equalsNumNum((Number)((Object)this.cutoff()), (Number)((Object)sieveSegment.cutoff()))) return false;
        if (!sieveSegment.canEqual(this)) return false;
        return true;
    }

    public SieveSegment(SafeLong start, BitSet primes, SafeLong cutoff) {
        this.start = start;
        this.primes = primes;
        this.cutoff = cutoff;
        Product.$init$((Product)this);
    }
}

