/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import javax.jdo.AttributeConverter;
import org.datanucleus.store.types.converters.TypeConverter;

public class JDOTypeConverter<X, Y>
implements TypeConverter<X, Y> {
    private static final long serialVersionUID = -4250901331525617340L;
    AttributeConverter<X, Y> jdoConverter;
    Class<X> memberType;
    Class<Y> dbType;

    public JDOTypeConverter(AttributeConverter<X, Y> conv, Class<X> memberType, Class<Y> dbType) {
        this.jdoConverter = conv;
        this.dbType = dbType;
        this.memberType = memberType;
    }

    public Class<X> getMemberClass() {
        return this.memberType;
    }

    public Class<Y> getDatastoreClass() {
        return this.dbType;
    }

    public Y toDatastoreType(X memberValue) {
        return (Y)this.jdoConverter.convertToDatastore(memberValue);
    }

    public X toMemberType(Y datastoreValue) {
        return (X)this.jdoConverter.convertToAttribute(datastoreValue);
    }

    public String toString() {
        return "JDOTypeConverter<" + this.memberType.getName() + "," + this.dbType.getName() + ">";
    }
}

