/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusUserException;

class ParamLoggingPreparedStatement
implements PreparedStatement {
    private final PreparedStatement ps;
    private SubStatement currentStatement = null;
    private List subStatements = null;
    private boolean paramAngleBrackets = true;
    private static final String DN_UNPRINTABLE = "DN_UNPRINTABLE";

    public ParamLoggingPreparedStatement(PreparedStatement ps, String jdbcSql) {
        this.ps = ps;
        this.currentStatement = new SubStatement(jdbcSql);
    }

    public void setParamsInAngleBrackets(boolean flag) {
        this.paramAngleBrackets = flag;
    }

    public String getStatementWithParamsReplaced() {
        StringBuilder statementWithParams = new StringBuilder();
        if (this.subStatements == null) {
            return this.getStatementWithParamsReplacedForSubStatement(this.currentStatement);
        }
        statementWithParams.append("BATCH [");
        Iterator iter = this.subStatements.iterator();
        while (iter.hasNext()) {
            SubStatement stParams = (SubStatement)iter.next();
            String stmt = this.getStatementWithParamsReplacedForSubStatement(stParams);
            statementWithParams.append(stmt);
            if (!iter.hasNext()) continue;
            statementWithParams.append("; ");
        }
        statementWithParams.append("]");
        return statementWithParams.toString();
    }

    private String getStatementWithParamsReplacedForSubStatement(SubStatement stParams) {
        StringBuilder statementWithParams = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(stParams.statementText, "?", true);
        int i = 1;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("?")) {
                Integer paramPos;
                String paramValue = DN_UNPRINTABLE;
                if (stParams.parameters.containsKey(paramPos = Integer.valueOf(i++))) {
                    paramValue = stParams.parameters.get(paramPos);
                }
                this.appendParamValue(statementWithParams, paramValue);
                continue;
            }
            statementWithParams.append(token);
        }
        if (i > 1) {
            return statementWithParams.toString();
        }
        return stParams.statementText;
    }

    private void appendParamValue(StringBuilder statementWithParams, Object paramValue) {
        if (this.paramAngleBrackets) {
            if (paramValue instanceof String) {
                if (paramValue.equals(DN_UNPRINTABLE)) {
                    statementWithParams.append("<UNPRINTABLE>");
                } else {
                    statementWithParams.append("<'" + paramValue + "'>");
                }
            } else {
                statementWithParams.append("<" + paramValue + ">");
            }
        } else if (paramValue instanceof String) {
            if (paramValue.equals(DN_UNPRINTABLE)) {
                statementWithParams.append("<UNPRINTABLE'>");
            } else {
                statementWithParams.append("'" + paramValue + "'");
            }
        } else {
            statementWithParams.append("" + paramValue);
        }
    }

    private void setParameter(int i, Object p) {
        this.currentStatement.parameters.put(i, p);
    }

    public Object getParameter(int i) {
        return this.currentStatement.parameters.get(i);
    }

    @Override
    public void addBatch() throws SQLException {
        SubStatement newSubStmt = new SubStatement(this.currentStatement.statementText);
        newSubStmt.parameters.putAll(this.currentStatement.parameters);
        if (this.subStatements == null) {
            this.subStatements = new ArrayList();
        }
        this.subStatements.add(newSubStmt);
        this.ps.addBatch();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SubStatement newSubStmt = new SubStatement(sql);
        newSubStmt.parameters.putAll(this.currentStatement.parameters);
        if (this.subStatements == null) {
            this.subStatements = new ArrayList();
        }
        this.subStatements.add(newSubStmt);
        this.ps.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.subStatements != null) {
            this.subStatements.clear();
        }
        this.ps.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentStatement.parameters.clear();
        if (this.subStatements != null) {
            for (SubStatement subStmt : this.subStatements) {
                subStmt.parameters.clear();
            }
        }
        this.ps.clearParameters();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.ps.close();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.setParameter(i, x);
        this.ps.setArray(i, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.ps.setBlob(i, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ps.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.ps.setClob(i, x);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setDate(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setDouble(parameterIndex, x);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, Float.valueOf(x));
        this.ps.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setLong(parameterIndex, x);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(paramIndex, null);
        this.ps.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, null);
        this.ps.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setObject(parameterIndex, x);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.setParameter(i, x);
        this.ps.setRef(i, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NucleusUserException("Not supported");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, x);
        this.ps.setURL(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ps.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ps.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setClob(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.ps.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParameter(parameterIndex, value);
        this.ps.setNString(parameterIndex, value);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ps.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.ps.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ps.setPoolable(poolable);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.ps.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.ps.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.ps.setNClob(parameterIndex, reader);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ps.setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.ps.setSQLXML(parameterIndex, xmlObject);
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return PreparedStatement.class.equals((Object)iface);
    }

    public Object unwrap(Class iface) throws SQLException {
        if (!PreparedStatement.class.equals((Object)iface)) {
            throw new SQLException("PreparedStatement of type [" + this.getClass().getName() + "] can only be unwrapped as [java.sql.PreparedStatement], not as [" + iface.getName() + "]");
        }
        return this;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.ps.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.ps.isCloseOnCompletion();
    }

    static class SubStatement {
        public final Map parameters = new HashMap();
        public final String statementText;

        public SubStatement(String statementText) {
            this.statementText = statementText;
        }
    }
}

