/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hive.spark.client.metrics.Metrics;
import org.apache.hive.spark.client.metrics.ShuffleReadMetrics;

final class SparkMetricsUtils {
    private static final String EXECUTOR_DESERIALIZE_TIME = "ExecutorDeserializeTime";
    private static final String EXECUTOR_RUN_TIME = "ExecutorRunTime";
    private static final String RESULT_SIZE = "ResultSize";
    private static final String JVM_GC_TIME = "JvmGCTime";
    private static final String RESULT_SERIALIZATION_TIME = "ResultSerializationTime";
    private static final String MEMORY_BYTES_SPLIED = "MemoryBytesSpilled";
    private static final String DISK_BYTES_SPILLED = "DiskBytesSpilled";
    private static final String BYTES_READ = "BytesRead";
    private static final String REMOTE_BLOCKS_FETCHED = "RemoteBlocksFetched";
    private static final String LOCAL_BLOCKS_FETCHED = "LocalBlocksFetched";
    private static final String TOTAL_BLOCKS_FETCHED = "TotalBlocksFetched";
    private static final String FETCH_WAIT_TIME = "FetchWaitTime";
    private static final String REMOTE_BYTES_READ = "RemoteBytesRead";
    private static final String SHUFFLE_BYTES_WRITTEN = "ShuffleBytesWritten";
    private static final String SHUFFLE_WRITE_TIME = "ShuffleWriteTime";

    private SparkMetricsUtils() {
    }

    static Map<String, Long> collectMetrics(Metrics allMetrics) {
        LinkedHashMap<String, Long> results = new LinkedHashMap<String, Long>();
        results.put(EXECUTOR_DESERIALIZE_TIME, allMetrics.executorDeserializeTime);
        results.put(EXECUTOR_RUN_TIME, allMetrics.executorRunTime);
        results.put(RESULT_SIZE, allMetrics.resultSize);
        results.put(JVM_GC_TIME, allMetrics.jvmGCTime);
        results.put(RESULT_SERIALIZATION_TIME, allMetrics.resultSerializationTime);
        results.put(MEMORY_BYTES_SPLIED, allMetrics.memoryBytesSpilled);
        results.put(DISK_BYTES_SPILLED, allMetrics.diskBytesSpilled);
        if (allMetrics.inputMetrics != null) {
            results.put(BYTES_READ, allMetrics.inputMetrics.bytesRead);
        }
        if (allMetrics.shuffleReadMetrics != null) {
            ShuffleReadMetrics shuffleReadMetrics = allMetrics.shuffleReadMetrics;
            long rbf = shuffleReadMetrics.remoteBlocksFetched;
            long lbf = shuffleReadMetrics.localBlocksFetched;
            results.put(REMOTE_BLOCKS_FETCHED, rbf);
            results.put(LOCAL_BLOCKS_FETCHED, lbf);
            results.put(TOTAL_BLOCKS_FETCHED, rbf + lbf);
            results.put(FETCH_WAIT_TIME, shuffleReadMetrics.fetchWaitTime);
            results.put(REMOTE_BYTES_READ, shuffleReadMetrics.remoteBytesRead);
        }
        if (allMetrics.shuffleWriteMetrics != null) {
            results.put(SHUFFLE_BYTES_WRITTEN, allMetrics.shuffleWriteMetrics.shuffleBytesWritten);
            results.put(SHUFFLE_WRITE_TIME, allMetrics.shuffleWriteMetrics.shuffleWriteTime);
        }
        return results;
    }
}

