/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class CastLongToDate
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputColumn;
    private int outputColumn;
    private transient Date date = new Date(0L);

    public CastLongToDate() {
    }

    public CastLongToDate(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inV = (LongColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        if (n == 0) {
            return;
        }
        switch (this.inputTypes[0]) {
            case DATE: {
                inV.copySelected(batch.selectedInUse, batch.selected, batch.size, outV);
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String getOutputType() {
        return "date";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DATE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

