/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveDefaultCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveOnTezCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveRelMdCost;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistinctRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdMemory;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdParallelism;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdPredicates;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdRowCount;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSelectivity;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdSize;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.HiveRelMdUniqueKeys;

public class HiveDefaultRelMetadataProvider {
    private final HiveConf hiveConf;

    public HiveDefaultRelMetadataProvider(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
    }

    public RelMetadataProvider getMetadataProvider() {
        HiveCostModel cm = HiveConf.getVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_EXTENDED_COST_MODEL) ? HiveOnTezCostModel.getCostModel(this.hiveConf) : HiveDefaultCostModel.getCostModel();
        Double maxSplitSize = HiveConf.getLongVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
        return ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)HiveRelMdDistinctRowCount.SOURCE, (Object)new HiveRelMdCost(cm).getMetadataProvider(), (Object)HiveRelMdSelectivity.SOURCE, (Object)HiveRelMdRowCount.SOURCE, (Object)HiveRelMdUniqueKeys.SOURCE, (Object)HiveRelMdSize.SOURCE, (Object)HiveRelMdMemory.SOURCE, (Object)new HiveRelMdParallelism(maxSplitSize).getMetadataProvider(), (Object)HiveRelMdDistribution.SOURCE, (Object)HiveRelMdCollation.SOURCE, (Object)HiveRelMdPredicates.SOURCE, (Object)DefaultRelMetadataProvider.INSTANCE, (Object[])new RelMetadataProvider[0]));
    }
}

