/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.io.File;
import java.io.Flushable;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.log4j.FileAppender;
import org.apache.log4j.spi.LoggingEvent;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ContainerLogAppender
extends FileAppender
implements Flushable {
    private String containerLogDir;
    private String containerLogFile;
    private int maxEvents;
    private Deque<LoggingEvent> eventBuffer;
    private boolean closed = false;
    private static final long EVENT_SIZE = 100L;

    public synchronized void activateOptions() {
        if (this.maxEvents > 0) {
            this.eventBuffer = new ArrayDeque<LoggingEvent>();
        }
        this.setFile(new File(this.containerLogDir, this.containerLogFile).toString());
        this.setAppend(true);
        super.activateOptions();
    }

    public synchronized void append(LoggingEvent event) {
        if (this.closed) {
            return;
        }
        if (this.eventBuffer != null) {
            if (this.eventBuffer.size() == this.maxEvents) {
                this.eventBuffer.removeFirst();
            }
            this.eventBuffer.addLast(event);
        } else {
            super.append(event);
        }
    }

    @Override
    public void flush() {
        if (this.qw != null) {
            this.qw.flush();
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.eventBuffer != null) {
                for (LoggingEvent event : this.eventBuffer) {
                    super.append(event);
                }
                this.eventBuffer = null;
            }
            super.close();
        }
    }

    public String getContainerLogDir() {
        return this.containerLogDir;
    }

    public void setContainerLogDir(String containerLogDir) {
        this.containerLogDir = containerLogDir;
    }

    public String getContainerLogFile() {
        return this.containerLogFile;
    }

    public void setContainerLogFile(String containerLogFile) {
        this.containerLogFile = containerLogFile;
    }

    public long getTotalLogFileSize() {
        return (long)this.maxEvents * 100L;
    }

    public void setTotalLogFileSize(long logSize) {
        this.maxEvents = (int)(logSize / 100L);
    }
}

