/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.diagnostics;

import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.azurebfs.contracts.diagnostics.ConfigurationValidator;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidConfigurationValueException;
import org.apache.hadoop.fs.azurebfs.diagnostics.ConfigurationBasicValidator;

@InterfaceStability.Evolving
public class LongConfigurationBasicValidator
extends ConfigurationBasicValidator<Long>
implements ConfigurationValidator {
    private final long min;
    private final long max;

    public LongConfigurationBasicValidator(long min, long max, long defaultVal, String configKey, boolean throwIfInvalid) {
        super(configKey, defaultVal, throwIfInvalid);
        this.min = min;
        this.max = max;
    }

    @Override
    public Long validate(String configValue) throws InvalidConfigurationValueException {
        Long result = (Long)super.validate(configValue);
        if (result != null) {
            return result;
        }
        try {
            result = Long.parseLong(configValue);
            if (this.getThrowIfInvalid() && (result < this.min || result > this.max)) {
                throw new InvalidConfigurationValueException(this.getConfigKey());
            }
            if (result < this.min) {
                return this.min;
            }
            if (result > this.max) {
                return this.max;
            }
        }
        catch (NumberFormatException ex) {
            throw new InvalidConfigurationValueException(this.getConfigKey(), ex);
        }
        return result;
    }
}

