/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.fpm.FPGrowth;
import org.apache.spark.ml.fpm.FPGrowthModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaFPGrowthExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaFPGrowthExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("1 2 5".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("1 2 3 5".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("1 2".split(" "))}));
        StructType schema = new StructType(new StructField[]{new StructField("items", (DataType)new ArrayType(DataTypes.StringType, true), false, Metadata.empty())});
        Dataset itemsDF = spark.createDataFrame(data, schema);
        FPGrowthModel model = new FPGrowth().setItemsCol("items").setMinSupport(0.5).setMinConfidence(0.6).fit(itemsDF);
        model.freqItemsets().show();
        model.associationRules().show();
        model.transform(itemsDF).show();
        spark.stop();
    }
}

