/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.GaussianMixture;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaGaussianMixtureExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaGaussianMixtureExample").getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_kmeans_data.txt");
        GaussianMixture gmm = new GaussianMixture().setK(2);
        GaussianMixtureModel model = gmm.fit(dataset);
        for (int i = 0; i < model.getK(); ++i) {
            System.out.printf("Gaussian %d:\nweight=%f\nmu=%s\nsigma=\n%s\n\n", i, model.weights()[i], model.gaussians()[i].mean(), model.gaussians()[i].cov());
        }
        spark.stop();
    }
}

