/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.VarianceThresholdSelector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaVarianceThresholdSelectorExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaVarianceThresholdSelectorExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{1, Vectors.dense((double)6.0, (double[])new double[]{7.0, 0.0, 7.0, 6.0, 0.0})}), RowFactory.create((Object[])new Object[]{2, Vectors.dense((double)0.0, (double[])new double[]{9.0, 6.0, 0.0, 5.0, 9.0})}), RowFactory.create((Object[])new Object[]{3, Vectors.dense((double)0.0, (double[])new double[]{9.0, 3.0, 0.0, 5.0, 5.0})}), RowFactory.create((Object[])new Object[]{4, Vectors.dense((double)0.0, (double[])new double[]{9.0, 8.0, 5.0, 6.0, 4.0})}), RowFactory.create((Object[])new Object[]{5, Vectors.dense((double)8.0, (double[])new double[]{9.0, 6.0, 5.0, 4.0, 4.0})}), RowFactory.create((Object[])new Object[]{6, Vectors.dense((double)8.0, (double[])new double[]{9.0, 6.0, 0.0, 0.0, 0.0})}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        VarianceThresholdSelector selector = new VarianceThresholdSelector().setVarianceThreshold(8.0).setFeaturesCol("features").setOutputCol("selectedFeatures");
        Dataset result = selector.fit(df).transform(df);
        System.out.println("Output: Features with variance lower than " + selector.getVarianceThreshold() + " are removed.");
        result.show();
        spark.stop();
    }
}

