/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.KMeans;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.evaluation.ClusteringEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class KMeansExample$ {
    public static KMeansExample$ MODULE$;

    static {
        new KMeansExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(String.valueOf(this.getClass().getSimpleName())).getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_kmeans_data.txt");
        KMeans kmeans = new KMeans().setK(2).setSeed(1L);
        KMeansModel model = kmeans.fit(dataset);
        Dataset predictions = model.transform(dataset);
        ClusteringEvaluator evaluator = new ClusteringEvaluator();
        double silhouette = evaluator.evaluate(predictions);
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("Silhouette with squared euclidean distance = ").append(silhouette).toString());
        Predef$.MODULE$.println((Object)"Cluster Centers: ");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).foreach((Function1 & java.io.Serializable & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    private KMeansExample$() {
        MODULE$ = this;
    }
}

