/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;

public final class MultilayerPerceptronClassifierExample$ {
    public static MultilayerPerceptronClassifierExample$ MODULE$;

    static {
        new MultilayerPerceptronClassifierExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MultilayerPerceptronClassifierExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        Dataset[] splits = data.randomSplit(new double[]{0.6, 0.4}, 1234L);
        Dataset train = splits[0];
        Dataset test = splits[1];
        int[] layers = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 4, 3}), ClassTag$.MODULE$.Int());
        MultilayerPerceptronClassifier trainer = new MultilayerPerceptronClassifier().setLayers(layers).setBlockSize(128).setSeed(1234L).setMaxIter(100);
        MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)trainer.fit(train);
        Dataset result = model.transform(test);
        Dataset predictionAndLabels = result.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("accuracy");
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("Test set accuracy = ").append(evaluator.evaluate(predictionAndLabels)).toString());
        spark.stop();
    }

    private MultilayerPerceptronClassifierExample$() {
        MODULE$ = this;
    }
}

