/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.DoubleFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;

public class JavaRandomForestRegressionExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaRandomForestRegressionExample");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        String datapath = "data/mllib/sample_libsvm_data.txt";
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)datapath).toJavaRDD();
        JavaRDD[] splits = data.randomSplit(new double[]{0.7, 0.3});
        JavaRDD trainingData = splits[0];
        JavaRDD testData = splits[1];
        HashMap categoricalFeaturesInfo = new HashMap();
        int numTrees = 3;
        String featureSubsetStrategy = "auto";
        String impurity = "variance";
        int maxDepth = 4;
        int maxBins = 32;
        int seed = 12345;
        RandomForestModel model = RandomForest.trainRegressor((JavaRDD)trainingData, categoricalFeaturesInfo, (int)numTrees, (String)featureSubsetStrategy, (String)impurity, (int)maxDepth, (int)maxBins, (int)seed);
        JavaPairRDD predictionAndLabel = testData.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)model.predict(p.features()), (Object)p.label()));
        double testMSE = predictionAndLabel.mapToDouble((DoubleFunction & Serializable)pl -> {
            double diff = (Double)pl._1() - (Double)pl._2();
            return diff * diff;
        }).mean();
        System.out.println("Test Mean Squared Error: " + testMSE);
        System.out.println("Learned regression forest model:\n" + model.toDebugString());
        model.save(jsc.sc(), "target/tmp/myRandomForestRegressionModel");
        RandomForestModel sameModel = RandomForestModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myRandomForestRegressionModel");
        jsc.stop();
    }
}

