/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableIdentifier;
import com.amazonaws.services.glue.model.ViewDefinitionInput;
import com.amazonaws.services.glue.model.transform.TableInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String owner;
    private Date lastAccessTime;
    private Date lastAnalyzedTime;
    private Integer retention;
    private StorageDescriptor storageDescriptor;
    private List<Column> partitionKeys;
    private String viewOriginalText;
    private String viewExpandedText;
    private String tableType;
    private Map<String, String> parameters;
    private TableIdentifier targetTable;
    private ViewDefinitionInput viewDefinition;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TableInput withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TableInput withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public TableInput withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public TableInput withLastAccessTime(Date lastAccessTime) {
        this.setLastAccessTime(lastAccessTime);
        return this;
    }

    public void setLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
    }

    public Date getLastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public TableInput withLastAnalyzedTime(Date lastAnalyzedTime) {
        this.setLastAnalyzedTime(lastAnalyzedTime);
        return this;
    }

    public void setRetention(Integer retention) {
        this.retention = retention;
    }

    public Integer getRetention() {
        return this.retention;
    }

    public TableInput withRetention(Integer retention) {
        this.setRetention(retention);
        return this;
    }

    public void setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
    }

    public StorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    public TableInput withStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.setStorageDescriptor(storageDescriptor);
        return this;
    }

    public List<Column> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(Collection<Column> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
            return;
        }
        this.partitionKeys = new ArrayList<Column>(partitionKeys);
    }

    public TableInput withPartitionKeys(Column ... partitionKeys) {
        if (this.partitionKeys == null) {
            this.setPartitionKeys(new ArrayList<Column>(partitionKeys.length));
        }
        for (Column ele : partitionKeys) {
            this.partitionKeys.add(ele);
        }
        return this;
    }

    public TableInput withPartitionKeys(Collection<Column> partitionKeys) {
        this.setPartitionKeys(partitionKeys);
        return this;
    }

    public void setViewOriginalText(String viewOriginalText) {
        this.viewOriginalText = viewOriginalText;
    }

    public String getViewOriginalText() {
        return this.viewOriginalText;
    }

    public TableInput withViewOriginalText(String viewOriginalText) {
        this.setViewOriginalText(viewOriginalText);
        return this;
    }

    public void setViewExpandedText(String viewExpandedText) {
        this.viewExpandedText = viewExpandedText;
    }

    public String getViewExpandedText() {
        return this.viewExpandedText;
    }

    public TableInput withViewExpandedText(String viewExpandedText) {
        this.setViewExpandedText(viewExpandedText);
        return this;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getTableType() {
        return this.tableType;
    }

    public TableInput withTableType(String tableType) {
        this.setTableType(tableType);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public TableInput withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public TableInput addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public TableInput clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setTargetTable(TableIdentifier targetTable) {
        this.targetTable = targetTable;
    }

    public TableIdentifier getTargetTable() {
        return this.targetTable;
    }

    public TableInput withTargetTable(TableIdentifier targetTable) {
        this.setTargetTable(targetTable);
        return this;
    }

    public void setViewDefinition(ViewDefinitionInput viewDefinition) {
        this.viewDefinition = viewDefinition;
    }

    public ViewDefinitionInput getViewDefinition() {
        return this.viewDefinition;
    }

    public TableInput withViewDefinition(ViewDefinitionInput viewDefinition) {
        this.setViewDefinition(viewDefinition);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getLastAccessTime() != null) {
            sb.append("LastAccessTime: ").append(this.getLastAccessTime()).append(",");
        }
        if (this.getLastAnalyzedTime() != null) {
            sb.append("LastAnalyzedTime: ").append(this.getLastAnalyzedTime()).append(",");
        }
        if (this.getRetention() != null) {
            sb.append("Retention: ").append(this.getRetention()).append(",");
        }
        if (this.getStorageDescriptor() != null) {
            sb.append("StorageDescriptor: ").append(this.getStorageDescriptor()).append(",");
        }
        if (this.getPartitionKeys() != null) {
            sb.append("PartitionKeys: ").append(this.getPartitionKeys()).append(",");
        }
        if (this.getViewOriginalText() != null) {
            sb.append("ViewOriginalText: ").append(this.getViewOriginalText()).append(",");
        }
        if (this.getViewExpandedText() != null) {
            sb.append("ViewExpandedText: ").append(this.getViewExpandedText()).append(",");
        }
        if (this.getTableType() != null) {
            sb.append("TableType: ").append(this.getTableType()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getTargetTable() != null) {
            sb.append("TargetTable: ").append(this.getTargetTable()).append(",");
        }
        if (this.getViewDefinition() != null) {
            sb.append("ViewDefinition: ").append(this.getViewDefinition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableInput)) {
            return false;
        }
        TableInput other = (TableInput)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getLastAccessTime() == null ^ this.getLastAccessTime() == null) {
            return false;
        }
        if (other.getLastAccessTime() != null && !other.getLastAccessTime().equals(this.getLastAccessTime())) {
            return false;
        }
        if (other.getLastAnalyzedTime() == null ^ this.getLastAnalyzedTime() == null) {
            return false;
        }
        if (other.getLastAnalyzedTime() != null && !other.getLastAnalyzedTime().equals(this.getLastAnalyzedTime())) {
            return false;
        }
        if (other.getRetention() == null ^ this.getRetention() == null) {
            return false;
        }
        if (other.getRetention() != null && !other.getRetention().equals(this.getRetention())) {
            return false;
        }
        if (other.getStorageDescriptor() == null ^ this.getStorageDescriptor() == null) {
            return false;
        }
        if (other.getStorageDescriptor() != null && !other.getStorageDescriptor().equals(this.getStorageDescriptor())) {
            return false;
        }
        if (other.getPartitionKeys() == null ^ this.getPartitionKeys() == null) {
            return false;
        }
        if (other.getPartitionKeys() != null && !other.getPartitionKeys().equals(this.getPartitionKeys())) {
            return false;
        }
        if (other.getViewOriginalText() == null ^ this.getViewOriginalText() == null) {
            return false;
        }
        if (other.getViewOriginalText() != null && !other.getViewOriginalText().equals(this.getViewOriginalText())) {
            return false;
        }
        if (other.getViewExpandedText() == null ^ this.getViewExpandedText() == null) {
            return false;
        }
        if (other.getViewExpandedText() != null && !other.getViewExpandedText().equals(this.getViewExpandedText())) {
            return false;
        }
        if (other.getTableType() == null ^ this.getTableType() == null) {
            return false;
        }
        if (other.getTableType() != null && !other.getTableType().equals(this.getTableType())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getTargetTable() == null ^ this.getTargetTable() == null) {
            return false;
        }
        if (other.getTargetTable() != null && !other.getTargetTable().equals(this.getTargetTable())) {
            return false;
        }
        if (other.getViewDefinition() == null ^ this.getViewDefinition() == null) {
            return false;
        }
        return other.getViewDefinition() == null || other.getViewDefinition().equals(this.getViewDefinition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getLastAccessTime() == null ? 0 : this.getLastAccessTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastAnalyzedTime() == null ? 0 : this.getLastAnalyzedTime().hashCode());
        hashCode = 31 * hashCode + (this.getRetention() == null ? 0 : this.getRetention().hashCode());
        hashCode = 31 * hashCode + (this.getStorageDescriptor() == null ? 0 : this.getStorageDescriptor().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKeys() == null ? 0 : this.getPartitionKeys().hashCode());
        hashCode = 31 * hashCode + (this.getViewOriginalText() == null ? 0 : this.getViewOriginalText().hashCode());
        hashCode = 31 * hashCode + (this.getViewExpandedText() == null ? 0 : this.getViewExpandedText().hashCode());
        hashCode = 31 * hashCode + (this.getTableType() == null ? 0 : this.getTableType().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTargetTable() == null ? 0 : this.getTargetTable().hashCode());
        hashCode = 31 * hashCode + (this.getViewDefinition() == null ? 0 : this.getViewDefinition().hashCode());
        return hashCode;
    }

    public TableInput clone() {
        try {
            return (TableInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

