/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaConfig;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.IcebergCompat$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.UniversalFormat$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile$Tags$ICEBERG_COMPAT_VERSION$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.AlterTableSetPropertiesDeltaCommand;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]aaB\u0005\u000b!\u0003\r\ta\u0006\u0005\u0006I\u0001!\t!\n\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0011\u0015a\u0004\u0001\"\u0003>\u0011\u0015)\u0005A\"\u0001G\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!!\u0004\u0001\t#\tyAA\u0011SK>\u0014x\rV1cY\u00164uN]+qOJ\fG-Z+oS\u001a|'/\u001c%fYB,'O\u0003\u0002\f\u0019\u0005A1m\\7nC:$7O\u0003\u0002\u000e\u001d\u0005)A-\u001a7uC*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\"%D\u0001!\u0015\t\tC\"\u0001\u0005nKR,'/\u001b8h\u0013\t\u0019\u0003E\u0001\u0007EK2$\u0018\rT8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002MA\u0011\u0011dJ\u0005\u0003Qi\u0011A!\u00168ji\u0006ab/\u001a:tS>t7\t[1oO\u0016\u001c(+Z9vSJ,'+Z<sSR,W#A\u0016\u0011\t1\u001ad'\u000f\b\u0003[E\u0002\"A\f\u000e\u000e\u0003=R!\u0001\r\f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011$$\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u00121!T1q\u0015\t\u0011$\u0004\u0005\u0002\u001ao%\u0011\u0001H\u0007\u0002\u0004\u0013:$\bc\u0001\u0017;m%\u00111(\u000e\u0002\u0004'\u0016$\u0018a\u0005:f_J<W*Y=OK\u0016$'+Z<sSR,Gc\u0001 B\u0007B\u0011\u0011dP\u0005\u0003\u0001j\u0011qAQ8pY\u0016\fg\u000eC\u0003C\u0007\u0001\u0007a'\u0001\u0006pY\u00124VM]:j_:DQ\u0001R\u0002A\u0002Y\n!B\\3x-\u0016\u00148/[8o\u0003=y\u0007\u000f^5nSj,')\u001f*f_J<GCA$U!\rAU\n\u0015\b\u0003\u0013.s!A\f&\n\u0003mI!\u0001\u0014\u000e\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\u0004'\u0016\f(B\u0001'\u001b!\t\t&+D\u0001\u000f\u0013\t\u0019fBA\u0002S_^DQ!\u0016\u0003A\u0002Y\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"!U,\n\u0005as!\u0001D*qCJ\\7+Z:tS>t\u0017aE3oC\ndW-S2fE\u0016\u0014xmQ8na\u0006$H\u0003\u0002\u0014\\G\"DQ\u0001X\u0003A\u0002u\u000ba\u0001^1sO\u0016$\bC\u00010b\u001b\u0005y&B\u00011\r\u0003\u001d\u0019\u0017\r^1m_\u001eL!AY0\u0003\u0019\u0011+G\u000e^1UC\ndWM\u0016\u001a\t\u000b\u0011,\u0001\u0019A3\u00027\r,(O]%dK\n,'oZ\"p[B\fGOV3sg&|gn\u00149u!\rIbMN\u0005\u0003Oj\u0011aa\u00149uS>t\u0007\"B5\u0006\u0001\u0004Q\u0017\u0001\u0007;be\u001e,GOV3sg&|g\u000eR3mi\u0006\u001cuN\u001c4jOB\u00191\u000e\u001c8\u000e\u00031I!!\u001c\u0007\u0003\u0017\u0011+G\u000e^1D_:4\u0017n\u001a\t\u00043\u0019t\u0014\u0001E4fi:+Xn\u00144BI\u00124\u0015\u000e\\3t)\u0011\tx/_>\u0011\te\u0011H\u000f^\u0005\u0003gj\u0011a\u0001V;qY\u0016\u0014\u0004CA\rv\u0013\t1(D\u0001\u0003M_:<\u0007\"\u0002=\u0007\u0001\u00041\u0014\u0001F5dK\n,'oZ\"p[B\fGOV3sg&|g\u000eC\u0003{\r\u0001\u0007Q,A\u0003uC\ndW\rC\u0003}\r\u0001\u0007Q0\u0001\u0005t]\u0006\u00048\u000f[8u!\tYg0\u0003\u0002\u0000\u0019\tA1K\\1qg\"|G/A\u0005e_J+wO]5uKR9q)!\u0002\u0002\b\u0005%\u0001\"\u0002/\b\u0001\u0004i\u0006\"B+\b\u0001\u00041\u0006BBA\u0006\u000f\u0001\u0007a'\u0001\u000euCJ<W\r^%dK\n,'oZ\"p[B\fGOV3sg&|g.\u0001\u0012va\u001e\u0014\u0018\rZ3V]&4wN]7JG\u0016\u0014WM]4D_6\u0004\u0018\r\u001e,feNLwN\u001c\u000b\b\u000f\u0006E\u00111CA\u000b\u0011\u0015a\u0006\u00021\u0001^\u0011\u0015)\u0006\u00021\u0001W\u0011\u0019\tY\u0001\u0003a\u0001m\u0001")
public interface ReorgTableForUpgradeUniformHelper
extends DeltaLogging {
    public void org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$_setter_$org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$versionChangesRequireRewrite_$eq(Map<Object, Set<Object>> var1);

    public Map<Object, Set<Object>> org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$versionChangesRequireRewrite();

    private boolean reorgMayNeedRewrite(int oldVersion, int newVersion) {
        return ((SetLike)this.org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$versionChangesRequireRewrite().getOrElse((Object)BoxesRunTime.boxToInteger((int)oldVersion), (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).contains((Object)BoxesRunTime.boxToInteger((int)newVersion));
    }

    public Seq<Row> optimizeByReorg(SparkSession var1);

    private void enableIcebergCompat(DeltaTableV2 target, Option<Object> currIcebergCompatVersionOpt, DeltaConfig<Option<Object>> targetVersionDeltaConfig) {
        OptimisticTransaction alterConfTxn;
        Map enableIcebergCompatConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)targetVersionDeltaConfig.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().key()), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.COLUMN_MAPPING_MODE().key()), (Object)"name")}));
        if (currIcebergCompatVersionOpt.nonEmpty()) {
            DeltaConfig<Option<Object>> currIcebergCompatVersionDeltaConfig = IcebergCompat$.MODULE$.getIcebergCompatVersionConfigForValidVersion(BoxesRunTime.unboxToInt((Object)currIcebergCompatVersionOpt.get()));
            enableIcebergCompatConf = enableIcebergCompatConf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)currIcebergCompatVersionDeltaConfig.key()), (Object)"false")})));
        }
        if ((alterConfTxn = target.startTransaction(target.startTransaction$default$1())).protocol().minWriterVersion() < 7) {
            enableIcebergCompatConf = enableIcebergCompatConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Protocol$.MODULE$.MIN_WRITER_VERSION_PROP()), (Object)"7"));
        }
        if (alterConfTxn.protocol().minReaderVersion() < 3) {
            enableIcebergCompatConf = enableIcebergCompatConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Protocol$.MODULE$.MIN_READER_VERSION_PROP()), (Object)"3"));
        }
        Metadata metadata = alterConfTxn.metadata();
        String x$1 = metadata.description();
        Map x$2 = metadata.configuration().$plus$plus((GenTraversableOnce)enableIcebergCompatConf);
        String x$3 = metadata.copy$default$1();
        String x$4 = metadata.copy$default$2();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        Metadata newMetadata = metadata.copy(x$3, x$4, x$1, x$5, x$6, x$7, (Map<String, String>)x$2, x$8);
        alterConfTxn.updateMetadata(newMetadata, alterConfTxn.updateMetadata$default$2());
        alterConfTxn.commit((Seq<Action>)Nil$.MODULE$, new DeltaOperations.UpgradeUniformProperties((Map<String, String>)enableIcebergCompatConf));
    }

    private Tuple2<Object, Object> getNumOfAddFiles(int icebergCompatVersion, DeltaTableV2 table, Snapshot snapshot) {
        long numOfAddFilesWithTag = snapshot.allFiles().select("tags", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).where(Utils$.MODULE$.try_element_at(functions$.MODULE$.col("tags"), AddFile$Tags$ICEBERG_COMPAT_VERSION$.MODULE$.name()).$eq$eq$eq((Object)Integer.toString(icebergCompatVersion))).count();
        long numOfAddFiles = snapshot.numOfFiles();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("For table ").append(table.tableIdentifier()).append(" at version ").append(snapshot.version()).append(", there are ").append(numOfAddFiles).append(" addFiles, and ").append(numOfAddFilesWithTag).append(" addFiles with ICEBERG_COMPAT_VERSION=").append(icebergCompatVersion).append(" tag.").toString());
        return new Tuple2.mcJJ.sp(numOfAddFiles, numOfAddFilesWithTag);
    }

    private Seq<Row> doRewrite(DeltaTableV2 target, SparkSession sparkSession, int targetIcebergCompatVersion) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        boolean allAddFilesHaveTag;
        boolean bl;
        Snapshot snapshot = target.deltaLog().update(target.deltaLog().update$default$1(), target.deltaLog().update$default$2());
        Option<Object> currIcebergCompatVersionOpt = IcebergCompat$.MODULE$.getEnabledVersion(snapshot.metadata());
        DeltaConfig<Option<Object>> targetVersionDeltaConfig = IcebergCompat$.MODULE$.getIcebergCompatVersionConfigForValidVersion(targetIcebergCompatVersion);
        boolean versionChangeMayNeedRewrite = this.reorgMayNeedRewrite(BoxesRunTime.unboxToInt((Object)currIcebergCompatVersionOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), targetIcebergCompatVersion);
        if (!currIcebergCompatVersionOpt.contains((Object)BoxesRunTime.boxToInteger((int)targetIcebergCompatVersion))) {
            this.enableIcebergCompat(target, currIcebergCompatVersionOpt, targetVersionDeltaConfig);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Update table ").append(target.tableIdentifier()).append(" to iceberg compat version = ").append(targetIcebergCompatVersion).append(" successfully.").toString());
            bl = true;
        } else {
            bl = false;
        }
        boolean didUpdateIcebergCompatVersion = bl;
        Tuple2<Object, Object> tuple23 = this.getNumOfAddFiles(targetIcebergCompatVersion, target, snapshot);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        long numOfAddFilesBefore = tuple23._1$mcJ$sp();
        long numOfAddFilesWithTagBefore = tuple23._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(numOfAddFilesBefore, numOfAddFilesWithTagBefore);
        long numOfAddFilesBefore2 = sp2._1$mcJ$sp();
        long numOfAddFilesWithTagBefore2 = sp2._2$mcJ$sp();
        boolean bl2 = allAddFilesHaveTag = numOfAddFilesWithTagBefore2 == numOfAddFilesBefore2;
        if (versionChangeMayNeedRewrite && !allAddFilesHaveTag) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Reorg Table ").append(target.tableIdentifier()).append(" to iceberg compat version = ").append(targetIcebergCompatVersion).append(" need rewrite data files.").toString());
            Seq metrics = this.liftedTree1$1(sparkSession, targetIcebergCompatVersion);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Rewrite table ").append(target.tableIdentifier()).append(" to iceberg compat version = ").append(targetIcebergCompatVersion).append(" successfully.").toString());
            tuple22 = new Tuple2((Object)new Some((Object)metrics), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option metricsOpt = (Option)tuple2._1();
        boolean didRewrite = tuple2._2$mcZ$sp();
        Tuple2 tuple24 = new Tuple2((Object)metricsOpt, (Object)BoxesRunTime.boxToBoolean((boolean)didRewrite));
        Option metricsOpt2 = (Option)tuple24._1();
        boolean didRewrite2 = tuple24._2$mcZ$sp();
        Snapshot updatedSnapshot = target.deltaLog().update(target.deltaLog().update$default$1(), target.deltaLog().update$default$2());
        Tuple2<Object, Object> tuple25 = this.getNumOfAddFiles(targetIcebergCompatVersion, target, updatedSnapshot);
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        long numOfAddFiles = tuple25._1$mcJ$sp();
        long numOfAddFilesWithIcebergCompatTag = tuple25._2$mcJ$sp();
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(numOfAddFiles, numOfAddFilesWithIcebergCompatTag);
        long numOfAddFiles2 = sp3._1$mcJ$sp();
        long numOfAddFilesWithIcebergCompatTag2 = sp3._2$mcJ$sp();
        if (versionChangeMayNeedRewrite && numOfAddFilesWithIcebergCompatTag2 != numOfAddFiles2) {
            throw DeltaErrors$.MODULE$.icebergCompatReorgAddFileTagsMissingException(updatedSnapshot.version(), targetIcebergCompatVersion, numOfAddFiles2, numOfAddFilesWithIcebergCompatTag2);
        }
        if (!UniversalFormat$.MODULE$.icebergEnabled(updatedSnapshot.metadata())) {
            Map enableUniformConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()), (Object)UniversalFormat$.MODULE$.ICEBERG_FORMAT())}));
            new AlterTableSetPropertiesDeltaCommand(target, (Map<String, String>)enableUniformConf).run(sparkSession);
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Enabling universal format with iceberg compat version = ").append(targetIcebergCompatVersion).append(" for table ").append(target.tableIdentifier()).append(" succeeded.").toString());
        }
        DeltaLog x$1 = updatedSnapshot.deltaLog();
        String x$2 = "delta.upgradeUniform.success";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currIcebergCompatVersion"), (Object)currIcebergCompatVersionOpt.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetIcebergCompatVersion"), (Object)Integer.toString(targetIcebergCompatVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics"), (Object)metricsOpt2.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"didUpdateIcebergCompatVersion"), (Object)Boolean.toString(didUpdateIcebergCompatVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"needRewrite"), (Object)Boolean.toString(versionChangeMayNeedRewrite)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"didRewrite"), (Object)Boolean.toString(didRewrite2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesBefore"), (Object)Long.toString(numOfAddFilesBefore2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesWithIcebergCompatTagBefore"), (Object)Long.toString(numOfAddFilesWithTagBefore2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesAfter"), (Object)Long.toString(numOfAddFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesWithIcebergCompatTagAfter"), (Object)Long.toString(numOfAddFilesWithIcebergCompatTag2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"universalFormatIcebergEnabled"), (Object)Boolean.toString(UniversalFormat$.MODULE$.icebergEnabled(target.deltaLog().update(target.deltaLog().update$default$1(), target.deltaLog().update$default$2()).metadata())))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
        return (Seq)metricsOpt2.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public static /* synthetic */ Seq upgradeUniformIcebergCompatVersion$(ReorgTableForUpgradeUniformHelper $this, DeltaTableV2 target, SparkSession sparkSession, int targetIcebergCompatVersion) {
        return $this.upgradeUniformIcebergCompatVersion(target, sparkSession, targetIcebergCompatVersion);
    }

    default public Seq<Row> upgradeUniformIcebergCompatVersion(DeltaTableV2 target, SparkSession sparkSession, int targetIcebergCompatVersion) {
        Seq<Row> seq;
        try {
            seq = this.doRewrite(target, sparkSession, targetIcebergCompatVersion);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                DeltaLog x$1 = target.deltaLog();
                String x$2 = "delta.upgradeUniform.exception";
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetIcebergCompatVersion"), (Object)Integer.toString(targetIcebergCompatVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)e.toString())}));
                Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                throw e;
            }
            throw throwable;
        }
        return seq;
    }

    private /* synthetic */ Seq liftedTree1$1(SparkSession sparkSession$1, int targetIcebergCompatVersion$1) {
        Seq<Row> seq;
        try {
            seq = this.optimizeByReorg(sparkSession$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw DeltaErrors$.MODULE$.icebergCompatDataFileRewriteFailedException(targetIcebergCompatVersion$1, e);
            }
            throw throwable;
        }
        return seq;
    }

    public static void $init$(ReorgTableForUpgradeUniformHelper $this) {
        $this.org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$_setter_$org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$versionChangesRequireRewrite_$eq((Map<Object, Set<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))}))));
    }
}

