/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.storage.LineClosableIterator;
import org.apache.spark.sql.delta.storage.LogStore;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee!\u0002\f\u0018\u0003\u0003!\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Q\u0002!\u0011!Q\u0001\nUBQ!\u0010\u0001\u0005\u0002yBQ!\u0010\u0001\u0005\u0002\tCQ\u0001\u0013\u0001\u0005\u0012%CQA\u0013\u0001\u0005B-CQA\u0013\u0001\u0005B!DQa\u001b\u0001\u0005B1DQa\u001b\u0001\u0005BEDQ\u0001\u001e\u0001\u0005\nUDQa\u001f\u0001\u0005\nqDaa \u0001\u0005\n\u0005\u0005\u0001bBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u000b\u0001A\u0011IA\f\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\b\u0001\t\u0003\n\u0019\u0003C\u0004\u0002*\u0001!\t\"a\u000b\t\u0013\u0005\u0015\u0004!%A\u0005\u0012\u0005\u001d\u0004bBA\u0015\u0001\u0011E\u0011Q\u0010\u0005\b\u0003\u000f\u0003A\u0011CAE\u0011\u001d\ti\t\u0001C!\u0003\u001f\u0013\u0001\u0004S1e_>\u0004h)\u001b7f'f\u001cH/Z7M_\u001e\u001cFo\u001c:f\u0015\tA\u0012$A\u0004ti>\u0014\u0018mZ3\u000b\u0005iY\u0012!\u00023fYR\f'B\u0001\u000f\u001e\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011c\u0001\u0001&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0017\u000e\u0003]I!AL\f\u0003\u00111{wm\u0015;pe\u0016\f\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005E\u0012T\"A\u000f\n\u0005Mj\"!C*qCJ\\7i\u001c8g\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nAaY8oM*\u0011!hH\u0001\u0007Q\u0006$wn\u001c9\n\u0005q:$!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0001\u000b\u0005C\u0001\u0017\u0001\u0011\u0015y3\u00011\u00011\u0011\u0015!4\u00011\u00016)\ty4\tC\u0003E\t\u0001\u0007Q)\u0001\u0002tGB\u0011\u0011GR\u0005\u0003\u000fv\u0011Ab\u00159be.\u001cuN\u001c;fqR\facZ3u\u0011\u0006$wn\u001c9D_:4\u0017nZ;sCRLwN\\\u000b\u0002k\u0005!!/Z1e)\ta\u0005\rE\u0002N+bs!AT*\u000f\u0005=\u0013V\"\u0001)\u000b\u0005E\u001b\u0013A\u0002\u001fs_>$h(C\u0001)\u0013\t!v%A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&aA*fc*\u0011Ak\n\t\u00033vs!AW.\u0011\u0005=;\u0013B\u0001/(\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q;\u0003\"B1\u0007\u0001\u0004\u0011\u0017\u0001\u00029bi\"\u0004\"a\u00194\u000e\u0003\u0011T!!Z\u001d\u0002\u0005\u0019\u001c\u0018BA4e\u0005\u0011\u0001\u0016\r\u001e5\u0015\u00071K'\u000eC\u0003b\u000f\u0001\u0007!\rC\u00035\u000f\u0001\u0007Q'\u0001\bsK\u0006$\u0017i]%uKJ\fGo\u001c:\u0015\u00055\u0004\bc\u0001\u0017o1&\u0011qn\u0006\u0002\u0011\u00072|7/\u00192mK&#XM]1u_JDQ!\u0019\u0005A\u0002\t$2!\u001c:t\u0011\u0015\t\u0017\u00021\u0001c\u0011\u0015!\u0014\u00021\u00016\u0003\u0011y\u0007/\u001a8\u0015\u0007YL(\u0010\u0005\u0002do&\u0011\u0001\u0010\u001a\u0002\u0012\rN#\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0007\"B1\u000b\u0001\u0004\u0011\u0007\"\u0002\u001b\u000b\u0001\u0004)\u0014A\u0003:fC\u0012\u001cFO]3b[R\u0011A* \u0005\u0006}.\u0001\rA^\u0001\u0007gR\u0014X-Y7\u0002)I,\u0017\rZ*ue\u0016\fW.Q:Ji\u0016\u0014\u0018\r^8s)\ri\u00171\u0001\u0005\u0006}2\u0001\rA^\u0001\tY&\u001cHO\u0012:p[R!\u0011\u0011BA\u000b!\u0015i\u00151BA\b\u0013\r\tia\u0016\u0002\t\u0013R,'/\u0019;peB\u00191-!\u0005\n\u0007\u0005MAM\u0001\u0006GS2,7\u000b^1ukNDQ!Y\u0007A\u0002\t$b!!\u0003\u0002\u001a\u0005m\u0001\"B1\u000f\u0001\u0004\u0011\u0007\"\u0002\u001b\u000f\u0001\u0004)\u0014\u0001\b:fg>dg/\u001a)bi\"|e\u000e\u00155zg&\u001c\u0017\r\\*u_J\fw-\u001a\u000b\u0004E\u0006\u0005\u0002\"B1\u0010\u0001\u0004\u0011G#\u00022\u0002&\u0005\u001d\u0002\"B1\u0011\u0001\u0004\u0011\u0007\"\u0002\u001b\u0011\u0001\u0004)\u0014aD<sSR,w+\u001b;i%\u0016t\u0017-\\3\u0015\u0011\u00055\u00121GA\u001b\u0003w\u00012AJA\u0018\u0013\r\t\td\n\u0002\u0005+:LG\u000fC\u0003b#\u0001\u0007!\rC\u0004\u00028E\u0001\r!!\u000f\u0002\u000f\u0005\u001cG/[8ogB!Q*a\u0003Y\u0011%\ti$\u0005I\u0001\u0002\u0004\ty$A\u0005pm\u0016\u0014xO]5uKB\u0019a%!\u0011\n\u0007\u0005\rsEA\u0004C_>dW-\u00198)\u000fE\t9%!\u0014\u0002RA\u0019a%!\u0013\n\u0007\u0005-sE\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a\u0014\u0002\u0007\u000e\fG\u000e\u001c\u0011uQ\u0016\u0004S.\u001a;i_\u0012\u0004C\u000f[1uA\u0005\u001c8n\u001d\u0011g_J\u0004\u0013\r\t%bI>|\u0007\u000fI\"p]\u001aLw-\u001e:bi&|g\u000eI8cU\u0016\u001cG\u000fI5ogR,\u0017\rZ\u0019\tGa\u000b\u0019&a\u0017\u0002V%!\u0011QKA,\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e)\u0019\u0011\u0011L\u0014\u0002\u0015\u0011,\u0007O]3dCR,G-M\u0005$\u0003;\ny&!\u0019\u0002Z9\u0019a%a\u0018\n\u0007\u0005es%M\u0003#M\u001d\n\u0019GA\u0003tG\u0006d\u0017-A\rxe&$XmV5uQJ+g.Y7fI\u0011,g-Y;mi\u0012\u001aTCAA5U\u0011\ty$a\u001b,\u0005\u00055\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001e(\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\n\tHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$\"\"!\f\u0002\u0000\u0005\u0005\u00151QAC\u0011\u0015\t7\u00031\u0001c\u0011\u001d\t9d\u0005a\u0001\u0003sAq!!\u0010\u0014\u0001\u0004\ty\u0004C\u00035'\u0001\u0007Q'\u0001\bde\u0016\fG/\u001a+f[B\u0004\u0016\r\u001e5\u0015\u0007\t\fY\tC\u0003b)\u0001\u0007!-A\bj]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195f)\t\ti\u0003")
public abstract class HadoopFileSystemLogStore
implements LogStore {
    private final Configuration hadoopConf;

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final Seq<String> read(FileStatus fileStatus, Configuration hadoopConf) {
        return LogStore.read$((LogStore)this, fileStatus, hadoopConf);
    }

    @Override
    public final ClosableIterator<String> readAsIterator(String path) {
        return LogStore.readAsIterator$((LogStore)this, path);
    }

    @Override
    public ClosableIterator<String> readAsIterator(FileStatus fileStatus, Configuration hadoopConf) {
        return LogStore.readAsIterator$((LogStore)this, fileStatus, hadoopConf);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public boolean write$default$3() {
        return LogStore.write$default$3$(this);
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        LogStore.write$(this, path, actions, overwrite, hadoopConf);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return LogStore.isPartialWriteVisible$(this, path);
    }

    @Override
    public boolean isPartialWriteVisible(Path path, Configuration hadoopConf) {
        return LogStore.isPartialWriteVisible$(this, path, hadoopConf);
    }

    public Configuration getHadoopConfiguration() {
        return (Configuration)SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.sessionState().newHadoopConf()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.hadoopConf);
    }

    @Override
    public Seq<String> read(Path path) {
        return this.read(path, this.getHadoopConfiguration());
    }

    @Override
    public Seq<String> read(Path path, Configuration hadoopConf) {
        return this.readStream(this.open(path, hadoopConf));
    }

    @Override
    public ClosableIterator<String> readAsIterator(Path path) {
        return this.readAsIterator(path, this.getHadoopConfiguration());
    }

    @Override
    public ClosableIterator<String> readAsIterator(Path path, Configuration hadoopConf) {
        return this.readStreamAsIterator(this.open(path, hadoopConf));
    }

    private FSDataInputStream open(Path path, Configuration hadoopConf) {
        return path.getFileSystem(hadoopConf).open(path);
    }

    private Seq<String> readStream(FSDataInputStream stream) {
        Seq seq;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            seq = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Buffer$.MODULE$.canBuildFrom())).toSeq();
        }
        finally {
            stream.close();
        }
        return seq;
    }

    private ClosableIterator<String> readStreamAsIterator(FSDataInputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        return new LineClosableIterator(reader);
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        return this.listFrom(path, this.getHadoopConfiguration());
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw DeltaErrors$.MODULE$.fileOrDirectoryNotFoundException(String.valueOf(path.getParent()));
        }
        FileStatus[] files = fs.listStatus(path.getParent());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HadoopFileSystemLogStore.$anonfun$listFrom$1(path, x$3))))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().getName(), (Ordering)Ordering.String$.MODULE$))).iterator();
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return this.resolvePathOnPhysicalStorage(path, this.getHadoopConfiguration());
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path, Configuration hadoopConf) {
        return path.getFileSystem(hadoopConf).makeQualified(path);
    }

    public void writeWithRename(Path path, Iterator<String> actions, boolean overwrite) {
        this.writeWithRename(path, actions, overwrite, this.getHadoopConfiguration());
    }

    public void writeWithRename(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        block16: {
            FileSystem fs = path.getFileSystem(hadoopConf);
            if (!fs.exists(path.getParent())) {
                throw DeltaErrors$.MODULE$.fileOrDirectoryNotFoundException(String.valueOf(path.getParent()));
            }
            if (overwrite) {
                try (FSDataOutputStream stream = fs.create(path, true);){
                    actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        stream.write(x$1);
                        return BoxedUnit.UNIT;
                    });
                }
                return;
            }
            if (fs.exists(path)) {
                throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
            }
            Path tempPath = this.createTempPath(path);
            boolean streamClosed = false;
            boolean renameDone = false;
            FSDataOutputStream stream = fs.create(tempPath);
            try {
                actions.map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(1).append((String)x$7).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    stream.write(x$1);
                    return BoxedUnit.UNIT;
                });
                stream.close();
                streamClosed = true;
                try {
                    if (fs.rename(tempPath, path)) {
                        renameDone = true;
                        break block16;
                    }
                    if (fs.exists(path)) {
                        throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
                    }
                    throw DeltaErrors$.MODULE$.cannotRenamePath(tempPath.toString(), path.toString());
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw DeltaErrors$.MODULE$.fileAlreadyExists(path.toString());
                }
            }
            finally {
                if (!streamClosed) {
                    stream.close();
                }
                if (!renameDone) {
                    fs.delete(tempPath, false);
                }
            }
        }
    }

    public boolean writeWithRename$default$3() {
        return false;
    }

    public Path createTempPath(Path path) {
        return new Path(path.getParent(), new StringBuilder(6).append(".").append(path.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
    }

    @Override
    public void invalidateCache() {
    }

    public static final /* synthetic */ boolean $anonfun$listFrom$1(Path path$1, FileStatus x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.getPath().getName())).$greater$eq((Object)path$1.getName());
    }

    public HadoopFileSystemLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
    }

    public HadoopFileSystemLogStore(SparkContext sc) {
        this(sc.getConf(), sc.hadoopConfiguration());
    }
}

