/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005a\u0001\u00020`\u0001)D!\"a\u0003\u0001\u0005\u000b\u0007I\u0011IA\u0007\u0011)\tY\u0004\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003\u007f\u0001!Q1A\u0005\u0002\u0005\u0005\u0003BCA(\u0001\t\u0005\t\u0015!\u0003\u0002D!Q\u00111\u000b\u0001\u0003\u0006\u0004%\t!!\u0016\t\u0013\u0005e\u0003A!A!\u0002\u0013y\u0007BCA/\u0001\t\u0015\r\u0011\"\u0011\u0002`!Q\u0011q\u000e\u0001\u0003\u0002\u0003\u0006I!!\u0019\t\u0015\u0005M\u0004A!b\u0001\n\u0013\t)\b\u0003\u0006\u0002~\u0001\u0011\t\u0011)A\u0005\u0003oB\u0001\"a \u0001\t\u0003\u0019\u0017\u0011\u0011\u0005\t\u0003\u007f\u0002A\u0011A2\u0002\u0016\"9\u00111\u0014\u0001\u0005\u0002\u0005U\u0003BCAW\u0001!\u0015\r\u0011\"\u0003\u0002V!9\u0011q\u0014\u0001\u0005\u0002\u0005=\u0006\"CAZ\u0001\t\u0007I\u0011BA[\u0011!\ti\f\u0001Q\u0001\n\u0005]\u0006\"CA`\u0001\t\u0007I\u0011BAX\u0011!\t\t\r\u0001Q\u0001\n\u0005\u0005\u0006\"CAb\u0001\u0001\u0007I\u0011BAc\u0011%\ti\r\u0001a\u0001\n\u0013\ty\r\u0003\u0005\u0002\\\u0002\u0001\u000b\u0015BAd\u0011!\ti\u000e\u0001C!C\u0006}\u0007b\u0002B\u0004\u0001\u0011\u0005#\u0011\u0002\u0005\b\u0005/\u0001A\u0011IAX\u0011\u001d\u0011Y\u0002\u0001C!\u0005;AqAa\t\u0001\t\u0003\n)\rC\u0005\u0003(\u0001\u0011\r\u0011\"\u0003\u0003*!A!\u0011\u0007\u0001!\u0002\u0013\u0011Y\u0003C\u0005\u00034\u0001\u0011\r\u0011\"\u0003\u00036!A!\u0011\b\u0001!\u0002\u0013\u00119\u0004C\u0005\u0003<\u0001\u0011\r\u0011\"\u0003\u0003*!A!Q\b\u0001!\u0002\u0013\u0011Y\u0003C\u0005\u0003@\u0001\u0011\r\u0011\"\u0011\u0002`!A!q\t\u0001!\u0002\u0013\t\t\u0007C\u0004\u0003L\u0001!\tE!\u0014\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!\u0011\r\u0001\u0005\u0002\t\r\u0004b\u0002BC\u0001\u0011\u0005#q\u0011\u0005\b\u0005\u001b\u0003A\u0011\u000bBH\u0011\u001d\u0011)\n\u0001C!\u0005/CqA!)\u0001\t\u0003\u0012\u0019\u000bC\u0004\u00032\u0002!\tFa-\t\u000f\t]\u0006\u0001\"\u0015\u0003:\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bf\u0001\u0011\u0005#QZ\u0004\b\u0005#|\u0006\u0012\u0001Bj\r\u0019qv\f#\u0001\u0003V\"9\u0011q\u0010\u0019\u0005\u0002\t%\bb\u0002Bva\u0011\u0005#Q\u001e\u0005\b\u0005o\u0004D\u0011\tB}\r\u001d\u0019\t\u0001\r\u00011\u0007\u0007A\u0011b!\u00055\u0005\u0003\u0005\u000b\u0011B;\t\u000f\u0005}D\u0007\"\u0001\u0004\u0014\u0019111\u0004\u001bE\u0007;A!\"!\u00188\u0005+\u0007I\u0011AA0\u0011)\tyg\u000eB\tB\u0003%\u0011\u0011\r\u0005\u000b\u0005\u007f9$Q3A\u0005\u0002\u0005}\u0003B\u0003B$o\tE\t\u0015!\u0003\u0002b!Q\u00111K\u001c\u0003\u0016\u0004%\t!!\u0016\t\u0013\u0005esG!E!\u0002\u0013y\u0007BCA o\tU\r\u0011\"\u0001\u0002B!Q\u0011qJ\u001c\u0003\u0012\u0003\u0006I!a\u0011\t\u0015\u0005MtG!f\u0001\n\u0003\t)\b\u0003\u0006\u0002~]\u0012\t\u0012)A\u0005\u0003oBq!a 8\t\u0003\u0019)\u0003C\u0005\u0003\"^\n\t\u0011\"\u0001\u00046!I1\u0011I\u001c\u0012\u0002\u0013\u000511\t\u0005\n\u0007/:\u0014\u0013!C\u0001\u0007\u0007B\u0011b!\u00178#\u0003%\taa\u0017\t\u0013\r}s'%A\u0005\u0002\r\u0005\u0004\"CB3oE\u0005I\u0011AB4\u0011%\u0019YgNA\u0001\n\u0003\u001ai\u0007C\u0005\u0004~]\n\t\u0011\"\u0001\u0002`!I1qP\u001c\u0002\u0002\u0013\u00051\u0011\u0011\u0005\n\u0007\u000b;\u0014\u0011!C!\u0007\u000fC\u0011b!&8\u0003\u0003%\taa&\t\u0013\rmu'!A\u0005B\ru\u0005\"\u0003Bfo\u0005\u0005I\u0011IBP\u0011%\u0019\tkNA\u0001\n\u0003\u001a\u0019kB\u0005\u0004(R\n\t\u0011#\u0003\u0004*\u001aI11\u0004\u001b\u0002\u0002#%11\u0016\u0005\b\u0003\u007f\u0012F\u0011AB]\u0011%\u0011YMUA\u0001\n\u000b\u001ay\nC\u0005\u0004<J\u000b\t\u0011\"!\u0004>\"I1\u0011\u001a*\u0002\u0002\u0013\u000551\u001a\u0005\b\u0007;$D\u0011KBp\r\u0019\u0019\u0019\u000f\r\u0003\u0004f\"9\u0011q\u0010-\u0005\u0002\r\u001d\b\"CBv1\n\u0007I\u0011BB7\u0011!\u0019i\u000f\u0017Q\u0001\n\r=\u0004b\u0002B|1\u0012\u00053q\u001e\u0005\n\u0007g\u0004\u0014\u0011!C\u0005\u0007k\u0014q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\u0001\f\u0017AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003E\u000e\f!!\u001c7\u000b\u0005\u0011,\u0017!B:qCJ\\'B\u00014h\u0003\u0019\t\u0007/Y2iK*\t\u0001.A\u0002pe\u001e\u001c\u0001aE\u0003\u0001WZdx\u0010\u0005\u0003m[>,X\"A0\n\u00059|&\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001]:\u000e\u0003ET!A]1\u0002\r1Lg.\u00197h\u0013\t!\u0018O\u0001\u0004WK\u000e$xN\u001d\t\u0003Y\u0002\u0001\"a\u001e>\u000e\u0003aT!!_1\u0002\tU$\u0018\u000e\\\u0005\u0003wb\u0014!\"\u0014'Xe&$\u0018M\u00197f!\taW0\u0003\u0002\u007f?\nABj\\4jgRL7MU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u000b]\f\t!!\u0002\n\u0007\u0005\r\u0001P\u0001\nICN$&/Y5oS:<7+^7nCJL\bc\u00017\u0002\b%\u0019\u0011\u0011B0\u0003C1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=\u0002\u0007ULG-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\u0012\u001d\u0011\t\u0019\"a\b\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007j\u0003\u0019a$o\\8u})\u0011\u0011QD\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003C\tY\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\t9C\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003C\tY\u0002K\u0003\u0002\u0003W\t9\u0004\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tdY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001b\u0003_\u0011QaU5oG\u0016\f#!!\u000f\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0006\u0005\u0005-\u0012qG\u0001\u0012G>,gMZ5dS\u0016tG/T1ue&DXCAA\"!\r\u0001\u0018QI\u0005\u0004\u0003\u000f\n(AB'biJL\u0007\u0010K\u0003\u0004\u0003W\tY%\t\u0002\u0002N\u0005)!GL\u0019/a\u0005\u00112m\\3gM&\u001c\u0017.\u001a8u\u001b\u0006$(/\u001b=!Q\u0015!\u00111FA&\u0003=Ig\u000e^3sG\u0016\u0004HOV3di>\u0014X#A8)\u000b\u0015\tY#a\u0013\u0002!%tG/\u001a:dKB$h+Z2u_J\u0004\u0003&\u0002\u0004\u0002,\u0005-\u0013A\u00038v[\u000ec\u0017m]:fgV\u0011\u0011\u0011\r\t\u0005\u0003G\n)'\u0004\u0002\u0002\u001c%!\u0011qMA\u000e\u0005\rIe\u000e\u001e\u0015\u0006\u000f\u0005-\u00121N\u0011\u0003\u0003[\nQ!\r\u00184]A\n1B\\;n\u00072\f7o]3tA!*\u0001\"a\u000b\u0002l\u0005i\u0011n]'vYRLgn\\7jC2,\"!a\u001e\u0011\t\u0005\r\u0014\u0011P\u0005\u0005\u0003w\nYBA\u0004C_>dW-\u00198\u0002\u001d%\u001cX*\u001e7uS:|W.[1mA\u00051A(\u001b8jiz\"2\"^AB\u0003\u000f\u000bY)a$\u0002\u0014\"9\u00111B\u0006A\u0002\u0005=\u0001FBAB\u0003W\t9\u0004C\u0004\u0002@-\u0001\r!a\u0011)\r\u0005\u001d\u00151FA&\u0011\u0019\t\u0019f\u0003a\u0001_\"2\u00111RA\u0016\u0003\u0017Bq!!\u0018\f\u0001\u0004\t\t\u0007\u000b\u0004\u0002\u0010\u0006-\u00121\u000e\u0005\b\u0003gZ\u0001\u0019AA<)\u001d)\u0018qSAM\u0003;Cq!a\u0003\r\u0001\u0004\ty\u0001\u0003\u0004\u0002\u001c2\u0001\ra\\\u0001\rG>,gMZ5dS\u0016tGo\u001d\u0005\b\u0003?c\u0001\u0019AAQ\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0005\u0003\u0002d\u0005\r\u0016\u0002BAS\u00037\u0011a\u0001R8vE2,\u0007&B\u0007\u0002,\u0005%\u0016EAAV\u0003\u0015\u0011d\u0006\r\u00181\u00035y6m\\3gM&\u001c\u0017.\u001a8ugV\u0011\u0011\u0011\u0015\u0015\u0006\u001f\u0005-\u00121N\u0001\u0011?&tG/\u001a:dKB$h+Z2u_J,\"!a.\u0011\u0007A\fI,C\u0002\u0002<F\u00141\u0002R3og\u00164Vm\u0019;pe\u0006\tr,\u001b8uKJ\u001cW\r\u001d;WK\u000e$xN\u001d\u0011\u0002\u0015}Kg\u000e^3sG\u0016\u0004H/A\u0006`S:$XM]2faR\u0004\u0013!E0cS:\f'/\u001f+ie\u0016\u001c\bn\u001c7egV\u0011\u0011q\u0019\t\u0007\u0003G\nI-!)\n\t\u0005-\u00171\u0004\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0016?\nLg.\u0019:z)\"\u0014Xm\u001d5pY\u0012\u001cx\fJ3r)\u0011\t\t.a6\u0011\t\u0005\r\u00141[\u0005\u0005\u0003+\fYB\u0001\u0003V]&$\b\"CAm+\u0005\u0005\t\u0019AAd\u0003\rAH%M\u0001\u0013?\nLg.\u0019:z)\"\u0014Xm\u001d5pY\u0012\u001c\b%A\u0007p]B\u000b'/Y7DQ\u0006tw-\u001a\u000b\u0005\u0003#\f\t\u000fC\u0004\u0002d^\u0001\r!!:\u0002\u000bA\f'/Y71\t\u0005\u001d\u0018Q\u001f\t\u0007\u0003S\fi/!=\u000e\u0005\u0005-(bAArC&!\u0011q^Av\u0005\u0015\u0001\u0016M]1n!\u0011\t\u00190!>\r\u0001\u0011a\u0011q_Aq\u0003\u0003\u0005\tQ!\u0001\u0002z\n\u0019q\fJ\u001a\u0012\t\u0005m(\u0011\u0001\t\u0005\u0003G\ni0\u0003\u0003\u0002\u0000\u0006m!a\u0002(pi\"Lgn\u001a\t\u0005\u0003G\u0012\u0019!\u0003\u0003\u0003\u0006\u0005m!aA!os\u0006a1/\u001a;UQJ,7\u000f[8mIR!!1\u0002B\u0007\u001b\u0005\u0001\u0001b\u0002B\b1\u0001\u0007\u0011\u0011U\u0001\u0006m\u0006dW/\u001a\u0015\u00061\u0005-\"1C\u0011\u0003\u0005+\tQ!\r\u00186]A\nAbZ3u)\"\u0014Xm\u001d5pY\u0012DS!GA\u0016\u0005'\tQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cH\u0003\u0002B\u0006\u0005?AqAa\u0004\u001b\u0001\u0004\t9\rK\u0003\u001b\u0003W\u0011\u0019\"A\u0007hKR$\u0006N]3tQ>dGm\u001d\u0015\u00067\u0005-\"1C\u0001\u0007[\u0006\u0014x-\u001b8\u0016\u0005\t-\u0002cBA2\u0005[y\u0017\u0011U\u0005\u0005\u0005_\tYBA\u0005Gk:\u001cG/[8oc\u00059Q.\u0019:hS:\u0004\u0013aB7be\u001eLgn]\u000b\u0003\u0005o\u0001b!a\u0019\u0003.=|\u0017\u0001C7be\u001eLgn\u001d\u0011\u0002\u000bM\u001cwN]3\u0002\rM\u001cwN]3!\u0003-qW/\u001c$fCR,(/Z:)\u000b\t\nYCa\u0011\"\u0005\t\u0015\u0013!B\u0019/m9\u0002\u0014\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003&B\u0012\u0002,\t\r\u0013aB:v[6\f'/_\u000b\u0003\u0003\u000bAS\u0001JA\u0016\u0005'\tQBY5oCJL8+^7nCJLXC\u0001B+!\ra'qK\u0005\u0004\u00053z&a\n\"j]\u0006\u0014\u0018\u0010T8hSN$\u0018n\u0019*fOJ,7o]5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7befDS!JA\u0016\u0005;\n#Aa\u0018\u0002\u000bIr3G\f\u0019\u0002\u0011\u00154\u0018\r\\;bi\u0016$BA!\u001a\u0003lA\u0019ANa\u001a\n\u0007\t%tLA\rM_\u001eL7\u000f^5d%\u0016<'/Z:tS>t7+^7nCJL\bb\u0002B7M\u0001\u0007!qN\u0001\bI\u0006$\u0018m]3ua\u0011\u0011\tHa \u0011\r\tM$\u0011\u0010B?\u001b\t\u0011)HC\u0002\u0003x\r\f1a]9m\u0013\u0011\u0011YH!\u001e\u0003\u000f\u0011\u000bG/Y:fiB!\u00111\u001fB@\t1\u0011\tIa\u001b\u0002\u0002\u0003\u0005)\u0011AA}\u0005\ryF\u0005\u000e\u0015\u0006M\u0005-\u0012\u0011V\u0001\baJ,G-[2u)\u0011\t\tK!#\t\r\t-u\u00051\u0001p\u0003!1W-\u0019;ve\u0016\u001c\u0018A\u0006:boJ\u0002(o\u001c2bE&d\u0017\u000e^=J]Bc\u0017mY3\u0015\u0007=\u0014\t\n\u0003\u0004\u0003\u0014\"\u0002\ra\\\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002p\u00053CaAa#*\u0001\u0004y\u0007&B\u0015\u0002,\tu\u0015E\u0001BP\u0003\u0015\u0019d\u0006\r\u00181\u0003\u0011\u0019w\u000e]=\u0015\u0007U\u0014)\u000bC\u0004\u0003(*\u0002\rA!+\u0002\u000b\u0015DHO]1\u0011\t\u0005%(1V\u0005\u0005\u0005[\u000bYO\u0001\u0005QCJ\fW.T1qQ\u0015Q\u00131FA\u001c\u00039\u0011\u0018m\u001e\u001aqe\u0016$\u0017n\u0019;j_:$B!!)\u00036\"1!1S\u0016A\u0002=\fa\u0003\u001d:pE\u0006\u0014\u0017\u000e\\5usJ\u0002(/\u001a3jGRLwN\u001c\u000b\u0005\u0003C\u0013Y\f\u0003\u0004\u0003>2\u0002\ra\\\u0001\faJ|'-\u00192jY&$\u00180A\u0003xe&$X-\u0006\u0002\u0003DB\u0019qO!2\n\u0007\t\u001d\u0007P\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015i\u00131\u0006B\"\u0003!!xn\u0015;sS:<GCAA\bQ\u0015\u0001\u00111FA\u001c\u0003]aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002maM9\u0001Ga6\u0003^\n\r\b\u0003BA2\u00053LAAa7\u0002\u001c\t1\u0011I\\=SK\u001a\u0004Ba\u001eBpk&\u0019!\u0011\u001d=\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0002d\t\u0015\u0018\u0002\u0002Bt\u00037\u0011AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa5\u0002\tI,\u0017\rZ\u000b\u0003\u0005_\u0004Ba\u001eByk&\u0019!1\u001f=\u0003\u00115c%+Z1eKJDSAMA\u0016\u0005\u0007\nA\u0001\\8bIR\u0019QOa?\t\u000f\tu8\u00071\u0001\u0002\u0010\u0005!\u0001/\u0019;iQ\u0015\u0019\u00141\u0006B\"\u0005uaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,Gn\u0016:ji\u0016\u00148#\u0002\u001b\u0003D\u000e\u0015\u0001\u0003BB\u0004\u0007\u001bi!a!\u0003\u000b\u0007\r-1-\u0001\u0005j]R,'O\\1m\u0013\u0011\u0019ya!\u0003\u0003\u000f1{wmZ5oO\u0006A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0004\u0016\re\u0001cAB\fi5\t\u0001\u0007\u0003\u0004\u0004\u0012Y\u0002\r!\u001e\u0002\u0005\t\u0006$\u0018mE\u00048\u0005/\u001cyBa9\u0011\t\u0005\r4\u0011E\u0005\u0005\u0007G\tYBA\u0004Qe>$Wo\u0019;\u0015\u0019\r\u001d21FB\u0017\u0007_\u0019\tda\r\u0011\u0007\r%r'D\u00015\u0011\u001d\tiF\u0011a\u0001\u0003CBqAa\u0010C\u0001\u0004\t\t\u0007\u0003\u0004\u0002T\t\u0003\ra\u001c\u0005\b\u0003\u007f\u0011\u0005\u0019AA\"\u0011\u001d\t\u0019H\u0011a\u0001\u0003o\"Bba\n\u00048\re21HB\u001f\u0007\u007fA\u0011\"!\u0018D!\u0003\u0005\r!!\u0019\t\u0013\t}2\t%AA\u0002\u0005\u0005\u0004\u0002CA*\u0007B\u0005\t\u0019A8\t\u0013\u0005}2\t%AA\u0002\u0005\r\u0003\"CA:\u0007B\u0005\t\u0019AA<\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0012+\t\u0005\u00054qI\u0016\u0003\u0007\u0013\u0002Baa\u0013\u0004T5\u00111Q\n\u0006\u0005\u0007\u001f\u001a\t&A\u0005v]\u000eDWmY6fI*!\u0011\u0011GA\u000e\u0013\u0011\u0019)f!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u00111Q\f\u0016\u0004_\u000e\u001d\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007GRC!a\u0011\u0004H\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAB5U\u0011\t9ha\u0012\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0019y\u0007\u0005\u0003\u0004r\rmTBAB:\u0015\u0011\u0019)ha\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0007s\nAA[1wC&!\u0011QEB:\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0001\u0004\u0004\"I\u0011\u0011\\&\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u00111\u0011\u0012\t\u0007\u0007\u0017\u001b\tJ!\u0001\u000e\u0005\r5%\u0002BBH\u00037\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019\u0019j!$\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003o\u001aI\nC\u0005\u0002Z6\u000b\t\u00111\u0001\u0003\u0002\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002bQ\u00111qN\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]4Q\u0015\u0005\n\u00033\u0004\u0016\u0011!a\u0001\u0005\u0003\tA\u0001R1uCB\u00191\u0011\u0006*\u0014\u000bI\u001biKa9\u0011\u001f\r=6QWA1\u0003Cz\u00171IA<\u0007Oi!a!-\u000b\t\rM\u00161D\u0001\beVtG/[7f\u0013\u0011\u00199l!-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0006\u0002\u0004*\u0006)\u0011\r\u001d9msRa1qEB`\u0007\u0003\u001c\u0019m!2\u0004H\"9\u0011QL+A\u0002\u0005\u0005\u0004b\u0002B +\u0002\u0007\u0011\u0011\r\u0005\u0007\u0003'*\u0006\u0019A8\t\u000f\u0005}R\u000b1\u0001\u0002D!9\u00111O+A\u0002\u0005]\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u001b\u001cI\u000e\u0005\u0004\u0002d\r=71[\u0005\u0005\u0007#\fYB\u0001\u0004PaRLwN\u001c\t\u000e\u0003G\u001a).!\u0019\u0002b=\f\u0019%a\u001e\n\t\r]\u00171\u0004\u0002\u0007)V\u0004H.Z\u001b\t\u0013\rmg+!AA\u0002\r\u001d\u0012a\u0001=%a\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0002R\u000e\u0005\bb\u0002B\u007f/\u0002\u0007\u0011q\u0002\u0002\u001e\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2\u0014V-\u00193feN\u0019\u0001La<\u0015\u0005\r%\bcAB\f1\u0006I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004CcA;\u0004r\"9!Q /A\u0002\u0005=\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"aa>\u0011\t\rE4\u0011`\u0005\u0005\u0007w\u001c\u0019H\u0001\u0004PE*,7\r\u001e\u0015\u0006a\u0005-\"1\t\u0015\u0006_\u0005-\"1\t")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements MLWritable,
LogisticRegressionParams,
HasTrainingSummary<LogisticRegressionTrainingSummary> {
    private Vector _coefficients;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final DenseVector _interceptVector;
    private final double _intercept;
    private double[] _binaryThresholds;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile boolean bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LogisticRegressionTrainingSummary> setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if (!this.bitmap$0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable & scala.Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = true;
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        if (!this.bitmap$0) {
            return this._coefficients$lzycompute();
        }
        return this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private DenseVector _interceptVector() {
        return this._interceptVector;
    }

    private double _intercept() {
        return this._intercept;
    }

    private double[] _binaryThresholds() {
        return this._binaryThresholds;
    }

    private void _binaryThresholds_$eq(double[] x$1) {
        this._binaryThresholds = x$1;
    }

    @Override
    public void onParamChange(Param<?> param) {
        block6: {
            block7: {
                if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) break block6;
                String string = param.name();
                String string2 = "threshold";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                String string3 = param.name();
                String string4 = "thresholds";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block6;
            }
            if (this.isDefined(this.threshold()) || this.isDefined(this.thresholds())) {
                double _threshold = this.getThreshold();
                if (_threshold == 0.0) {
                    this._binaryThresholds_$eq(new double[]{_threshold, Double.NEGATIVE_INFINITY});
                    return;
                }
                if (_threshold == 1.0) {
                    this._binaryThresholds_$eq(new double[]{_threshold, Double.POSITIVE_INFINITY});
                    return;
                }
                this._binaryThresholds_$eq(new double[]{_threshold, scala.math.package$.MODULE$.log(_threshold / (1.0 - _threshold))});
                return;
            }
            this._binaryThresholds_$eq(null);
            return;
        }
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary) {
            BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
            return binaryLogisticRegressionTrainingSummary;
        }
        throw new RuntimeException(new StringBuilder(88).append("Cannot create a binary summary for a non-binary model").append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString());
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        if (this.numClasses() > 2) {
            return new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
        }
        return new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return super.predict(features);
        }
        if (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this._binaryThresholds()[0]) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            double[] values = denseVector.values();
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                Utils$.MODULE$.softmax(values);
            } else {
                values[0] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-values[0]));
                values[1] = 1.0 - values[0];
            }
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return (Vector)this.margins().apply((Object)features);
        }
        double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return super.raw2prediction(rawPrediction);
        }
        if (rawPrediction.apply(1) > this._binaryThresholds()[1]) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            return super.probability2prediction(probability);
        }
        if (probability.apply(1) > this._binaryThresholds()[0]) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(56).append("LogisticRegressionModel: uid=").append(this.uid()).append(", numClasses=").append(this.numClasses()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        double[] dArray;
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        MLWritable.$init$(this);
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LogisticRegressionParams.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dimension mismatch! Expected ").append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").append(this.interceptVector().size()).toString());
        this._interceptVector = isMultinomial ? interceptVector.toDense() : null;
        double d = this._intercept = !isMultinomial ? interceptVector.apply(0) : Double.NaN;
        if (!isMultinomial) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.5;
            dArray = dArray2;
            dArray2[1] = 0.0;
        } else {
            dArray = null;
        }
        this._binaryThresholds = dArray;
        this.margin = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable & scala.Serializable)features -> {
            DenseVector m = this._interceptVector().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return m;
        };
        this.score = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    private static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    int major2 = sp2._1$mcI$sp();
                                    int minor2 = sp2._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqLike)some.get()).apply(0);
                                    Object numFeatures = ((SeqLike)some.get()).apply(1);
                                    Object intercept = ((SeqLike)some.get()).apply(2);
                                    coefficients = ((SeqLike)some.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple4._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple4._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                            Vector coefficients2 = (Vector)tuple4._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple5._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple5._2());
                Vector interceptVector = (Vector)tuple5._3();
                Matrix coefficientMatrix = (Matrix)tuple5._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        scala.Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.numClasses());
                    }
                    case 1: {
                        return BoxesRunTime.boxToInteger((int)this.numFeatures());
                    }
                    case 2: {
                        return this.interceptVector();
                    }
                    case 3: {
                        return this.coefficientMatrix();
                    }
                    case 4: {
                        return BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

