/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.UUID;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Binomial$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Gaussian$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Identity$;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$Poisson$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u0012$\u00019B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"1\u0001\u000b\u0001C\u0001GECq!\u0017\u0001C\u0002\u0013\u0005!\f\u0003\u0004p\u0001\u0001\u0006Ia\u0017\u0005\bc\u0002\u0011\r\u0011\"\u0005s\u0011\u0019\u0019\b\u0001)A\u0005\u0019\"9A\u000f\u0001b\u0001\n\u0003)\bbBA\u0007\u0001\u0001\u0006IA\u001e\u0005\f\u00033\u0001\u0001R1A\u0005\u0002\r\nY\u0002C\u0006\u0002,\u0001A)\u0019!C\u0001G\u00055\u0002bCA\u001b\u0001!\u0015\r\u0011\"\u0001$\u0003oA!\"a\u0010\u0001\u0011\u000b\u0007I\u0011BA!\u0011)\tI\u0005\u0001EC\u0002\u0013\u0005\u00111\n\u0005\f\u00033\u0002\u0001R1A\u0005\u0002\u0015\nY\u0006\u0003\u0006\u0002d\u0001A)\u0019!C\u0001\u0003\u0017B!\"a\u001a\u0001\u0011\u000b\u0007I\u0011AA&\u0011)\tY\u0007\u0001EC\u0002\u0013\u0005\u00111\n\u0005\u000b\u0003_\u0002\u0001R1A\u0005\u0002\u0005-\u0003bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011BA;\u0011\u001d\ty\b\u0001C\u0005\u0003kBq!!!\u0001\t\u0013\t)\b\u0003\u0006\u0002\u0004\u0002A)\u0019!C\u0001GUD!\"!\"\u0001\u0011\u000b\u0007I\u0011A\u0012v\u0011)\t9\t\u0001EC\u0002\u0013\u00051%\u001e\u0005\u000b\u0003\u0013\u0003\u0001R1A\u0005\u0002\r*\bbBAF\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0003\u0017\u0003A\u0011AAI\u0011)\tI\n\u0001EC\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003K\u0003\u0001R1A\u0005\u0002\u0005m\u0005BCAU\u0001!\u0015\r\u0011\"\u0001\u0002\u001c\"Q\u0011Q\u0016\u0001\t\u0006\u0004%\t!a'\u0003E\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o'VlW.\u0019:z\u0015\t!S%\u0001\u0006sK\u001e\u0014Xm]:j_:T!AJ\u0014\u0002\u00055d'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t\u0001d'\u0003\u00028c\ta1+\u001a:jC2L'0\u00192mK\u00069A-\u0019;bg\u0016$\bG\u0001\u001eC!\rYd\bQ\u0007\u0002y)\u0011QhJ\u0001\u0004gFd\u0017BA =\u0005\u001d!\u0015\r^1tKR\u0004\"!\u0011\"\r\u0001\u0011I1)AA\u0001\u0002\u0003\u0015\t\u0001\u0012\u0002\u0004?\u0012*\u0014CA#I!\t\u0001d)\u0003\u0002Hc\t9aj\u001c;iS:<\u0007C\u0001\u0019J\u0013\tQ\u0015GA\u0002B]f\f\u0011b\u001c:jO6{G-\u001a7\u0011\u00055sU\"A\u0012\n\u0005=\u001b#\u0001I$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3beJ+wM]3tg&|g.T8eK2\fa\u0001P5oSRtDc\u0001*T1B\u0011Q\n\u0001\u0005\u0006q\r\u0001\r\u0001\u0016\u0019\u0003+^\u00032a\u000f W!\t\tu\u000bB\u0005D'\u0006\u0005\t\u0011!B\u0001\t\")1j\u0001a\u0001\u0019\u0006i\u0001O]3eS\u000e$\u0018n\u001c8D_2,\u0012a\u0017\t\u00039\u000et!!X1\u0011\u0005y\u000bT\"A0\u000b\u0005\u0001l\u0013A\u0002\u001fs_>$h(\u0003\u0002cc\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011\u0017\u0007K\u0002\u0005O6\u0004\"\u0001[6\u000e\u0003%T!A[\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002mS\n)1+\u001b8dK\u0006\na.A\u00033]Ar\u0003'\u0001\bqe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u0011)\u0007\u00159W.A\u0003n_\u0012,G.F\u0001M\u0003\u0019iw\u000eZ3mA\u0005Y\u0001O]3eS\u000e$\u0018n\u001c8t+\u00051\bcA<\u0002\u00069\u0019\u00010!\u0001\u000f\u0005e|hB\u0001>\u007f\u001d\tYXP\u0004\u0002_y&\tA&\u0003\u0002+W%\u0011\u0001&K\u0005\u0003{\u001dJ1!a\u0001=\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0002\u0002\n\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u0007a\u0004f\u0001\u0005h[\u0006a\u0001O]3eS\u000e$\u0018n\u001c8tA!\u001a\u0011\"!\u0005\u0011\u0007A\n\u0019\"C\u0002\u0002\u0016E\u0012\u0011\u0002\u001e:b]NLWM\u001c;)\u0007%9W.\u0001\u0006gC6LG.\u001f'j].,\"!!\b\u0011\t\u0005}\u0011Q\u0005\b\u0004\u001b\u0006\u0005\u0012bAA\u0012G\u0005Yr)\u001a8fe\u0006d\u0017N_3e\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:LA!a\n\u0002*\tia)Y7jYf\fe\u000e\u001a'j].T1!a\t$\u0003\u00191\u0017-\\5msV\u0011\u0011q\u0006\t\u0005\u0003?\t\t$\u0003\u0003\u00024\u0005%\"A\u0002$b[&d\u00170\u0001\u0003mS:\\WCAA\u001d!\u0011\ty\"a\u000f\n\t\u0005u\u0012\u0011\u0006\u0002\u0005\u0019&t7.\u0001\u0006hYJ\u001cV/\\7bef,\"!a\u0011\u0011\u0007m\n)%C\u0002\u0002Hq\u00121AU8x\u00031qW/\\%ogR\fgnY3t+\t\ti\u0005E\u00021\u0003\u001fJ1!!\u00152\u0005\u0011auN\\4)\t99\u0017QK\u0011\u0003\u0003/\nQA\r\u00183]A\nABZ3biV\u0014XMT1nKN,\"!!\u0018\u0011\tA\nyfW\u0005\u0004\u0003C\n$!B!se\u0006L\u0018\u0001\u0002:b].D3\u0001E4n\u0003A!Wm\u001a:fKN|eM\u0012:fK\u0012|W\u000eK\u0002\u0012O6\fqC]3tS\u0012,\u0018\r\u001c#fOJ,Wm\u00144Ge\u0016,Gm\\7)\u0007I9W.A\u000esKNLG-^1m\t\u0016<'/Z3PM\u001a\u0013X-\u001a3p[:+H\u000e\u001c\u0015\u0004'\u001dl\u0017!\u00027bE\u0016dWCAA<!\rY\u0014\u0011P\u0005\u0004\u0003wb$AB\"pYVlg.\u0001\u0006qe\u0016$\u0017n\u0019;j_:\faa^3jO\"$\u0018AB8gMN,G/A\teKZL\u0017M\\2f%\u0016\u001c\u0018\u000eZ;bYN\f\u0001\u0003]3beN|gNU3tS\u0012,\u0018\r\\:\u0002!]|'o[5oOJ+7/\u001b3vC2\u001c\u0018!\u0005:fgB|gn]3SKNLG-^1mg\u0006I!/Z:jIV\fGn\u001d\u000b\u0002m\"\u001aAdZ7\u0015\u0007Y\f\u0019\n\u0003\u0004\u0002\u0016v\u0001\raW\u0001\u000ee\u0016\u001c\u0018\u000eZ;bYN$\u0016\u0010]3)\u0007u9W.\u0001\u0007ok2dG)\u001a<jC:\u001cW-\u0006\u0002\u0002\u001eB\u0019\u0001'a(\n\u0007\u0005\u0005\u0016G\u0001\u0004E_V\u0014G.\u001a\u0015\u0004=\u001dl\u0017\u0001\u00033fm&\fgnY3)\u0007}9W.\u0001\u0006eSN\u0004XM]:j_:D3\u0001I4n\u0003\r\t\u0017n\u0019\u0015\u0004C\u001dl\u0007f\u0001\u0001h[\u0002")
public class GeneralizedLinearRegressionSummary
implements scala.Serializable {
    private GeneralizedLinearRegression.FamilyAndLink familyLink;
    private GeneralizedLinearRegression.Family family;
    private GeneralizedLinearRegression.Link link;
    private Row glrSummary;
    private long numInstances;
    private String[] featureNames;
    private long rank;
    private long degreesOfFreedom;
    private long residualDegreeOfFreedom;
    private long residualDegreeOfFreedomNull;
    private Dataset<Row> devianceResiduals;
    private Dataset<Row> pearsonResiduals;
    private Dataset<Row> workingResiduals;
    private Dataset<Row> responseResiduals;
    private double nullDeviance;
    private double deviance;
    private double dispersion;
    private double aic;
    private final Dataset<?> dataset;
    private GeneralizedLinearRegressionModel origModel;
    private final String predictionCol;
    private final GeneralizedLinearRegressionModel model;
    private final transient Dataset<Row> predictions;
    private volatile int bitmap$0;

    public String predictionCol() {
        return this.predictionCol;
    }

    public GeneralizedLinearRegressionModel model() {
        return this.model;
    }

    public Dataset<Row> predictions() {
        return this.predictions;
    }

    private GeneralizedLinearRegression.FamilyAndLink familyLink$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 1) == 0) {
                this.familyLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this.model());
                this.bitmap$0 |= 1;
            }
        }
        return this.familyLink;
    }

    public GeneralizedLinearRegression.FamilyAndLink familyLink() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.familyLink$lzycompute();
        }
        return this.familyLink;
    }

    private GeneralizedLinearRegression.Family family$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 2) == 0) {
                this.family = this.familyLink().family();
                this.bitmap$0 |= 2;
            }
        }
        return this.family;
    }

    public GeneralizedLinearRegression.Family family() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.family$lzycompute();
        }
        return this.family;
    }

    private GeneralizedLinearRegression.Link link$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 4) == 0) {
                this.link = this.familyLink().link();
                this.bitmap$0 |= 4;
            }
        }
        return this.link;
    }

    public GeneralizedLinearRegression.Link link() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.link$lzycompute();
        }
        return this.link;
    }

    /*
     * Unable to fully structure code
     */
    private Row glrSummary$lzycompute() {
        block9: {
            var1_1 = this;
            synchronized (var1_1) {
                if ((this.bitmap$0 & 8) != 0) break block9;
                devUDF = functions$.MODULE$.udf((Function3)(Function3 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$glrSummary$1$adapted(org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary java.lang.Object java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((GeneralizedLinearRegressionSummary)this), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                devCol = functions$.MODULE$.sum(devUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label(), this.prediction(), this.weight()})));
                v0 = this.model().getFamily().toLowerCase(Locale.ROOT);
                var5_4 = GeneralizedLinearRegression$Binomial$.MODULE$.name();
                if (!(v0 == null ? var5_4 != null : v0.equals(var5_4) == false)) ** GOTO lbl-1000
                v1 = this.model().getFamily().toLowerCase(Locale.ROOT);
                var6_5 = GeneralizedLinearRegression$Poisson$.MODULE$.name();
                if (v1 == null ? var6_5 != null : v1.equals(var6_5) == false) {
                    rssUDF = functions$.MODULE$.udf((Function3)(Function3 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$glrSummary$2$adapted(org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary java.lang.Object java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;)((GeneralizedLinearRegressionSummary)this), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                    v2 = functions$.MODULE$.sum(rssUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label(), this.prediction(), this.weight()})));
                } else lbl-1000:
                // 2 sources

                {
                    v2 = rssCol = functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)NaN));
                }
                if (!this.model().getFitIntercept()) ** GOTO lbl-1000
                if (!this.model().hasOffsetCol()) ** GOTO lbl-1000
                if (this.model().hasOffsetCol()) {
                    v3 = this.family();
                    var9_8 = GeneralizedLinearRegression$Gaussian$.MODULE$;
                    if (!(v3 != null ? v3.equals(var9_8) == false : var9_8 != null)) {
                        v4 = this.link();
                        var10_9 = GeneralizedLinearRegression$Identity$.MODULE$;
                        ** if (v4 != null ? v4.equals((Object)var10_9) == false : var10_9 != null) goto lbl-1000
                    }
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v5 = functions$.MODULE$.sum(this.label().$minus((Object)this.offset()).$times((Object)this.weight())).$div((Object)functions$.MODULE$.sum(this.weight()));
                    ** GOTO lbl30
                }
lbl-1000:
                // 3 sources

                {
                    v5 = functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)NaN));
                }
lbl30:
                // 2 sources

                avgCol = v5;
                this.glrSummary = (Row)this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count(this.label()), functions$.MODULE$.sum(this.weight()), devCol, rssCol, avgCol})).head();
                this.bitmap$0 |= 8;
            }
        }
        return this.glrSummary;
    }

    private Row glrSummary() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.glrSummary$lzycompute();
        }
        return this.glrSummary;
    }

    private long numInstances$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.numInstances = this.glrSummary().getLong(0);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.numInstances;
    }

    public long numInstances() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.numInstances$lzycompute();
        }
        return this.numInstances;
    }

    private String[] featureNames$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x20) == 0) {
                Option<Attribute[]> featureAttrs = AttributeGroup$.MODULE$.fromStructField(this.dataset.schema().apply(this.model().getFeaturesCol())).attributes();
                this.featureNames = featureAttrs.isDefined() ? (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureAttrs.get())).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3.name().get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Array$.MODULE$.tabulate(this.origModel.numFeatures(), (Function1 & Serializable & scala.Serializable)x -> GeneralizedLinearRegressionSummary.$anonfun$featureNames$2(this, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(String.class));
                this.bitmap$0 |= 0x20;
            }
        }
        this.origModel = null;
        return this.featureNames;
    }

    public String[] featureNames() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.featureNames$lzycompute();
        }
        return this.featureNames;
    }

    private long rank$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.rank = this.model().getFitIntercept() ? (long)(this.model().coefficients().size() + 1) : (long)this.model().coefficients().size();
                this.bitmap$0 |= 0x40;
            }
        }
        return this.rank;
    }

    public long rank() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.rank$lzycompute();
        }
        return this.rank;
    }

    private long degreesOfFreedom$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.degreesOfFreedom = this.numInstances() - this.rank();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.degreesOfFreedom;
    }

    public long degreesOfFreedom() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.degreesOfFreedom$lzycompute();
        }
        return this.degreesOfFreedom;
    }

    private long residualDegreeOfFreedom$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.residualDegreeOfFreedom = this.degreesOfFreedom();
                this.bitmap$0 |= 0x100;
            }
        }
        return this.residualDegreeOfFreedom;
    }

    public long residualDegreeOfFreedom() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.residualDegreeOfFreedom$lzycompute();
        }
        return this.residualDegreeOfFreedom;
    }

    private long residualDegreeOfFreedomNull$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.residualDegreeOfFreedomNull = this.model().getFitIntercept() ? this.numInstances() - 1L : this.numInstances();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.residualDegreeOfFreedomNull;
    }

    public long residualDegreeOfFreedomNull() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.residualDegreeOfFreedomNull$lzycompute();
        }
        return this.residualDegreeOfFreedomNull;
    }

    private Column label() {
        return functions$.MODULE$.col(this.model().getLabelCol()).cast((DataType)DoubleType$.MODULE$);
    }

    private Column prediction() {
        return functions$.MODULE$.col(this.predictionCol());
    }

    private Column weight() {
        if (!this.model().hasWeightCol()) {
            return functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        }
        return functions$.MODULE$.col(this.model().getWeightCol());
    }

    private Column offset() {
        if (!this.model().hasOffsetCol()) {
            return functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        return functions$.MODULE$.col(this.model().getOffsetCol()).cast((DataType)DoubleType$.MODULE$);
    }

    private Dataset<Row> devianceResiduals$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x400) == 0) {
                UserDefinedFunction drUDF = functions$.MODULE$.udf((Function3 & Serializable & scala.Serializable)(y, mu, weight) -> BoxesRunTime.boxToDouble((double)GeneralizedLinearRegressionSummary.$anonfun$devianceResiduals$1(this, BoxesRunTime.unboxToDouble((Object)y), BoxesRunTime.unboxToDouble((Object)mu), BoxesRunTime.unboxToDouble((Object)weight))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                this.devianceResiduals = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{drUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label(), this.prediction(), this.weight()})).as("devianceResiduals")}));
                this.bitmap$0 |= 0x400;
            }
        }
        return this.devianceResiduals;
    }

    public Dataset<Row> devianceResiduals() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.devianceResiduals$lzycompute();
        }
        return this.devianceResiduals;
    }

    private Dataset<Row> pearsonResiduals$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x800) == 0) {
                UserDefinedFunction prUDF = functions$.MODULE$.udf((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)mu -> this.family().variance(mu), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                this.pearsonResiduals = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label().minus((Object)this.prediction()).multiply((Object)functions$.MODULE$.sqrt(this.weight())).divide((Object)functions$.MODULE$.sqrt(prUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.prediction()})))).as("pearsonResiduals")}));
                this.bitmap$0 |= 0x800;
            }
        }
        return this.pearsonResiduals;
    }

    public Dataset<Row> pearsonResiduals() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.pearsonResiduals$lzycompute();
        }
        return this.pearsonResiduals;
    }

    private Dataset<Row> workingResiduals$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                UserDefinedFunction wrUDF = functions$.MODULE$.udf((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(y, mu) -> (y - mu) * this.link().deriv(mu), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                this.workingResiduals = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{wrUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label(), this.prediction()})).as("workingResiduals")}));
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.workingResiduals;
    }

    public Dataset<Row> workingResiduals() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.workingResiduals$lzycompute();
        }
        return this.workingResiduals;
    }

    private Dataset<Row> responseResiduals$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.responseResiduals = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label().minus((Object)this.prediction()).as("responseResiduals")}));
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.responseResiduals;
    }

    public Dataset<Row> responseResiduals() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.responseResiduals$lzycompute();
        }
        return this.responseResiduals;
    }

    public Dataset<Row> residuals() {
        return this.devianceResiduals();
    }

    public Dataset<Row> residuals(String residualsType) {
        String string = residualsType;
        if ("deviance".equals(string)) {
            return this.devianceResiduals();
        }
        if ("pearson".equals(string)) {
            return this.pearsonResiduals();
        }
        if ("working".equals(string)) {
            return this.workingResiduals();
        }
        if ("response".equals(string)) {
            return this.responseResiduals();
        }
        throw new UnsupportedOperationException(new StringBuilder(70).append("The residuals type ").append(string).append(" is not supported by Generalized Linear Regression.").toString());
    }

    /*
     * Unable to fully structure code
     */
    private double nullDeviance$lzycompute() {
        block7: {
            var1_1 = this;
            synchronized (var1_1) {
                block9: {
                    block8: {
                        if ((this.bitmap$0 & 16384) != 0) break block7;
                        if (this.model().getFitIntercept()) break block8;
                        v0 = 0.0;
                        break block9;
                    }
                    if (!this.model().hasOffsetCol()) ** GOTO lbl-1000
                    if (this.model().hasOffsetCol()) {
                        v1 = this.family();
                        var4_2 = GeneralizedLinearRegression$Gaussian$.MODULE$;
                        if (!(v1 != null ? v1.equals(var4_2) == false : var4_2 != null)) {
                            v2 = this.link();
                            var5_3 = GeneralizedLinearRegression$Identity$.MODULE$;
                            ** if (v2 != null ? v2.equals((Object)var5_3) == false : var5_3 != null) goto lbl-1000
                        }
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v0 = this.link().link(this.glrSummary().getDouble(4));
                        ** GOTO lbl31
                    }
lbl-1000:
                    // 2 sources

                    {
                        featureNull = new StringBuilder(8).append("feature_").append(UUID.randomUUID().toString()).toString();
                        paramMap = this.model().extractParamMap();
                        paramMap.put(this.model().featuresCol(), featureNull);
                        v3 = this.family().name();
                        var8_6 = "tweedie";
                        v4 = (v3 == null ? var8_6 != null : v3.equals(var8_6) == false) ? paramMap.remove(this.model().variancePower()) : BoxedUnit.UNIT;
                        $u = package$.MODULE$.universe();
                        $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionSummary.class.getClassLoader());
                        emptyVectorUDF = functions$.MODULE$.udf((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$nullDeviance$1(), ()Lorg/apache/spark/ml/linalg/Vector;)(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new $typecreator1$3(null)));
                        v0 = ((GeneralizedLinearRegressionModel)this.model().parent().fit(this.dataset.withColumn(featureNull, emptyVectorUDF.apply((Seq)Nil$.MODULE$)), paramMap)).intercept();
                    }
                }
                intercept = v0;
                this.nullDeviance = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label(), this.offset(), this.weight()})).rdd().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$nullDeviance$2$adapted(org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary double org.apache.spark.sql.Row ), (Lorg/apache/spark/sql/Row;)Ljava/lang/Object;)((GeneralizedLinearRegressionSummary)this, (double)intercept), ClassTag$.MODULE$.Double())).sum();
                this.bitmap$0 |= 16384;
            }
        }
        return this.nullDeviance;
    }

    public double nullDeviance() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.nullDeviance$lzycompute();
        }
        return this.nullDeviance;
    }

    private double deviance$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.deviance = this.glrSummary().getDouble(2);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.deviance;
    }

    public double deviance() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.deviance$lzycompute();
        }
        return this.deviance;
    }

    /*
     * Unable to fully structure code
     */
    private double dispersion$lzycompute() {
        block5: {
            var1_1 = this;
            synchronized (var1_1) {
                if ((this.bitmap$0 & 65536) != 0) break block5;
                v0 = this.model().getFamily().toLowerCase(Locale.ROOT);
                var2_2 = GeneralizedLinearRegression$Binomial$.MODULE$.name();
                if (!(v0 == null ? var2_2 != null : v0.equals(var2_2) == false)) ** GOTO lbl-1000
                v1 = this.model().getFamily().toLowerCase(Locale.ROOT);
                var3_3 = GeneralizedLinearRegression$Poisson$.MODULE$.name();
                if (!(v1 != null ? v1.equals(var3_3) == false : var3_3 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = 1.0;
                } else {
                    rss = this.glrSummary().getDouble(3);
                    v2 = rss / (double)this.degreesOfFreedom();
                }
                this.dispersion = v2;
                this.bitmap$0 |= 65536;
            }
        }
        return this.dispersion;
    }

    public double dispersion() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.dispersion$lzycompute();
        }
        return this.dispersion;
    }

    private double aic$lzycompute() {
        GeneralizedLinearRegressionSummary generalizedLinearRegressionSummary = this;
        synchronized (generalizedLinearRegressionSummary) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                double weightSum = this.glrSummary().getDouble(1);
                RDD t = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.label(), this.prediction(), this.weight()})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Row row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                        Object label = ((SeqLike)some.get()).apply(0);
                        Object pred = ((SeqLike)some.get()).apply(1);
                        Object weight = ((SeqLike)some.get()).apply(2);
                        if (label instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)label);
                            if (pred instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)pred);
                                if (weight instanceof Double) {
                                    double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
                                }
                            }
                        }
                    }
                    throw new MatchError((Object)row);
                }, ClassTag$.MODULE$.apply(Tuple3.class));
                this.aic = this.family().aic((RDD<Tuple3<Object, Object, Object>>)t, this.deviance(), this.numInstances(), weightSum) + (double)(2L * this.rank());
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.aic;
    }

    public double aic() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.aic$lzycompute();
        }
        return this.aic;
    }

    public static final /* synthetic */ double $anonfun$glrSummary$1(GeneralizedLinearRegressionSummary $this, double label, double pred, double weight) {
        return $this.family().deviance(label, pred, weight);
    }

    public static final /* synthetic */ double $anonfun$glrSummary$2(GeneralizedLinearRegressionSummary $this, double label, double pred, double weight) {
        return (label - pred) * (label - pred) * weight / $this.family().variance(pred);
    }

    public static final /* synthetic */ String $anonfun$featureNames$2(GeneralizedLinearRegressionSummary $this, int x) {
        return new StringBuilder(1).append($this.model().getFeaturesCol()).append("_").append(x).toString();
    }

    public static final /* synthetic */ double $anonfun$devianceResiduals$1(GeneralizedLinearRegressionSummary $this, double y, double mu, double weight) {
        double r = scala.math.package$.MODULE$.sqrt(scala.math.package$.MODULE$.max($this.family().deviance(y, mu, weight), 0.0));
        if (y > mu) {
            return r;
        }
        return -1.0 * r;
    }

    public static final /* synthetic */ Vector $anonfun$nullDeviance$1() {
        return Vectors$.MODULE$.zeros(0);
    }

    public static final /* synthetic */ double $anonfun$nullDeviance$2(GeneralizedLinearRegressionSummary $this, double intercept$1, Row x0$1) {
        Row row = x0$1;
        Some some = Row$.MODULE$.unapplySeq(row);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
            Object y = ((SeqLike)some.get()).apply(0);
            Object offset = ((SeqLike)some.get()).apply(1);
            Object weight = ((SeqLike)some.get()).apply(2);
            if (y instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)y);
                if (offset instanceof Double) {
                    double d2 = BoxesRunTime.unboxToDouble((Object)offset);
                    if (weight instanceof Double) {
                        double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                        return $this.family().deviance(d, $this.link().unlink(intercept$1 + d2), d3);
                    }
                }
            }
        }
        throw new MatchError((Object)row);
    }

    public GeneralizedLinearRegressionSummary(Dataset<?> dataset, GeneralizedLinearRegressionModel origModel) {
        this.dataset = dataset;
        this.origModel = origModel;
        this.predictionCol = origModel.isDefined(origModel.predictionCol()) && new StringOps(Predef$.MODULE$.augmentString(origModel.getPredictionCol())).nonEmpty() ? origModel.getPredictionCol() : new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString();
        this.model = (GeneralizedLinearRegressionModel)origModel.copy(ParamMap$.MODULE$.empty()).setPredictionCol(this.predictionCol());
        this.predictions = this.model().transform(dataset);
    }

    public static final /* synthetic */ Object $anonfun$glrSummary$1$adapted(GeneralizedLinearRegressionSummary $this, Object label, Object pred, Object weight) {
        return BoxesRunTime.boxToDouble((double)GeneralizedLinearRegressionSummary.$anonfun$glrSummary$1($this, BoxesRunTime.unboxToDouble((Object)label), BoxesRunTime.unboxToDouble((Object)pred), BoxesRunTime.unboxToDouble((Object)weight)));
    }

    public static final /* synthetic */ Object $anonfun$glrSummary$2$adapted(GeneralizedLinearRegressionSummary $this, Object label, Object pred, Object weight) {
        return BoxesRunTime.boxToDouble((double)GeneralizedLinearRegressionSummary.$anonfun$glrSummary$2($this, BoxesRunTime.unboxToDouble((Object)label), BoxesRunTime.unboxToDouble((Object)pred), BoxesRunTime.unboxToDouble((Object)weight)));
    }

    public static final /* synthetic */ Object $anonfun$nullDeviance$2$adapted(GeneralizedLinearRegressionSummary $this, double intercept$1, Row x0$1) {
        return BoxesRunTime.boxToDouble((double)GeneralizedLinearRegressionSummary.$anonfun$nullDeviance$2($this, intercept$1, x0$1));
    }
}

