/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpAnd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpEq$;
import breeze.linalg.operators.OpGT$;
import breeze.linalg.operators.OpGTE$;
import breeze.linalg.operators.OpLT$;
import breeze.linalg.operators.OpLTE$;
import breeze.linalg.operators.OpMod$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpNe$;
import breeze.linalg.operators.OpNeg$;
import breeze.linalg.operators.OpNot$;
import breeze.linalg.operators.OpOr$;
import breeze.linalg.operators.OpPow$;
import breeze.linalg.operators.OpSolveMatrixBy$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.operators.OpXor$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanSlice;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.CanTranspose;
import breeze.optimize.DiffFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.util.Isomorphism;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0017/\u0001eB\u0001B\u0013\u0001\u0003\u0002\u0004%Ia\u0013\u0005\t\u001f\u0002\u0011\t\u0019!C\u0005!\"Aa\u000b\u0001B\u0001B\u0003&A\n\u0003\u0005X\u0001\t\u0005\r\u0011\"\u0003Y\u0011!a\u0006A!a\u0001\n\u0013i\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0015B-\t\u000b\u0001\u0004A\u0011A1\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\"9!\u000e\u0001a\u0001\n\u0013Y\u0007BB7\u0001A\u0003&q\rC\u0004o\u0001\u0001\u0007I\u0011B8\t\u000fM\u0004\u0001\u0019!C\u0005i\"1a\u000f\u0001Q!\nADqa\u001e\u0001A\u0002\u0013%a\rC\u0004y\u0001\u0001\u0007I\u0011B=\t\rm\u0004\u0001\u0015)\u0003h\u0011\u001da\b\u00011A\u0005\n=Dq! \u0001A\u0002\u0013%a\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0015\u00029\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001\u0002CA\u000b\u0001\u0011\u0005\u0001'a\u0006\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!A\u0011\u0011\u0005\u0001\u0005\u0002A\n\u0019\u0003C\u0004\u0002&\u0001!\t!a\n\t\u0011\u0005-\u0002\u0001\"\u00011\u0003/Aq!!\f\u0001\t\u0003\ty\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u0011\u0005e\u0002\u0001\"\u00011\u0003wAq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002h\u0001!\t!!\u001b\b\u000f\u0005]d\u0006#\u0001\u0002z\u00191QF\fE\u0001\u0003wBa\u0001Y\u0011\u0005\u0002\u0005\r\u0005bBACC\u0011\u0005\u0011q\u0011\u0004\u0007\u00033\u000bC!a'\t\u0015\u0005=CE!A!\u0002\u0013\t\t\u0006\u0003\u0005KI\t\u0005\t\u0015!\u0003M\u0011!9FE!A!\u0002\u0013I\u0006\u0002\u0003?%\u0005\u0003\u0005\u000b\u0011\u00029\t\u0015\u0005UFE!A!\u0002\u0013\t9\f\u0003\u0004aI\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u001b$C\u0011IAh\u0011%\t9.IA\u0001\n\u0013\tINA\u0003M\u0005\u001a;5K\u0003\u00020a\u0005aq\u000e\u001d;j[&T\u0018\r^5p]*\u0011\u0011GM\u0001\u0006[2d\u0017N\u0019\u0006\u0003gQ\nQa\u001d9be.T!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO\u000e\u00011\u0003\u0002\u0001;\u0001\u0012\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!C\u001b\u0005q\u0013BA\"/\u0005%y\u0005\u000f^5nSj,'\u000f\u0005\u0002F\u00116\taI\u0003\u0002He\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002J\r\n9Aj\\4hS:<\u0017\u0001C4sC\u0012LWM\u001c;\u0016\u00031\u0003\"!Q'\n\u00059s#\u0001C$sC\u0012LWM\u001c;\u0002\u0019\u001d\u0014\u0018\rZ5f]R|F%Z9\u0015\u0005E#\u0006CA\u001eS\u0013\t\u0019FH\u0001\u0003V]&$\bbB+\u0003\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014!C4sC\u0012LWM\u001c;!\u0003\u001d)\b\u000fZ1uKJ,\u0012!\u0017\t\u0003\u0003jK!a\u0017\u0018\u0003\u000fU\u0003H-\u0019;fe\u0006YQ\u000f\u001d3bi\u0016\u0014x\fJ3r)\t\tf\fC\u0004V\u000b\u0005\u0005\t\u0019A-\u0002\u0011U\u0004H-\u0019;fe\u0002\na\u0001P5oSRtDc\u00012dIB\u0011\u0011\t\u0001\u0005\u0006\u0015\u001e\u0001\r\u0001\u0014\u0005\u0006/\u001e\u0001\r!W\u0001\u000f]Vl7i\u001c:sK\u000e$\u0018n\u001c8t+\u00059\u0007CA\u001ei\u0013\tIGHA\u0002J]R\f!C\\;n\u0007>\u0014(/Z2uS>t7o\u0018\u0013fcR\u0011\u0011\u000b\u001c\u0005\b+&\t\t\u00111\u0001h\u0003=qW/\\\"peJ,7\r^5p]N\u0004\u0013AD2p]Z,'oZ3oG\u0016$v\u000e\\\u000b\u0002aB\u00111(]\u0005\u0003er\u0012a\u0001R8vE2,\u0017AE2p]Z,'oZ3oG\u0016$v\u000e\\0%KF$\"!U;\t\u000fUc\u0011\u0011!a\u0001a\u0006y1m\u001c8wKJ<WM\\2f)>d\u0007%\u0001\tnCbtU/\\%uKJ\fG/[8og\u0006!R.\u0019=Ok6LE/\u001a:bi&|gn]0%KF$\"!\u0015>\t\u000fU{\u0011\u0011!a\u0001O\u0006\tR.\u0019=Ok6LE/\u001a:bi&|gn\u001d\u0011\u0002\u0011I,w\rU1sC6\fAB]3h!\u0006\u0014\u0018-\\0%KF$\"!U@\t\u000fU\u0013\u0012\u0011!a\u0001a\u0006I!/Z4QCJ\fW\u000eI\u0001\u0012g\u0016$h*^7D_J\u0014Xm\u0019;j_:\u001cH\u0003BA\u0004\u0003\u0013i\u0011\u0001\u0001\u0005\u0007\u0003\u0017!\u0002\u0019A4\u0002\u0017\r|'O]3di&|gn]\u0001\u0012g\u0016$8i\u001c8wKJ<WM\\2f)>dG\u0003BA\u0004\u0003#Aa!a\u0005\u0016\u0001\u0004\u0001\u0018!\u0003;pY\u0016\u0014\u0018M\\2f\u0003E9W\r^\"p]Z,'oZ3oG\u0016$v\u000e\u001c\u000b\u0002a\u0006\u00012/\u001a;Ok6LE/\u001a:bi&|gn\u001d\u000b\u0005\u0003\u000f\ti\u0002\u0003\u0004\u0002 ]\u0001\raZ\u0001\u0006SR,'o]\u0001\u0011O\u0016$h*^7Ji\u0016\u0014\u0018\r^5p]N$\u0012aZ\u0001\fg\u0016$(+Z4QCJ\fW\u000e\u0006\u0003\u0002\b\u0005%\u0002\"\u0002?\u001a\u0001\u0004\u0001\u0018aC4fiJ+w\rU1sC6\f1b]3u\u000fJ\fG-[3oiR!\u0011qAA\u0019\u0011\u0015Q5\u00041\u0001M\u0003)\u0019X\r^+qI\u0006$XM\u001d\u000b\u0005\u0003\u000f\t9\u0004C\u0003X9\u0001\u0007\u0011,\u0001\u0006hKR,\u0006\u000fZ1uKJ$\u0012!W\u0001\t_B$\u0018.\\5{KR1\u0011\u0011IA'\u0003G\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\u0002\u0014A\u00027j]\u0006dw-\u0003\u0003\u0002L\u0005\u0015#A\u0002,fGR|'\u000fC\u0004\u0002Py\u0001\r!!\u0015\u0002\t\u0011\fG/\u0019\t\u0007\u0003'\nI&!\u0018\u000e\u0005\u0005U#bAA,e\u0005\u0019!\u000f\u001a3\n\t\u0005m\u0013Q\u000b\u0002\u0004%\u0012#\u0005CB\u001e\u0002`A\f\t%C\u0002\u0002bq\u0012a\u0001V;qY\u0016\u0014\u0004bBA3=\u0001\u0007\u0011\u0011I\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t\u0003ay\u0007\u000f^5nSj,w+\u001b;i\u0019>\u001c8OU3ukJtW\r\u001a\u000b\u0007\u0003W\n\u0019(!\u001e\u0011\u000fm\ny&!\u0011\u0002nA!1(a\u001cq\u0013\r\t\t\b\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u001fz\u0002\u0019AA)\u0011\u001d\t)g\ba\u0001\u0003\u0003\nQ\u0001\u0014\"G\u000fN\u0003\"!Q\u0011\u0014\u000b\u0005RD)! \u0011\u0007m\ny(C\u0002\u0002\u0002r\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\u001f\u0002\u0011I,h\u000e\u0014\"G\u000fN#\"#a\u001b\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\"9\u0011qJ\u0012A\u0002\u0005E\u0003\"\u0002&$\u0001\u0004a\u0005\"B,$\u0001\u0004I\u0006\"B3$\u0001\u00049\u0007\"\u00028$\u0001\u0004\u0001\b\"B<$\u0001\u00049\u0007\"\u0002?$\u0001\u0004\u0001\bbBA3G\u0001\u0007\u0011\u0011\t\u0002\b\u0007>\u001cHOR;o'\u0011!#(!(\u0011\r\u0005}\u0015qUAV\u001b\t\t\tK\u0003\u0003\u0002>\u0005\r&BAAS\u0003\u0019\u0011'/Z3{K&!\u0011\u0011VAQ\u00051!\u0015N\u001a4Gk:\u001cG/[8o!\u0015\ti+!-q\u001b\t\tyK\u0003\u0003\u0002H\u0005\r\u0016\u0002BAZ\u0003_\u00131\u0002R3og\u00164Vm\u0019;pe\u0006Ya.^7Fq\u0006l\u0007\u000f\\3t!\rY\u0014\u0011X\u0005\u0004\u0003wc$\u0001\u0002'p]\u001e$B\"a0\u0002D\u0006\u0015\u0017qYAe\u0003\u0017\u00042!!1%\u001b\u0005\t\u0003bBA(U\u0001\u0007\u0011\u0011\u000b\u0005\u0006\u0015*\u0002\r\u0001\u0014\u0005\u0006/*\u0002\r!\u0017\u0005\u0006y*\u0002\r\u0001\u001d\u0005\b\u0003kS\u0003\u0019AA\\\u0003%\u0019\u0017\r\\2vY\u0006$X\r\u0006\u0003\u0002R\u0006M\u0007CB\u001e\u0002`A\fY\u000bC\u0004\u0002V.\u0002\r!a+\u0002\u000f],\u0017n\u001a5ug\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\t1\fgn\u001a\u0006\u0003\u0003K\fAA[1wC&!\u0011\u0011^Ap\u0005\u0019y%M[3di\u0002")
public class LBFGS
implements Optimizer,
Logging {
    private Gradient gradient;
    private Updater updater;
    private int numCorrections;
    private double convergenceTol;
    private int maxNumIterations;
    private double regParam;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<Vector, double[]> runLBFGS(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient, Updater updater, int n, double d, int n2, double d2, Vector vector) {
        return LBFGS$.MODULE$.runLBFGS(rDD, gradient, updater, n, d, n2, d2, vector);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Gradient gradient() {
        return this.gradient;
    }

    private void gradient_$eq(Gradient x$1) {
        this.gradient = x$1;
    }

    private Updater updater() {
        return this.updater;
    }

    private void updater_$eq(Updater x$1) {
        this.updater = x$1;
    }

    private int numCorrections() {
        return this.numCorrections;
    }

    private void numCorrections_$eq(int x$1) {
        this.numCorrections = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxNumIterations() {
        return this.maxNumIterations;
    }

    private void maxNumIterations_$eq(int x$1) {
        this.maxNumIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    public LBFGS setNumCorrections(int corrections) {
        Predef$.MODULE$.require(corrections > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Number of corrections must be positive but got ").append(corrections).toString());
        this.numCorrections_$eq(corrections);
        return this;
    }

    public LBFGS setConvergenceTol(double tolerance) {
        Predef$.MODULE$.require(tolerance >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Convergence tolerance must be nonnegative but got ").append(tolerance).toString());
        this.convergenceTol_$eq(tolerance);
        return this;
    }

    public double getConvergenceTol() {
        return this.convergenceTol();
    }

    public LBFGS setNumIterations(int iters) {
        Predef$.MODULE$.require(iters >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(iters).toString());
        this.maxNumIterations_$eq(iters);
        return this;
    }

    public int getNumIterations() {
        return this.maxNumIterations();
    }

    public LBFGS setRegParam(double regParam) {
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Regularization parameter must be nonnegative but got ").append(regParam).toString());
        this.regParam_$eq(regParam);
        return this;
    }

    public double getRegParam() {
        return this.regParam();
    }

    public LBFGS setGradient(Gradient gradient) {
        this.gradient_$eq(gradient);
        return this;
    }

    public LBFGS setUpdater(Updater updater) {
        this.updater_$eq(updater);
        return this;
    }

    public Updater getUpdater() {
        return this.updater();
    }

    @Override
    public Vector optimize(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        Tuple2<Vector, double[]> tuple2 = this.optimizeWithLossReturned(data, initialWeights);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector weights = (Vector)tuple2._1();
        Vector weights2 = weights;
        return weights2;
    }

    public Tuple2<Vector, double[]> optimizeWithLossReturned(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        return LBFGS$.MODULE$.runLBFGS(data, this.gradient(), this.updater(), this.numCorrections(), this.convergenceTol(), this.maxNumIterations(), this.regParam(), initialWeights);
    }

    public LBFGS(Gradient gradient, Updater updater) {
        this.gradient = gradient;
        this.updater = updater;
        Logging.$init$((Logging)this);
        this.numCorrections = 10;
        this.convergenceTol = 1.0E-6;
        this.maxNumIterations = 100;
        this.regParam = 0.0;
    }

    private static class CostFun
    implements DiffFunction<breeze.linalg.DenseVector<Object>> {
        private final RDD<Tuple2<Object, Vector>> data;
        private final Gradient gradient;
        private final Updater updater;
        private final double regParam;
        private final long numExamples;

        public DiffFunction<breeze.linalg.DenseVector<Object>> repr() {
            return DiffFunction.repr$((DiffFunction)this);
        }

        public DiffFunction<breeze.linalg.DenseVector<Object>> cached(CanCopy<breeze.linalg.DenseVector<Object>> copy) {
            return DiffFunction.cached$((DiffFunction)this, copy);
        }

        public <U> DiffFunction<U> throughLens(Isomorphism<breeze.linalg.DenseVector<Object>, U> l) {
            return DiffFunction.throughLens$((DiffFunction)this, l);
        }

        public Object gradientAt(Object x) {
            return StochasticDiffFunction.gradientAt$((StochasticDiffFunction)this, (Object)x);
        }

        public double valueAt(Object x) {
            return StochasticDiffFunction.valueAt$((StochasticDiffFunction)this, (Object)x);
        }

        public final double apply(Object x) {
            return StochasticDiffFunction.apply$((StochasticDiffFunction)this, (Object)x);
        }

        public final <B, C, That> That $plus(B b, UFunc.UImpl2<OpAdd$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)NumericOps.$plus$((NumericOps)this, b, op);
        }

        public final Object $colon$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$plus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$times$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $plus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $times$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$minus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$percent$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $percent$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $minus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$div$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $div$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final <B, That> That $less$colon$less(B b, UFunc.UImpl2<OpLT$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)NumericOps.$less$colon$less$((NumericOps)this, b, op);
        }

        public final <B, That> That $less$colon$eq(B b, UFunc.UImpl2<OpLTE$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)NumericOps.$less$colon$eq$((NumericOps)this, b, op);
        }

        public final <B, That> That $greater$colon$greater(B b, UFunc.UImpl2<OpGT$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)NumericOps.$greater$colon$greater$((NumericOps)this, b, op);
        }

        public final <B, That> That $greater$colon$eq(B b, UFunc.UImpl2<OpGTE$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)NumericOps.$greater$colon$eq$((NumericOps)this, b, op);
        }

        public final Object $colon$amp$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$bar$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $amp$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $bar$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final <B, That> That $plus$colon$plus(B b, UFunc.UImpl2<OpAdd$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$plus$colon$plus$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $times$colon$times(B b, UFunc.UImpl2<OpMulScalar$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$times$colon$times$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $colon$eq$eq(B b, UFunc.UImpl2<OpEq$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$colon$eq$eq$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $colon$bang$eq(B b, UFunc.UImpl2<OpNe$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$colon$bang$eq$((ImmutableNumericOps)this, b, op);
        }

        public final <That> That unary_$minus(UFunc.UImpl<OpNeg$, DiffFunction<breeze.linalg.DenseVector<Object>>, That> op) {
            return (That)ImmutableNumericOps.unary_$minus$((ImmutableNumericOps)this, op);
        }

        public final <B, That> That $minus$colon$minus(B b, UFunc.UImpl2<OpSub$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$minus$colon$minus$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $minus(B b, UFunc.UImpl2<OpSub$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$minus$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $percent$colon$percent(B b, UFunc.UImpl2<OpMod$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$percent$colon$percent$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $percent(B b, UFunc.UImpl2<OpMod$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$percent$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $div$colon$div(B b, UFunc.UImpl2<OpDiv$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$div$colon$div$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $div(B b, UFunc.UImpl2<OpDiv$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$div$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $up$colon$up(B b, UFunc.UImpl2<OpPow$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$up$colon$up$((ImmutableNumericOps)this, b, op);
        }

        public final <B, BB, That> That dot(B b, UFunc.UImpl2<OpMulInner$, DiffFunction<breeze.linalg.DenseVector<Object>>, BB, That> op) {
            return (That)ImmutableNumericOps.dot$((ImmutableNumericOps)this, b, op);
        }

        public final <That> That unary_$bang(UFunc.UImpl<OpNot$, DiffFunction<breeze.linalg.DenseVector<Object>>, That> op) {
            return (That)ImmutableNumericOps.unary_$bang$((ImmutableNumericOps)this, op);
        }

        public final <B, That> That $amp$colon$amp(B b, UFunc.UImpl2<OpAnd$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$amp$colon$amp$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $bar$colon$bar(B b, UFunc.UImpl2<OpOr$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$bar$colon$bar$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $up$up$colon$up$up(B b, UFunc.UImpl2<OpXor$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$up$up$colon$up$up$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $amp(B b, UFunc.UImpl2<OpAnd$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$amp$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $bar(B b, UFunc.UImpl2<OpOr$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$bar$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $up$up(B b, UFunc.UImpl2<OpXor$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$up$up$((ImmutableNumericOps)this, b, op);
        }

        public final <B, That> That $times(B b, UFunc.UImpl2<OpMulMatrix$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$times$((ImmutableNumericOps)this, b, op);
        }

        public final <That> That t(CanTranspose<DiffFunction<breeze.linalg.DenseVector<Object>>, That> op) {
            return (That)ImmutableNumericOps.t$((ImmutableNumericOps)this, op);
        }

        public <B, That> That $bslash(B b, UFunc.UImpl2<OpSolveMatrixBy$, DiffFunction<breeze.linalg.DenseVector<Object>>, B, That> op) {
            return (That)ImmutableNumericOps.$bslash$((ImmutableNumericOps)this, b, op);
        }

        public final <That, Slice1, Slice2, Result> Result t(Slice1 a, Slice2 b, CanTranspose<DiffFunction<breeze.linalg.DenseVector<Object>>, That> op, CanSlice2<That, Slice1, Slice2, Result> canSlice) {
            return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, b, op, canSlice);
        }

        public final <That, Slice1, Result> Result t(Slice1 a, CanTranspose<DiffFunction<breeze.linalg.DenseVector<Object>>, That> op, CanSlice<That, Slice1, Result> canSlice) {
            return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, op, canSlice);
        }

        public boolean apply$mcZD$sp(double v1) {
            return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
        }

        public double apply$mcDD$sp(double v1) {
            return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
        }

        public float apply$mcFD$sp(double v1) {
            return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
        }

        public int apply$mcID$sp(double v1) {
            return Function1.apply$mcID$sp$((Function1)this, (double)v1);
        }

        public long apply$mcJD$sp(double v1) {
            return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
        }

        public void apply$mcVD$sp(double v1) {
            Function1.apply$mcVD$sp$((Function1)this, (double)v1);
        }

        public boolean apply$mcZF$sp(float v1) {
            return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
        }

        public double apply$mcDF$sp(float v1) {
            return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
        }

        public float apply$mcFF$sp(float v1) {
            return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
        }

        public int apply$mcIF$sp(float v1) {
            return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
        }

        public long apply$mcJF$sp(float v1) {
            return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
        }

        public void apply$mcVF$sp(float v1) {
            Function1.apply$mcVF$sp$((Function1)this, (float)v1);
        }

        public boolean apply$mcZI$sp(int v1) {
            return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
        }

        public double apply$mcDI$sp(int v1) {
            return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
        }

        public float apply$mcFI$sp(int v1) {
            return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
        }

        public int apply$mcII$sp(int v1) {
            return Function1.apply$mcII$sp$((Function1)this, (int)v1);
        }

        public long apply$mcJI$sp(int v1) {
            return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
        }

        public void apply$mcVI$sp(int v1) {
            Function1.apply$mcVI$sp$((Function1)this, (int)v1);
        }

        public boolean apply$mcZJ$sp(long v1) {
            return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
        }

        public double apply$mcDJ$sp(long v1) {
            return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
        }

        public float apply$mcFJ$sp(long v1) {
            return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
        }

        public int apply$mcIJ$sp(long v1) {
            return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
        }

        public long apply$mcJJ$sp(long v1) {
            return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
        }

        public void apply$mcVJ$sp(long v1) {
            Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
        }

        public <A> Function1<A, Object> compose(Function1<A, breeze.linalg.DenseVector<Object>> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A> Function1<breeze.linalg.DenseVector<Object>, A> andThen(Function1<Object, A> g) {
            return Function1.andThen$((Function1)this, g);
        }

        public String toString() {
            return Function1.toString$((Function1)this);
        }

        public Tuple2<Object, breeze.linalg.DenseVector<Object>> calculate(breeze.linalg.DenseVector<Object> weights) {
            int x$4;
            Function2 & Serializable & scala.Serializable x$3;
            Function2 & Serializable & scala.Serializable x$2;
            Vector w = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)weights);
            int n = w.size();
            Broadcast bcW = this.data.context().broadcast((Object)w, ClassTag$.MODULE$.apply(Vector.class));
            Gradient localGradient = this.gradient;
            Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, v) -> {
                Tuple2 tuple2 = new Tuple2(c, v);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Vector grad = (Vector)tuple22._1();
                        double loss = tuple22._2$mcD$sp();
                        if (tuple23 != null) {
                            double label = tuple23._1$mcD$sp();
                            Vector features = (Vector)tuple23._2();
                            DenseVector denseGrad = grad.toDense();
                            double l = localGradient.compute(features, label, (Vector)bcW.value(), denseGrad);
                            return new Tuple2((Object)denseGrad, (Object)BoxesRunTime.boxToDouble((double)(loss + l)));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            };
            Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> {
                Tuple2 tuple2 = new Tuple2(c1, c2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Vector grad1 = (Vector)tuple22._1();
                        double loss1 = tuple22._2$mcD$sp();
                        if (tuple23 != null) {
                            Vector grad2 = (Vector)tuple23._1();
                            double loss2 = tuple23._2$mcD$sp();
                            DenseVector denseGrad1 = grad1.toDense();
                            DenseVector denseGrad2 = grad2.toDense();
                            BLAS$.MODULE$.axpy(1.0, (Vector)denseGrad2, (Vector)denseGrad1);
                            return new Tuple2((Object)denseGrad1, (Object)BoxesRunTime.boxToDouble((double)(loss1 + loss2)));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            };
            Vector zeroSparseVector = Vectors$.MODULE$.sparse(n, (Seq<Tuple2<Object, Object>>)((Seq)Nil$.MODULE$));
            Tuple2 x$1 = new Tuple2((Object)zeroSparseVector, (Object)BoxesRunTime.boxToDouble((double)0.0));
            Tuple2 tuple2 = (Tuple2)this.data.treeAggregate((Object)x$1, (Function2)(x$2 = seqOp), (Function2)(x$3 = combOp), x$4 = this.data.treeAggregate$default$4((Object)x$1), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector gradientSum = (Vector)tuple2._1();
            double lossSum = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)gradientSum, (Object)BoxesRunTime.boxToDouble((double)lossSum));
            Vector gradientSum2 = (Vector)tuple22._1();
            double lossSum2 = tuple22._2$mcD$sp();
            bcW.destroy();
            double regVal = this.updater.compute(w, Vectors$.MODULE$.zeros(n), 0.0, 1, this.regParam)._2$mcD$sp();
            double loss = lossSum2 / (double)this.numExamples + regVal;
            Vector gradientTotal = w.copy();
            BLAS$.MODULE$.axpy(-1.0, (Vector)this.updater.compute(w, Vectors$.MODULE$.zeros(n), 1.0, 1, this.regParam)._1(), gradientTotal);
            BLAS$.MODULE$.axpy(1.0 / (double)this.numExamples, gradientSum2, gradientTotal);
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)loss), (Object)((breeze.linalg.DenseVector)gradientTotal.asBreeze()));
        }

        public CostFun(RDD<Tuple2<Object, Vector>> data, Gradient gradient, Updater updater, double regParam, long numExamples) {
            this.data = data;
            this.gradient = gradient;
            this.updater = updater;
            this.regParam = regParam;
            this.numExamples = numExamples;
            Function1.$init$((Function1)this);
            ImmutableNumericOps.$init$((ImmutableNumericOps)this);
            NumericOps.$init$((NumericOps)this);
            StochasticDiffFunction.$init$((StochasticDiffFunction)this);
            DiffFunction.$init$((DiffFunction)this);
        }
    }
}

