/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.wildfly.openssl.CertificateVerifier;
import org.wildfly.openssl.Identification;
import org.wildfly.openssl.Messages;
import org.wildfly.openssl.OpenSSLServerSessionContext;
import org.wildfly.openssl.SSLImpl;
import org.wildfly.openssl.ServerALPNCallback;

public abstract class SSL {
    private static final Logger logger = Logger.getLogger(SSL.class.getName());
    public static final String MAC_HOMEBREW_OPENSSL_PATH = "/usr/local/opt/openssl/lib/";
    private static SSL instance;
    public static final String ORG_WILDFLY_OPENSSL_PATH = "org.wildfly.openssl.path";
    public static final String ORG_WILDFLY_OPENSSL_PATH_LIBSSL = "org.wildfly.openssl.path.ssl";
    public static final String ORG_WILDFLY_OPENSSL_PATH_LIBCRYPTO = "org.wildfly.openssl.path.crypto";
    public static final String ORG_WILDFLY_LIBWFSSL_PATH = "org.wildfly.openssl.libwfssl.path";
    private static final String[] LIBCRYPTO_NAMES;
    private static final String[] LIBSSL_NAMES;
    private static Object holder;
    private static volatile boolean init;
    static final String SSL_PROTO_ALL = "all";
    static final String SSL_PROTO_TLS = "TLS";
    static final String SSL_PROTO_TLSv1_2 = "TLSv1.2";
    static final String SSL_PROTO_TLSv1_1 = "TLSv1.1";
    static final String SSL_PROTO_TLSv1 = "TLSv1";
    static final String SSL_PROTO_SSLv3 = "SSLv3";
    static final String SSL_PROTO_SSLv2 = "SSLv2";
    static final String SSL_PROTO_SSLv2Hello = "SSLv2Hello";
    static final int UNSET = -1;
    static final int SSL_ALGO_UNKNOWN = 0;
    static final int SSL_ALGO_RSA = 1;
    static final int SSL_ALGO_DSA = 2;
    static final int SSL_ALGO_ALL = 3;
    static final int SSL_AIDX_RSA = 0;
    static final int SSL_AIDX_DSA = 1;
    static final int SSL_AIDX_ECC = 3;
    static final int SSL_AIDX_MAX = 4;
    static final int SSL_TMP_KEY_RSA_512 = 0;
    static final int SSL_TMP_KEY_RSA_1024 = 1;
    static final int SSL_TMP_KEY_RSA_2048 = 2;
    static final int SSL_TMP_KEY_RSA_4096 = 3;
    static final int SSL_TMP_KEY_DH_512 = 4;
    static final int SSL_TMP_KEY_DH_1024 = 5;
    static final int SSL_TMP_KEY_DH_2048 = 6;
    static final int SSL_TMP_KEY_DH_4096 = 7;
    static final int SSL_TMP_KEY_MAX = 8;
    static final int SSL_OPT_NONE = 0;
    static final int SSL_OPT_RELSET = 1;
    static final int SSL_OPT_STDENVVARS = 2;
    static final int SSL_OPT_EXPORTCERTDATA = 8;
    static final int SSL_OPT_FAKEBASICAUTH = 16;
    static final int SSL_OPT_STRICTREQUIRE = 32;
    static final int SSL_OPT_OPTRENEGOTIATE = 64;
    static final int SSL_OPT_ALL = 122;
    static final int SSL_PROTOCOL_NONE = 0;
    static final int SSL_PROTOCOL_SSLV2 = 1;
    static final int SSL_PROTOCOL_SSLV3 = 2;
    static final int SSL_PROTOCOL_TLSV1 = 4;
    static final int SSL_PROTOCOL_TLSV1_1 = 8;
    static final int SSL_PROTOCOL_TLSV1_2 = 16;
    static final int SSL_PROTOCOL_ALL = 28;
    static final int SSL_CVERIFY_UNSET = -1;
    static final int SSL_CVERIFY_NONE = 0;
    static final int SSL_CVERIFY_OPTIONAL = 1;
    static final int SSL_CVERIFY_REQUIRE = 2;
    static final int SSL_CVERIFY_OPTIONAL_NO_CA = 3;
    static final int SSL_VERIFY_NONE = 0;
    static final int SSL_VERIFY_PEER = 1;
    static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    static final int SSL_VERIFY_CLIENT_ONCE = 4;
    static final int SSL_VERIFY_PEER_STRICT = 3;
    static final int SSL_OP_MICROSOFT_SESS_ID_BUG = 1;
    static final int SSL_OP_NETSCAPE_CHALLENGE_BUG = 2;
    static final int SSL_OP_NETSCAPE_REUSE_CIPHER_CHANGE_BUG = 8;
    static final int SSL_OP_SSLREF2_REUSE_CERT_TYPE_BUG = 16;
    static final int SSL_OP_MICROSOFT_BIG_SSLV3_BUFFER = 32;
    static final int SSL_OP_MSIE_SSLV2_RSA_PADDING = 64;
    static final int SSL_OP_SSLEAY_080_CLIENT_DH_BUG = 128;
    static final int SSL_OP_TLS_D5_BUG = 256;
    static final int SSL_OP_TLS_BLOCK_PADDING_BUG = 512;
    static final int SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS = 2048;
    static final int SSL_OP_ALL = 4095;
    static final int SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536;
    static final int SSL_OP_NO_COMPRESSION = 131072;
    static final int SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION = 262144;
    static final int SSL_OP_SINGLE_ECDH_USE = 524288;
    static final int SSL_OP_SINGLE_DH_USE = 0x100000;
    static final int SSL_OP_EPHEMERAL_RSA = 0x200000;
    static final int SSL_OP_CIPHER_SERVER_PREFERENCE = 0x400000;
    static final int SSL_OP_TLS_ROLLBACK_BUG = 0x800000;
    static final int SSL_OP_NO_SSLv2 = 0x1000000;
    static final int SSL_OP_NO_SSLv3 = 0x2000000;
    static final int SSL_OP_NO_TLSv1 = 0x4000000;
    static final int SSL_OP_NO_TLSv1_2 = 0x8000000;
    static final int SSL_OP_NO_TLSv1_1 = 0x10000000;
    static final int SSL3_VERSION = 768;
    static final int TLS1_VERSION = 769;
    static final int TLS1_1_VERSION = 770;
    static final int TLS1_2_VERSION = 771;
    static final int SSL_OP_NO_TICKET = 16384;
    @Deprecated
    static final int SSL_OP_PKCS1_CHECK_1 = 0x8000000;
    @Deprecated
    static final int SSL_OP_PKCS1_CHECK_2 = 0x10000000;
    static final int SSL_OP_NETSCAPE_CA_DN_BUG = 0x20000000;
    static final int SSL_OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = 0x40000000;
    static final int SSL_CRT_FORMAT_UNDEF = 0;
    static final int SSL_CRT_FORMAT_ASN1 = 1;
    static final int SSL_CRT_FORMAT_TEXT = 2;
    static final int SSL_CRT_FORMAT_PEM = 3;
    static final int SSL_CRT_FORMAT_NETSCAPE = 4;
    static final int SSL_CRT_FORMAT_PKCS12 = 5;
    static final int SSL_CRT_FORMAT_SMIME = 6;
    static final int SSL_CRT_FORMAT_ENGINE = 7;
    static final int SSL_MODE_CLIENT = 0;
    static final int SSL_MODE_SERVER = 1;
    static final int SSL_MODE_COMBINED = 2;
    static final int SSL_SHUTDOWN_TYPE_UNSET = 0;
    static final int SSL_SHUTDOWN_TYPE_STANDARD = 1;
    static final int SSL_SHUTDOWN_TYPE_UNCLEAN = 2;
    static final int SSL_SHUTDOWN_TYPE_ACCURATE = 3;
    static final int SSL_INFO_SESSION_ID = 1;
    static final int SSL_INFO_CIPHER = 2;
    static final int SSL_INFO_CIPHER_USEKEYSIZE = 3;
    static final int SSL_INFO_CIPHER_ALGKEYSIZE = 4;
    static final int SSL_INFO_CIPHER_VERSION = 5;
    static final int SSL_INFO_CIPHER_DESCRIPTION = 6;
    static final int SSL_INFO_PROTOCOL = 7;
    static final int SSL_INFO_CLIENT_S_DN = 16;
    static final int SSL_INFO_CLIENT_I_DN = 32;
    static final int SSL_INFO_SERVER_S_DN = 64;
    static final int SSL_INFO_SERVER_I_DN = 128;
    static final int SSL_INFO_DN_COUNTRYNAME = 1;
    static final int SSL_INFO_DN_STATEORPROVINCENAME = 2;
    static final int SSL_INFO_DN_LOCALITYNAME = 3;
    static final int SSL_INFO_DN_ORGANIZATIONNAME = 4;
    static final int SSL_INFO_DN_ORGANIZATIONALUNITNAME = 5;
    static final int SSL_INFO_DN_COMMONNAME = 6;
    static final int SSL_INFO_DN_TITLE = 7;
    static final int SSL_INFO_DN_INITIALS = 8;
    static final int SSL_INFO_DN_GIVENNAME = 9;
    static final int SSL_INFO_DN_SURNAME = 10;
    static final int SSL_INFO_DN_DESCRIPTION = 11;
    static final int SSL_INFO_DN_UNIQUEIDENTIFIER = 12;
    static final int SSL_INFO_DN_EMAILADDRESS = 13;
    static final int SSL_INFO_CLIENT_M_VERSION = 257;
    static final int SSL_INFO_CLIENT_M_SERIAL = 258;
    static final int SSL_INFO_CLIENT_V_START = 259;
    static final int SSL_INFO_CLIENT_V_END = 260;
    static final int SSL_INFO_CLIENT_A_SIG = 261;
    static final int SSL_INFO_CLIENT_A_KEY = 262;
    static final int SSL_INFO_CLIENT_CERT = 263;
    static final int SSL_INFO_CLIENT_V_REMAIN = 264;
    static final int SSL_INFO_SERVER_M_VERSION = 513;
    static final int SSL_INFO_SERVER_M_SERIAL = 514;
    static final int SSL_INFO_SERVER_V_START = 515;
    static final int SSL_INFO_SERVER_V_END = 516;
    static final int SSL_INFO_SERVER_A_SIG = 517;
    static final int SSL_INFO_SERVER_A_KEY = 518;
    static final int SSL_INFO_SERVER_CERT = 519;
    static final int SSL_INFO_CLIENT_CERT_CHAIN = 1024;
    static final long SSL_SESS_CACHE_OFF = 0L;
    static final long SSL_SESS_CACHE_SERVER = 2L;
    static final int SSL_SELECTOR_FAILURE_NO_ADVERTISE = 0;
    static final int SSL_SELECTOR_FAILURE_CHOOSE_MY_LAST_PROTOCOL = 1;
    static final long VERSION_1_1_0 = 0x10100000L;
    static final long VERSION_1_1_0_F = 269484143L;
    static final int SSL_SENT_SHUTDOWN = 1;
    static final int SSL_RECEIVED_SHUTDOWN = 2;
    static final int SSL_ERROR_NONE = 0;
    static final int SSL_ERROR_SSL = 1;
    static final int SSL_ERROR_WANT_READ = 2;
    static final int SSL_ERROR_WANT_WRITE = 3;
    static final int SSL_ERROR_WANT_X509_LOOKUP = 4;
    static final int SSL_ERROR_SYSCALL = 5;
    static final int SSL_ERROR_ZERO_RETURN = 6;
    static final int SSL_ERROR_WANT_CONNECT = 7;
    static final int SSL_ERROR_WANT_ACCEPT = 8;
    private static Map<Long, SNICallBack> sniCallBacks;

    public static SSL getInstance() {
        SSL.init();
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void init() {
        if (init) return;
        Class<SSL> clazz = SSL.class;
        synchronized (SSL.class) {
            File file;
            String os;
            String path;
            if (init) return;
            String libPath = System.getProperty(ORG_WILDFLY_LIBWFSSL_PATH);
            if (libPath == null || libPath.isEmpty()) {
                try {
                    System.loadLibrary("wfssl");
                    instance = new SSLImpl();
                }
                catch (Throwable e) {
                    LibraryClassLoader libCl = new LibraryClassLoader(SSL.class.getClassLoader());
                    try {
                        Class<?> loader = libCl.loadClass(LibraryLoader.class.getName());
                        Method load = loader.getDeclaredMethod("load", new Class[0]);
                        Constructor<?> ctor = loader.getDeclaredConstructor(new Class[0]);
                        ctor.setAccessible(true);
                        load.setAccessible(true);
                        holder = ctor.newInstance(new Object[0]);
                        load.invoke(holder, new Object[0]);
                        Class<?> sslClass = libCl.loadClass(SSLImpl.class.getName());
                        instance = (SSL)sslClass.newInstance();
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1);
                    }
                }
            } else {
                Runtime.getRuntime().load(libPath);
                instance = new SSLImpl();
            }
            String specifiedPath = System.getProperty(ORG_WILDFLY_OPENSSL_PATH);
            if (specifiedPath != null && specifiedPath.isEmpty()) {
                specifiedPath = null;
            }
            if (specifiedPath != null && !specifiedPath.endsWith(File.separator)) {
                specifiedPath = specifiedPath + File.separator;
            }
            if ((path = specifiedPath) == null && (os = System.getProperty("os.name").toLowerCase()).contains("mac") && (file = new File(MAC_HOMEBREW_OPENSSL_PATH)).exists()) {
                path = MAC_HOMEBREW_OPENSSL_PATH;
            }
            String sslPath = System.getProperty(ORG_WILDFLY_OPENSSL_PATH_LIBSSL);
            String cryptoPath = System.getProperty(ORG_WILDFLY_OPENSSL_PATH_LIBCRYPTO);
            ArrayList<Object> paths = new ArrayList<Object>();
            if (specifiedPath != null) {
                paths.add(specifiedPath);
            } else {
                if (path != null) {
                    paths.add(path);
                }
                for (String p : System.getProperty("java.library.path").split(File.pathSeparator)) {
                    if (p == null) continue;
                    paths.add(p);
                }
            }
            ArrayList<String> attemptedSSL = new ArrayList<String>();
            ArrayList<String> attemptedCrypto = new ArrayList<String>();
            VersionedLibrary sslVersion = null;
            for (String string : paths) {
                File file2;
                String lib;
                if (sslPath != null && cryptoPath != null) break;
                if (sslPath == null) {
                    for (String ssl : LIBSSL_NAMES) {
                        lib = System.mapLibraryName(ssl);
                        file2 = new File(string, lib);
                        if (file2.exists()) {
                            sslPath = file2.getAbsolutePath();
                            break;
                        }
                        attemptedSSL.add(file2.getAbsolutePath());
                    }
                    if (sslPath == null) {
                        for (String ssl : LIBSSL_NAMES) {
                            lib = System.mapLibraryName(ssl);
                            sslVersion = SSL.searchForVersionedLibrary(string, lib, null);
                            if (sslVersion == null) continue;
                            sslPath = sslVersion.file;
                            break;
                        }
                    }
                }
                if (sslPath == null) continue;
                for (String crypto : LIBCRYPTO_NAMES) {
                    lib = System.mapLibraryName(crypto);
                    file2 = new File(string, lib);
                    if (file2.exists()) {
                        cryptoPath = file2.getAbsolutePath();
                        break;
                    }
                    attemptedCrypto.add(file2.getAbsolutePath());
                }
                if (cryptoPath == null && sslVersion != null) {
                    for (String crypto : LIBCRYPTO_NAMES) {
                        lib = System.mapLibraryName(crypto);
                        VersionedLibrary cryptoVersion = SSL.searchForVersionedLibrary(string, lib, sslVersion.versionPart);
                        if (cryptoVersion == null) continue;
                        cryptoPath = cryptoVersion.file;
                        break;
                    }
                }
                if (cryptoPath != null) continue;
                sslPath = null;
                sslVersion = null;
            }
            if (sslPath == null) {
                throw new RuntimeException(Messages.MESSAGES.couldNotFindLibSSL(ORG_WILDFLY_OPENSSL_PATH, ((Object)attemptedSSL).toString()));
            }
            if (cryptoPath == null) {
                throw new RuntimeException(Messages.MESSAGES.couldNotFindLibCrypto(ORG_WILDFLY_OPENSSL_PATH, ((Object)attemptedCrypto).toString()));
            }
            instance.initialize(cryptoPath, sslPath);
            String version = instance.version();
            logger.info(Messages.MESSAGES.openSSLVersion(version));
            init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static VersionedLibrary searchForVersionedLibrary(String path, String lib, String requiredVersion) {
        File file = new File(path);
        String[] files = file.list();
        ArrayList<VersionedLibrary> versionedLibraries = new ArrayList<VersionedLibrary>();
        if (files != null) {
            for (String test : files) {
                if (!test.startsWith(lib)) continue;
                String absolutePath = new File(path, test).getAbsolutePath();
                String versionedPart = test.substring(lib.length());
                if (requiredVersion != null && versionedPart.equals(requiredVersion)) {
                    return new VersionedLibrary(absolutePath, versionedPart);
                }
                versionedLibraries.add(new VersionedLibrary(absolutePath, versionedPart));
            }
        }
        if (versionedLibraries.isEmpty()) {
            return null;
        }
        Collections.sort(versionedLibraries);
        return (VersionedLibrary)versionedLibraries.get(0);
    }

    protected abstract void initialize(String var1, String var2);

    protected abstract String version();

    protected abstract boolean hasOp(int var1);

    protected abstract long newSSL(long var1, boolean var3);

    protected abstract int pendingWrittenBytesInBIO(long var1);

    protected abstract int pendingReadableBytesInSSL(long var1);

    protected abstract int writeToBIO(long var1, long var3, int var5);

    protected abstract int readFromBIO(long var1, long var3, int var5);

    protected abstract int writeToSSL(long var1, long var3, int var5);

    protected abstract int readFromSSL(long var1, long var3, int var5);

    protected abstract int getShutdown(long var1);

    protected abstract void freeSSL(long var1);

    protected abstract long makeNetworkBIO(long var1);

    protected abstract void freeBIO(long var1);

    protected abstract int shutdownSSL(long var1);

    protected abstract int getLastErrorNumber();

    protected abstract String getCipherForSSL(long var1);

    protected abstract String getVersion(long var1);

    protected abstract long versionNumber();

    protected abstract int doHandshake(long var1);

    protected abstract int getSSLError(long var1, int var3);

    protected abstract void saveServerCipher(long var1, int var3);

    protected abstract int renegotiate(long var1);

    protected abstract int isInInit(long var1);

    protected abstract String getAlpnSelected(long var1);

    protected abstract void enableAlpn(long var1);

    protected abstract boolean isAlpnSupported();

    protected abstract byte[][] getPeerCertChain(long var1);

    protected abstract byte[] getPeerCertificate(long var1);

    protected abstract String getErrorString(long var1);

    protected abstract long getTime(long var1);

    protected abstract void setSSLVerify(long var1, int var3, int var4);

    protected abstract void setOptions(long var1, long var3);

    protected abstract long getOptions(long var1);

    protected abstract String[] getCiphers(long var1);

    protected abstract boolean setCipherSuites(long var1, String var3) throws Exception;

    protected abstract boolean setServerNameIndication(long var1, String var3);

    protected abstract long getSession(long var1);

    protected abstract void setSession(long var1, long var3);

    protected abstract byte[] getSessionId(long var1);

    protected abstract long bufferAddress(ByteBuffer var1);

    protected abstract long makeSSLContext(int var1, int var2) throws Exception;

    protected abstract int freeSSLContext(long var1);

    protected abstract void setSSLContextOptions(long var1, long var3);

    protected abstract void clearSSLContextOptions(long var1, long var3);

    protected abstract void setSSLOptions(long var1, long var3);

    protected abstract void clearSSLOptions(long var1, long var3);

    protected abstract boolean setCipherSuite(long var1, String var3) throws Exception;

    protected abstract boolean setCARevocation(long var1, String var3, String var4) throws Exception;

    protected abstract boolean setCertificate(long var1, byte[] var3, byte[][] var4, byte[] var5, int var6) throws Exception;

    protected abstract long setSessionCacheSize(long var1, long var3);

    protected abstract long getSessionCacheSize(long var1);

    protected abstract long setSessionCacheTimeout(long var1, long var3);

    protected abstract long getSessionCacheTimeout(long var1);

    protected abstract long setSessionCacheMode(long var1, long var3);

    protected abstract long getSessionCacheMode(long var1);

    protected abstract long sessionAccept(long var1);

    protected abstract long sessionAcceptGood(long var1);

    protected abstract long sessionAcceptRenegotiate(long var1);

    protected abstract long sessionCacheFull(long var1);

    protected abstract long sessionCbHits(long var1);

    protected abstract long sessionConnect(long var1);

    protected abstract long sessionConnectGood(long var1);

    protected abstract long sessionConnectRenegotiate(long var1);

    protected abstract long sessionHits(long var1);

    protected abstract long sessionMisses(long var1);

    protected abstract long sessionNumber(long var1);

    protected abstract long sessionTimeouts(long var1);

    protected abstract void setSessionTicketKeys(long var1, byte[] var3);

    static long sniCallBack(long currentCtx, String sniHostName) {
        SNICallBack sniCallBack = sniCallBacks.get(currentCtx);
        if (sniCallBack == null) {
            return 0L;
        }
        return sniCallBack.getSslContext(sniHostName);
    }

    static void registerDefault(Long defaultSSLContext, SNICallBack sniCallBack) {
        sniCallBacks.put(defaultSSLContext, sniCallBack);
    }

    static void unregisterDefault(Long defaultSSLContext) {
        sniCallBacks.remove(defaultSSLContext);
    }

    protected abstract void invalidateSession(long var1);

    protected abstract void registerSessionContext(long var1, OpenSSLServerSessionContext var3);

    protected abstract void setCertVerifyCallback(long var1, CertificateVerifier var3);

    protected abstract void setAlpnProtos(long var1, String[] var3);

    protected abstract void setServerALPNCallback(long var1, ServerALPNCallback var3);

    protected abstract boolean setSessionIdContext(long var1, byte[] var3);

    protected abstract void setMinProtoVersion(long var1, int var3);

    protected abstract void setMaxProtoVersion(long var1, int var3);

    protected abstract int getMinProtoVersion(long var1);

    protected abstract int getMaxProtoVersion(long var1);

    static {
        LIBCRYPTO_NAMES = new String[]{"crypto.1.1", "libcrypto-1_1-x64", "crypto", "libeay32", "libcrypto-1_1"};
        LIBSSL_NAMES = new String[]{"ssl.1.1", "libssl-1_1-x64", "ssl", "ssleay32", "libssl32", "libssl-1_1"};
        init = false;
        sniCallBacks = new ConcurrentHashMap<Long, SNICallBack>();
    }

    private static final class VersionedLibrary
    implements Comparable<VersionedLibrary> {
        final String file;
        final String versionPart;

        private VersionedLibrary(String file, String versionPart) {
            this.file = file;
            this.versionPart = versionPart;
        }

        @Override
        public int compareTo(VersionedLibrary versionedLibrary) {
            boolean other11 = versionedLibrary.versionPart.contains("1.1");
            boolean this11 = this.versionPart.contains("1.1");
            if (other11 && !this11) {
                return 1;
            }
            if (!other11 && this11) {
                return -1;
            }
            return versionedLibrary.versionPart.compareTo(this.versionPart);
        }
    }

    static interface SNICallBack {
        public long getSslContext(String var1);
    }

    static class LibraryLoader {
        LibraryLoader() {
        }

        public void load() {
            System.loadLibrary("wfssl");
        }
    }

    private static final class LibraryClassLoader
    extends ClassLoader {
        LibraryClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected String findLibrary(String libname) {
            String mapped = System.mapLibraryName(libname);
            String[] stringArray = Identification.NATIVE_SEARCH_PATHS;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block30: {
                    String path = stringArray[n2];
                    String complete = path + "/" + mapped;
                    try (InputStream resource = SSL.class.getClassLoader().getResourceAsStream(complete);){
                        if (resource == null) break block30;
                        File temp = File.createTempFile("tmp-", "openssl");
                        temp.delete();
                        temp.mkdir();
                        File result = new File(temp, mapped);
                        try (FileOutputStream out = new FileOutputStream(result);){
                            int r;
                            byte[] buf = new byte[1000];
                            while ((r = resource.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        result.deleteOnExit();
                        temp.deleteOnExit();
                        String string = result.getAbsolutePath();
                        return string;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++n2;
            }
            return super.findLibrary(libname);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (!name.endsWith("$LibraryLoader") && !name.endsWith(".SSLImpl")) {
                return this.getParent().loadClass(name);
            }
            try (InputStream file = SSL.class.getClassLoader().getResourceAsStream(name.replace(".", "/") + ".class");){
                int r;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((r = file.read(buf)) > 0) {
                    out.write(buf, 0, r);
                }
                byte[] data = out.toByteArray();
                Class<?> clazz = this.defineClass(name, data, 0, data.length, SSL.class.getProtectionDomain());
                return clazz;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(e.getMessage());
            }
        }
    }
}

