/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.TypeConversionHelper;

public class ShortArrayByteBufferConverter
implements TypeConverter<short[], ByteBuffer> {
    private static final long serialVersionUID = -8773804855531292024L;

    @Override
    public ByteBuffer toDatastoreType(short[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = TypeConversionHelper.getByteArrayFromShortArray(memberValue);
        ByteBuffer byteBuffer = ByteBuffer.allocate(memberValue.length);
        byteBuffer.put(bytes);
        return byteBuffer;
    }

    @Override
    public short[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return TypeConversionHelper.getShortArrayFromByteArray(datastoreValue.array());
    }
}

