/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.datanucleus.flush.CollectionAddOperation;
import org.datanucleus.flush.CollectionRemoveOperation;
import org.datanucleus.flush.ListAddAtOperation;
import org.datanucleus.flush.ListRemoveAtOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.RelationshipManager;
import org.datanucleus.store.types.SCOList;
import org.datanucleus.store.types.SCOListIterator;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class List<E>
extends AbstractList<E>
implements SCOList<java.util.List<E>, E>,
Cloneable,
Serializable {
    protected ObjectProvider ownerOP;
    protected AbstractMemberMetaData ownerMmd;
    protected java.util.List<E> delegate;

    public List(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        this.ownerOP = ownerOP;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.List<E> newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.List c) {
        this.delegate = c != null ? new ArrayList(c) : new ArrayList();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    @Override
    public java.util.List<E> getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.List<E> value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedElement(E element, int fieldNumber, Object value, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public synchronized void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.List detachCopy(FetchPlanState state) {
        ArrayList detached = new ArrayList();
        SCOUtils.detachCopyForCollection(this.ownerOP, this.toArray(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.List value) {
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(this.ownerMmd);
        ArrayList attachedElements = new ArrayList(value.size());
        SCOUtils.attachCopyForCollection(this.ownerOP, value.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    @Override
    public Object clone() {
        return ((ArrayList)this.delegate).clone();
    }

    @Override
    public synchronized boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public E get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    @Override
    public synchronized Iterator iterator() {
        return new SCOListIterator<E>(this, this.ownerOP, this.delegate, null, true, -1);
    }

    @Override
    public ListIterator listIterator() {
        return new SCOListIterator<E>(this, this.ownerOP, this.delegate, null, true, -1);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new SCOListIterator<E>(this, this.ownerOP, this.delegate, null, true, index);
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized java.util.List<E> subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public synchronized boolean add(E element) {
        boolean success = this.delegate.add(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element));
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(index, element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
            this.ownerOP.getExecutionContext().addOperationToQueue(new ListAddAtOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), index, element));
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionAddOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element));
                }
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public boolean addAll(int index, Collection elements) {
        boolean success = this.delegate.addAll(index, elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationAdd(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (success) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                int pos = index;
                for (Object element : elements) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new ListAddAtOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), pos++, element));
                }
            }
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized void clear() {
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            Iterator<E> iter = this.delegate.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.ownerOP != null && !this.delegate.isEmpty()) {
            Iterator iter;
            ArrayList<E> copy;
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                copy = new ArrayList<E>(this.delegate);
                iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                copy = new ArrayList<E>(this.delegate);
                iter = copy.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    @Override
    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerOP != null && allowCascadeDelete) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), element, allowCascadeDelete));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(element);
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public E remove(int index) {
        E element = this.delegate.remove(index);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP).relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), element);
        }
        if (this.ownerOP != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), index, element));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(element);
            }
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return element;
    }

    @Override
    public boolean removeAll(Collection elements) {
        Iterator iter;
        boolean success = this.delegate.removeAll(elements);
        if (this.ownerOP != null && this.ownerOP.getExecutionContext().getManageRelations()) {
            iter = elements.iterator();
            RelationshipManager relMgr = this.ownerOP.getExecutionContext().getRelationshipManager(this.ownerOP);
            while (iter.hasNext()) {
                relMgr.relationRemove(this.ownerMmd.getAbsoluteFieldNumber(), iter.next());
            }
        }
        if (this.ownerOP != null && elements != null && !elements.isEmpty()) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                iter = elements.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new CollectionRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), iter.next(), true));
                }
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                iter = elements.iterator();
                while (iter.hasNext()) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(iter.next());
                }
            }
        }
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
            if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
                this.ownerOP.getExecutionContext().processNontransactionalUpdate();
            }
        }
        return success;
    }

    @Override
    public E set(int index, E element, boolean allowDependentField) {
        E prevElement = this.delegate.set(index, element);
        if (this.ownerOP != null && allowDependentField && !this.delegate.contains(prevElement)) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new ListRemoveAtOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), index, prevElement));
            } else if (SCOUtils.hasDependentElement(this.ownerMmd)) {
                this.ownerOP.getExecutionContext().deleteObjectInternal(prevElement);
            }
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return prevElement;
    }

    @Override
    public E set(int index, E element) {
        return this.set(index, element, true);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new ArrayList<E>(this.delegate);
    }
}

