/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.SQLException;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.ClientHook;
import org.apache.hive.jdbc.Utils;

public class ClientCommandHookFactory {
    private static final ClientCommandHookFactory instance = new ClientCommandHookFactory();

    private ClientCommandHookFactory() {
    }

    public static ClientCommandHookFactory get() {
        return instance;
    }

    public ClientHook getHook(BeeLine beeLine, String cmdLine) {
        if (!beeLine.isBeeLine()) {
            if (cmdLine.toLowerCase().startsWith("set")) {
                if (cmdLine.contains("=")) {
                    return new SetCommandHook(cmdLine);
                }
                return null;
            }
            if (cmdLine.toLowerCase().startsWith("use")) {
                return new UseCommandHook(cmdLine);
            }
            return null;
        }
        if (beeLine.getOpts().getShowDbInPrompt()) {
            if (cmdLine.toLowerCase().startsWith("use")) {
                return new UseCommandHook(cmdLine);
            }
            if (cmdLine.toLowerCase().startsWith("connect")) {
                return new ConnectCommandHook(cmdLine);
            }
            if (cmdLine.toLowerCase().startsWith("go")) {
                return new GoCommandHook(cmdLine);
            }
            return null;
        }
        return null;
    }

    public class GoCommandHook
    extends ClientHook {
        public GoCommandHook(String sql) {
            super(sql);
        }

        @Override
        public void postHook(BeeLine beeLine) {
            String dbName = "";
            try {
                dbName = beeLine.getDatabaseConnection().getConnection().getSchema();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            beeLine.setCurrentDatabase(dbName);
        }
    }

    public class ConnectCommandHook
    extends ClientHook {
        public ConnectCommandHook(String sql) {
            super(sql);
        }

        @Override
        public void postHook(BeeLine beeLine) {
            String dbName;
            String line = this.sql.replaceAll("\\s+", " ");
            String[] strs = line.split(" ");
            if (strs == null || strs.length < 1) {
                dbName = "";
            } else {
                try {
                    dbName = Utils.parseURL((String)strs[1]).getDbName();
                }
                catch (Exception e) {
                    dbName = "";
                }
            }
            beeLine.setCurrentDatabase(dbName);
        }
    }

    public class UseCommandHook
    extends ClientHook {
        public UseCommandHook(String sql) {
            super(sql);
        }

        @Override
        public void postHook(BeeLine beeLine) {
            String line = this.sql.replaceAll("\\s+", " ");
            String[] strs = line.split(" ");
            String dbName = strs == null || strs.length != 2 ? "" : strs[1];
            beeLine.setCurrentDatabase(dbName);
        }
    }

    public class SetCommandHook
    extends ClientHook {
        public SetCommandHook(String sql) {
            super(sql);
        }

        @Override
        public void postHook(BeeLine beeLine) {
            if (!beeLine.isBeeLine()) {
                beeLine.getOpts().setHiveConf(beeLine.getCommands().getHiveConf(false));
            }
        }
    }
}

