/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.spark.serializer.KryoInputObjectInputBridge;
import org.apache.spark.serializer.KryoOutputObjectOutputBridge;
import org.apache.spark.streaming.util.EmptyStateMap;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap$;
import org.apache.spark.streaming.util.OpenHashMapBasedStateMap$StateInfo$;
import org.apache.spark.streaming.util.StateMap;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001db!\u0002/^\u0001};\u0007BCA\n\u0001\t\u0005\r\u0011\"\u0001\u0002\u0016!Q\u0011q\u0003\u0001\u0003\u0002\u0004%\t!!\u0007\t\u0013\u0005\u0015\u0002A!A!B\u0013I\u0007BCA\u001c\u0001\t\u0005\r\u0011\"\u0003\u0002:!Q\u0011\u0011\t\u0001\u0003\u0002\u0004%I!a\u0011\t\u0015\u0005\u001d\u0003A!A!B\u0013\tY\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0019!C\u0005\u0003sA!\"a\u0013\u0001\u0005\u0003\u0007I\u0011BA'\u0011)\t\t\u0006\u0001B\u0001B\u0003&\u00111\b\u0005\u000b\u0003'\u0002!\u00111A\u0005\f\u0005U\u0003BCA2\u0001\t\u0005\r\u0011\"\u0003\u0002f!Q\u0011\u0011\u000e\u0001\u0003\u0002\u0003\u0006K!a\u0016\t\u0015\u0005-\u0004A!a\u0001\n\u0017\ti\u0007\u0003\u0006\u0002r\u0001\u0011\t\u0019!C\u0005\u0003gB!\"a\u001e\u0001\u0005\u0003\u0005\u000b\u0015BA8\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!\u001f\u0001\t\u0003\tY\tC\u0004\u0002z\u0001!\t!a&\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\"\"I\u0011\u0011\u0016\u0001A\u0002\u0013%\u00111\u0016\u0005\n\u0007S\u0002\u0001\u0019!C\u0005\u0007WB\u0001ba\u001c\u0001A\u0003&\u0011Q\u0016\u0005\b\u0007k\u0002A\u0011IB<\u0011\u001d\u0019y\b\u0001C!\u0007\u0003Cqa!'\u0001\t\u0003\u001aY\nC\u0004\u0004\u001e\u0002!\tea(\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"9!\u0011\n\u0001\u0005B\r=\u0006bBBY\u0001\u0011\u0005!Q\u0004\u0005\b\u0007g\u0003A\u0011AA\u001d\u0011\u001d\u0019)\f\u0001C\u0001\u0003sAqaa.\u0001\t\u0003\u001aI\fC\u0004\u0003@\u0002!\te!/\t\u000f\r%\u0007\u0001\"\u0003\u0004L\"91q\u001b\u0001\u0005\n\re\u0007bBBs\u0001\u0011%1q\u001d\u0005\b\u0007c\u0004A\u0011BBz\u0011\u001d\u0019i\u0010\u0001C!\u0007\u007fDq\u0001b\u0006\u0001\t\u0003\"Ib\u0002\u0005\u0002ZvC\taXAn\r\u001daV\f#\u0001`\u0003;Dq!!\u001f*\t\u0003\tYO\u0002\u0004\u0002n&\u0002\u0015q\u001e\u0005\u000b\u0003s\\#\u00113A\u0005\u0002\u0005m\bB\u0003B\u0001W\t\u0005\r\u0011\"\u0001\u0003\u0004!Q!qA\u0016\u0003\u0012\u0003\u0006K!!@\t\u0015\t%1F!e\u0001\n\u0003\u0011Y\u0001\u0003\u0006\u0003\u0014-\u0012\t\u0019!C\u0001\u0005+A!B!\u0007,\u0005#\u0005\u000b\u0015\u0002B\u0007\u0011)\u0011Yb\u000bBI\u0002\u0013\u0005!Q\u0004\u0005\u000b\u0005KY#\u00111A\u0005\u0002\t\u001d\u0002B\u0003B\u0016W\tE\t\u0015)\u0003\u0003 !9\u0011\u0011P\u0016\u0005\u0002\t5\u0002b\u0002B\u001dW\u0011\u0005!1\b\u0005\b\u0005{YC\u0011\u0001B \u0011%\u0011IeKA\u0001\n\u0003\u0011Y\u0005C\u0005\u0003\\-\n\n\u0011\"\u0001\u0003^!I!qO\u0016\u0012\u0002\u0013\u0005!\u0011\u0010\u0005\n\u0005\u0003[\u0013\u0013!C\u0001\u0005\u0007C\u0011Ba#,\u0003\u0003%\tE!$\t\u0013\t}5&!A\u0005\u0002\u0005e\u0002\"\u0003BQW\u0005\u0005I\u0011\u0001BR\u0011%\u00119kKA\u0001\n\u0003\u0012I\u000bC\u0005\u00036.\n\t\u0011\"\u0001\u00038\"I!1X\u0016\u0002\u0002\u0013\u0005#Q\u0018\u0005\n\u0005\u007f[\u0013\u0011!C!\u0005\u0003D\u0011Ba1,\u0003\u0003%\tE!2\b\u0013\t%\u0017&!A\t\u0002\t-g!CAwS\u0005\u0005\t\u0012\u0001Bg\u0011\u001d\tI(\u0012C\u0001\u0005\u001fD\u0011Ba0F\u0003\u0003%)E!1\t\u0013\tEW)!A\u0005\u0002\nM\u0007\"\u0003Br\u000bF\u0005I\u0011\u0001Bs\u0011%\u0011y/RI\u0001\n\u0003\u0011\t\u0010C\u0005\u0003v\u0016\u000b\n\u0011\"\u0001\u0003x\"I!1`#\u0002\u0002\u0013\u0005%Q \u0005\n\u0007/)\u0015\u0013!C\u0001\u00073A\u0011ba\tF#\u0003%\ta!\n\t\u0013\r%R)%A\u0005\u0002\r-\u0002\"CB\u0018\u000b\u0006\u0005I\u0011BB\u0019\r\u0019\u0019I$\u000b\u0001\u0004<!Q1qI)\u0003\u0006\u0004%\t!!\u000f\t\u0015\r%\u0013K!A!\u0002\u0013\tY\u0004C\u0004\u0002zE#\taa\u0013\t\u0013\rE\u0013F1A\u0005\u0002\u0005e\u0002\u0002CB*S\u0001\u0006I!a\u000f\t\u0013\rU\u0013F1A\u0005\u0002\u0005e\u0002\u0002CB,S\u0001\u0006I!a\u000f\t\u0013\r\r\u0012&%A\u0005\u0002\re\u0003\"CB\u0015SE\u0005I\u0011AB2\u0011%\u0019y#KA\u0001\n\u0013\u0019\tD\u0001\rPa\u0016t\u0007*Y:i\u001b\u0006\u0004()Y:fIN#\u0018\r^3NCBT!AX0\u0002\tU$\u0018\u000e\u001c\u0006\u0003A\u0006\f\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\t\u001c\u0017!B:qCJ\\'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001e,2\u0001[8~'\r\u0001\u0011n \t\u0005U.lG0D\u0001^\u0013\taWL\u0001\u0005Ti\u0006$X-T1q!\tqw\u000e\u0004\u0001\u0005\u000bA\u0004!\u0019\u0001:\u0003\u0003-\u001b\u0001!\u0005\u0002tsB\u0011Ao^\u0007\u0002k*\ta/A\u0003tG\u0006d\u0017-\u0003\u0002yk\n9aj\u001c;iS:<\u0007C\u0001;{\u0013\tYXOA\u0002B]f\u0004\"A\\?\u0005\u000by\u0004!\u0019\u0001:\u0003\u0003M\u0003B!!\u0001\u0002\u00105\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003lef|'\u0002BA\u0005\u0003\u0017\t\u0001#Z:pi\u0016\u0014\u0018nY:pMR<\u0018M]3\u000b\u0005\u00055\u0011aA2p[&!\u0011\u0011CA\u0002\u0005AY%/_8TKJL\u0017\r\\5{C\ndW-\u0001\bqCJ,g\u000e^*uCR,W*\u00199\u0016\u0003%\f!\u0003]1sK:$8\u000b^1uK6\u000b\u0007o\u0018\u0013fcR!\u00111DA\u0011!\r!\u0018QD\u0005\u0004\u0003?)(\u0001B+oSRD\u0001\"a\t\u0003\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0014a\u00049be\u0016tGo\u0015;bi\u0016l\u0015\r\u001d\u0011)\u0007\r\tI\u0003E\u0002u\u0003WI1!!\fv\u0005!1x\u000e\\1uS2,\u0007fA\u0002\u00022A\u0019A/a\r\n\u0007\u0005UROA\u0005ue\u0006t7/[3oi\u0006y\u0011N\\5uS\u0006d7)\u00199bG&$\u00180\u0006\u0002\u0002<A\u0019A/!\u0010\n\u0007\u0005}ROA\u0002J]R\f1#\u001b8ji&\fGnQ1qC\u000eLG/_0%KF$B!a\u0007\u0002F!I\u00111E\u0003\u0002\u0002\u0003\u0007\u00111H\u0001\u0011S:LG/[1m\u0007\u0006\u0004\u0018mY5us\u0002\n1\u0003Z3mi\u0006\u001c\u0005.Y5o)\"\u0014Xm\u001d5pY\u0012\fq\u0003Z3mi\u0006\u001c\u0005.Y5o)\"\u0014Xm\u001d5pY\u0012|F%Z9\u0015\t\u0005m\u0011q\n\u0005\n\u0003GA\u0011\u0011!a\u0001\u0003w\tA\u0003Z3mi\u0006\u001c\u0005.Y5o)\"\u0014Xm\u001d5pY\u0012\u0004\u0013aC6fs\u000ec\u0017m]:UC\u001e,\"!a\u0016\u0011\u000b\u0005e\u0013qL7\u000e\u0005\u0005m#bAA/k\u00069!/\u001a4mK\u000e$\u0018\u0002BA1\u00037\u0012\u0001b\u00117bgN$\u0016mZ\u0001\u0010W\u0016L8\t\\1tgR\u000bwm\u0018\u0013fcR!\u00111DA4\u0011%\t\u0019cCA\u0001\u0002\u0004\t9&\u0001\u0007lKf\u001cE.Y:t)\u0006<\u0007%A\u0007ti\u0006$Xm\u00117bgN$\u0016mZ\u000b\u0003\u0003_\u0002R!!\u0017\u0002`q\f\u0011c\u001d;bi\u0016\u001cE.Y:t)\u0006<w\fJ3r)\u0011\tY\"!\u001e\t\u0013\u0005\rb\"!AA\u0002\u0005=\u0014AD:uCR,7\t\\1tgR\u000bw\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005u\u0014QQAD\u0003\u0013#b!a \u0002\u0002\u0006\r\u0005\u0003\u00026\u0001[rDq!a\u0015\u0011\u0001\b\t9\u0006C\u0004\u0002lA\u0001\u001d!a\u001c\t\r\u0005M\u0001\u00031\u0001j\u0011%\t9\u0004\u0005I\u0001\u0002\u0004\tY\u0004C\u0005\u0002JA\u0001\n\u00111\u0001\u0002<Q1\u0011QRAJ\u0003+#b!a \u0002\u0010\u0006E\u0005bBA*#\u0001\u000f\u0011q\u000b\u0005\b\u0003W\n\u00029AA8\u0011\u001d\t9$\u0005a\u0001\u0003wAq!!\u0013\u0012\u0001\u0004\tY\u0004\u0006\u0003\u0002\u001a\u0006}ECBA@\u00037\u000bi\nC\u0004\u0002TI\u0001\u001d!a\u0016\t\u000f\u0005-$\u0003q\u0001\u0002p!9\u0011\u0011\n\nA\u0002\u0005mBCAAR)\u0019\ty(!*\u0002(\"9\u00111K\nA\u0004\u0005]\u0003bBA6'\u0001\u000f\u0011qN\u0001\tI\u0016dG/Y'baV\u0011\u0011Q\u0016\t\b\u0003_\u000b9,\\A^\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016AC2pY2,7\r^5p]*\u0011a,Y\u0005\u0005\u0003s\u000b\tLA\u0006Pa\u0016t\u0007*Y:i\u001b\u0006\u0004\b\u0003BA_Wqt1!a0)\u001d\u0011\t\t-a6\u000f\t\u0005\r\u0017Q\u001b\b\u0005\u0003\u000b\f\u0019N\u0004\u0003\u0002H\u0006Eg\u0002BAe\u0003\u001fl!!a3\u000b\u0007\u00055\u0017/\u0001\u0004=e>|GOP\u0005\u0002M&\u0011A-Z\u0005\u0003E\u000eL!\u0001Y1\n\u0005y{\u0016\u0001G(qK:D\u0015m\u001d5NCB\u0014\u0015m]3e'R\fG/Z'baB\u0011!.K\n\u0006S\u0005}\u0017Q\u001d\t\u0004i\u0006\u0005\u0018bAArk\n1\u0011I\\=SK\u001a\u00042\u0001^At\u0013\r\tI/\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u00037\u0014\u0011b\u0015;bi\u0016LeNZ8\u0016\t\u0005E\u0018q`\n\bW\u0005}\u00171_As!\r!\u0018Q_\u0005\u0004\u0003o,(a\u0002)s_\u0012,8\r^\u0001\u0005I\u0006$\u0018-\u0006\u0002\u0002~B\u0019a.a@\u0005\u000by\\#\u0019\u0001:\u0002\u0011\u0011\fG/Y0%KF$B!a\u0007\u0003\u0006!I\u00111E\u0017\u0002\u0002\u0003\u0007\u0011Q`\u0001\u0006I\u0006$\u0018\rI\u0001\u000bkB$\u0017\r^3US6,WC\u0001B\u0007!\r!(qB\u0005\u0004\u0005#)(\u0001\u0002'p]\u001e\fa\"\u001e9eCR,G+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\t]\u0001\"CA\u0012a\u0005\u0005\t\u0019\u0001B\u0007\u0003-)\b\u000fZ1uKRKW.\u001a\u0011\u0002\u000f\u0011,G.\u001a;fIV\u0011!q\u0004\t\u0004i\n\u0005\u0012b\u0001B\u0012k\n9!i\\8mK\u0006t\u0017a\u00033fY\u0016$X\rZ0%KF$B!a\u0007\u0003*!I\u00111E\u001a\u0002\u0002\u0003\u0007!qD\u0001\tI\u0016dW\r^3eAQA!q\u0006B\u001a\u0005k\u00119\u0004E\u0003\u00032-\ni0D\u0001*\u0011%\tI0\u000eI\u0001\u0002\u0004\ti\u0010C\u0005\u0003\nU\u0002\n\u00111\u0001\u0003\u000e!I!1D\u001b\u0011\u0002\u0003\u0007!qD\u0001\f[\u0006\u00148\u000eR3mKR,G\r\u0006\u0002\u0002\u001c\u00051Q\u000f\u001d3bi\u0016$b!a\u0007\u0003B\t\u0015\u0003b\u0002B\"o\u0001\u0007\u0011Q`\u0001\b]\u0016<H)\u0019;b\u0011\u001d\u00119e\u000ea\u0001\u0005\u001b\tQB\\3x+B$\u0017\r^3US6,\u0017\u0001B2paf,BA!\u0014\u0003TQA!q\nB+\u0005/\u0012I\u0006E\u0003\u00032-\u0012\t\u0006E\u0002o\u0005'\"QA \u001dC\u0002ID\u0011\"!?9!\u0003\u0005\rA!\u0015\t\u0013\t%\u0001\b%AA\u0002\t5\u0001\"\u0003B\u000eqA\u0005\t\u0019\u0001B\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*BAa\u0018\u0003vU\u0011!\u0011\r\u0016\u0005\u0003{\u0014\u0019g\u000b\u0002\u0003fA!!q\rB9\u001b\t\u0011IG\u0003\u0003\u0003l\t5\u0014!C;oG\",7m[3e\u0015\r\u0011y'^\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B:\u0005S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015q\u0018H1\u0001s\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*BAa\u001f\u0003\u0000U\u0011!Q\u0010\u0016\u0005\u0005\u001b\u0011\u0019\u0007B\u0003\u007fu\t\u0007!/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\t\u0015%\u0011R\u000b\u0003\u0005\u000fSCAa\b\u0003d\u0011)ap\u000fb\u0001e\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa$\u0011\t\tE%1T\u0007\u0003\u0005'SAA!&\u0003\u0018\u0006!A.\u00198h\u0015\t\u0011I*\u0001\u0003kCZ\f\u0017\u0002\u0002BO\u0005'\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004s\n\u0015\u0006\"CA\u0012}\u0005\u0005\t\u0019AA\u001e\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BV!\u0015\u0011iK!-z\u001b\t\u0011yKC\u0002\u00024VLAAa-\u00030\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011yB!/\t\u0011\u0005\r\u0002)!AA\u0002e\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003w\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u001f\u000ba!Z9vC2\u001cH\u0003\u0002B\u0010\u0005\u000fD\u0001\"a\tD\u0003\u0003\u0005\r!_\u0001\n'R\fG/Z%oM>\u00042A!\rF'\u0015)\u0015q\\As)\t\u0011Y-A\u0003baBd\u00170\u0006\u0003\u0003V\nmG\u0003\u0003Bl\u0005;\u0014yN!9\u0011\u000b\tE2F!7\u0011\u00079\u0014Y\u000eB\u0003\u007f\u0011\n\u0007!\u000fC\u0005\u0002z\"\u0003\n\u00111\u0001\u0003Z\"I!\u0011\u0002%\u0011\u0002\u0003\u0007!Q\u0002\u0005\n\u00057A\u0005\u0013!a\u0001\u0005?\tq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0005\u0005O\u0014i/\u0006\u0002\u0003j*\"!1\u001eB2!\rq'Q\u001e\u0003\u0006}&\u0013\rA]\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!!1\u0010Bz\t\u0015q(J1\u0001s\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002BC\u0005s$QA`&C\u0002I\fq!\u001e8baBd\u00170\u0006\u0003\u0003\u0000\u000e=A\u0003BB\u0001\u0007#\u0001R\u0001^B\u0002\u0007\u000fI1a!\u0002v\u0005\u0019y\u0005\u000f^5p]BIAo!\u0003\u0004\u000e\t5!qD\u0005\u0004\u0007\u0017)(A\u0002+va2,7\u0007E\u0002o\u0007\u001f!QA 'C\u0002ID\u0011ba\u0005M\u0003\u0003\u0005\ra!\u0006\u0002\u0007a$\u0003\u0007E\u0003\u00032-\u001ai!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0005\u00077\u0019\t#\u0006\u0002\u0004\u001e)\"1q\u0004B2!\rq7\u0011\u0005\u0003\u0006}6\u0013\rA]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\tm4q\u0005\u0003\u0006}:\u0013\rA]\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\t\u00155Q\u0006\u0003\u0006}>\u0013\rA]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00044A!!\u0011SB\u001b\u0013\u0011\u00199Da%\u0003\r=\u0013'.Z2u\u0005-a\u0015.\\5u\u001b\u0006\u00148.\u001a:\u0014\u000bE\u000byn!\u0010\u0011\t\r}2QI\u0007\u0003\u0007\u0003RAaa\u0011\u0003\u0018\u0006\u0011\u0011n\\\u0005\u0005\u0003S\u001c\t%A\u0002ok6\fAA\\;nAQ!1QJB(!\r\u0011\t$\u0015\u0005\b\u0007\u000f\"\u0006\u0019AA\u001e\u0003q!U\t\u0014+B?\u000eC\u0015)\u0013(`\u0019\u0016su\t\u0016%`)\"\u0013Vi\u0015%P\u0019\u0012\u000bQ\u0004R#M)\u0006{6\tS!J\u001d~cUIT$U\u0011~#\u0006JU#T\u0011>cE\tI\u0001\u0019\t\u00163\u0015)\u0016'U?&s\u0015\nV%B\u0019~\u001b\u0015\tU!D\u0013RK\u0016!\u0007#F\r\u0006+F\nV0J\u001d&#\u0016*\u0011'`\u0007\u0006\u0003\u0016iQ%U3\u0002*baa\u0017\u0004`\r\u0005TCAB/U\u0011\tYDa\u0019\u0005\u000bAL&\u0019\u0001:\u0005\u000byL&\u0019\u0001:\u0016\r\rm3QMB4\t\u0015\u0001(L1\u0001s\t\u0015q(L1\u0001s\u00031!W\r\u001c;b\u001b\u0006\u0004x\fJ3r)\u0011\tYb!\u001c\t\u0013\u0005\rR#!AA\u0002\u00055\u0016!\u00033fYR\fW*\u00199!Q\r1\u0012\u0011\u0006\u0015\u0004-\u0005E\u0012aA4fiR!1\u0011PB>!\u0011!81\u0001?\t\r\rut\u00031\u0001n\u0003\rYW-_\u0001\nO\u0016$()\u001f+j[\u0016$Baa!\u0004\u0016B11QQBH\u0007'sAaa\"\u0004\f:!\u0011\u0011ZBE\u0013\u00051\u0018bABGk\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BZ\u0007#S1a!$v!\u001d!8\u0011B7}\u0005\u001bAqaa&\u0019\u0001\u0004\u0011i!A\tuQJ,7\u000f[+qI\u0006$X\r\u001a+j[\u0016\faaZ3u\u00032dGCABB\u0003\r\u0001X\u000f\u001e\u000b\t\u00037\u0019\tka)\u0004(\"11Q\u0010\u000eA\u00025Daa!*\u001b\u0001\u0004a\u0018!B:uCR,\u0007b\u0002B\u00055\u0001\u0007!QB\u0001\u0007e\u0016lwN^3\u0015\t\u0005m1Q\u0016\u0005\u0007\u0007{Z\u0002\u0019A7\u0015\u0003%\fQb\u001d5pk2$7i\\7qC\u000e$\u0018\u0001\u00053fYR\f7\t[1j]2+gn\u001a;i\u0003)\t\u0007\u000f\u001d:pqNK'0Z\u0001\u000ei>$UMY;h'R\u0014\u0018N\\4\u0015\u0005\rm\u0006\u0003BB_\u0007\u000btAaa0\u0004BB\u0019\u0011\u0011Z;\n\u0007\r\rW/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005;\u001b9MC\u0002\u0004DV\f1c\u001e:ji\u0016|%M[3di&sG/\u001a:oC2$B!a\u0007\u0004N\"91q\u001a\u0012A\u0002\rE\u0017\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0003BB \u0007'LAa!6\u0004B\taqJ\u00196fGR|U\u000f\u001e9vi\u0006\u0011\"/Z1e\u001f\nTWm\u0019;J]R,'O\\1m)\u0011\tYba7\t\u000f\ru7\u00051\u0001\u0004`\u0006Y\u0011N\u001c9viN#(/Z1n!\u0011\u0019yd!9\n\t\r\r8\u0011\t\u0002\f\u001f\nTWm\u0019;J]B,H/A\u0006xe&$Xm\u00142kK\u000e$H\u0003BA\u000e\u0007SDqaa4%\u0001\u0004\u0019Y\u000f\u0005\u0003\u0004@\r5\u0018\u0002BBx\u0007\u0003\u0012!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\u0006Q!/Z1e\u001f\nTWm\u0019;\u0015\t\u0005m1Q\u001f\u0005\b\u0007;,\u0003\u0019AB|!\u0011\u0019yd!?\n\t\rm8\u0011\t\u0002\u0012\u001f\nTWm\u0019;J]B,Ho\u0015;sK\u0006l\u0017!B<sSR,GCBA\u000e\t\u0003!I\u0001C\u0004\u0002\u0006\u0019\u0002\r\u0001b\u0001\u0011\t\u0005\u0005AQA\u0005\u0005\t\u000f\t\u0019A\u0001\u0003Lef|\u0007b\u0002C\u0006M\u0001\u0007AQB\u0001\u0007_V$\b/\u001e;\u0011\t\u0011=A1C\u0007\u0003\t#QAaa\u0011\u0002\u0004%!AQ\u0003C\t\u0005\u0019yU\u000f\u001e9vi\u0006!!/Z1e)\u0019\tY\u0002b\u0007\u0005\u001e!9\u0011QA\u0014A\u0002\u0011\r\u0001b\u0002C\u0010O\u0001\u0007A\u0011E\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\t\u001f!\u0019#\u0003\u0003\u0005&\u0011E!!B%oaV$\b")
public class OpenHashMapBasedStateMap<K, S>
extends StateMap<K, S>
implements KryoSerializable {
    private volatile transient StateMap<K, S> parentStateMap;
    private int initialCapacity;
    private int deltaChainThreshold;
    private ClassTag<K> keyClassTag;
    private ClassTag<S> stateClassTag;
    private volatile transient OpenHashMap<K, StateInfo<S>> deltaMap;

    public static <K, S> int $lessinit$greater$default$3() {
        return OpenHashMapBasedStateMap$.MODULE$.$lessinit$greater$default$3();
    }

    public static <K, S> int $lessinit$greater$default$2() {
        return OpenHashMapBasedStateMap$.MODULE$.$lessinit$greater$default$2();
    }

    public static int DEFAULT_INITIAL_CAPACITY() {
        return OpenHashMapBasedStateMap$.MODULE$.DEFAULT_INITIAL_CAPACITY();
    }

    public static int DELTA_CHAIN_LENGTH_THRESHOLD() {
        return OpenHashMapBasedStateMap$.MODULE$.DELTA_CHAIN_LENGTH_THRESHOLD();
    }

    public StateMap<K, S> parentStateMap() {
        return this.parentStateMap;
    }

    public void parentStateMap_$eq(StateMap<K, S> x$1) {
        this.parentStateMap = x$1;
    }

    private int initialCapacity() {
        return this.initialCapacity;
    }

    private void initialCapacity_$eq(int x$1) {
        this.initialCapacity = x$1;
    }

    private int deltaChainThreshold() {
        return this.deltaChainThreshold;
    }

    private void deltaChainThreshold_$eq(int x$1) {
        this.deltaChainThreshold = x$1;
    }

    private ClassTag<K> keyClassTag() {
        return this.keyClassTag;
    }

    private void keyClassTag_$eq(ClassTag<K> x$1) {
        this.keyClassTag = x$1;
    }

    private ClassTag<S> stateClassTag() {
        return this.stateClassTag;
    }

    private void stateClassTag_$eq(ClassTag<S> x$1) {
        this.stateClassTag = x$1;
    }

    private OpenHashMap<K, StateInfo<S>> deltaMap() {
        return this.deltaMap;
    }

    private void deltaMap_$eq(OpenHashMap<K, StateInfo<S>> x$1) {
        this.deltaMap = x$1;
    }

    @Override
    public Option<S> get(K key) {
        StateInfo stateInfo = (StateInfo)this.deltaMap().apply(key);
        if (stateInfo != null) {
            if (!stateInfo.deleted()) {
                return new Some(stateInfo.data());
            }
            return None$.MODULE$;
        }
        return this.parentStateMap().get(key);
    }

    @Override
    public Iterator<Tuple3<K, S, Object>> getByTime(long threshUpdatedTime) {
        Iterator oldStates = this.parentStateMap().getByTime(threshUpdatedTime).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getByTime$1(this, x0$1)));
        Iterator updatedStates = this.deltaMap().iterator().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getByTime$2(threshUpdatedTime, x0$2))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Object key = tuple2._1();
                StateInfo stateInfo = (StateInfo)tuple2._2();
                return new Tuple3(key, stateInfo.data(), (Object)BoxesRunTime.boxToLong((long)stateInfo.updateTime()));
            }
            throw new MatchError((Object)tuple2);
        });
        return oldStates.$plus$plus((Function0 & Serializable & scala.Serializable)() -> updatedStates);
    }

    @Override
    public Iterator<Tuple3<K, S, Object>> getAll() {
        Iterator oldStates = this.parentStateMap().getAll().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getAll$1(this, x0$1)));
        Iterator updatedStates = this.deltaMap().iterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OpenHashMapBasedStateMap.$anonfun$getAll$2(x$1))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object key = tuple2._1();
                StateInfo stateInfo = (StateInfo)tuple2._2();
                return new Tuple3(key, stateInfo.data(), (Object)BoxesRunTime.boxToLong((long)stateInfo.updateTime()));
            }
            throw new MatchError((Object)tuple2);
        });
        return oldStates.$plus$plus((Function0 & Serializable & scala.Serializable)() -> updatedStates);
    }

    @Override
    public void put(K key, S state, long updateTime) {
        StateInfo stateInfo = (StateInfo)this.deltaMap().apply(key);
        if (stateInfo != null) {
            stateInfo.update(state, updateTime);
            return;
        }
        this.deltaMap().update(key, new StateInfo<S>(state, updateTime, OpenHashMapBasedStateMap$StateInfo$.MODULE$.$lessinit$greater$default$3()));
    }

    @Override
    public void remove(K key) {
        StateInfo stateInfo = (StateInfo)this.deltaMap().apply(key);
        if (stateInfo != null) {
            stateInfo.markDeleted();
            return;
        }
        boolean x$1 = true;
        Object x$2 = OpenHashMapBasedStateMap$StateInfo$.MODULE$.$lessinit$greater$default$1();
        long x$3 = OpenHashMapBasedStateMap$StateInfo$.MODULE$.$lessinit$greater$default$2();
        StateInfo newInfo = new StateInfo(x$2, x$3, x$1);
        this.deltaMap().update(key, newInfo);
    }

    @Override
    public StateMap<K, S> copy() {
        OpenHashMapBasedStateMap x$1 = this;
        int x$2 = this.deltaChainThreshold();
        int x$3 = OpenHashMapBasedStateMap$.MODULE$.$lessinit$greater$default$2();
        return new OpenHashMapBasedStateMap<K, S>(x$1, x$3, x$2, this.keyClassTag(), this.stateClassTag());
    }

    public boolean shouldCompact() {
        return this.deltaChainLength() >= this.deltaChainThreshold();
    }

    public int deltaChainLength() {
        StateMap<K, S> stateMap = this.parentStateMap();
        if (stateMap instanceof OpenHashMapBasedStateMap) {
            OpenHashMapBasedStateMap openHashMapBasedStateMap = (OpenHashMapBasedStateMap)stateMap;
            return openHashMapBasedStateMap.deltaChainLength() + 1;
        }
        return 0;
    }

    public int approxSize() {
        int n;
        int n2 = this.deltaMap().size();
        StateMap<K, S> stateMap = this.parentStateMap();
        if (stateMap instanceof OpenHashMapBasedStateMap) {
            OpenHashMapBasedStateMap openHashMapBasedStateMap = (OpenHashMapBasedStateMap)stateMap;
            n = openHashMapBasedStateMap.approxSize();
        } else {
            n = 0;
        }
        return n2 + n;
    }

    @Override
    public String toDebugString() {
        String tabs = this.deltaChainLength() > 0 ? new StringBuilder(5).append(new StringOps(Predef$.MODULE$.augmentString("    ")).$times(this.deltaChainLength() - 1)).append("+--- ").toString() : "";
        return new StringBuilder(1).append(this.parentStateMap().toDebugString()).append("\n").append(this.deltaMap().iterator().mkString(tabs, new StringBuilder(1).append("\n").append(tabs).toString(), "")).toString();
    }

    public String toString() {
        return new StringBuilder(4).append("[").append(System.identityHashCode(this)).append(", ").append(System.identityHashCode(this.parentStateMap())).append("]").toString();
    }

    private void writeObjectInternal(ObjectOutput outputStream) {
        OpenHashMapBasedStateMap<K, S> openHashMapBasedStateMap;
        outputStream.writeInt(this.deltaMap().size());
        Iterator deltaMapIterator = this.deltaMap().iterator();
        int deltaMapCount = 0;
        while (deltaMapIterator.hasNext()) {
            ++deltaMapCount;
            Tuple2 tuple2 = (Tuple2)deltaMapIterator.next();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            StateInfo stateInfo = (StateInfo)tuple2._2();
            Tuple2 tuple22 = new Tuple2(key, (Object)stateInfo);
            Object key2 = tuple22._1();
            StateInfo stateInfo2 = (StateInfo)tuple22._2();
            outputStream.writeObject(key2);
            outputStream.writeObject(stateInfo2);
        }
        Predef$.MODULE$.assert(deltaMapCount == this.deltaMap().size());
        boolean doCompaction = this.shouldCompact();
        if (doCompaction) {
            int initCapacity = this.approxSize() > 0 ? this.approxSize() : 64;
            openHashMapBasedStateMap = new OpenHashMapBasedStateMap<K, S>(initCapacity, this.deltaChainThreshold(), this.keyClassTag(), this.stateClassTag());
        } else {
            openHashMapBasedStateMap = null;
        }
        OpenHashMapBasedStateMap<K, S> newParentSessionStore = openHashMapBasedStateMap;
        Iterator<Tuple3<K, S, Object>> iterOfActiveSessions = this.parentStateMap().getAll();
        int parentSessionCount = 0;
        outputStream.writeInt(this.approxSize());
        while (iterOfActiveSessions.hasNext()) {
            ++parentSessionCount;
            Tuple3 tuple3 = (Tuple3)iterOfActiveSessions.next();
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Object key = tuple3._1();
            Object state = tuple3._2();
            long updateTime = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3(key, state, (Object)BoxesRunTime.boxToLong((long)updateTime));
            Object key3 = tuple32._1();
            Object state2 = tuple32._2();
            long updateTime2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
            outputStream.writeObject(key3);
            outputStream.writeObject(state2);
            outputStream.writeLong(updateTime2);
            if (!doCompaction) continue;
            super.deltaMap().update(key3, new StateInfo<Object>(state2, updateTime2, false));
        }
        LimitMarker limiterObj = new LimitMarker(parentSessionCount);
        outputStream.writeObject(limiterObj);
        if (doCompaction) {
            this.parentStateMap_$eq(newParentSessionStore);
            return;
        }
    }

    private void readObjectInternal(ObjectInput inputStream) {
        int deltaMapSize = inputStream.readInt();
        this.deltaMap_$eq(deltaMapSize != 0 ? new OpenHashMap(deltaMapSize, this.keyClassTag(), ClassTag$.MODULE$.apply(StateInfo.class)) : new OpenHashMap(this.initialCapacity(), this.keyClassTag(), ClassTag$.MODULE$.apply(StateInfo.class)));
        for (int deltaMapCount = 0; deltaMapCount < deltaMapSize; ++deltaMapCount) {
            Object key = inputStream.readObject();
            StateInfo sessionInfo = (StateInfo)inputStream.readObject();
            this.deltaMap().update(key, (Object)sessionInfo);
        }
        int parentStateMapSizeHint = inputStream.readInt();
        int newStateMapInitialCapacity = package$.MODULE$.max(parentStateMapSizeHint, OpenHashMapBasedStateMap$.MODULE$.DEFAULT_INITIAL_CAPACITY());
        OpenHashMapBasedStateMap<K, S> newParentSessionStore = new OpenHashMapBasedStateMap<K, S>(newStateMapInitialCapacity, this.deltaChainThreshold(), this.keyClassTag(), this.stateClassTag());
        boolean parentSessionLoopDone = false;
        while (!parentSessionLoopDone) {
            Object obj = inputStream.readObject();
            Object object = obj;
            if (object instanceof LimitMarker) {
                LimitMarker limitMarker = (LimitMarker)object;
                parentSessionLoopDone = true;
                int expectedCount = limitMarker.num();
                Predef$.MODULE$.assert(expectedCount == super.deltaMap().size());
                continue;
            }
            Object key = obj;
            Object state = inputStream.readObject();
            long updateTime = inputStream.readLong();
            super.deltaMap().update(key, new StateInfo<Object>(state, updateTime, false));
        }
        this.parentStateMap_$eq(newParentSessionStore);
    }

    private void writeObject(ObjectOutputStream outputStream) {
        outputStream.defaultWriteObject();
        this.writeObjectInternal(outputStream);
    }

    private void readObject(ObjectInputStream inputStream) {
        inputStream.defaultReadObject();
        this.readObjectInternal(inputStream);
    }

    public void write(Kryo kryo, Output output) {
        output.writeInt(this.initialCapacity());
        output.writeInt(this.deltaChainThreshold());
        kryo.writeClassAndObject(output, this.keyClassTag());
        kryo.writeClassAndObject(output, this.stateClassTag());
        this.writeObjectInternal((ObjectOutput)new KryoOutputObjectOutputBridge(kryo, output));
    }

    public void read(Kryo kryo, Input input) {
        this.initialCapacity_$eq(input.readInt());
        this.deltaChainThreshold_$eq(input.readInt());
        this.keyClassTag_$eq((ClassTag)kryo.readClassAndObject(input));
        this.stateClassTag_$eq((ClassTag)kryo.readClassAndObject(input));
        this.readObjectInternal((ObjectInput)new KryoInputObjectInputBridge(kryo, input));
    }

    public static final /* synthetic */ boolean $anonfun$getByTime$1(OpenHashMapBasedStateMap $this, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object key = tuple3._1();
            return !$this.deltaMap().contains(key);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$getByTime$2(long threshUpdatedTime$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            StateInfo stateInfo = (StateInfo)tuple2._2();
            return !stateInfo.deleted() && stateInfo.updateTime() < threshUpdatedTime$1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getAll$1(OpenHashMapBasedStateMap $this, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            Object key = tuple3._1();
            return !$this.deltaMap().contains(key);
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$getAll$2(Tuple2 x$1) {
        return !((StateInfo)x$1._2()).deleted();
    }

    public OpenHashMapBasedStateMap(StateMap<K, S> parentStateMap, int initialCapacity, int deltaChainThreshold, ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this.parentStateMap = parentStateMap;
        this.initialCapacity = initialCapacity;
        this.deltaChainThreshold = deltaChainThreshold;
        this.keyClassTag = keyClassTag;
        this.stateClassTag = stateClassTag;
        Predef$.MODULE$.require(this.initialCapacity() >= 1, (Function0 & Serializable & scala.Serializable)() -> "Invalid initial capacity");
        Predef$.MODULE$.require(this.deltaChainThreshold() >= 1, (Function0 & Serializable & scala.Serializable)() -> "Invalid delta chain threshold");
        this.deltaMap = new OpenHashMap(this.initialCapacity(), this.keyClassTag(), ClassTag$.MODULE$.apply(StateInfo.class));
    }

    public OpenHashMapBasedStateMap(int initialCapacity, int deltaChainThreshold, ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this(new EmptyStateMap(), initialCapacity, deltaChainThreshold, keyClassTag, stateClassTag);
    }

    public OpenHashMapBasedStateMap(int deltaChainThreshold, ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this(OpenHashMapBasedStateMap$.MODULE$.DEFAULT_INITIAL_CAPACITY(), deltaChainThreshold, keyClassTag, stateClassTag);
    }

    public OpenHashMapBasedStateMap(ClassTag<K> keyClassTag, ClassTag<S> stateClassTag) {
        this(OpenHashMapBasedStateMap$.MODULE$.DELTA_CHAIN_LENGTH_THRESHOLD(), keyClassTag, stateClassTag);
    }

    public static class LimitMarker
    implements Serializable {
        private final int num;

        public int num() {
            return this.num;
        }

        public LimitMarker(int num) {
            this.num = num;
        }
    }

    public static class StateInfo<S>
    implements Product,
    scala.Serializable {
        private S data;
        private long updateTime;
        private boolean deleted;

        public S data() {
            return this.data;
        }

        public void data_$eq(S x$1) {
            this.data = x$1;
        }

        public long updateTime() {
            return this.updateTime;
        }

        public void updateTime_$eq(long x$1) {
            this.updateTime = x$1;
        }

        public boolean deleted() {
            return this.deleted;
        }

        public void deleted_$eq(boolean x$1) {
            this.deleted = x$1;
        }

        public void markDeleted() {
            this.deleted_$eq(true);
        }

        public void update(S newData, long newUpdateTime) {
            this.data_$eq(newData);
            this.updateTime_$eq(newUpdateTime);
            this.deleted_$eq(false);
        }

        public <S> StateInfo<S> copy(S data, long updateTime, boolean deleted) {
            return new StateInfo<S>(data, updateTime, deleted);
        }

        public <S> S copy$default$1() {
            return this.data();
        }

        public <S> long copy$default$2() {
            return this.updateTime();
        }

        public <S> boolean copy$default$3() {
            return this.deleted();
        }

        public String productPrefix() {
            return "StateInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.data();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.updateTime());
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this.deleted());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StateInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.data()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.updateTime()));
            n = Statics.mix((int)n, (int)(this.deleted() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StateInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            StateInfo stateInfo = (StateInfo)x$1;
            if (!BoxesRunTime.equals(this.data(), stateInfo.data())) return false;
            if (this.updateTime() != stateInfo.updateTime()) return false;
            if (this.deleted() != stateInfo.deleted()) return false;
            if (!stateInfo.canEqual(this)) return false;
            return true;
        }

        public StateInfo(S data, long updateTime, boolean deleted) {
            this.data = data;
            this.updateTime = updateTime;
            this.deleted = deleted;
            Product.$init$((Product)this);
        }
    }
}

