/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.xml.IdInfo;
import org.geotools.data.shapefile.shp.xml.Metadata;
import org.locationtech.jts.geom.Envelope;

public class ShpXmlFileReader
implements FileReader {
    private ShpFiles shapefileFiles;

    public ShpXmlFileReader(ShpFiles shapefileFiles) {
        this.shapefileFiles = shapefileFiles;
    }

    private XMLStreamReader reader(InputStream in) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        return inputFactory.createXMLStreamReader(in, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Metadata parse() {
        try (InputStream inputStream = this.shapefileFiles.getInputStream(ShpFileType.SHP_XML, this);){
            Metadata metadata = this.parseMetadata(this.reader(inputStream));
            return metadata;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    protected Metadata parseMetadata(XMLStreamReader reader) throws XMLStreamException {
        int tag;
        Metadata meta = new Metadata();
        while ((tag = reader.next()) != 8) {
            if (1 != tag) continue;
            switch (reader.getLocalName()) {
                case "idinfo": {
                    IdInfo idInfo = this.parseIdInfo(reader);
                    meta.setIdinfo(idInfo);
                }
            }
        }
        return meta;
    }

    protected IdInfo parseIdInfo(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, "idinfo");
        Envelope bounding = new Envelope();
        Envelope lbounding = new Envelope();
        if (this.seekElement(reader, "spdom")) {
            int tag;
            while ((tag = reader.nextTag()) != 2 && !"spdom".equals(reader.getLocalName())) {
                if (tag != 1) continue;
                switch (reader.getLocalName()) {
                    case "bounding": {
                        bounding = this.parseBounding(reader);
                        break;
                    }
                    case "lbounding": {
                        lbounding = this.parseBounding(reader);
                    }
                }
            }
        }
        IdInfo idInfo = new IdInfo();
        idInfo.setBounding(bounding);
        idInfo.setLbounding(lbounding);
        return idInfo;
    }

    private boolean seekElement(XMLStreamReader reader, String elementName) throws XMLStreamException {
        int tag;
        reader.require(1, null, null);
        String thisElem = reader.getLocalName();
        do {
            if ((tag = reader.next()) != 1 || !elementName.equals(reader.getLocalName())) continue;
            return true;
        } while (tag != 2 || !thisElem.equals(reader.getLocalName()));
        return false;
    }

    protected Envelope parseBounding(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, null);
        double minX = Double.NaN;
        double maxX = Double.NaN;
        double minY = Double.NaN;
        double maxY = Double.NaN;
        String thisElem = reader.getLocalName();
        while (reader.nextTag() != 2 && !thisElem.equals(reader.getLocalName())) {
            switch (reader.getLocalName()) {
                case "westbc": {
                    minX = Double.parseDouble(reader.getElementText());
                    break;
                }
                case "eastbc": {
                    maxX = Double.parseDouble(reader.getElementText());
                    break;
                }
                case "southbc": {
                    minY = Double.parseDouble(reader.getElementText());
                    break;
                }
                case "northbc": {
                    maxY = Double.parseDouble(reader.getElementText());
                }
            }
        }
        return new Envelope(minX, maxX, minY, maxY);
    }

    @Override
    public String id() {
        return "Shp Xml Reader";
    }
}

