/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.activity.filterutils;

import com.dataiku.dip.activity.UsageSummaryBuilderUtils;
import com.dataiku.dip.activity.UsageSummaryModel;
import com.dataiku.dip.activity.filterutils.FilterAnalyzer;
import com.dataiku.dip.utils.DKULogger;
import java.util.SortedMap;
import java.util.TreeMap;

public class FilterAggregator {
    private int nbFilters = 0;
    private int nbConditionFilters = 0;
    private int nbSQLFilters = 0;
    private int nbFormulaFilters = 0;
    private int nbElasticFilters = 0;
    private int nbUnknownFilters = 0;
    private SortedMap<Integer, Integer> countByFilterDepth = new TreeMap<Integer, Integer>();
    private double depthTotal = 0.0;
    private int maxDepth = 0;
    private double nbConditionsTotal = 0.0;
    private int maxNbConditions = 0;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.usage");

    public void add(FilterAggregator other) {
        this.nbFilters += other.nbFilters;
        this.nbConditionFilters += other.nbConditionFilters;
        this.nbSQLFilters += other.nbSQLFilters;
        this.nbFormulaFilters += other.nbFormulaFilters;
        this.nbElasticFilters += other.nbElasticFilters;
        this.nbUnknownFilters += other.nbUnknownFilters;
        other.countByFilterDepth.forEach((k, v) -> this.countByFilterDepth.merge((Integer)k, (Integer)v, (v1, v2) -> v1 + v2));
        this.depthTotal += other.depthTotal;
        this.maxDepth = Math.max(this.maxDepth, other.maxDepth);
        this.nbConditionsTotal += other.nbConditionsTotal;
        this.maxNbConditions = Math.max(this.maxNbConditions, other.maxNbConditions);
    }

    public void appendFilter(FilterAnalyzer.FilterSummary fs) {
        ++this.nbFilters;
        if ("SQL".equals(fs.mode)) {
            ++this.nbSQLFilters;
        } else if ("CUSTOM".equals(fs.mode)) {
            ++this.nbFormulaFilters;
        } else if ("ES_QUERY_STRING".equals(fs.mode)) {
            ++this.nbElasticFilters;
        } else if ("&&".equals(fs.mode) || "||".equals(fs.mode)) {
            ++this.nbConditionFilters;
            UsageSummaryBuilderUtils.iinc(this.countByFilterDepth, fs.depth);
            this.depthTotal += (double)fs.depth;
            if (this.maxDepth < fs.depth) {
                this.maxDepth = fs.depth;
            }
            this.nbConditionsTotal += (double)fs.numberOfConditions;
            if (this.maxNbConditions < fs.numberOfConditions) {
                this.maxNbConditions = fs.numberOfConditions;
            }
        } else {
            logger.warn((Object)String.format("A filter with an unexpected mode (new to reporting logic) was encountered when gathering filters for the reports. Mode: %s", fs.mode));
            ++this.nbUnknownFilters;
        }
    }

    public UsageSummaryModel.FilterStats buildStats() {
        UsageSummaryModel.FilterStats filterStats = new UsageSummaryModel.FilterStats();
        filterStats.nbFilters = this.nbFilters;
        if (this.nbConditionFilters > 0) {
            UsageSummaryModel.ConditionFilterStatUnit conditionFilterStats = new UsageSummaryModel.ConditionFilterStatUnit();
            conditionFilterStats.nbFilters = this.nbConditionFilters;
            conditionFilterStats.maxDepth = this.maxDepth;
            conditionFilterStats.maxNbConditions = this.maxNbConditions;
            conditionFilterStats.countByFilterDepth = this.countByFilterDepth;
            conditionFilterStats.avgDepth = this.depthTotal / (double)this.nbConditionFilters;
            conditionFilterStats.avgNbConditions = this.nbConditionsTotal / (double)this.nbConditionFilters;
            filterStats.condition = conditionFilterStats;
        }
        if (this.nbFormulaFilters > 0) {
            filterStats.formula = new UsageSummaryModel.FilterStatUnit();
            filterStats.formula.nbFilters = this.nbFormulaFilters;
        }
        if (this.nbSQLFilters > 0) {
            filterStats.sql = new UsageSummaryModel.FilterStatUnit();
            filterStats.sql.nbFilters = this.nbSQLFilters;
        }
        if (this.nbElasticFilters > 0) {
            filterStats.elasticSearchQueryString = new UsageSummaryModel.FilterStatUnit();
            filterStats.elasticSearchQueryString.nbFilters = this.nbElasticFilters;
        }
        if (this.nbUnknownFilters > 0) {
            filterStats.unknownType = new UsageSummaryModel.FilterStatUnit();
            filterStats.unknownType.nbFilters = this.nbUnknownFilters;
        }
        return filterStats;
    }
}

