/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.EndpointServerSideConfig;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.OAuth2Config;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAPIServiceDeployment
extends AbstractDeployment {
    public String deployedServiceId;
    public String publishedServiceId;
    public boolean enabled;
    @Nullable
    public GenerationsMapping generationsMapping;
    public APIAuthSettings auth = new APIAuthSettings();
    public List<OverrideEndpointServerSideConfig> endpointsServerSideConfigs = new ArrayList<OverrideEndpointServerSideConfig>();
    @Nullable
    public OpenAPISettings openAPISettings;

    protected AbstractAPIServiceDeployment() {
    }

    protected AbstractAPIServiceDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag) {
        super(id, infraId, creationTag);
        this.enabled = enabled;
        this.publishedServiceId = publishedServiceId;
        if (StringUtils.isNotBlank((String)version)) {
            this.generationsMapping = new GenerationsMapping();
            this.generationsMapping.setSingleGeneration(version);
            this.generationsMapping.auditRoutingKey = id;
            this.openAPISettings = new OpenAPISettings(version);
        }
    }

    protected AbstractAPIServiceDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag, List<AuthorizationItem> authorizationsToQueryThroughDeployer) {
        this(id, infraId, publishedServiceId, version, enabled, creationTag);
        this.auth.permissions = authorizationsToQueryThroughDeployer;
    }

    protected AbstractAPIServiceDeployment(AbstractAPIServiceDeployment existingDeployment, String deploymentId, String infraId, boolean enabled, VersionTag creationTag) {
        super(deploymentId, infraId, creationTag);
        this.enabled = enabled;
        this.publishedServiceId = existingDeployment.publishedServiceId;
        this.generationsMapping = existingDeployment.generationsMapping;
        this.auth = existingDeployment.auth;
        this.endpointsServerSideConfigs = existingDeployment.endpointsServerSideConfigs;
        this.tags = existingDeployment.tags;
        this.openAPISettings = existingDeployment.openAPISettings;
        this.typeBadges = existingDeployment.typeBadges;
    }

    @Override
    public AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.APIServiceDeploymentBasicInfo apiNodeDeplBI = new AbstractDeploymentBasicInfo.APIServiceDeploymentBasicInfo();
        apiNodeDeplBI.id = this.id;
        apiNodeDeplBI.enabled = this.enabled;
        apiNodeDeplBI.publishedServiceId = this.publishedServiceId;
        apiNodeDeplBI.deployedServiceId = this.deployedServiceId;
        apiNodeDeplBI.infraId = this.infraId;
        apiNodeDeplBI.generationsMapping = this.generationsMapping;
        apiNodeDeplBI.tags = this.tags;
        apiNodeDeplBI.creationTag = this.creationTag;
        apiNodeDeplBI.versionTag = this.versionTag;
        apiNodeDeplBI.deploymentTag = this.deploymentTag;
        apiNodeDeplBI.typeBadges = this.typeBadges;
        return apiNodeDeplBI;
    }

    @Override
    public String getKey() {
        return "api+" + this.id;
    }

    @Override
    public boolean hasPublishedItemAndPackageVersion(String publishedServiceId, String generationId) {
        return this.publishedServiceId.equals(publishedServiceId) && this.generationsMapping != null && this.generationsMapping.isUsed(generationId);
    }

    @Override
    public String getPublishedItemId() {
        return this.publishedServiceId;
    }

    @Override
    public void switchVersion(String versionId) {
        if (this.generationsMapping == null) {
            this.generationsMapping = new GenerationsMapping();
            this.generationsMapping.auditRoutingKey = this.id;
        }
        this.generationsMapping.setSingleGeneration(versionId);
    }

    @Override
    public String getTargetId() {
        return StringUtils.isBlank((String)this.deployedServiceId) ? this.publishedServiceId : this.deployedServiceId;
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (!(oldDeployment instanceof AbstractAPIServiceDeployment)) {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not a AbstractAPIServiceDeployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
        AbstractAPIServiceDeployment oldAPIDeployment = (AbstractAPIServiceDeployment)oldDeployment;
        AbstractAPIServiceDeployment.verifyImmutableField(oldAPIDeployment.publishedServiceId, this.publishedServiceId, "published service id");
        assert (this.generationsMapping != null);
        this.generationsMapping.validate();
    }

    public boolean canQueryThroughDeployer(AuthCtx authCtx) throws DKUSecurityException {
        for (AuthorizationItem pi : this.auth.permissions) {
            if (!pi.queryThroughDeployer || !authCtx.getGroups().contains(pi.group) && !authCtx.isAdmin()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Nonnull
    public abstract AbstractAPIDeploymentInfra.APINodeLogging getNodeLogging();

    @Nonnull
    public abstract AbstractAPIDeploymentInfra.APINodeLogging getNodeLogging(AbstractAPIDeploymentInfra var1);

    public String getOpenAPISettingsGenerationIfIsUsedOrNull() {
        if (this.generationsMapping != null && this.openAPISettings != null && this.openAPISettings.generation != null && this.generationsMapping.isUsed(this.openAPISettings.generation)) {
            return this.openAPISettings.generation;
        }
        return null;
    }

    public void createOrUpdateOpenAPISettingsGenerationIfNeeded() {
        if (this.openAPISettings == null) {
            this.openAPISettings = new OpenAPISettings(null);
        }
        if (this.generationsMapping != null && (this.openAPISettings.generation == null || this.generationsMapping.isSingleGeneration() || !this.generationsMapping.isUsed(this.openAPISettings.generation))) {
            this.openAPISettings.generation = this.generationsMapping.getDefaultOpenAPIGeneration();
        }
    }

    public static class APIAuthSettings {
        public DeployedAuthenticationMode authMode = DeployedAuthenticationMode.INHERIT_DEV;
        public List<QueryAPIKey> apiKeys = new ArrayList<QueryAPIKey>();
        public OAuth2Config oauth2Config = new OAuth2Config();
        public List<AuthorizationItem> permissions = new ArrayList<AuthorizationItem>();

        public String getHash() {
            return DigestUtils.md5Hex((String)JSON.json((Object)this));
        }

        public void encryptKeysIfNotEncrypted(PasswordEncryptionService passwordEncryptionService) {
            this.apiKeys.forEach(key -> {
                key.key = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(key.key);
            });
        }

        public void decryptKeysIfEncrypted(PasswordEncryptionService passwordEncryptionService) {
            this.apiKeys.forEach(key -> {
                key.key = passwordEncryptionService.decryptIfEncrypted(key.key);
            });
        }

        public static enum DeployedAuthenticationMode {
            INHERIT_DEV,
            PUBLIC,
            API_KEYS,
            OAUTH2;

        }
    }

    public static class OpenAPISettings {
        public String generation;

        public OpenAPISettings(String generation) {
            this.generation = generation;
        }
    }

    public static class AuthorizationItem {
        public String group;
        public boolean queryThroughDeployer;
    }

    public static class OverrideEndpointServerSideConfig {
        public String endpointId;
        public EndpointServerSideConfig config;
    }
}

