/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import java.io.IOException;
import java.sql.SQLException;

public abstract class SimpleSQLDSSConnectionWithBasicCredential
extends AbstractSQLConnection
implements ConnectionWithBasicCredential {
    @Override
    public boolean actuallyHasBasicCredential() {
        return true;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        if (this.actuallyHasBasicCredential()) {
            ICredentialsService.BasicCredential creds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
            return clazz.cast(creds);
        }
        return null;
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        ICredentialsService.BasicCredential creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getType(), this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        if (this.actuallyHasBasicCredential() && creds != null) {
            if (creds.user != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
            }
            if (creds.password != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
            }
        }
        return cd;
    }
}

