/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.ComputeRequiredRefreshOfSubgraphs;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeHashComputer;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.GeneratorEvaluator;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;

public class ComputeRequiredRefreshRecursiveBuild
extends ComputeRequiredRefreshOfSubgraphs {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.compute.prune");

    public ComputeRequiredRefreshRecursiveBuild(ComputableHashComputer dtComputer, RecipeHashComputer ttComputer, JobDef jobDef, JobActivity topLevelActivity) {
        super(dtComputer, ttComputer, jobDef, topLevelActivity);
    }

    @Override
    public void pruneInternal(DSSDBConnection conn) throws Exception {
        this.prune(conn, this.topLevelActivity);
    }

    private boolean prune(DSSDBConnection conn, JobActivity item) throws Exception {
        HashSet<String> currentlyVisitingStack = new HashSet<String>();
        return this.pruneAndReturnIfNeeded(conn, item, 0, currentlyVisitingStack);
    }

    private boolean pruneAndReturnIfNeeded(DSSDBConnection conn, JobActivity item, int indentLevel, Set<String> currentlyVisitingStack) throws Exception {
        if (item.pruned) {
            return false;
        }
        if (this.requiredActivityCache.containsKey(item)) {
            return (Boolean)this.requiredActivityCache.get(item);
        }
        if (item.getSubgraph() instanceof RecipeRunnableSubgraph && ((RecipeRunnableSubgraph)item.getSubgraph()).getRecipe().isNeverRecomputeExistingPartitions()) {
            this.infoV(item, indentLevel, "is never-recompute, checking if targets exist", new Object[0]);
            boolean allTargetsExist = this.allTargetsExist(conn, item, indentLevel);
            if (allTargetsExist) {
                this.infoV(item, indentLevel, "all targets exist --> activity is not required", new Object[0]);
                return this.cacheAndReturnIsActivityRequired(item, false);
            }
            this.infoV(item, indentLevel, "some targets don't exist --> recursing", new Object[0]);
        }
        if (item.getSubgraph() != null) {
            for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                SerializedDataset.RebuildBehavior rb = flowComputable.getRebuildBehavior();
                boolean bl = rb == SerializedDataset.RebuildBehavior.WRITE_PROTECT || rb == SerializedDataset.RebuildBehavior.EXPLICIT && !item.topLevelActivity;
                if (!bl) continue;
                this.infoV(item, indentLevel, "Target %s is write-protected: checking if target partition exists", flowComputable.getFullId());
                Partition targetPart = item.getSubgraph().getTargetPartition(flowComputable);
                if (!this.dtComputer.partitionExists(flowComputable, targetPart)) continue;
                this.infoV(item, indentLevel, "Target %s is write-protected: not writing target %s", flowComputable.getFullId(), targetPart);
                return this.cacheAndReturnIsActivityRequired(item, false);
            }
        }
        if (item.dependencies.size() > 0) {
            this.infoV(item, indentLevel, "checking if activity is required by its %d dependencies", item.dependencies.size());
            ArrayList<JobActivity> neededDependencies = new ArrayList<JobActivity>();
            for (JobActivity dependency : item.dependencies) {
                this.infoV(item, indentLevel, "checking dep  " + dependency.id(), new Object[0]);
                if (currentlyVisitingStack.contains(dependency.id())) {
                    this.infoV(item, indentLevel, "%s is already in the currently visiting set. Loop in Flow likely", dependency.id());
                    continue;
                }
                currentlyVisitingStack.add(dependency.id());
                boolean bl = this.pruneAndReturnIfNeeded(conn, dependency, indentLevel + 1, currentlyVisitingStack);
                currentlyVisitingStack.remove(dependency.id());
                if (bl) {
                    neededDependencies.add(dependency);
                    continue;
                }
                if (dependency.pruned) continue;
                this.infoV(item, indentLevel, "Pruning one dependency: %s", dependency.id());
                dependency.pruned = true;
            }
            item.dependencies = neededDependencies;
            if (item.dependencies.size() > 0) {
                this.infoV(item, indentLevel, "yes, %s is required by %d dependencies", item.id(), item.dependencies.size());
                item.setRequiredForDeps();
                return this.cacheAndReturnIsActivityRequired(item, true);
            }
            this.infoV(item, indentLevel, "no, %s is not required by its dependencies -> will check if itself is needed", item.id());
        } else {
            this.infoV(item, indentLevel, "no dependencies -> checking if itself is needed", new Object[0]);
        }
        if (item.getSubgraph() == null) {
            return this.cacheAndReturnIsActivityRequired(item, true);
        }
        for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
            Partition targetP = item.getSubgraph().getTargetPartition(flowComputable);
            String string = this.dtComputer.getSettingsHash(flowComputable);
            HashesModel.DatasetSettingsHashInfo recordedHash = this.flowStateInternalDB.getPropagatedTargetSettingsHash(conn, flowComputable.getFullId(), targetP.id());
            if (recordedHash == null) {
                item.setRequiredNeverExecuted();
                this.infoV(item, indentLevel, "activity required: target %s does not have recorded settings", this.prettyDSP(flowComputable, targetP));
                return this.cacheAndReturnIsActivityRequired(item, true);
            }
            this.infoV(item, indentLevel, "target %s built with settings has %s (on %s - %s)", this.prettyDSP(flowComputable, targetP), recordedHash.propagatedHash, DKUtils.isoFormat((long)recordedHash.propagatedOn), recordedHash.reason);
            if (recordedHash.propagatedHash.equals(string)) continue;
            this.infoV(item, indentLevel, "activity required: target %s settings-hash mismatch : cur:%s propagated:%s (on %s - %s)", this.prettyDSP(flowComputable, targetP), string, recordedHash.propagatedHash, DKUtils.isoFormat((long)recordedHash.propagatedOn), recordedHash.reason);
            item.setRequiredTargetSettingsChanged(flowComputable.getFullId(), recordedHash.propagatedOn, recordedHash.reason);
            return this.cacheAndReturnIsActivityRequired(item, true);
        }
        if (item.getSubgraph() instanceof RecipeRunnableSubgraph && ((RecipeRunnableSubgraph)item.getSubgraph()).getRecipe().isGenerator()) {
            RecipeRunnableSubgraph subgraph = (RecipeRunnableSubgraph)item.getSubgraph();
            this.infoV(item, indentLevel, "Checking a generator recipe", new Object[0]);
            GeneratorEvaluator generatorEvaluator = subgraph.getRecipe().getGeneratorEvaluator();
            for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                Partition targetP = item.getSubgraph().getTargetPartition(flowComputable);
                HashesModel.GeneratorHashInfo generatorHashInfo = this.flowStateInternalDB.getPropagatedGeneratorTaskHash(conn, flowComputable.getFullId(), targetP.id(), item.getSubgraph().getName());
                if (generatorHashInfo == null) {
                    this.infoV(item, indentLevel, "generator task never propagated to %s, so item is required", this.prettyDSP(flowComputable, targetP));
                    item.setRequiredNeverExecuted();
                    return this.cacheAndReturnIsActivityRequired(item, true);
                }
                if (this.cachedIsGeneratorExecutionNeeded(generatorEvaluator, flowComputable, targetP)) {
                    this.infoV(item, indentLevel, " gtask: target %s propagatedHash %s is required", this.prettyDSP(flowComputable, targetP), generatorHashInfo.propagatedHash);
                    item.setRequiredSourceOutOfDate(generatorHashInfo.propagatedOn, generatorHashInfo.reason);
                    return this.cacheAndReturnIsActivityRequired(item, true);
                }
                this.infoV(item, indentLevel, " gtask: target %s propagatedHash %s is not required", this.prettyDSP(flowComputable, targetP), generatorHashInfo.propagatedHash);
            }
            logger.info((Object)(DKUtils.indent((int)indentLevel) + " gtask:" + item.getSubgraph().getName() + " required by nobody"));
            return this.cacheAndReturnIsActivityRequired(item, false);
        }
        boolean needed = false;
        SerializedRecipe.RecipeHashPropagationBehavior recipeHashPropagationBehavior = SerializedRecipe.RecipeHashPropagationBehavior.getEffectivePropagationBehavior(this.getProjectUnsafe(), item);
        for (FlowComputable flowComputable : item.getSubgraph().getSources()) {
            block5: for (Partition partition : item.getSubgraph().getSourcePartitions(flowComputable)) {
                DatasetReadiness sourcePartitionHash = this.dtComputer.getCurrentContentHash(conn, flowComputable, partition);
                if (!sourcePartitionHash.isReady()) {
                    if (recipeHashPropagationBehavior == SerializedRecipe.RecipeHashPropagationBehavior.ENABLED_BUT_IGNORE_NON_READY_SOURCES) {
                        this.infoV(item, indentLevel, "%s is not ready but non-ready-sources allowed --> skipping", this.prettyDSP(flowComputable, partition));
                        continue;
                    }
                    if (flowComputable instanceof FlowPartitionable) {
                        Partitionable sourceDataset = ((FlowPartitionable)((Object)flowComputable)).getPartitioned(this.dao);
                        if (sourceDataset.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                            item.warnContext.addWarning(WarningsContext.WarningType.MISSING_SOURCE_PARTITION, String.format("Partition %s of source %s was missing, considering it as empty", partition.id(), flowComputable.getFullId()), logger);
                            continue;
                        }
                    }
                    this.throwSourceNotReady(flowComputable, partition, sourcePartitionHash.error);
                    continue;
                }
                this.infoV(item, indentLevel, "src %s is ready and provides hash %s", this.prettyDSP(flowComputable, partition), sourcePartitionHash.hash);
                for (FlowComputable flowComputable2 : item.getSubgraph().getTargets()) {
                    Partition targetP = item.getSubgraph().getTargetPartition(flowComputable2);
                    this.infoV(item, indentLevel, "  -> Checking target recorded has for %s %s %s %s", flowComputable2, targetP, flowComputable, partition);
                    HashesModel.SrcDatasetHashInfo recordedHash = this.flowStateInternalDB.getPropagatedDatasetHash(conn, flowComputable2.getFullId(), targetP.id(), flowComputable.getFullId(), partition.id());
                    if (recordedHash == null) {
                        this.infoV(item, indentLevel, "activity required: src %s was never propagated in %s", this.prettyDSP(flowComputable, partition), this.prettyDSP(flowComputable2, targetP));
                        item.setRequiredNeverExecuted();
                        needed = true;
                        continue block5;
                    }
                    this.infoV(item, indentLevel, "src %s (hash %s) propagated in %s with hash %s (on %s - %s)", this.prettyDSP(flowComputable, partition), sourcePartitionHash.hash, this.prettyDSP(flowComputable2, targetP), recordedHash.propagatedHash, DKUtils.isoFormat((long)recordedHash.propagatedOn), recordedHash.reason);
                    if (recordedHash.propagatedHash.equals(sourcePartitionHash.hash)) continue;
                    this.infoV(item, indentLevel, "activity required: src %s hash mismatch : src:%s propagated:%s in %s (on %s - %s)", this.prettyDSP(flowComputable, partition), sourcePartitionHash.hash, recordedHash.propagatedHash, this.prettyDSP(flowComputable2, targetP), DKUtils.isoFormat((long)recordedHash.propagatedOn), recordedHash.reason);
                    needed = true;
                    item.setRequiredSourceChanged(flowComputable.getFullId(), partition.id(), recordedHash.propagatedOn, recordedHash.reason);
                    continue block5;
                }
            }
        }
        if (item.getSubgraph() instanceof RecipeRunnableSubgraph) {
            subgraph = (RecipeRunnableSubgraph)item.getSubgraph();
            String string = this.ttComputer.getRecipeHash(subgraph.getRecipe());
            this.infoV(item, indentLevel, "recipe hash %s", string);
            for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                targetP = item.getSubgraph().getTargetPartition(flowComputable);
                recordedHash = this.flowStateInternalDB.getPropagatedRecipeCodeHash(conn, flowComputable.getFullId(), targetP.id(), item.getSubgraph().getName());
                if (recordedHash == null) {
                    this.infoV(item, indentLevel, "recipe %s was never propagated in %s, so item is required", item.getSubgraph().getName(), this.prettyDSP(flowComputable, targetP));
                    item.setRequiredNeverExecuted();
                    needed = true;
                } else {
                    if (recordedHash.propagatedHash.equals(string)) {
                        this.infoV(item, indentLevel, "recipe %s correctly propagated in %s (hash %s)", item.getSubgraph().getName(), this.prettyDSP(flowComputable, targetP), string);
                        continue;
                    }
                    this.infoV(item, indentLevel, "item needed because recipe %s is different from propagated info in %s", item.getSubgraph().getName(), this.prettyDSP(flowComputable, targetP));
                    needed = true;
                    item.setRequiredRecipeChanged(recordedHash.propagatedOn, recordedHash.reason);
                }
                break;
            }
        } else if (item.getSubgraph() instanceof AbstractPipelineRunnableSubgraph) {
            subgraph = (AbstractPipelineRunnableSubgraph)item.getSubgraph();
            String string = this.ttComputer.getPipelineHash((AbstractPipelineRunnableSubgraph)subgraph);
            this.infoV(item, indentLevel, "pipeline hash %s", string);
            for (FlowComputable flowComputable : item.getSubgraph().getTargets()) {
                targetP = item.getSubgraph().getTargetPartition(flowComputable);
                recordedHash = this.flowStateInternalDB.getPropagatedRecipeCodeHash(conn, flowComputable.getFullId(), targetP.id(), item.getSubgraph().getName());
                if (recordedHash == null) {
                    this.infoV(item, indentLevel, "pipeline %s was never propagated in %s, so item is required", item.getSubgraph().getName(), this.prettyDSP(flowComputable, targetP));
                    item.setRequiredNeverExecuted();
                    needed = true;
                } else {
                    if (recordedHash.propagatedHash.equals(string)) {
                        this.infoV(item, indentLevel, "pipeline %s correctly propagated in %s (hash %s)", item.getSubgraph().getName(), this.prettyDSP(flowComputable, targetP), string);
                        continue;
                    }
                    this.infoV(item, indentLevel, "item needed because pipeline %s is different from propagated info in %s", item.getSubgraph().getName(), this.prettyDSP(flowComputable, targetP));
                    needed = true;
                    item.setRequiredRecipeChanged(recordedHash.propagatedOn, recordedHash.reason);
                }
                break;
            }
        } else {
            throw new NotImplementedException();
        }
        if (!needed) {
            this.infoV(item, indentLevel, "not required, pruning", new Object[0]);
        }
        return this.cacheAndReturnIsActivityRequired(item, needed);
    }
}

