/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.geojoin.DatasetAndSelection;
import com.dataiku.dip.dataflow.exec.geojoin.DatasetPreFilterKey;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinInputsHelper;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoUtils;
import com.dataiku.dip.dataflow.exec.geojoin.SpillableIndexableDataSource;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.streaming.DatasetWriter;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoJoinRecipeBuiltinRunner
implements AbortableRecipeRunner {
    public static final int LOG_EVERY_ROW = 10000;
    private static final DKULogger logger;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final StreamColumnFactory cf = new StreamColumnFactory();
    private final StreamRowFactory rf = new StreamRowFactory();
    protected GeoJoinRecipePayloadParams params;
    private final Map<DatasetPreFilterKey, SpillableIndexableDataSource> spilledSources = new HashMap<DatasetPreFilterKey, SpillableIndexableDataSource>();
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;

    public GeoJoinRecipeBuiltinRunner(JobActivity activity) {
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void notifyBeforeAborting() {
        logger.infoV("Aborting the builtin runner", new Object[0]);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.params.validate();
        FlowDataset outputFD = this.activity.getSubgraph().getTargetsDatasets().get(0);
        Dataset outputDS = outputFD.getMandatory(this.datasetsDAO);
        Partition targetPartition = this.activity.getSubgraph().getTargetPartition(outputFD);
        SerializedRecipe.RecipeOutput recipeOutput = this.recipe.getModel().getSingleOutput("main");
        Output.WriteMode writeMode = DatasetWriter.getWriteModeAfterDatasetCleanup(outputDS, targetPartition, recipeOutput.getWriteMode(), this.authCtxService.getAuthCtx());
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        WarningsContext warnContext = this.activity.warnContext;
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(authCtx, outputDS, targetPartition, (ColumnFactory)this.cf, warnContext, writeMode);
        VariablesContext variablesContext = this.variablesService.getForProject(this.recipe.getProjectKey());
        ProcessorOutput recipeOut = this.createRecipeOutputChain(streamer, outputDS.getSchema());
        GeoJoinInputsHelper inputsHelper = new GeoJoinInputsHelper(this.params);
        JoinInputDescBase first = (JoinInputDescBase)this.params.virtualInputs.get(0);
        DatasetAndSelection firstDSandSel = this.getDatasetAndSelectionByVirtualInput(0, variablesContext);
        SpillableIndexableDataSource firstDataSource = new SpillableIndexableDataSource(firstDSandSel);
        MemTable mt = null;
        try {
            this.indexJoinedInputs(authCtx, inputsHelper, first, this.params.virtualInputs, variablesContext);
            for (int vInputIdx = 1; vInputIdx < this.params.virtualInputs.size(); ++vInputIdx) {
                JoinInputDescBase indexedInput = (JoinInputDescBase)this.params.virtualInputs.get(vInputIdx);
                SpillableIndexableDataSource joinedDataSource = this.spilledSources.get(this.createDatasetPreFilterKey(this.getDatasetLocByInputIdx(indexedInput.index), indexedInput.preFilter));
                GeoJoiner geoJoiner = new GeoJoiner(inputsHelper.joinMatrix.get(this.params.virtualInputs.indexOf(indexedInput)));
                if (this.params.virtualInputs.size() == 2) {
                    logger.infoV("Joining 2 datasets directly to recipe output", new Object[0]);
                    RowInputStream stream = firstDataSource.stream(authCtx);
                    geoJoiner.joinStreamIntoOutput(stream, vInputIdx, recipeOut, joinedDataSource, inputsHelper.outputColumnsPerVirtualInput.get(0), inputsHelper.outputColumnsPerVirtualInput.get(vInputIdx));
                    continue;
                }
                if (mt == null) {
                    SpillableIndexableDataSource.SpilledRowInputStream stream;
                    logger.infoV("Joining streamed dataset into a memory table", new Object[0]);
                    Set<String> firstInputOutputColNames = inputsHelper.outputColumnNames(0);
                    firstInputOutputColNames.addAll((Collection<String>)inputsHelper.joinColumnsPerVirtualInput.get(0));
                    Map<DatasetPreFilterKey, SpillableIndexableDataSource> map = this.spilledSources;
                    synchronized (map) {
                        DatasetPreFilterKey firstDatasetPreFilterKey = this.createDatasetPreFilterKey(this.getDatasetLocByInputIdx(first.index), first.preFilter);
                        if (!this.spilledSources.containsKey(firstDatasetPreFilterKey)) {
                            stream = firstDataSource.spillAndStream(firstInputOutputColNames, authCtx);
                            this.spilledSources.put(firstDatasetPreFilterKey, firstDataSource);
                        } else {
                            stream = this.spilledSources.get(firstDatasetPreFilterKey).getInputStreamFromSpill();
                        }
                    }
                    mt = geoJoiner.joinStreamIntoMemTable(stream, vInputIdx, joinedDataSource);
                    continue;
                }
                logger.infoV("Joining memory table into a memory table", new Object[0]);
                geoJoiner.joinMemTableIntoMemTable(mt, vInputIdx, joinedDataSource);
            }
            if (mt != null) {
                this.emitRowsFromMemtable(recipeOut, inputsHelper, mt);
            }
            recipeOut.lastRowEmitted();
            this.cleanup();
        }
        catch (Throwable throwable) {
            this.cleanup();
            for (SpillableIndexableDataSource ss : this.spilledSources.values()) {
                logger.infoV("Spilled rows cache stats for %s:  hit: %d, miss: %d", new Object[]{ss.datasetAndSelection.dataset.getFullName(), ss.spilledRowsCache.cacheHit, ss.spilledRowsCache.cacheMiss});
            }
            throw throwable;
        }
        for (SpillableIndexableDataSource ss : this.spilledSources.values()) {
            logger.infoV("Spilled rows cache stats for %s:  hit: %d, miss: %d", new Object[]{ss.datasetAndSelection.dataset.getFullName(), ss.spilledRowsCache.cacheHit, ss.spilledRowsCache.cacheMiss});
        }
    }

    private DatasetPreFilterKey createDatasetPreFilterKey(DatasetLocUtils.DatasetLoc datasetLoc, FilterDesc filterDesc) throws Exception {
        return new DatasetPreFilterKey(datasetLoc, filterDesc);
    }

    private ProcessorOutput createRecipeOutputChain(ToDatasetStreamer streamer, Schema outputSchema) throws Exception {
        Object recipeOut = streamer.getAsOutput();
        if (this.params.postFilter != null && this.params.postFilter.distinct) {
            recipeOut = new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsProcessorOutput((ProcessorOutput)recipeOut, outputSchema, (RowFactory)this.rf, (ColumnFactory)this.cf, (ColumnFactory)this.cf, (File)FlowJobUtils.getTmpFolder("geojoin-sorter", "geojoin"), new Sorter.MergeSortParams());
        }
        if (this.params.postFilter != null && this.params.postFilter.enabled && FilterDescUtils.willFilter(this.params.postFilter)) {
            GrelExpression filterExpression = FilterDescUtils.getGrelFilterExpression(this.params.postFilter);
            recipeOut = new AbstractStagedThreadedBuiltinRunner.FilteringRowsProcessorOutput((ProcessorOutput)recipeOut, (ColumnFactory)this.cf, filterExpression);
        }
        return recipeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Map<DatasetPreFilterKey, SpillableIndexableDataSource> map = this.spilledSources;
        synchronized (map) {
            for (SpillableIndexableDataSource spillableDatasource : this.spilledSources.values()) {
                spillableDatasource.close();
            }
        }
        logger.infoV("Done cleaning temporary storage", new Object[0]);
    }

    private void indexJoinedInputs(AuthCtx authCtx, GeoJoinInputsHelper inputsHelper, JoinInputDescBase first, List<JoinInputDescBase> virtualInputs, VariablesContext variablesContext) throws Exception {
        HashMap joinColumnsPerDS = new HashMap();
        HashMap outputColumnsPerDS = new HashMap();
        HashMap<DatasetPreFilterKey, DatasetAndSelection> dsToIndex = new HashMap<DatasetPreFilterKey, DatasetAndSelection>();
        boolean shouldIncludeFirstInpColumns = virtualInputs.stream().anyMatch(i -> i.index == first.index);
        for (int i2 = 0; i2 < virtualInputs.size(); ++i2) {
            JoinInputDescBase vi = virtualInputs.get(i2);
            DatasetLocUtils.DatasetLoc dsLoc = this.getDatasetLocByInputIdx(vi.index);
            if (vi != first || shouldIncludeFirstInpColumns) {
                joinColumnsPerDS.putIfAbsent(dsLoc, new HashSet());
                outputColumnsPerDS.putIfAbsent(dsLoc, new HashSet());
                ((Set)joinColumnsPerDS.get(dsLoc)).addAll((Collection)inputsHelper.joinColumnsPerVirtualInput.get(i2));
                Set<String> outputColumnNames = inputsHelper.outputColumnNames(i2);
                ((Set)outputColumnsPerDS.get(dsLoc)).addAll(outputColumnNames);
            }
            DatasetPreFilterKey datasetPreFilterKey = new DatasetPreFilterKey(dsLoc, vi.preFilter);
            if (vi == first || dsToIndex.containsKey(datasetPreFilterKey)) continue;
            DatasetAndSelection datasetAndSelectionByVirtualInput = this.getDatasetAndSelectionByVirtualInput(i2, variablesContext);
            dsToIndex.put(datasetPreFilterKey, datasetAndSelectionByVirtualInput);
        }
        dsToIndex.entrySet().parallelStream().forEach(entry -> {
            DatasetAndSelection dsAndSel = (DatasetAndSelection)entry.getValue();
            DatasetPreFilterKey datasetPreFilterKey = (DatasetPreFilterKey)entry.getKey();
            DatasetLocUtils.DatasetLoc dsLoc = datasetPreFilterKey.datasetLoc;
            try {
                SpillableIndexableDataSource joinedDataSource = new SpillableIndexableDataSource(dsAndSel);
                logger.infoV("Indexing dataset: %s", new Object[]{dsLoc.getFullName()});
                joinedDataSource.spillAndIndex((Set)joinColumnsPerDS.get(dsLoc), (Set)outputColumnsPerDS.get(dsLoc), authCtx);
                Map<DatasetPreFilterKey, SpillableIndexableDataSource> map = this.spilledSources;
                synchronized (map) {
                    this.spilledSources.put(datasetPreFilterKey, joinedDataSource);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to stream and index input: %s", dsLoc.getFullName()), e);
            }
        });
    }

    private void emitRowsFromMemtable(ProcessorOutput recipeOut, GeoJoinInputsHelper inputsHelper, MemTable mt) throws Exception {
        logger.infoV("Starting to enrich and emit %d rows from memory table", new Object[]{mt.nrowsNotDeleted()});
        for (MemRow mtRow : mt.rows) {
            if (mtRow.isDeleted()) continue;
            Row outRow = this.rf.row();
            for (Map.Entry<Integer, Set<ColumnDesc>> entry : inputsHelper.outputColumnsPerVirtualInput.entrySet()) {
                Integer vInputIdx = entry.getKey();
                Set<ColumnDesc> outputCols = entry.getValue();
                if (outputCols.isEmpty()) continue;
                JoinInputDescBase inputDescBase = (JoinInputDescBase)this.params.virtualInputs.get(vInputIdx);
                DatasetLocUtils.DatasetLoc datasetLoc = this.getDatasetLocByInputIdx(inputDescBase.index);
                FilterDesc filterDesc = inputDescBase.preFilter;
                String spilledRowId = mtRow.get(String.valueOf(vInputIdx));
                if (spilledRowId == null) continue;
                Row spilledRow = this.spilledSources.get(this.createDatasetPreFilterKey(datasetLoc, filterDesc)).getRowByNumber(Long.parseLong(spilledRowId));
                for (ColumnDesc cd : outputCols) {
                    StreamColumn column = this.cf.column(cd.alias != null ? cd.alias : cd.name);
                    outRow.put((Column)column, spilledRow.get((Column)this.cf.column(cd.name)));
                }
            }
            recipeOut.emitRow(outRow);
        }
    }

    private Row copyRow(MemTable mt, MemRow row) {
        Row newRow = mt.row();
        for (MemColumn col : mt.columnsList) {
            newRow.put((Column)col, row.get(col));
        }
        return newRow;
    }

    private Row createOutputRow(MemTable mt, int streamedInputIdx, long streamedRowNum, int joinedInputIdx, String joinedRowNum, SpillableIndexableDataSource joinedDataSource) {
        MemRow res = this.createPreparedRowForMemTable(mt, streamedInputIdx, streamedRowNum);
        SimpleFeature joinedFeature = joinedDataSource.getFeatureById(Long.parseLong(joinedRowNum));
        this.addColumnsFromJoinedDataSource(res, mt, joinedInputIdx, Long.parseLong(joinedFeature.getID()));
        return res;
    }

    private void addColumnsFromJoinedDataSource(Row res, ColumnFactory mt, int inputIdx, long rowId) {
        res.put(mt.column(String.valueOf(inputIdx)), rowId);
    }

    private MemRow createPreparedRowForMemTable(MemTable mt, int inputIdx, long rowId) {
        Row res = mt.row();
        this.addColumnsFromJoinedDataSource(res, mt, inputIdx, rowId);
        return (MemRow)res;
    }

    private Row createOutputRow(Row streamedRow, Set<ColumnDesc> streamedCols, Row storedRow, Set<ColumnDesc> storedCols) {
        Row out = this.extractColumns(streamedRow, streamedCols);
        this.fillRowFromDataSource(storedCols, storedRow, out);
        return out;
    }

    private Row createOutputRow(Row currRow, Set<ColumnDesc> leftCols, Set<ColumnDesc> rightCols, String spillId, SpillableIndexableDataSource joinedDataSource) throws IOException {
        Row out = this.extractColumns(currRow, leftCols);
        Row spilledRow = joinedDataSource.getRowByNumber(Long.parseLong(spillId));
        this.fillRowFromDataSource(rightCols, spilledRow, out);
        return out;
    }

    private void fillRowFromDataSource(Set<ColumnDesc> rightCols, Row spilledRow, Row out) {
        if (rightCols != null) {
            for (ColumnDesc col : rightCols) {
                StreamColumn column = this.cf.column(col.alias != null ? col.alias : col.name);
                out.put((Column)column, spilledRow.get((Column)this.cf.column(col.name)));
            }
        }
    }

    private Row extractColumns(Row currRow, Set<ColumnDesc> columns) {
        Row out = this.rf.row();
        if (columns != null) {
            for (ColumnDesc col : columns) {
                StreamColumn column = this.cf.column(col.alias != null ? col.alias : col.name);
                out.put((Column)column, currRow.get((Column)this.cf.column(col.name)));
            }
        }
        return out;
    }

    private Filter createFilter(Integer joinedTableIdx, GeoJoinRecipePayloadParams.JoinDesc joinDesc, Row currentResRow, ColumnFactory cf) throws Exception {
        return this.createFilter(joinedTableIdx, joinDesc, currentResRow, cf, false);
    }

    private Filter createFilter(Integer joinedTableIdx, GeoJoinRecipePayloadParams.JoinDesc joinDesc, Row streamedRow, ColumnFactory cf, boolean readQueryValueFromSpill) throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        GeometryMeaning geometryMeaning = new GeometryMeaning();
        ArrayList<BinarySpatialOperator> filters = new ArrayList<BinarySpatialOperator>();
        for (GeoJoinRecipePayloadParams.MatchingCondition mc : joinDesc.on) {
            String queryValStr;
            ColumnDesc streamedTableCol;
            ColumnDesc joinedTableCol = joinDesc.table1 == joinedTableIdx ? mc.column1 : mc.column2;
            ColumnDesc columnDesc = streamedTableCol = joinDesc.table1 == joinedTableIdx ? mc.column2 : mc.column1;
            if (readQueryValueFromSpill) {
                int streamedTableIdx = joinDesc.table1 == joinedTableIdx ? joinDesc.table2 : joinDesc.table1;
                DatasetLocUtils.DatasetLoc datasetLoc = this.getDatasetLocByInputIdx(streamedTableIdx);
                FilterDesc filterDesc = ((JoinInputDescBase)this.params.virtualInputs.get((int)streamedTableIdx)).preFilter;
                String spilledRowId = streamedRow.get(cf.column(String.valueOf(streamedTableIdx)));
                queryValStr = this.readValueFromSpill(datasetLoc, spilledRowId, streamedTableCol.name, filterDesc);
            } else {
                queryValStr = streamedRow.get(cf.column(streamedTableCol.name));
            }
            if (queryValStr != null) {
                Geometry queryVal = geometryMeaning.toGeometry(queryValStr);
                if (queryVal == null) {
                    return Filter.EXCLUDE;
                }
                filters.add(this.createJoinOperator(mc, ff.property(joinedTableCol.name), ff.literal((Object)queryVal), ff));
                continue;
            }
            return Filter.EXCLUDE;
        }
        switch (joinDesc.conditionsMode) {
            case AND: {
                return ff.and(filters);
            }
            case OR: {
                return ff.or(filters);
            }
        }
        throw new RuntimeException("Join conditions should be linked with either AND or OR");
    }

    private String readValueFromSpill(DatasetLocUtils.DatasetLoc datasetLoc, String spilledRowId, String columnName, FilterDesc filterDesc) throws Exception {
        if (spilledRowId == null) {
            return null;
        }
        try {
            SpillableIndexableDataSource spill = this.spilledSources.get(this.createDatasetPreFilterKey(datasetLoc, filterDesc));
            Row rowFromSpill = spill.getRowByNumber(Long.parseLong(spilledRowId));
            return rowFromSpill.get((Column)new StreamColumnFactory().column(columnName));
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Failed to read row #%s from spill: %s", new Object[]{spilledRowId, datasetLoc.getFullName()});
            return null;
        }
    }

    private BinarySpatialOperator createJoinOperator(GeoJoinRecipePayloadParams.MatchingCondition mc, PropertyName property, Literal literal, FilterFactory2 ff) {
        switch (mc.type) {
            case EQ: {
                return ff.equal((Expression)property, (Expression)literal);
            }
            case DWITHIN: {
                return ff.dwithin((Expression)property, (Expression)literal, GeoUtils.convertToMeters(mc.threshold, mc.unit), "m");
            }
            case WITHIN: {
                return ff.contains((Expression)property, (Expression)literal);
            }
            case BEYOND: {
                return ff.beyond((Expression)property, (Expression)literal, GeoUtils.convertToMeters(mc.threshold, mc.unit), "m");
            }
            case TOUCHES: {
                return ff.touches((Expression)property, (Expression)literal);
            }
            case CONTAINS: {
                return ff.within((Expression)property, (Expression)literal);
            }
            case DISJOINT: {
                return ff.disjoint((Expression)property, (Expression)literal);
            }
            case INTERSECTS: {
                return ff.intersects((Expression)property, (Expression)literal);
            }
        }
        throw new IllegalArgumentException("Unsupported join operator: " + mc.type.name());
    }

    private StreamableDatasetSelection prepareDataSelection(JoinInputDescBase input, Dataset inputDS, VariablesContext variablesContext) {
        FlowDataset fdSource = new FlowDataset(inputDS);
        StreamableDatasetSelection dataSelection = StreamableDatasetSelection.full();
        if (inputDS.getPartitioningSchema().isPartitioned()) {
            dataSelection.withSelectedPartitions(this.activity.getSubgraph().getSourcePartitions(fdSource));
        }
        ArrayList filters = Lists.newArrayList();
        FilterDesc inputPreFilter = this.expandFilter(input.preFilter, variablesContext);
        if (FilterDescUtils.willFilter(inputPreFilter)) {
            filters.add(inputPreFilter);
        }
        if (filters.size() > 0) {
            dataSelection.filter = FilterDesc.andFilter((FilterDesc[])filters.toArray(new FilterDesc[0]));
        }
        if (input.preFilter != null) {
            dataSelection.filter.distinct = input.preFilter.distinct;
        }
        return dataSelection;
    }

    DatasetLocUtils.DatasetLoc getDatasetLocByInputIdx(int index) {
        SerializedRecipe.RecipeInput recipeInput = this.recipe.getModel().getInputsForRole("main").get(index);
        return DatasetLocUtils.resolveSmart(this.recipe.getProjectKey(), recipeInput.ref);
    }

    private DatasetAndSelection getDatasetAndSelectionByVirtualInput(Integer virtualInputIdx, VariablesContext variablesContext) throws IOException {
        JoinInputDescBase streamedInput = (JoinInputDescBase)this.params.virtualInputs.get(virtualInputIdx);
        DatasetLocUtils.DatasetLoc dloc = this.getDatasetLocByInputIdx(streamedInput.index);
        Dataset dataset = this.datasetAccessService.getMandatory(dloc);
        StreamableDatasetSelection streamableDatasetSelection = this.prepareDataSelection(streamedInput, dataset, variablesContext);
        return new DatasetAndSelection(dataset, streamableDatasetSelection);
    }

    private FilterDesc expandFilter(FilterDesc filterDesc, VariablesContext vc) {
        FilterDesc expandedFilterDesc = (FilterDesc)JSON.deepCopy((Object)filterDesc);
        if (vc != null && expandedFilterDesc != null) {
            FilterDescUtils.expandExpressionIfNeeded(expandedFilterDesc, vc);
        }
        return expandedFilterDesc;
    }

    static {
        System.setProperty("org.opengis.filter.FilterFactory", "com.dataiku.dip.dataflow.exec.geojoin.DkuFilterFactory");
        logger = DKULogger.getLogger((String)"dku.recipes.geojoin.builtinrunner");
    }

    private class GeoJoiner {
        Set<FeatureId> joinedRows = new HashSet<FeatureId>();
        GeoJoinRecipePayloadParams.JoinDesc joinDesc;

        public GeoJoiner(GeoJoinRecipePayloadParams.JoinDesc joinDesc) {
            this.joinDesc = joinDesc;
        }

        void joinStreamIntoOutput(RowInputStream stream, int joinedInputIdx, ProcessorOutput recipeOut, SpillableIndexableDataSource joinedDataSource, Set<ColumnDesc> streamedInputOutCols, Set<ColumnDesc> indexedInputOutCols) throws Exception {
            LoggingOutput output = new LoggingOutput(recipeOut, 10000);
            LoggingInput input = new LoggingInput(stream, 10000);
            Row streamedRow = input.next();
            while (streamedRow != null) {
                if (this.joinDesc.type == JoinType.CROSS) {
                    for (Long rowId : joinedDataSource.spilledRowsPositionsByRowNumber.keySet()) {
                        Row outputRow = GeoJoinRecipeBuiltinRunner.this.createOutputRow(streamedRow, streamedInputOutCols, joinedDataSource.getRowByNumber(rowId), indexedInputOutCols);
                        output.emitRow(outputRow);
                    }
                } else {
                    Filter filter = GeoJoinRecipeBuiltinRunner.this.createFilter(joinedInputIdx, this.joinDesc, streamedRow, (ColumnFactory)GeoJoinRecipeBuiltinRunner.this.cf);
                    SimpleFeatureIterator matchingRecords = joinedDataSource.getIndexedDataSource().getFeatures(filter).features();
                    if (matchingRecords.hasNext()) {
                        while (matchingRecords.hasNext()) {
                            SimpleFeature joinedFeatures = (SimpleFeature)matchingRecords.next();
                            if (this.joinDesc.type == JoinType.RIGHT || this.joinDesc.type == JoinType.FULL) {
                                this.joinedRows.add((FeatureId)new FeatureIdImpl(joinedFeatures.getID()));
                            }
                            Row outputRow = GeoJoinRecipeBuiltinRunner.this.createOutputRow(streamedRow, streamedInputOutCols, indexedInputOutCols, joinedFeatures.getID(), joinedDataSource);
                            output.emitRow(outputRow);
                        }
                    } else if (this.joinDesc.type == JoinType.LEFT || this.joinDesc.type == JoinType.FULL) {
                        output.emitRow(GeoJoinRecipeBuiltinRunner.this.extractColumns(streamedRow, streamedInputOutCols));
                    }
                }
                streamedRow = input.next();
            }
            if (this.joinDesc.type == JoinType.RIGHT || this.joinDesc.type == JoinType.FULL) {
                for (Long rowId : joinedDataSource.spilledRowsPositionsByRowNumber.keySet()) {
                    if (this.joinedRows.contains(new FeatureIdImpl(String.valueOf(rowId)))) continue;
                    output.emitRow(GeoJoinRecipeBuiltinRunner.this.extractColumns(joinedDataSource.getRowByNumber(rowId), indexedInputOutCols));
                }
            }
        }

        private MemTable joinStreamIntoMemTable(SpillableIndexableDataSource.SpilledRowInputStream stream, int indexedInputIdx, SpillableIndexableDataSource joinedDataSource) throws Exception {
            int streamedInputIdx = 0;
            MemTable mt = new MemTable();
            LoggingOutput out = new LoggingOutput((ProcessorOutput)new MemTableAppendingOutput(mt), 10000);
            NumberedRow numberedRow = stream.next();
            while (numberedRow != null) {
                Row streamedRow = numberedRow.row;
                if (this.joinDesc.type == JoinType.CROSS) {
                    for (Long rowId : joinedDataSource.spilledRowsPositionsByRowNumber.keySet()) {
                        MemRow outRow = GeoJoinRecipeBuiltinRunner.this.createPreparedRowForMemTable(mt, streamedInputIdx, numberedRow.number);
                        GeoJoinRecipeBuiltinRunner.this.addColumnsFromJoinedDataSource(outRow, mt, indexedInputIdx, rowId);
                        out.emitRow(outRow);
                    }
                } else {
                    Filter filter = GeoJoinRecipeBuiltinRunner.this.createFilter(indexedInputIdx, this.joinDesc, streamedRow, (ColumnFactory)GeoJoinRecipeBuiltinRunner.this.cf);
                    SimpleFeatureIterator matchingRecords = joinedDataSource.getIndexedDataSource().getFeatures(filter).features();
                    if (matchingRecords.hasNext()) {
                        while (matchingRecords.hasNext()) {
                            SimpleFeature joinedFeatures = (SimpleFeature)matchingRecords.next();
                            if (this.joinDesc.type == JoinType.RIGHT || this.joinDesc.type == JoinType.FULL) {
                                this.joinedRows.add((FeatureId)new FeatureIdImpl(joinedFeatures.getID()));
                            }
                            Row outputRow = GeoJoinRecipeBuiltinRunner.this.createOutputRow(mt, streamedInputIdx, numberedRow.number, indexedInputIdx, joinedFeatures.getID(), joinedDataSource);
                            out.emitRow(outputRow);
                        }
                    } else if (this.joinDesc.type == JoinType.LEFT || this.joinDesc.type == JoinType.FULL) {
                        out.emitRow(GeoJoinRecipeBuiltinRunner.this.createPreparedRowForMemTable(mt, streamedInputIdx, numberedRow.number));
                    }
                }
                numberedRow = stream.next();
            }
            if (this.joinDesc.type == JoinType.RIGHT || this.joinDesc.type == JoinType.FULL) {
                for (Long rowId : joinedDataSource.spilledRowsPositionsByRowNumber.keySet()) {
                    if (this.joinedRows.contains(new FeatureIdImpl(String.valueOf(rowId)))) continue;
                    out.emitRow(GeoJoinRecipeBuiltinRunner.this.createPreparedRowForMemTable(mt, indexedInputIdx, rowId));
                }
            }
            joinedDataSource.reader.close();
            return mt;
        }

        private void joinMemTableIntoMemTable(MemTable mt, int indexedInputIdx, SpillableIndexableDataSource joinedDataSource) throws Exception {
            LoggingOutput output = new LoggingOutput((ProcessorOutput)new MemTableAppendingOutput(mt), 10000);
            for (int i = mt.rows.size() - 1; i >= 0; --i) {
                MemRow row = mt.rows.get(i);
                if (this.joinDesc.type == JoinType.CROSS) {
                    boolean isFirstMatch = true;
                    for (Long storedRowId : joinedDataSource.spilledRowsPositionsByRowNumber.keySet()) {
                        if (isFirstMatch) {
                            GeoJoinRecipeBuiltinRunner.this.addColumnsFromJoinedDataSource(row, mt, indexedInputIdx, storedRowId);
                            isFirstMatch = false;
                            continue;
                        }
                        Row newRow = GeoJoinRecipeBuiltinRunner.this.copyRow(mt, row);
                        GeoJoinRecipeBuiltinRunner.this.addColumnsFromJoinedDataSource(newRow, mt, indexedInputIdx, storedRowId);
                        output.emitRow(newRow);
                    }
                    continue;
                }
                Filter filter = GeoJoinRecipeBuiltinRunner.this.createFilter(indexedInputIdx, this.joinDesc, row, mt, true);
                SimpleFeatureIterator matchingRecords = joinedDataSource.getIndexedDataSource().getFeatures(filter).features();
                if (matchingRecords.hasNext()) {
                    boolean isFirstMatch = true;
                    while (matchingRecords.hasNext()) {
                        SimpleFeature joinedFeatures = (SimpleFeature)matchingRecords.next();
                        if (this.joinDesc.type == JoinType.RIGHT || this.joinDesc.type == JoinType.FULL) {
                            this.joinedRows.add((FeatureId)new FeatureIdImpl(joinedFeatures.getID()));
                        }
                        if (isFirstMatch) {
                            GeoJoinRecipeBuiltinRunner.this.addColumnsFromJoinedDataSource(row, mt, indexedInputIdx, Long.parseLong(joinedFeatures.getID()));
                            isFirstMatch = false;
                            continue;
                        }
                        Row newRow = GeoJoinRecipeBuiltinRunner.this.copyRow(mt, row);
                        GeoJoinRecipeBuiltinRunner.this.addColumnsFromJoinedDataSource(newRow, mt, indexedInputIdx, Long.parseLong(joinedFeatures.getID()));
                        output.emitRow(newRow);
                    }
                    continue;
                }
                if (this.joinDesc.type == JoinType.LEFT || this.joinDesc.type == JoinType.FULL) continue;
                row.delete();
            }
            if (this.joinDesc.type == JoinType.RIGHT || this.joinDesc.type == JoinType.FULL) {
                SimpleFeatureIterator allFeatures = joinedDataSource.getIndexedDataSource().getFeatures().features();
                while (allFeatures.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)allFeatures.next();
                    if (this.joinedRows.contains(new FeatureIdImpl(String.valueOf(feature.getID())))) continue;
                    Row row = mt.row();
                    GeoJoinRecipeBuiltinRunner.this.addColumnsFromJoinedDataSource(row, mt, indexedInputIdx, Long.parseLong(feature.getID()));
                    output.emitRow(row);
                }
            }
        }
    }

    private static class LoggingOutput
    implements ProcessorOutput {
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin.builtinrunner.output");
        private final ProcessorOutput originalOutput;
        private final int logEvery;
        int emittedRows;

        public LoggingOutput(ProcessorOutput originalOutput, int logEvery) {
            this.originalOutput = originalOutput;
            this.logEvery = logEvery;
        }

        public void emitRow(Row row) throws Exception {
            if (this.emittedRows == 0) {
                logger.infoV("Started emitting rows", new Object[0]);
            } else if (this.emittedRows % this.logEvery == 0) {
                logger.infoV("Emitted %d rows", new Object[]{this.emittedRows});
            }
            this.originalOutput.emitRow(row);
            ++this.emittedRows;
        }

        public void lastRowEmitted() throws Exception {
            logger.infoV("Done emitting rows", new Object[0]);
            this.originalOutput.lastRowEmitted();
        }

        public void cancel() throws Exception {
            this.originalOutput.cancel();
        }

        public void setMaxMemoryUsed(long size) {
            this.originalOutput.setMaxMemoryUsed(size);
        }
    }

    private static class LoggingInput
    implements RowInputStream {
        private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin.builtinrunner.input");
        private final RowInputStream originalInput;
        private final int logEvery;
        int streamedRows;

        public LoggingInput(RowInputStream originalInput, int logEvery) {
            this.originalInput = originalInput;
            this.logEvery = logEvery;
        }

        public Row next() throws Exception {
            if (this.streamedRows == 0) {
                logger.infoV("Started streaming rows", new Object[0]);
            } else if (this.streamedRows % this.logEvery == 0) {
                logger.infoV("Streamed %d rows", new Object[]{this.streamedRows});
            }
            ++this.streamedRows;
            return this.originalInput.next();
        }
    }
}

