/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.split.SplitRecipeStatusComputer;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private SplitRecipeService service;
    @Autowired
    private TransactionService transactionService;
    private SplitRecipePayloadParams params;
    private String payload;

    public SplitRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.payload = payload;
        this.params = this.service.loadParams(payload, this.activity, this.recipe.projectKey);
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            Schema schema = this.getSchema();
            ArrayList<Schema> ret = new ArrayList<Schema>();
            for (int i = 0; i < this.recipe.getOutputsForRole(role).size(); ++i) {
                ret.add(new Schema(schema));
            }
            ArrayList<Schema> arrayList = ret;
            return arrayList;
        }
    }

    private Schema getSchema() throws Exception {
        AnyLoc inputLoc = this.recipe.getSingleInput("main").getLoc(this.recipe.projectKey);
        Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
        SplitRecipeStatusComputer sc = new SplitRecipeStatusComputer(this.recipe, this.payload);
        SplitRecipeStatusComputer.SplitRecipeStatus status = sc.fastStatusIgnorePartitions(this.authCtx);
        boolean lowerCase = "HIVE".equals(status.selectedEngine.type) || "IMPALA".equals(status.selectedEngine.type);
        return this.service.getOutputSchema(inputDataset, this.params, lowerCase);
    }
}

