/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.dqmetrics;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInSetMetric;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.ImpalaMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class ValuesInSetSQLLikeComputer {
    public static void addAggregations(MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder) throws Exception {
        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        ValuesInSetMetric metric = (ValuesInSetMetric)computation.metric;
        List valuesExceptEmpty = metric.values.stream().distinct().filter(s -> s != null && !s.isEmpty()).collect(Collectors.toList());
        queryBuilder.where(ebf.col(metric.getColumn()).isnotnull());
        if (!valuesExceptEmpty.isEmpty()) {
            queryBuilder.where(ebf.col(metric.getColumn()).castToString(dialect.getDefaultVarcharLen()).inList(valuesExceptEmpty).not());
        }
        queryBuilder.select(ebf.col(metric.getColumn()).distinct());
    }

    public static String getAggregate(QueryRunResult rs2, int maxOutlierCount) throws Exception {
        ArrayList<String> outliers = new ArrayList<String>();
        for (String[] row : rs2.rows) {
            if (row[0] == null || row[0].isEmpty()) continue;
            outliers.add(row[0]);
            if (outliers.size() <= maxOutlierCount) continue;
            break;
        }
        return JSON.json(outliers);
    }

    public static class ValuesInSetSparkComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET) {
                return new SparkMetricsEngine.SparkMetricsEngineRun().neverMergeable().with(new MetricComputation(probe, this, metric, 3.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInSetSQLLikeComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInSetSQLLikeComputer.getAggregate(rs2, ((ValuesInSetMetric)computation.metric).maxOutlierCount);
        }
    }

    public static class ValuesInSetHiveComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                return new HiveMetricsEngine.HiveMetricsEngineRun().neverMergeable().with(new MetricComputation(probe, this, metric, 2.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInSetSQLLikeComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInSetSQLLikeComputer.getAggregate(rs2, ((ValuesInSetMetric)computation.metric).maxOutlierCount);
        }
    }

    public static class ValuesInSetImpalaComputer
    extends MetricComputer.ImpalaMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                return new ImpalaMetricsEngine.ImpalaMetricsEngineRun(null).neverMergeable().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInSetSQLLikeComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInSetSQLLikeComputer.getAggregate(rs2, ((ValuesInSetMetric)computation.metric).maxOutlierCount);
        }
    }

    public static class ValuesInSetSQLComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return "temporary_metrics_probe";
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                return new SQLMetricsEngine.SQLMetricsEngineRun().neverMergeable().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            ValuesInSetSQLLikeComputer.addAggregations(computation, dialect, queryBuilder);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return ValuesInSetSQLLikeComputer.getAggregate(rs2, ((ValuesInSetMetric)computation.metric).maxOutlierCount);
        }
    }
}

