/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AzureBlobDatasetTestHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class AzureBlobDatasetHandler
extends BlobLikeDatasetHandler<BuiltinFSDatasets.AzureBlobDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler,
MetastoreAwareDatasetHandler {
    private final PasswordEncryptionService symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
    private final HDFSInterface hdfsInterface;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.azure");

    public AzureBlobDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        AzureConnection conn;
        ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).container = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).container);
        ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreDatabaseName = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreDatabaseName);
        ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreTableName = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreTableName);
        logger.info((Object)("Building Azure handler config: " + JSON.json((Object)this.resolvedConfig)));
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Failed to get Azure connection", (Throwable)e);
        }
        this.hdfsInterface = conn.params.hdfsInterface;
        if (this.hdfsInterface == null) {
            throw ErrorContext.iae((String)"Invalid HDFS interface for Azure connection");
        }
    }

    @Override
    public String getDSSConnectionForHive() {
        throw new IllegalArgumentException("unreachable");
    }

    @Override
    public SQLUtils.SQLTable getResolvedHiveTableRef(boolean databaseIsMandatory) {
        String database = null;
        database = !StringUtils.isBlank((String)((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreDatabaseName) ? ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreDatabaseName : this.getConnection().params.defaultMetastoreDatabase;
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine metastore database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        String table = null;
        table = !StringUtils.isBlank((String)((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreTableName) ? ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).metastoreTableName : this.dataset.getName();
        String schema = database == null ? null : database.toLowerCase(Locale.ENGLISH);
        String table1 = table == null ? null : table.toLowerCase(Locale.ENGLISH);
        return new SQLUtils.SQLTable(null, schema, table1, true);
    }

    @Override
    public SQLUtils.SQLTable getUnresolvedHiveTableRef() {
        String database = null;
        BuiltinFSDatasets.AzureBlobDatasetConfig rawConfig = (BuiltinFSDatasets.AzureBlobDatasetConfig)this.config;
        database = !StringUtils.isBlank((String)rawConfig.metastoreDatabaseName) ? rawConfig.metastoreDatabaseName : this.getConnection().params.defaultMetastoreDatabase;
        String table = null;
        table = !StringUtils.isBlank((String)rawConfig.metastoreTableName) ? rawConfig.metastoreTableName : this.dataset.getName();
        return new SQLUtils.SQLTable(null, database, table, true);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, CodedException, DKUSecurityException {
        String providerPath = path == null ? ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("Azure", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    public AzureConnection getConnection() {
        try {
            AzureConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).connection, AzureConnection.class);
            return connection;
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get connection", e);
        }
    }

    @Override
    public DSSConnection getHDFSAbleConnection() {
        return this.getConnection();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.AZURE_META;
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException, CodedException {
        if (StringUtils.isBlank((String)((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).path)) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Invalid Azure dataset configuration: no path specified");
        }
        if (StringUtils.isBlank((String)this.getContainer())) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Invalid Azure dataset configuration: no container specified");
        }
        super.checkConfiguration();
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        return new AzureBlobDatasetTestHandler(this.authCtx, this, this, this.dataset);
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        String providerRoot = "azure://" + this.getContainer() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
        if (this.isSingleFile()) {
            return providerRoot + "/" + this.getSingleFile();
        }
        return providerRoot;
    }

    public String getContainer() {
        if (StringUtils.isNotBlank((String)this.getConnection().params.chcontainer)) {
            return this.getConnection().params.chcontainer;
        }
        return ((BuiltinFSDatasets.AzureBlobDatasetConfig)this.resolvedConfig).container;
    }

    @Override
    public String getFullyQualifiedRootPath() throws IOException, DKUSecurityException, CodedException {
        return this.getFullyQualifiedRootPath(this.hdfsInterface);
    }

    public String getFullyQualifiedRootPath(HDFSInterface hdfsInterface) throws IOException, DKUSecurityException, CodedException {
        String scheme;
        String location;
        if (hdfsInterface == null) {
            hdfsInterface = this.hdfsInterface;
        }
        AzureConnection conn = this.getConnection();
        switch (hdfsInterface) {
            case NONE: {
                return null;
            }
            case WASB: 
            case ABFS: {
                location = conn.getHDFSLocation();
                scheme = conn.getHDFSScheme();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        String providerRoot = String.format("%s://%s@%s.%s%s", scheme, this.getContainer(), conn.params.storageAccount, location, PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket()));
        if (this.isSingleFile()) {
            return providerRoot + "/" + this.getSingleFile();
        }
        return providerRoot;
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getHDFSExtraConf() throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        AzureConnection conn = this.getConnection();
        ret.addAll(conn.getHadoopConfigForAzureAccess(this.authCtx));
        return ret;
    }

    public String getRootPathForSnowflakeFastPath() throws CodedException, IOException, DKUSecurityException {
        AzureConnection connection = this.getConnection();
        AzureConnection.AzureParam params = connection.params;
        String rootWithinBucket = PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
        Object providerRoot = String.format("azure://%s.blob.core.windows.net/%s%s/", params.storageAccount, params.getDefaultManagedContainer(), rootWithinBucket);
        if (this.isSingleFile()) {
            providerRoot = (String)providerRoot + this.getSingleFile();
        }
        if (StringUtils.isNotBlank((String)params.snowflakeExternalStageName) && StringUtils.isNotBlank((String)params.snowflakeExternalStagePath)) {
            String pathToReplace = PathUtils.makeNotLeadingNoTrailing((String)params.snowflakeExternalStagePath);
            if (!pathToReplace.startsWith("azure://")) {
                pathToReplace = String.format("azure://%s.blob.core.windows.net/%s", params.storageAccount, pathToReplace);
            }
            providerRoot = FastpathUtils.placeSnowflakeStageInRootPath((String)providerRoot, pathToReplace, params.snowflakeExternalStageName, connection.name);
        }
        return providerRoot;
    }

    public static enum HDFSInterface {
        WASB,
        ABFS,
        NONE;

    }
}

