/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.discussions;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.AddColumnQueryBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryBuilderUtils;
import com.dataiku.dip.sql.queries.UpsertQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DiscussionsInternalDB
extends AbstractDSSDBService {
    private static final int SCHEMA_VERSION = 2;
    private static final String ERR_MSG_DISC_ID_NOT_SPEC = "Discussion id not specified";
    private static final String DB_NAME = "discussions";
    private static final int MAX_TOPIC_LENGTH = 200;
    private static final int MAX_REPLY_LENGTH = 10000;
    private static final String discussionsTable = "DISCUSSIONS";
    private static final String discussionsRepliesTable = "DISCUSSIONS_REPLIES";
    private static final String discussionsAckTable = "DISCUSSIONS_ACK";
    private static final String projectKeyField = "PROJECT_KEY";
    private static final String workspaceKeyField = "WORKSPACE_KEY";
    private static final String discussionIdField = "DISCUSSION_ID";
    private static final String topicField = "TOPIC";
    private static final String objectTypeField = "OBJECT_TYPE";
    private static final String objectIdField = "OBJECT_ID";
    private static final String closedOnField = "CLOSED_ON";
    private static final String closedByField = "CLOSED_BY";
    private static final String lastReplyTimeField = "LAST_REPLY_TIME";
    private static final String replyIdField = "REPLY_ID";
    private static final String textField = "TEXT";
    private static final String authorField = "AUTHOR";
    private static final String timeField = "TIME";
    private static final String editedOnField = "EDITED_ON";
    private static final String userField = "USER";
    private final String insertDiscussion = InsertQueryBuilder.insertInto(this.resolveTable("DISCUSSIONS")).addColumns(discussionsColumns).toSQL(this.getDialect());
    private final String insertReply = InsertQueryBuilder.insertInto(this.resolveTable("DISCUSSIONS_REPLIES")).addColumns(discussionsRepliesColumns).toSQL(this.getDialect());
    private final String updateReply = "UPDATE " + this.getQuotedFullResolvedTableName("DISCUSSIONS_REPLIES") + " SET " + this.quote("TEXT") + "=?, " + this.quote("EDITED_ON") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("REPLY_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String mergeDiscussionAck = UpsertQueryBuilder.into(this.resolveTable("DISCUSSIONS_ACK")).addKeyColumns("PROJECT_KEY", "DISCUSSION_ID", "USER", "WORKSPACE_KEY").addColumns(discussionsAckColumns).toSQL(this.getDialect());
    private final String setDiscussion = "UPDATE " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " SET " + this.quote("OBJECT_TYPE") + "=?, " + this.quote("OBJECT_ID") + "=?, " + this.quote("TOPIC") + "=?, " + this.quote("CLOSED_ON") + "=?, " + this.quote("CLOSED_BY") + "=?, " + this.quote("LAST_REPLY_TIME") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String updateDiscussion = "UPDATE " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " SET " + this.quote("OBJECT_TYPE") + "=?, " + this.quote("OBJECT_ID") + "=?, " + this.quote("TOPIC") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String closeDiscussion = "UPDATE " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " SET " + this.quote("CLOSED_ON") + "=?, " + this.quote("CLOSED_BY") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String updateLastReplyTime = "UPDATE " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " SET " + this.quote("LAST_REPLY_TIME") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String getDiscussion = "SELECT * FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String getDiscussionsForObject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String getDiscussionsForProject = "SELECT * FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("WORKSPACE_KEY") + "=''";
    private final String getDiscussionsForWorkspace = "SELECT * FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " WHERE " + this.quote("WORKSPACE_KEY") + "=? AND " + this.quote("PROJECT_KEY") + "=''";
    private final String deleteDiscussion = "DELETE FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String deleteDiscussionReplies = "DELETE FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS_REPLIES") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String deleteDiscussionAcks = "DELETE FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS_ACK") + " WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("DISCUSSION_ID") + "=? AND " + this.quote("WORKSPACE_KEY") + "=?";
    private final String getAllDiscussions = "SELECT * FROM " + this.getQuotedFullResolvedTableName("DISCUSSIONS");
    private final String changeObjectId = "UPDATE " + this.getQuotedFullResolvedTableName("DISCUSSIONS") + " SET " + this.quote("OBJECT_ID") + "=? WHERE " + this.quote("PROJECT_KEY") + "=? AND " + this.quote("OBJECT_TYPE") + "=? AND " + this.quote("OBJECT_ID") + "=?";
    private static final SchemaColumn PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("PROJECT_KEY", Type.STRING);
    private static final SchemaColumn WORKSPACE_KEY_SCHEMA_COLUMN = new SchemaColumn("WORKSPACE_KEY", Type.STRING);
    private static final SchemaColumn OBJECT_TYPE_SCHEMA_COLUMN = new SchemaColumn("OBJECT_TYPE", Type.STRING);
    private static final SchemaColumn OBJECT_ID_SCHEMA_COLUMN = new SchemaColumn("OBJECT_ID", Type.STRING);
    private static final SchemaColumn DISCUSSION_ID_SCHEMA_COLUMN = new SchemaColumn("DISCUSSION_ID", Type.STRING);
    private static final SchemaColumn[] discussionsColumns = new SchemaColumn[]{PROJECT_KEY_SCHEMA_COLUMN, DISCUSSION_ID_SCHEMA_COLUMN, new SchemaColumn("TOPIC", Type.STRING), OBJECT_TYPE_SCHEMA_COLUMN, OBJECT_ID_SCHEMA_COLUMN, new SchemaColumn("CLOSED_ON", Type.BIGINT), new SchemaColumn("CLOSED_BY", Type.STRING), new SchemaColumn("LAST_REPLY_TIME", Type.BIGINT), WORKSPACE_KEY_SCHEMA_COLUMN};
    private static final String[] discussionsIndexKeys = new String[]{"PROJECT_KEY", "OBJECT_TYPE", "OBJECT_ID", "WORKSPACE_KEY"};
    private static final SchemaColumn[] discussionsRepliesColumns = new SchemaColumn[]{PROJECT_KEY_SCHEMA_COLUMN, DISCUSSION_ID_SCHEMA_COLUMN, new SchemaColumn("REPLY_ID", Type.STRING), new SchemaColumn("TEXT", Type.STRING), new SchemaColumn("AUTHOR", Type.STRING), new SchemaColumn("TIME", Type.BIGINT), new SchemaColumn("EDITED_ON", Type.BIGINT), WORKSPACE_KEY_SCHEMA_COLUMN};
    private static final String[] discussionsRepliesKeys = new String[]{"PROJECT_KEY", "DISCUSSION_ID", "REPLY_ID", "WORKSPACE_KEY"};
    private static final SchemaColumn[] discussionsAckColumns = new SchemaColumn[]{PROJECT_KEY_SCHEMA_COLUMN, DISCUSSION_ID_SCHEMA_COLUMN, new SchemaColumn("USER", Type.STRING), new SchemaColumn("TIME", Type.BIGINT), WORKSPACE_KEY_SCHEMA_COLUMN};
    private static final String[] discussionsAckKeys = new String[]{"PROJECT_KEY", "DISCUSSION_ID", "USER", "WORKSPACE_KEY"};
    public static final List<String> TABLES = ImmutableList.of((Object)"DISCUSSIONS", (Object)"DISCUSSIONS_REPLIES", (Object)"DISCUSSIONS_ACK");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.discussions");

    public DiscussionsInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 2, false);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        Statement st2;
        if (currentSchemaVersion == 0) {
            st2 = conn.createStatement();
            try {
                this.createTable(discussionsTable, discussionsColumns, null, st2);
                this.createAnonymousIndex(discussionsTable, discussionsIndexKeys, st2);
                this.createTable(discussionsRepliesTable, discussionsRepliesColumns, null, st2);
                this.createAnonymousIndex(discussionsRepliesTable, discussionsRepliesKeys, st2);
                this.createTable(discussionsAckTable, discussionsAckColumns, discussionsAckKeys, st2);
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
        if (currentSchemaVersion == 1) {
            st2 = conn.createStatement();
            try {
                this.addWorkspaceIdToTable(st2, discussionsTable, discussionsIndexKeys);
                this.addWorkspaceIdToTable(st2, discussionsRepliesTable, discussionsRepliesKeys);
                this.addWorkspaceIdToTable(st2, discussionsAckTable, null);
                this.alterPrimaryKey(st2, discussionsAckTable, discussionsAckKeys);
                logger.debug((Object)"Workspace column added and filled");
            }
            finally {
                if (st2 != null) {
                    st2.close();
                }
            }
        }
    }

    private void alterPrimaryKey(Statement st2, String tableName, String[] keyColumns) throws SQLException {
        SQLDialect dialect = this.getDialect();
        this.dropPrimaryKey(st2, this.resolveTable(tableName));
        for (String newColumn : keyColumns) {
            st2.execute("ALTER TABLE " + dialect.getQuotedTableFullName(this.resolveTable(tableName)) + " ALTER COLUMN " + dialect.quoteIdentifier(newColumn) + " SET NOT NULL");
        }
        String addPrimaryKey = String.format("ALTER TABLE %s ADD PRIMARY KEY %s", dialect.getQuotedTableFullName(this.resolveTable(tableName)), QueryBuilderUtils.tuple(Arrays.asList(keyColumns), dialect));
        st2.execute(addPrimaryKey);
    }

    private void dropPrimaryKey(Statement st2, SQLUtils.SQLTable table) throws SQLException {
        SQLDialect dialect = this.getDialect();
        if (dialect instanceof MySQLDialect) {
            st2.execute(String.format("ALTER TABLE %s DROP PRIMARY KEY", dialect.getQuotedTableFullName(table)));
        } else {
            HashSet<String> constraints = new HashSet<String>();
            String query = String.format("select constraint_name from information_schema.%s WHERE table_name='%s' AND constraint_type='PRIMARY KEY'", dialect instanceof H2SQLDialect ? "constraints" : "table_constraints", table.getTable());
            try (ResultSet resultSet = st2.executeQuery(query);){
                while (resultSet.next()) {
                    constraints.add(resultSet.getString("constraint_name"));
                }
            }
            for (String constraintName : constraints) {
                st2.execute(String.format("ALTER TABLE %s DROP CONSTRAINT %s", dialect.getQuotedTableFullName(table), this.getDialect().quoteIdentifier(constraintName)));
            }
        }
    }

    private void addWorkspaceIdToTable(Statement st2, String tableName, String[] indexKeys) throws SQLException {
        logger.debugV("Adding a workspace key column to the discussions table: %s", new Object[]{tableName});
        AddColumnQueryBuilder.addColumnTo(this.resolveTable(tableName)).addColumns(WORKSPACE_KEY_SCHEMA_COLUMN).execute(st2, this.getDialect());
        if (indexKeys != null) {
            this.dropExistingIndexesOnTable(st2, this.resolveTable(tableName).getSchemaNullIfBlank(), this.resolveTable(tableName).getTable());
            this.createAnonymousIndex(tableName, indexKeys, st2);
        }
        String fillColumnQuery = String.format("UPDATE %s SET %s = '%s'", this.getDialect().getQuotedTableFullName(this.resolveTable(tableName)), this.getDialect().quoteIdentifier(WORKSPACE_KEY_SCHEMA_COLUMN.getName()), "");
        logger.debugV("Filling column workspaceId with empty value", new Object[0]);
        st2.execute(fillColumnQuery);
    }

    public void saveDiscussion(Discussion discussion, boolean creation) throws CodedSQLException {
        try {
            if (discussion.topic != null && discussion.topic.length() > 200) {
                throw new IllegalArgumentException("Discussion topic is too long: " + discussion.topic.length() + " (max length: 200)");
            }
            if (creation) {
                this.createDiscussion(discussion.projectKey, discussion.workspaceKey, discussion.objectType, discussion.objectId, discussion.id, discussion.topic);
            } else {
                this.updateDiscussion(discussion.projectKey, discussion.workspaceKey, discussion.objectType, discussion.objectId, discussion.id, discussion.topic);
            }
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    void importWholeDiscussion(Discussion discussion) throws CodedSQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussion.id), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussion.topic), (Object)"Discussion topic is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussion.objectId), (Object)"Discussion is not attached to any object");
        Preconditions.checkArgument((discussion.objectType != null ? 1 : 0) != 0, (Object)"Discussion object has no specified type");
        assert (discussion.objectType != null);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2;
            int i;
            int i2 = 0;
            PreparedStatement ps3 = this.getPreparedStatement(conn, this.insertDiscussion);
            ps3.setString(++i2, StringUtils.defaultString((String)discussion.projectKey, (String)""));
            ps3.setString(++i2, discussion.id);
            ps3.setString(++i2, discussion.topic);
            ps3.setString(++i2, discussion.objectType.toString());
            ps3.setString(++i2, discussion.objectId);
            ps3.setLong(++i2, discussion.closedOn);
            ps3.setString(++i2, discussion.closedBy);
            ps3.setLong(++i2, discussion.lastReplyTime);
            ps3.setString(++i2, StringUtils.defaultString((String)discussion.workspaceKey, (String)""));
            ps3.execute();
            for (Discussion.DiscussionReply reply : discussion.getReplies()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)reply.id), (Object)"Discussion reply id is not specified");
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)reply.author), (Object)"Author not specified");
                Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)reply.text), (Object)"Empty message");
                i = 0;
                ps2 = this.getPreparedStatement(conn, this.insertReply);
                ps2.setString(++i, StringUtils.defaultString((String)discussion.projectKey, (String)""));
                ps2.setString(++i, discussion.id);
                ps2.setString(++i, reply.id);
                ps2.setString(++i, reply.text);
                ps2.setString(++i, reply.author);
                ps2.setLong(++i, reply.time);
                ps2.setLong(++i, reply.editedOn);
                ps2.setString(++i, StringUtils.defaultString((String)discussion.workspaceKey, (String)""));
                ps2.execute();
            }
            for (Discussion.User userInfo : discussion.users.values()) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)userInfo.login), (Object)"User login not specified");
                i = 0;
                ps2 = this.getPreparedStatement(conn, this.mergeDiscussionAck);
                ps2.setString(++i, StringUtils.defaultString((String)discussion.projectKey, (String)""));
                ps2.setString(++i, discussion.id);
                ps2.setString(++i, userInfo.login);
                ps2.setLong(++i, userInfo.lastReadTime);
                ps2.setString(++i, StringUtils.defaultString((String)discussion.workspaceKey, (String)""));
                ps2.execute();
            }
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private void createDiscussion(@Nullable String projectKey, @Nullable String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String discussionId, String topic) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)topic), (Object)"Discussion topic is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"Discussion is not attached to any object");
        Preconditions.checkArgument((objectType != null ? 1 : 0) != 0, (Object)"Discussion object has no specified type");
        assert (objectType != null);
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertDiscussion);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, topic);
            ps2.setString(++i, objectType.toString());
            ps2.setString(++i, objectId);
            ps2.setLong(++i, 0L);
            ps2.setString(++i, "");
            ps2.setLong(++i, 0L);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
    }

    private void updateDiscussion(@Nullable String projectKey, @Nullable String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String discussionId, String topic) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)topic), (Object)"Discussion topic is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"Discussion is not attached to any object");
        Preconditions.checkArgument((objectType != null ? 1 : 0) != 0, (Object)"Discussion object has no specified type");
        assert (objectType != null);
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateDiscussion);
            ps2.setString(++i, objectType.toString());
            ps2.setString(++i, objectId);
            ps2.setString(++i, topic);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
    }

    void setDiscussion(String discussionId, @Nullable String projectKey, @Nullable String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String topic, long closedOn, String closedBy, long lastReplyTime) throws CodedSQLException {
        if (topic != null && topic.length() > 200) {
            throw new IllegalArgumentException("Discussion topic is too long: " + topic.length() + " (max length: 200)");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((StringUtils.isNotBlank((String)projectKey) || StringUtils.isNotBlank((String)workspaceKey) ? 1 : 0) != 0, (Object)"Either Project key or workspace key must be specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"Object id not specified");
        assert (objectType != null);
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.setDiscussion);
            ps2.setString(++i, objectType.toString());
            ps2.setString(++i, objectId);
            ps2.setString(++i, topic);
            ps2.setLong(++i, closedOn);
            ps2.setString(++i, closedBy);
            ps2.setLong(++i, lastReplyTime);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    void close(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId, boolean closed, String user) throws CodedSQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)user), (Object)"A user must be associated with a discussion resolution");
        try (DSSDBConnection conn = this.acquireConnection();){
            String user2;
            long time;
            if (closed) {
                time = System.currentTimeMillis();
                user2 = user;
            } else {
                time = 0L;
                user2 = "";
            }
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.closeDiscussion);
            ps2.setLong(++i, time);
            ps2.setString(++i, user2);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void saveReply(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId, Discussion.DiscussionReply reply, boolean newReply) throws CodedSQLException, NotFoundException {
        if (StringUtils.isEmpty((String)reply.text)) {
            throw new IllegalArgumentException("Empty discussion message");
        }
        if (reply.text.length() > 10000) {
            throw new IllegalArgumentException("Discussion message is too long: " + reply.text.length() + " (max length: 10000)");
        }
        try {
            if (newReply) {
                this.insertReply(projectKey, workspaceKey, discussionId, reply.id, reply.text, reply.author, reply.time);
            } else {
                this.updateReply(projectKey, workspaceKey, discussionId, reply.id, reply.text, reply.author, reply.editedOn);
            }
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private void insertReply(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId, String replyId, String text, String author, long time) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)replyId), (Object)"Discussion reply id is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)author), (Object)"Author not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)text), (Object)"Empty message");
        this.getDiscussion(projectKey, workspaceKey, discussionId);
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertReply);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, replyId);
            ps2.setString(++i, text);
            ps2.setString(++i, author);
            ps2.setLong(++i, time);
            ps2.setLong(++i, 0L);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            i = 0;
            ps2 = this.getPreparedStatement(conn, this.updateLastReplyTime);
            ps2.setLong(++i, time);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            i = 0;
            ps2 = this.getPreparedStatement(conn, this.mergeDiscussionAck);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, author);
            ps2.setLong(++i, time);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
    }

    private void updateReply(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId, String replyId, String text, String author, long editedOn) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)replyId), (Object)"Discussion reply id not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)author), (Object)"Author not specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getDiscussion(projectKey, workspaceKey, discussionId);
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateReply);
            ps2.setString(++i, text);
            ps2.setLong(++i, editedOn);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, replyId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
    }

    DiscussionCounts getCountsForObject(@Nullable String projectKey, @Nullable String workspaceKey, ITaggingService.TaggableType objectType, String objectId, String user) throws CodedSQLException {
        try {
            DiscussionCounts counts = new DiscussionCounts();
            List<Discussion> discussions = this.getDiscussionsForObjectNoReplies(projectKey, workspaceKey, objectType, objectId);
            counts.total = discussions.size();
            if (counts.total == 0) {
                return counts;
            }
            ArrayList<String> values = new ArrayList<String>(discussions.size());
            for (Discussion c2 : discussions) {
                if (c2.closedOn > 0L) {
                    ++counts.closed;
                } else {
                    ++counts.open;
                }
                values.add(this.getDialect().quoteString(c2.id));
            }
            String sql = "SELECT * FROM " + this.getQuotedFullResolvedTableName(discussionsAckTable) + " WHERE " + this.quote(userField) + "=" + this.getDialect().quoteString(user) + " AND " + this.quote(projectKeyField) + "=" + this.getDialect().quoteString(StringUtils.defaultString((String)projectKey, (String)"")) + " AND " + this.quote(workspaceKeyField) + "=" + this.getDialect().quoteString(StringUtils.defaultString((String)workspaceKey, (String)"")) + " AND " + this.quote(discussionIdField) + " IN (" + StringUtils.join(values, (String)", ") + ")";
            HashMap<String, Long> lastReadTimeByDiscussionId = new HashMap<String, Long>(discussions.size());
            try (DSSDBConnection conn = this.acquireConnection();
                 Statement st2 = conn.createStatement();
                 ResultSet rs2 = st2.executeQuery(sql);){
                while (rs2.next()) {
                    String discussionId = rs2.getString(discussionIdField);
                    long lastReadTime = rs2.getLong(timeField);
                    lastReadTimeByDiscussionId.put(discussionId, lastReadTime);
                }
            }
            for (Discussion c3 : discussions) {
                if (c3.closedOn != 0L) continue;
                Long lastReadTime = (Long)lastReadTimeByDiscussionId.get(c3.id);
                long lastReplyTime = c3.lastReplyTime;
                if (lastReadTime != null && lastReplyTime <= lastReadTime) continue;
                ++counts.unread;
            }
            return counts;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    List<Discussion> getForObject(@Nullable String projectKey, @Nullable String workspaceKey, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        try {
            List<Discussion> discussions = this.getDiscussionsForObjectNoReplies(projectKey, workspaceKey, objectType, objectId);
            if (!discussions.isEmpty()) {
                this.readDiscussionsReplies(discussions);
                this.readDiscussionsAcks(discussions);
                this.sortDiscussions(discussions);
            }
            return discussions;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    Map<TaggableObjectsService.TaggableObjectRef, List<Discussion>> getAllDiscussions() throws CodedSQLException {
        try {
            List<Discussion> discussions = this.getAllDiscussionsNoReplies();
            if (!discussions.isEmpty()) {
                this.readDiscussionsReplies(discussions);
                this.readDiscussionsAcks(discussions);
            }
            HashMap<TaggableObjectsService.TaggableObjectRef, List<Discussion>> map = new HashMap<TaggableObjectsService.TaggableObjectRef, List<Discussion>>(discussions.size());
            for (Discussion c2 : discussions) {
                try {
                    TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(c2.projectKey, c2.objectType, c2.objectId, c2.workspaceKey);
                    if (!map.containsKey(ref)) {
                        map.put(ref, new ArrayList());
                    }
                    ((List)map.get(ref)).add(c2);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to read discussion", (Throwable)e);
                }
            }
            for (List cs2 : map.values()) {
                this.sortDiscussions(cs2);
            }
            return map;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private String getConditionsKey(Discussion discussion) {
        if (StringUtils.isNotBlank((String)discussion.workspaceKey)) {
            return discussion.projectKey + "." + discussion.workspaceKey;
        }
        return discussion.projectKey;
    }

    private String buildCondition(String key, List<String> value) {
        String[] keys = key.split("\\.");
        String projectKey = keys[0];
        String workspaceKey = keys.length < 2 ? "" : keys[1];
        return "( " + this.quote(projectKeyField) + "=" + this.getDialect().quoteString(projectKey) + " AND " + this.quote(workspaceKeyField) + "=" + this.getDialect().quoteString(workspaceKey) + " AND " + this.quote(discussionIdField) + " IN (" + StringUtils.join(value, (String)", ") + ") )";
    }

    private void readDiscussionsAcks(List<Discussion> discussions) throws SQLException {
        HashMap<String, Discussion> discussionsMap = new HashMap<String, Discussion>(discussions.size());
        HashMap conditions = new HashMap();
        for (Discussion discussion : discussions) {
            discussionsMap.put(discussion.id, discussion);
            String conditionKey = this.getConditionsKey(discussion);
            if (!conditions.containsKey(conditionKey)) {
                conditions.put(conditionKey, new ArrayList());
            }
            ((List)conditions.get(conditionKey)).add(this.getDialect().quoteString(discussion.id));
        }
        ArrayList<String> andCond = new ArrayList<String>();
        for (Map.Entry entry : conditions.entrySet()) {
            andCond.add(this.buildCondition((String)entry.getKey(), (List)entry.getValue()));
        }
        String string = "SELECT * FROM " + this.getQuotedFullResolvedTableName(discussionsAckTable) + " WHERE " + StringUtils.join(andCond, (String)" OR ");
        try (DSSDBConnection dSSDBConnection = this.acquireConnection();
             Statement st2 = dSSDBConnection.createStatement();
             ResultSet rs2 = st2.executeQuery(string);){
            while (rs2.next()) {
                String discussionId = rs2.getString(discussionIdField);
                String login = rs2.getString(userField);
                long time = rs2.getLong(timeField);
                ((Discussion)discussionsMap.get(discussionId)).addLastReadTime(login, time);
            }
        }
    }

    private void readDiscussionsReplies(List<Discussion> discussions) throws SQLException {
        HashMap<String, Discussion> discussionsMap = new HashMap<String, Discussion>(discussions.size());
        HashMap conditions = new HashMap();
        for (Discussion discussion : discussions) {
            discussionsMap.put(discussion.id, discussion);
            String conditionKey = this.getConditionsKey(discussion);
            if (!conditions.containsKey(conditionKey)) {
                conditions.put(conditionKey, new ArrayList());
            }
            ((List)conditions.get(conditionKey)).add(this.getDialect().quoteString(discussion.id));
        }
        ArrayList<String> andCond = new ArrayList<String>();
        for (Map.Entry entry : conditions.entrySet()) {
            andCond.add(this.buildCondition((String)entry.getKey(), (List)entry.getValue()));
        }
        String string = "SELECT * FROM " + this.getQuotedFullResolvedTableName(discussionsRepliesTable) + " WHERE " + StringUtils.join(andCond, (String)" OR ");
        try (DSSDBConnection dSSDBConnection = this.acquireConnection();
             Statement st2 = dSSDBConnection.createStatement();
             ResultSet rs2 = st2.executeQuery(string);){
            while (rs2.next()) {
                try {
                    String discussionId = rs2.getString(discussionIdField);
                    Discussion.DiscussionReply reply = this.readReply(rs2);
                    ((Discussion)discussionsMap.get(discussionId)).addReply(reply);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to read discussion", (Throwable)e);
                }
            }
        }
    }

    private void addRepliesToDiscussion(Discussion c2) throws SQLException {
        this.readDiscussionsReplies(Collections.singletonList(c2));
    }

    private List<Discussion> getDiscussionsForObjectNoReplies(@Nullable String projectKey, @Nullable String workspaceKey, ITaggingService.TaggableType objectType, String objectId) throws CodedSQLException {
        ArrayList<Discussion> arrayList;
        block17: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)objectId), (Object)"Object id not specified");
            Preconditions.checkArgument((objectType != null ? 1 : 0) != 0, (Object)"Object has no type");
            assert (objectType != null);
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDiscussionsForObject);
                ps2.setString(1, StringUtils.defaultString((String)projectKey, (String)""));
                ps2.setString(2, objectType.toString());
                ps2.setString(3, objectId);
                ps2.setString(4, StringUtils.defaultString((String)workspaceKey, (String)""));
                ps2.execute();
                ArrayList<Discussion> ret = new ArrayList<Discussion>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        ret.add(this.readDiscussion(rs2));
                    }
                }
                arrayList = ret;
                if (conn == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Discussion> getDiscussionsForProjectNoReplies(String projectKey) throws CodedSQLException {
        ArrayList<Discussion> arrayList;
        block16: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key not specified");
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDiscussionsForProject);
                ps2.setString(1, projectKey);
                ps2.execute();
                ArrayList<Discussion> ret = new ArrayList<Discussion>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        ret.add(this.readDiscussion(rs2));
                    }
                }
                arrayList = ret;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Discussion> getDiscussionsForProject(String projectKey) throws CodedSQLException {
        try {
            List<Discussion> discussions = this.getDiscussionsForProjectNoReplies(projectKey);
            if (!discussions.isEmpty()) {
                this.readDiscussionsReplies(discussions);
                this.readDiscussionsAcks(discussions);
            }
            return discussions;
        }
        catch (CodedSQLException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public List<Discussion> getDiscussionsForWorkspaceNoReplies(String workspaceKey) throws CodedSQLException {
        ArrayList<Discussion> arrayList;
        block16: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)workspaceKey), (Object)"Workspace key not specified");
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDiscussionsForWorkspace);
                ps2.setString(1, workspaceKey);
                ps2.execute();
                ArrayList<Discussion> ret = new ArrayList<Discussion>();
                try (ResultSet rs2 = ps2.getResultSet();){
                    while (rs2.next()) {
                        ret.add(this.readDiscussion(rs2));
                    }
                }
                arrayList = ret;
                if (conn == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return arrayList;
    }

    public List<Discussion> getAllDiscussionsNoReplies() throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getAllDiscussions);
            ps2.execute();
            ArrayList<Discussion> ret = new ArrayList<Discussion>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ret.add(this.readDiscussion(rs2));
                }
            }
            ArrayList<Discussion> arrayList = ret;
            return arrayList;
        }
    }

    private void sortDiscussions(List<Discussion> discussions) {
        for (Discussion c3 : discussions) {
            c3.sortReplies();
        }
        discussions.sort(Comparator.comparingLong(c2 -> c2.lastReplyTime));
    }

    Discussion getDiscussion(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId) throws CodedSQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
        try {
            Discussion c2;
            block15: {
                try (DSSDBConnection conn = this.acquireConnection();){
                    PreparedStatement ps2 = this.getPreparedStatement(conn, this.getDiscussion);
                    ps2.setString(1, StringUtils.defaultString((String)projectKey, (String)""));
                    ps2.setString(2, discussionId);
                    ps2.setString(3, StringUtils.defaultString((String)workspaceKey, (String)""));
                    ps2.execute();
                    try (ResultSet rs2 = ps2.getResultSet();){
                        if (rs2.next()) {
                            c2 = this.readDiscussion(rs2);
                            break block15;
                        }
                        throw new NotFoundException("Discussion not found: " + projectKey + "." + discussionId);
                    }
                }
            }
            this.addRepliesToDiscussion(c2);
            return c2;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Map<String, Long>> getAllLastReadTimes() throws CodedSQLException {
        String sql = "SELECT * FROM " + this.getQuotedFullResolvedTableName(discussionsAckTable);
        HashMap<String, Map<String, Long>> timesPerUser = new HashMap<String, Map<String, Long>>();
        try (DSSDBConnection conn = this.acquireConnection();){
            HashMap<String, Map<String, Long>> hashMap;
            block23: {
                Statement st2 = conn.createStatement();
                try {
                    try (ResultSet rs2 = st2.executeQuery(sql);){
                        while (rs2.next()) {
                            String user = rs2.getString(userField);
                            String projectKey = rs2.getString(projectKeyField);
                            String discussionId = rs2.getString(discussionIdField);
                            long time = rs2.getLong(timeField);
                            if (!timesPerUser.containsKey(user)) {
                                timesPerUser.put(user, new HashMap());
                            }
                            ((Map)timesPerUser.get(user)).put(projectKey + "." + discussionId, time);
                        }
                    }
                    hashMap = timesPerUser;
                    if (st2 == null) break block23;
                }
                catch (Throwable throwable) {
                    if (st2 != null) {
                        try {
                            st2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st2.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private Discussion readDiscussion(ResultSet rs2) throws SQLException {
        return new Discussion(rs2.getString(discussionIdField), rs2.getString(projectKeyField), rs2.getString(workspaceKeyField), rs2.getString(objectIdField), ITaggingService.TaggableType.valueOf(rs2.getString(objectTypeField)), rs2.getString(topicField), rs2.getLong(closedOnField), rs2.getString(closedByField), rs2.getLong(lastReplyTimeField));
    }

    private Discussion.DiscussionReply readReply(ResultSet rs2) throws SQLException {
        return new Discussion.DiscussionReply(rs2.getString(replyIdField), rs2.getString(textField), rs2.getString(authorField), rs2.getLong(timeField), rs2.getLong(editedOnField));
    }

    public long ack(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId, String user) throws CodedSQLException {
        long l;
        block8: {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)discussionId), (Object)ERR_MSG_DISC_ID_NOT_SPEC);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)user), (Object)"User login not specified");
            long now = System.currentTimeMillis();
            DSSDBConnection conn = this.acquireConnection();
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.mergeDiscussionAck);
                ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
                ps2.setString(++i, discussionId);
                ps2.setString(++i, user);
                ps2.setLong(++i, now);
                ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
                ps2.execute();
                conn.commit();
                l = now;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            conn.close();
        }
        return l;
    }

    void deleteDiscussion(@Nullable String projectKey, @Nullable String workspaceKey, String discussionId) throws CodedSQLException {
        logger.info((Object)("Delete discussion: " + discussionId));
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.deleteDiscussion);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            i = 0;
            ps2 = this.getPreparedStatement(conn, this.deleteDiscussionReplies);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            i = 0;
            ps2 = this.getPreparedStatement(conn, this.deleteDiscussionAcks);
            ps2.setString(++i, StringUtils.defaultString((String)projectKey, (String)""));
            ps2.setString(++i, discussionId);
            ps2.setString(++i, StringUtils.defaultString((String)workspaceKey, (String)""));
            ps2.execute();
            conn.commit();
        }
        catch (Exception e) {
            throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    public void changeObjectId(ITaggingService.TaggableType objectType, String projectKey, String objectId, String newObjectId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key must be specified");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.changeObjectId);
            ps2.setString(1, newObjectId);
            ps2.setString(2, projectKey);
            ps2.setString(3, objectType.toString());
            ps2.setString(4, objectId);
            ps2.execute();
            conn.commit();
        }
    }

    public static class DiscussionCounts {
        int unread;
        int open;
        int closed;
        int total;
    }
}

