/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.StructuredContentDTO;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@PolyJSON(value={@Mapping(type="document", value=Document.class), @Mapping(type="section", value=Section.class), @Mapping(type="text", value=Text.class), @Mapping(type="image", value=Image.class), @Mapping(type="table", value=Table.class)})
public abstract class StructuredContent {
    public List<Integer> pages;
    public List<StructuredContent> content;
    public PageRange pageRange;
    public StructuredContent collapsedSubTree;

    public abstract String getType();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredContent other = (StructuredContent)obj;
        return Objects.equals(this.content, other.content) && Objects.equals(this.pages, other.pages) && this.equalsFields(other);
    }

    protected StructuredContent deepCopy() {
        StructuredContent copy = this.cloneWithoutChildren();
        if (this.content != null) {
            copy.content = new ArrayList<StructuredContent>();
            for (StructuredContent child : this.content) {
                copy.content.add(child.deepCopy());
            }
        }
        return copy;
    }

    public int hashCode() {
        int hash = Objects.hash(this.getType(), this.pages, this.pageRange);
        if (this.content != null) {
            for (StructuredContent child : this.content) {
                hash = 31 * hash + Objects.hashCode(child);
            }
        }
        return hash;
    }

    protected abstract boolean equalsFields(StructuredContent var1);

    protected abstract String toText();

    protected abstract StructuredContent cloneWithoutChildren();

    private static void copyPageFields(StructuredContent fromContent, StructuredContent toContent) {
        if (fromContent.pageRange != null) {
            toContent.pageRange = new PageRange(fromContent.pageRange.start, fromContent.pageRange.end);
        }
        if (fromContent.pages != null) {
            toContent.pages = new ArrayList<Integer>(fromContent.pages);
        }
    }

    public StructuredContent copyWithImmediateNonSectionChildren() {
        StructuredContent copy = this.cloneWithoutChildren();
        if (this.content == null || this.content.isEmpty()) {
            return copy;
        }
        copy.content = new ArrayList<StructuredContent>();
        for (StructuredContent child : this.content) {
            if (child instanceof Section) continue;
            copy.content.add(child.cloneWithoutChildren());
        }
        return copy;
    }

    public void addChild(StructuredContent child) {
        if (this.content == null) {
            this.content = new ArrayList<StructuredContent>();
        }
        this.content.add(child);
    }

    public StructuredContentDTO toDTO(boolean forExtractContentRecipe) {
        StructuredContentDTO dto;
        switch (this.getType()) {
            case "document": {
                dto = new StructuredContentDTO.Document();
                break;
            }
            case "section": {
                dto = new StructuredContentDTO.Section(((Section)this).level, this.toText());
                break;
            }
            case "text": {
                dto = new StructuredContentDTO.Text(this.toText());
                break;
            }
            case "table": {
                dto = new StructuredContentDTO.Table(this.toText());
                break;
            }
            case "image": {
                Image image = (Image)this;
                dto = new StructuredContentDTO.Image(image.mimeType, image.description, image.resolution, image.height, image.width, image.caption);
                if (forExtractContentRecipe) {
                    InputRefs.SingleImageRef singleImageRef = image.imageRef;
                    if (!(singleImageRef instanceof InputRefs.SingleManagedFolderImageRef)) break;
                    InputRefs.SingleManagedFolderImageRef ref = (InputRefs.SingleManagedFolderImageRef)singleImageRef;
                    ((StructuredContentDTO.Image)dto).image = ref.path;
                    break;
                }
                ((StructuredContentDTO.Image)dto).imageRef = image.imageRef;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown StructuredContent type: " + this.getClass().getName());
            }
        }
        dto.pageRange = this.pageRange;
        if (!forExtractContentRecipe) {
            dto.pages = this.pages;
        }
        if (this.content != null) {
            dto.content = new ArrayList<StructuredContentDTO>();
            dto.content = this.content.stream().map(child -> child.toDTO(forExtractContentRecipe)).toList();
        }
        return dto;
    }

    public static class PageRange {
        public Integer start;
        public Integer end;

        public PageRange() {
        }

        public PageRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public void mergeWith(PageRange other) {
            if (other == null) {
                return;
            }
            if (other.start != null) {
                this.start = this.start != null ? Integer.valueOf(Math.min(this.start, other.start)) : other.start;
            }
            if (other.end != null) {
                this.end = this.end != null ? Integer.valueOf(Math.max(this.end, other.end)) : other.end;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PageRange)) {
                return false;
            }
            PageRange otherPageRange = (PageRange)o;
            return Objects.equals(this.start, otherPageRange.start) && Objects.equals(this.end, otherPageRange.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }

    public static class Section
    extends StructuredContent {
        public Integer level;
        public String title;

        @Override
        public String getType() {
            return "section";
        }

        public Section() {
        }

        public Section(Integer level, String title) {
            this.level = level;
            this.title = title;
        }

        @Override
        protected boolean equalsFields(StructuredContent other) {
            if (!(other instanceof Section)) {
                return false;
            }
            Section section = (Section)other;
            return Objects.equals(section.title, this.title) && Objects.equals(section.level, this.level);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.level, this.title);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        protected String toText() {
            return this.title;
        }

        @Override
        protected StructuredContent cloneWithoutChildren() {
            Section section = new Section(this.level, this.title);
            StructuredContent.copyPageFields(this, section);
            return section;
        }
    }

    public static class Image
    extends StructuredContent {
        public InputRefs.SingleImageRef imageRef;
        public String mimeType;
        public String description;
        public Integer resolution;
        public Long height;
        public Long width;
        public String caption;

        @Override
        public String getType() {
            return "image";
        }

        @Override
        protected boolean equalsFields(StructuredContent other) {
            if (!(other instanceof Image)) {
                return false;
            }
            Image image = (Image)other;
            return Objects.equals(image.mimeType, this.mimeType) && Objects.equals(image.description, this.description) && Objects.equals(image.resolution, this.resolution) && Objects.equals(image.height, this.height) && Objects.equals(image.width, this.width) && Objects.equals(image.caption, this.caption);
        }

        @Override
        public String toText() {
            return this.description;
        }

        @Override
        protected StructuredContent cloneWithoutChildren() {
            Image image = new Image();
            image.imageRef = this.imageRef;
            image.description = this.description;
            image.resolution = this.resolution;
            image.height = this.height;
            image.width = this.width;
            image.caption = this.caption;
            StructuredContent.copyPageFields(this, image);
            return image;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.imageRef, this.mimeType, this.description, this.resolution, this.height, this.width, this.caption);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class Table
    extends StructuredContent {
        public String text;

        @Override
        public String getType() {
            return "table";
        }

        @Override
        public String toText() {
            return this.text;
        }

        @Override
        public StructuredContent cloneWithoutChildren() {
            Table table = new Table();
            table.text = this.text;
            StructuredContent.copyPageFields(this, table);
            return table;
        }

        @Override
        protected boolean equalsFields(StructuredContent other) {
            if (!(other instanceof Table)) {
                return false;
            }
            Table table = (Table)other;
            return Objects.equals(table.text, this.text);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.text);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class Text
    extends StructuredContent {
        public String text;

        @Override
        public String getType() {
            return "text";
        }

        public Text() {
        }

        public Text(String text) {
            this.text = text;
        }

        @Override
        public String toText() {
            return this.text;
        }

        @Override
        public StructuredContent cloneWithoutChildren() {
            Text clone = new Text(this.text);
            StructuredContent.copyPageFields(this, clone);
            return clone;
        }

        @Override
        protected boolean equalsFields(StructuredContent other) {
            if (!(other instanceof Text)) {
                return false;
            }
            Text textNode = (Text)other;
            return Objects.equals(textNode.text, this.text);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.text);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class Document
    extends Section {
        @Override
        public String getType() {
            return "document";
        }

        public Document() {
            this.level = 0;
        }

        @Override
        protected boolean equalsFields(StructuredContent other) {
            if (!(other instanceof Document)) {
                return false;
            }
            Document document = (Document)other;
            return Objects.equals(document.level, this.level) && Objects.equals(document.title, this.title);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }
}

