/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.VariableType;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.AuthorEmailPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.AuthorNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.DSSVersionPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.GenerationDatePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.OutputFileNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.ProjectLinkPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.chart.ChartNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.RelatedChartsIterable;
import com.dataiku.dip.docgen.flow.placeholders.dataset.RelatedWorksheetsIterable;
import com.dataiku.dip.docgen.flow.placeholders.dataset.SchemaColumnsIterable;
import com.dataiku.dip.docgen.flow.placeholders.dataset.details.DatasetConnectionPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.details.DatasetDataStewardPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.details.DatasetFullNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.details.DatasetIsPartitionedPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.details.DatasetTypePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.recipes.SourceFolderIterable;
import com.dataiku.dip.docgen.flow.placeholders.dataset.schema.column.SchemaColumnDescriptionPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.schema.column.SchemaColumnNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.schema.column.SchemaColumnTypePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.status.LastBuildPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.status.PartitionCountPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.status.RecordCountPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.dataset.status.TotalSizePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.folder.FilesInFolderDatasetsIterable;
import com.dataiku.dip.docgen.flow.placeholders.folder.FolderFileListIterable;
import com.dataiku.dip.docgen.flow.placeholders.folder.FolderLastBuildDatePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.folder.details.FolderConnectionPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.folder.details.FolderFullIdPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.folder.details.FolderIsPartitionedPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.folder.details.FolderTypePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.labeling.LabelingTaskInputsOutputsIterable;
import com.dataiku.dip.docgen.flow.placeholders.labeling.LabelingTaskTypePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.labeling.LabelingTasksIterable;
import com.dataiku.dip.docgen.flow.placeholders.labeling.RelatedLabelingTasksIterable;
import com.dataiku.dip.docgen.flow.placeholders.model.details.ModelActiveVersionNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.project.DatasetsIterable;
import com.dataiku.dip.docgen.flow.placeholders.project.FlowExportPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.project.ManagedFoldersIterable;
import com.dataiku.dip.docgen.flow.placeholders.project.ModelEvaluationStoresIterable;
import com.dataiku.dip.docgen.flow.placeholders.project.ModelsIterable;
import com.dataiku.dip.docgen.flow.placeholders.project.ProjectCurrentBranchPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.project.ProjectKeyPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.project.ProjectStatusPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.project.RecipesIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.BaseConditionPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.BaseJoinConditionIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.BaseJoinPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.DataRelationshipJoinConditionIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.DataRelationshipPlaceHolder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.DistinctRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.ExtractFailedRowsRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.GenerateFeaturesRecipePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.GroupRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.JoinUnmatchedRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.PivotRecipePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeBaseJoinIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeCodeEnvPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeGenerateFeaturesRelationshipIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeInputsOutputsIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeIsCodePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeIsJoinPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipePayloadPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipePrepareStepPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipePrepareStepsIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RecipeTypePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.RelatedRecipesIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.SamplingRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.SortingColumnPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.SplitRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.TimeWindowIterable;
import com.dataiku.dip.docgen.flow.placeholders.recipe.TimeWindowPlaceHolder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.TopNPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.UpdateRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.UpsertRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.VStackRecipePlaceholders;
import com.dataiku.dip.docgen.flow.placeholders.recipe.WindowPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TagNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableCreationDatePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableCreationUserPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableIdPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableIsForeignPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableLastModifDatePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableLastModifUserPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableLongDescPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableProjectKeyPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableProjectNamePlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableShortDescriptionPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TaggableTagsListPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.taggable.TagsIterable;
import com.dataiku.dip.docgen.flow.placeholders.worksheet.WorksheetNamePlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.IterableUnionPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.docgen.resolver.PlaceholderStore;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import java.util.Collection;
import java.util.function.Function;

public class FlowDocumentPlaceholderStore
extends PlaceholderStore<FlowDocumentContext> {
    public FlowDocumentPlaceholderStore() {
        this.registerProjectMetadataPlaceholders();
        this.register("flow.datasets", new DatasetsIterable());
        this.register("flow.folders", new ManagedFoldersIterable());
        this.register("flow.recipes", new RecipesIterable());
        this.register("flow.models", new ModelsIterable());
        this.register("flow.model_evaluation_stores", new ModelEvaluationStoresIterable());
        this.register("flow.labeling_tasks", new LabelingTasksIterable());
        this.registerErrorContextDescription(TaggableObjectsService.TaggableObject.class, to -> to.getDisplayName() + " (" + to.getFullId() + ")");
        this.registerFlowScreenshotPlaceholders();
        this.registerDatasetPlaceholders();
        this.registerRecipePlaceholders();
        this.registerFolderPlaceholders();
        this.registerLabelingTaskPlaceholders();
        this.registerErrorContextDescription(DatasetExploreSettings.DatasetChart.class, chart -> chart.def.name);
        this.register("$chart.name", new ChartNamePlaceholder());
        this.register("$worksheet.name", new WorksheetNamePlaceholder());
        this.registerErrorContextDescription(String.class, Function.identity());
        this.register("$tag.name", new TagNamePlaceholder());
        this.registerTaggablePlaceholders("$model", SavedModel.class, true);
        this.register("$model.active_version.name", new ModelActiveVersionNamePlaceholder());
        this.register("$model.parent.recipes", new RelatedRecipesIterable.Model(false));
        this.register("$model.successors.recipes", new RelatedRecipesIterable.Model(true));
        this.registerTaggablePlaceholders("$model_evaluation_store", ModelEvaluationStore.class, true);
        this.register("$model_evaluation_store.parent.recipes", new RelatedRecipesIterable.Mes(false));
        this.register("$model_evaluation_store.successors.recipes", new RelatedRecipesIterable.Mes(true));
        this.register("config.author.name", new AuthorNamePlaceholder());
        this.register("config.author.email", new AuthorEmailPlaceholder());
        this.register("config.dss.version", new DSSVersionPlaceholder());
        this.register("config.generation_date", new GenerationDatePlaceholder());
        this.register("config.output_file.name", new OutputFileNamePlaceholder());
        this.register("config.project.link", new ProjectLinkPlaceholder());
    }

    private void registerFlowScreenshotPlaceholders() {
        this.register("flow.picture.landscape", new FlowExportPlaceholder(ExportFormat.Orientation.LANDSCAPE, false));
        this.register("flow.picture.portrait", new FlowExportPlaceholder(ExportFormat.Orientation.PORTRAIT, false));
        this.register("flow.picture.full.landscape", new FlowExportPlaceholder(ExportFormat.Orientation.LANDSCAPE, true));
        this.register("flow.picture.full.portrait", new FlowExportPlaceholder(ExportFormat.Orientation.PORTRAIT, true));
    }

    private <T extends TaggableObjectsService.TaggableObject> void registerTaggablePlaceholders(String prefix, Class<T> clazz, boolean canBeForeign) {
        this.register(prefix + ".id", new TaggableIdPlaceholder<T>(clazz));
        this.register(prefix + ".name", new TaggableNamePlaceholder<T>(clazz));
        this.register(prefix + ".creation.date", new TaggableCreationDatePlaceholder<T>(clazz));
        this.register(prefix + ".creation.user", new TaggableCreationUserPlaceholder<T>(clazz));
        this.register(prefix + ".last_modification.date", new TaggableLastModifDatePlaceholder<T>(clazz));
        this.register(prefix + ".last_modification.user", new TaggableLastModifUserPlaceholder<T>(clazz));
        this.register(prefix + ".short_desc", new TaggableShortDescriptionPlaceholder<T>(clazz));
        this.register(prefix + ".long_desc", new TaggableLongDescPlaceholder<T>(clazz));
        this.register(prefix + ".tags", new TagsIterable<T>(clazz));
        this.register(prefix + ".tags.list", new TaggableTagsListPlaceholder<T>(clazz));
        if (canBeForeign) {
            this.register(prefix + ".project.key", new TaggableProjectKeyPlaceholder<T>(clazz));
            this.register(prefix + ".project.name", new TaggableProjectNamePlaceholder<T>(clazz));
            this.register(prefix + ".is_foreign", new TaggableIsForeignPlaceholder<T>(clazz));
        }
    }

    private FlowPlaceholder.RootTextPlaceholder wrapForProject(FlowPlaceholder.TextPlaceholder<SerializedProject> placeholder) {
        return (flowDocumentContext, unused) -> (PlaceholderOutput.Text)placeholder.resolve(flowDocumentContext, flowDocumentContext.serializedProject);
    }

    private <O> FlowPlaceholder.RootIterablePlaceholder<O> wrapForProject(final FlowPlaceholder.IterablePlaceholder<SerializedProject, O> placeholder) {
        return new FlowPlaceholder.RootIterablePlaceholder<O>(){

            @Override
            public IterableDescription<Void, O> getDescription() {
                IterableDescription desc = placeholder.getDescription();
                return IterableDescription.iterablePlaceholder(desc.output, desc.replacement);
            }

            @Override
            public Collection<O> resolve(FlowDocumentContext flowDocumentContext, Void unused) throws PlaceholderExpectedException {
                return (Collection)placeholder.resolve(flowDocumentContext, flowDocumentContext.serializedProject);
            }
        };
    }

    private void registerProjectMetadataPlaceholders() {
        this.register("project.name", this.wrapForProject(new TaggableNamePlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.creation.date", this.wrapForProject(new TaggableCreationDatePlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.creation.user", this.wrapForProject(new TaggableCreationUserPlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.last_modification.date", this.wrapForProject(new TaggableLastModifDatePlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.last_modification.user", this.wrapForProject(new TaggableLastModifUserPlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.short_desc", this.wrapForProject(new TaggableShortDescriptionPlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.long_desc", this.wrapForProject(new TaggableLongDescPlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.tags", this.wrapForProject(new TagsIterable<SerializedProject>(SerializedProject.class)));
        this.register("project.tags.list", this.wrapForProject(new TaggableTagsListPlaceholder<SerializedProject>(SerializedProject.class)));
        this.register("project.key", new ProjectKeyPlaceholder());
        this.register("project.status", new ProjectStatusPlaceholder());
        this.register("project.current.git.branch", new ProjectCurrentBranchPlaceholder());
    }

    private void registerDatasetPlaceholders() {
        this.register("$dataset.full_name", new DatasetFullNamePlaceholder());
        this.register("$dataset.type", new DatasetTypePlaceholder());
        this.registerTaggablePlaceholders("$dataset", SerializedDataset.class, true);
        this.register("$dataset.connection", new DatasetConnectionPlaceholder());
        this.register("$dataset.is_partitioned", new DatasetIsPartitionedPlaceholder());
        this.register("$dataset.status.last_build", new LastBuildPlaceholder());
        this.register("$dataset.status.total_size", new TotalSizePlaceholder());
        this.register("$dataset.status.record_count", new RecordCountPlaceholder());
        this.register("$dataset.status.partition_count", new PartitionCountPlaceholder());
        this.register("$dataset.parent.recipes", new RelatedRecipesIterable.Dataset(false));
        this.register("$dataset.parent.labeling_tasks", new RelatedLabelingTasksIterable.Dataset(false));
        this.register("$dataset.parent.all", new IterableUnionPlaceholder<FlowDocumentContext, SerializedDataset>(SerializedDataset.class).add(new RelatedRecipesIterable.Dataset(false)).add(new RelatedLabelingTasksIterable.Dataset(false)));
        this.register("$dataset.successors.recipes", new RelatedRecipesIterable.Dataset(true));
        this.register("$dataset.successors.labeling_tasks", new RelatedLabelingTasksIterable.Dataset(true));
        this.register("$dataset.successors.all", new IterableUnionPlaceholder<FlowDocumentContext, SerializedDataset>(SerializedDataset.class).add(new RelatedRecipesIterable.Dataset(true)).add(new RelatedLabelingTasksIterable.Dataset(true)));
        this.register("$dataset.charts", new RelatedChartsIterable());
        this.register("$dataset.worksheets", new RelatedWorksheetsIterable());
        this.register("$dataset.schema.columns", new SchemaColumnsIterable());
        this.registerErrorContextDescription(SchemaColumn.class, SchemaColumn::getName);
        this.register("$schema_column.name", new SchemaColumnNamePlaceholder());
        this.register("$schema_column.type", new SchemaColumnTypePlaceholder());
        this.register("$schema_column.description", new SchemaColumnDescriptionPlaceholder());
        this.register("$dataset.containing.folder", new SourceFolderIterable());
        this.register("$dataset.data_steward", new DatasetDataStewardPlaceholder());
    }

    private void registerRecipePlaceholders() {
        this.register("$recipe.type", new RecipeTypePlaceholder());
        this.registerTaggablePlaceholders("$recipe", SerializedRecipe.class, false);
        this.register("$recipe.outputs.datasets", new RecipeInputsOutputsIterable.Datasets(true));
        this.register("$recipe.outputs.folders", new RecipeInputsOutputsIterable.Folders(true));
        this.register("$recipe.outputs.models", new RecipeInputsOutputsIterable.SavedModels(true));
        this.register("$recipe.outputs.model_evaluation_stores", new RecipeInputsOutputsIterable.ModelEvaluationStores(true));
        this.register("$recipe.outputs.all", new IterableUnionPlaceholder<FlowDocumentContext, SerializedRecipe>(SerializedRecipe.class).add(new RecipeInputsOutputsIterable.Datasets(true)).add(new RecipeInputsOutputsIterable.Folders(true)).add(new RecipeInputsOutputsIterable.SavedModels(true)).add(new RecipeInputsOutputsIterable.ModelEvaluationStores(true)));
        this.register("$recipe.inputs.datasets", new RecipeInputsOutputsIterable.Datasets(false));
        this.register("$recipe.inputs.folders", new RecipeInputsOutputsIterable.Folders(false));
        this.register("$recipe.inputs.models", new RecipeInputsOutputsIterable.SavedModels(false));
        this.register("$recipe.inputs.model_evaluation_stores", new RecipeInputsOutputsIterable.ModelEvaluationStores(false));
        this.register("$recipe.inputs.all", new IterableUnionPlaceholder<FlowDocumentContext, SerializedRecipe>(SerializedRecipe.class).add(new RecipeInputsOutputsIterable.Datasets(false)).add(new RecipeInputsOutputsIterable.Folders(false)).add(new RecipeInputsOutputsIterable.SavedModels(false)).add(new RecipeInputsOutputsIterable.ModelEvaluationStores(false)));
        this.register("$recipe.is_code_recipe", new RecipeIsCodePlaceholder());
        this.register("$recipe.payload", new RecipePayloadPlaceholder());
        this.register("$recipe.has_code_env", new RecipeCodeEnvPlaceholder.HasCodeEnv());
        this.register("$recipe.code_env", new RecipeCodeEnvPlaceholder());
        this.register("$recipe.prepare.steps", new RecipePrepareStepsIterable());
        this.register("$step.type", new RecipePrepareStepPlaceholder.Type());
        this.register("$step.comment", new RecipePrepareStepPlaceholder.Comment());
        this.register("$recipe.is_join", new RecipeIsJoinPlaceholder());
        this.register("$recipe.joins", new RecipeBaseJoinIterable());
        this.register("$recipe.left_unmatched_output.may_exist", new JoinUnmatchedRecipePlaceholders.CanHaveUnmatchedOutput(JoinOutputRole.UNMATCHED_ROWS_LEFT));
        this.register("$recipe.right_unmatched_output.may_exist", new JoinUnmatchedRecipePlaceholders.CanHaveUnmatchedOutput(JoinOutputRole.UNMATCHED_ROWS_RIGHT));
        this.register("$recipe.left_unmatched_output.name", new JoinUnmatchedRecipePlaceholders.UnmatchedOutputRef(JoinOutputRole.UNMATCHED_ROWS_LEFT));
        this.register("$recipe.right_unmatched_output.name", new JoinUnmatchedRecipePlaceholders.UnmatchedOutputRef(JoinOutputRole.UNMATCHED_ROWS_RIGHT));
        this.register("$recipe.left_unmatched_output.datasets", new JoinUnmatchedRecipePlaceholders.UnmatchedOutput(JoinOutputRole.UNMATCHED_ROWS_LEFT));
        this.register("$recipe.right_unmatched_output.datasets", new JoinUnmatchedRecipePlaceholders.UnmatchedOutput(JoinOutputRole.UNMATCHED_ROWS_RIGHT));
        this.register("$join.type", new BaseJoinPlaceholder.Type());
        this.register("$join.condition_mode", new BaseJoinPlaceholder.ConditionMode());
        this.register("$join.left_dataset.name", new BaseJoinPlaceholder.Left());
        this.register("$join.right_dataset.name", new BaseJoinPlaceholder.Right());
        this.register("$join.conditions", new BaseJoinConditionIterable());
        this.register("$condition.left_column.name", new BaseConditionPlaceholder.Left());
        this.register("$condition.right_column.name", new BaseConditionPlaceholder.Right());
        this.register("$condition.description", new BaseConditionPlaceholder.Description());
        this.register("$recipe.primary_dataset", new GenerateFeaturesRecipePlaceholder.PrimaryDatasetName());
        this.register("$recipe.cutoff_time", new GenerateFeaturesRecipePlaceholder.CutoffTimeColumn());
        this.register("$recipe.feature_transformations.general", new GenerateFeaturesRecipePlaceholder.FeatureTransformations(null));
        this.register("$recipe.feature_transformations.categorical", new GenerateFeaturesRecipePlaceholder.FeatureTransformations(VariableType.CATEGORY));
        this.register("$recipe.feature_transformations.date", new GenerateFeaturesRecipePlaceholder.FeatureTransformations(VariableType.DATE));
        this.register("$recipe.feature_transformations.numerical", new GenerateFeaturesRecipePlaceholder.FeatureTransformations(VariableType.NUMERIC));
        this.register("$recipe.feature_transformations.text", new GenerateFeaturesRecipePlaceholder.FeatureTransformations(VariableType.TEXT));
        this.register("$recipe.data_relationships", new RecipeGenerateFeaturesRelationshipIterable());
        this.register("$data_relationship.left_dataset.name", new DataRelationshipPlaceHolder.LeftName());
        this.register("$data_relationship.right_dataset.name", new DataRelationshipPlaceHolder.RightName());
        this.register("$data_relationship.type", new DataRelationshipPlaceHolder.Type());
        this.register("$data_relationship.conditions", new DataRelationshipJoinConditionIterable());
        this.register("$data_relationship.right_dataset.time_index", new DataRelationshipPlaceHolder.RightTimeIndex());
        this.register("$data_relationship.left_dataset.time_index", new DataRelationshipPlaceHolder.LeftTimeIndex());
        this.register("$data_relationship.right_dataset.time_windows", new TimeWindowIterable.Right());
        this.register("$data_relationship.left_dataset.time_windows", new TimeWindowIterable.Left());
        this.register("$data_relationship.right_dataset.participant_index", new DataRelationshipPlaceHolder.RightParticipantIndex());
        this.register("$data_relationship.left_dataset.participant_index", new DataRelationshipPlaceHolder.LeftParticipantIndex());
        this.register("$time_window.from", new TimeWindowPlaceHolder.From());
        this.register("$time_window.to", new TimeWindowPlaceHolder.To());
        this.register("$time_window.units", new TimeWindowPlaceHolder.Units());
        this.register("$recipe.windows", new WindowPlaceholder.WindowsIterable());
        this.register("$window.name", new WindowPlaceholder.Name());
        this.register("$window.partitioning_columns", new WindowPlaceholder.PartitioningColumns());
        this.register("$recipe.sorting_columns", new SortingColumnPlaceholder.SortingColumnsIterable());
        this.register("$sorted_column.name", new SortingColumnPlaceholder.Name());
        this.register("$sorted_column.direction", new SortingColumnPlaceholder.Direction());
        this.register("$recipe.top_rows.count", new TopNPlaceholder.FirstRows());
        this.register("$recipe.bottom_rows.count", new TopNPlaceholder.LastRows());
        this.register("$recipe.row_identifiers", new PivotRecipePlaceholder.RowIdentifiers());
        this.register("$recipe.pivots", new PivotRecipePlaceholder.Pivots());
        this.register("$recipe.populated_columns", new PivotRecipePlaceholder.Populate());
        this.register("$recipe.is_filtered", new SamplingRecipePlaceholders.IsFiltered());
        this.register("$recipe.is_sampled", new SamplingRecipePlaceholders.IsSampled());
        this.register("$recipe.group_keys", new GroupRecipePlaceholders.GroupKeys());
        this.register("$recipe.upsert_keys", new UpsertRecipePlaceholders.UpsertKeys());
        this.register("$recipe.distinct_keys", new DistinctRecipePlaceholders.DistinctKeys());
        this.register("$recipe.split_mode", new SplitRecipePlaceholders.Mode());
        this.register("$recipe.stack_mode", new VStackRecipePlaceholders.Mode());
        this.register("$recipe.unique_keys", new UpdateRecipePlaceholders.UniqueKeys());
        this.register("$recipe.auto_select_all_compatible_rules", new ExtractFailedRowsRecipePlaceholders.AutoSelectAllCompatibleRules());
        this.register("$recipe.rules", new ExtractFailedRowsRecipePlaceholders.RulesIterable());
        this.register("$rule.id", new ExtractFailedRowsRecipePlaceholders.RuleId());
        this.register("$rule.name", new ExtractFailedRowsRecipePlaceholders.RuleName());
        this.register("$rule.rule_column", new ExtractFailedRowsRecipePlaceholders.RuleColumn());
        this.register("$rule.is_selected", new ExtractFailedRowsRecipePlaceholders.RuleIsSelected());
    }

    private void registerFolderPlaceholders() {
        this.register("$folder.full_id", new FolderFullIdPlaceholder());
        this.register("$folder.type", new FolderTypePlaceholder());
        this.register("$folder.connection", new FolderConnectionPlaceholder());
        this.registerTaggablePlaceholders("$folder", ManagedFolder.class, true);
        this.register("$folder.is_partitioned", new FolderIsPartitionedPlaceholder());
        this.register("$folder.status.last_build", new FolderLastBuildDatePlaceholder());
        this.register("$folder.parent.recipes", new RelatedRecipesIterable.Folder(false));
        this.register("$folder.successors.recipes", new RelatedRecipesIterable.Folder(true));
        this.register("$folder.successors.labeling_tasks", new RelatedLabelingTasksIterable.Folder(true));
        this.register("$folder.successors.all", new IterableUnionPlaceholder<FlowDocumentContext, ManagedFolder>(ManagedFolder.class).add(new RelatedRecipesIterable.Folder(true)).add(new RelatedLabelingTasksIterable.Folder(true)));
        this.register("$folder.files_in_folder.datasets", new FilesInFolderDatasetsIterable());
        this.register("$folder.files.list", new FolderFileListIterable());
        this.register("$file.path", new FolderFileListIterable.PathPlaceholder());
        this.register("$file.size", new FolderFileListIterable.SizePlaceholder());
        this.register("$file.last_modified", new FolderFileListIterable.LastModifiedPlaceholder());
    }

    private void registerLabelingTaskPlaceholders() {
        this.register("$labeling_task.type", new LabelingTaskTypePlaceholder());
        this.registerTaggablePlaceholders("$labeling_task", LabelingTask.class, false);
        this.register("$labeling_task.inputs.datasets", new LabelingTaskInputsOutputsIterable.Datasets(false));
        this.register("$labeling_task.inputs.folders", new LabelingTaskInputsOutputsIterable.Folders(false));
        this.register("$labeling_task.inputs.all", new IterableUnionPlaceholder<FlowDocumentContext, LabelingTask>(LabelingTask.class).add(new LabelingTaskInputsOutputsIterable.Datasets(false)).add(new LabelingTaskInputsOutputsIterable.Folders(false)));
        this.register("$labeling_task.outputs.datasets", new LabelingTaskInputsOutputsIterable.Datasets(true));
    }
}

