/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FutureHistoryService {
    @Autowired
    private FutureService futureService;
    private List<FutureHistoryItem> itemsRegistry = new ArrayList<FutureHistoryItem>();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.futures.history");

    public synchronized void register(String name, FutureResponse<?> initialResponse, String ... context) {
        FutureHistoryItem fhi = new FutureHistoryItem();
        fhi.name = name;
        fhi.jobId = initialResponse.jobId;
        fhi.lastResponse = initialResponse;
        for (int i = 0; i < context.length; i += 2) {
            fhi.context.put(context[i], context[i + 1]);
        }
        logger.info((Object)("Registering future item : " + name + " -> " + fhi.jobId));
        this.itemsRegistry.add(fhi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FutureHistoryItem> getAllByPrefix(String prefix) {
        ArrayList<FutureHistoryItem> matching = new ArrayList<FutureHistoryItem>();
        Validate.notNull((Object)prefix);
        FutureHistoryService futureHistoryService = this;
        synchronized (futureHistoryService) {
            for (FutureHistoryItem _item : this.itemsRegistry) {
                if (!_item.name.startsWith(prefix)) continue;
                matching.add(_item);
            }
        }
        logger.infoV("Found %d items matching prefix %s", new Object[]{matching.size(), prefix});
        for (FutureHistoryItem item : matching) {
            if (item.lastResponse != null && item.lastResponse.hasResult || item.storedError != null) continue;
            try {
                item.lastResponse = this.futureService.getUpdate(item.jobId);
            }
            catch (Throwable t) {
                item.storedError = new SerializedError(t, true);
            }
        }
        return matching;
    }

    public FutureHistoryItem getSingleByPrefix(String name) {
        Validate.notNull((Object)name);
        List<FutureHistoryItem> matching = this.getAllByPrefix(name);
        if (matching.size() == 0) {
            throw ErrorContext.iae((String)("No future matching name " + name));
        }
        if (matching.size() > 1) {
            throw ErrorContext.iae((String)("Multiple futures matching name " + name));
        }
        return matching.get(0);
    }

    public synchronized void removeWithPrefix(String prefix) {
        ArrayList<FutureHistoryItem> toDel = new ArrayList<FutureHistoryItem>();
        for (FutureHistoryItem item : this.itemsRegistry) {
            if (!item.name.startsWith(prefix)) continue;
            logger.info((Object)("Forgetting previous history of " + item.name));
            toDel.add(item);
        }
        for (FutureHistoryItem item : toDel) {
            this.itemsRegistry.remove(item);
        }
    }

    public static class FutureHistoryItem {
        public Map<String, String> context = new HashMap<String, String>();
        public String name;
        public String jobId;
        public SerializedError storedError;
        public FutureResponse<?> lastResponse;
    }
}

