/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.labeling.Label;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import org.apache.commons.lang.StringUtils;

@UIModel
public abstract class BaseLabelingAnswer {
    public String projectKey;
    public String labelingTaskId;
    public String recordId;
    public Label<?> label;
    public String reviewer;
    public long creationTime;
    public long lastUpdateTime;

    public void validate(LabelingTask task) {
        LabelingTask.LabelingTaskType taskType = task.type;
        if (StringUtils.isBlank((String)this.recordId)) {
            throw ErrorContext.iae((String)"Answer must be associated to a record, recordId cannot be blank");
        }
        if (StringUtils.isBlank((String)this.labelingTaskId)) {
            throw ErrorContext.iae((String)"Answer labeling task id cannot be blank");
        }
        if (StringUtils.isBlank((String)this.projectKey)) {
            throw ErrorContext.iae((String)"Answer project key cannot be blank");
        }
        if (this.label instanceof Label.ObjectDetectionLabel && taskType != LabelingTask.LabelingTaskType.OBJECT_DETECTION) {
            throw ErrorContext.iae((String)("Label is of type object detection but labeling task is of type:" + taskType.toString()));
        }
        if (this.label instanceof Label.ClassificationLabel && taskType != LabelingTask.LabelingTaskType.IMAGE_CLASSIFICATION && taskType != LabelingTask.LabelingTaskType.RECORD_CLASSIFICATION && taskType != LabelingTask.LabelingTaskType.TEXT_CLASSIFICATION) {
            throw ErrorContext.iae((String)("Label is of type classification but labeling task is of type:" + taskType.toString()));
        }
        if (this.label instanceof Label.NamedEntityExtractionLabel && taskType != LabelingTask.LabelingTaskType.NAMED_ENTITY_EXTRACTION) {
            throw ErrorContext.iae((String)("Label is of type entity extraction but labeling task is of type:" + taskType.toString()));
        }
        if (this.label instanceof Label.FreeTextLabel && taskType != LabelingTask.LabelingTaskType.RECORD_FREETEXT) {
            throw ErrorContext.iae((String)("Label is of type free-text but labeling task is of type:" + taskType.toString()));
        }
        this.label.validate(task);
    }
}

