/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.dip.connections.AbstractAzureAIConnection;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.online.LLMChatMessageUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.RemoteFineTuningClient;
import com.dataiku.dip.llm.online.openai.AzureClientBase;
import com.dataiku.dip.llm.online.openai.AzureOpenAIFineTuningClient;
import com.dataiku.dip.llm.online.openai.OpenAIChatAPI;
import com.dataiku.dip.llm.online.openai.OpenAIImageHandling;
import com.dataiku.dip.llm.online.openai.RawOpenAIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractAzureAIClient<D extends AbstractAzureAIConnection.AbstractAzureAIDeployment, C extends AbstractAzureAIConnection<D, HM, CM>, HM extends AbstractLLMConnection.IHardcodedConnectionModel<AbstractAzureAIConnection.AbstractAzureAIModel>, CM extends AbstractAzureAIConnection.AbstractCustomAzureAIModel>
extends AzureClientBase<AbstractAzureAIConnection.AbstractAzureAIModel> {
    protected RawOpenAIClient raw;
    protected final C connection;

    public AbstractAzureAIClient(C connection, LLMModelHandle<AbstractAzureAIConnection.AbstractAzureAIModel> modelHandle, AuthCtx authCtx, @Nullable String projectKey) throws DKUSecurityException, IOException {
        super(modelHandle.getEnrichedRef(), modelHandle.getModel(), ((AbstractAzureAIConnection)connection).params.networkSettings);
        this.connection = connection;
        Params connectionProperties = ((AbstractAzureAIConnection)connection).getDkuPropertiesAsParams();
        boolean trustAllSSLCertificates = connectionProperties.getBoolParam("dku.connection.llm.trustAllSSLCertificates", false);
        boolean forceContentLength = connectionProperties.getBoolParam("dku.connection.llm.forceContentLength", false);
        ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = ((DSSConnection)connection).getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
        AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = this.queryRunner.getHttpClientNetworkSettings();
        this.setRawClient(connection, authCtx, projectKey, creds, networkSettings, trustAllSSLCertificates, forceContentLength);
    }

    protected abstract void setRawClient(C var1, AuthCtx var2, @Nullable String var3, ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials var4, AbstractLLMConnection.HTTPBasedLLMNetworkSettings var5, boolean var6, boolean var7);

    @Override
    public List<LLMClient.ChatMessage> getFormattedPrompt(List<LLMClient.ChatMessage> chatMessages) {
        if (((AbstractAzureAIConnection.AbstractAzureAIModel)this.model).deploymentType == OpenAIConnection.OpenAIModelType.COMPLETION_CHAT_NO_SYSTEM_PROMPT) {
            chatMessages = LLMChatMessageUtils.convertMessageRole(chatMessages, "system", "user");
        }
        return super.getFormattedPrompt(chatMessages);
    }

    public AbstractAzureAIConnection.AbstractAzureAIModel getModel() {
        return (AbstractAzureAIConnection.AbstractAzureAIModel)this.model;
    }

    @Override
    public RawOpenAIClient getRaw() {
        return this.raw;
    }

    @Override
    public boolean isChatModel() {
        return ((AbstractAzureAIConnection.AbstractAzureAIModel)this.model).useChatApi;
    }

    @Override
    public String getAzureModelId() {
        return ((AbstractAzureAIConnection.AbstractAzureAIModel)this.model).deploymentId;
    }

    @Override
    public OpenAIImageHandling getImageHandlingMode() {
        return ((AbstractAzureAIConnection.AbstractAzureAIModel)this.model).imageHandlingMode;
    }

    @Override
    public OpenAIChatAPI getAPI() {
        return ((AbstractAzureAIConnection.AbstractAzureAIModel)this.model).api;
    }

    @Override
    public boolean requiresCostLimiting() {
        return true;
    }

    @Override
    public String getProviderId() {
        return "AzureOpenAI";
    }

    public C getConnection() {
        return this.connection;
    }

    @Override
    public int getMaxParallelism() {
        return ((AbstractAzureAIConnection)this.connection).params.maxParallelism;
    }

    @Override
    public List<LLMClient.SimpleRerankingResponse> rerankBatch(List<LLMClient.RerankingQuery> queries) throws Exception {
        throw new IllegalArgumentException("Rerankings not supported on this LLM");
    }

    @Override
    public RemoteFineTuningClient newFineTuningClient() {
        return new AzureOpenAIFineTuningClient(this);
    }
}

