/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilePartition
extends Partition {
    private static final long serialVersionUID = 9013015297665061087L;
    public List<FileBucket> buckets = new ArrayList<FileBucket>();

    public FilePartition(PartitioningScheme scheme) {
        super(scheme);
    }

    public Partition copy() {
        FilePartition copy = new FilePartition(this.scheme);
        for (Map.Entry dv : this.getDimensionValues().entrySet()) {
            copy.dimensionValues.put((String)dv.getKey(), ((DimensionValue)dv.getValue()).copy());
        }
        return copy;
    }

    public int getNbFiles() {
        int ret = 0;
        for (FileBucket bucket : this.buckets) {
            ret += bucket.paths.size();
        }
        return ret;
    }

    public List<FSPath> getAllPaths() {
        ArrayList<FSPath> ret = new ArrayList<FSPath>();
        for (FileBucket bucket : this.buckets) {
            ret.addAll(bucket.paths);
        }
        return ret;
    }

    public long getTotalSize() {
        long ret = 0L;
        for (FileBucket bucket : this.buckets) {
            for (FSPath path : bucket.paths) {
                ret += path.getSize();
            }
        }
        return ret;
    }
}

